/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.websocket;

import com.cisco.aci.vcplugin.log.VcpLogger;
import com.cisco.aci.vcplugin.websocket.EndpointConfig;
import com.cisco.aci.vcplugin.websocket.VcpWebSocketEndpoint;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.websocket.DeploymentException;
import javax.websocket.server.ServerContainer;
import javax.websocket.server.ServerEndpointConfig;

public class WebSocketInitializer
implements ServletContextListener {
    private static final VcpLogger LOG = new VcpLogger();
    private static final String SERVER_CONTAINER_ATTRIBUTE = "javax.websocket.server.ServerContainer";
    private static final String VUM_WEBSOCKET_ENDPOINT = "/vcplugin-websocket";

    public WebSocketInitializer() {
        LOG.info("initilizaed!");
    }

    public void contextInitialized(ServletContextEvent sce) {
        ServletContext servletContext = sce.getServletContext();
        ServerContainer serverContainer = (ServerContainer)servletContext.getAttribute(SERVER_CONTAINER_ATTRIBUTE);
        try {
            serverContainer.addEndpoint((ServerEndpointConfig)new EndpointConfig(VcpWebSocketEndpoint.class, VUM_WEBSOCKET_ENDPOINT));
            LOG.info("Registered websocket endpoint at /vcplugin-websocket");
        }
        catch (DeploymentException e) {
            LOG.error("Error registering websocket endpoint:" + e.getMessage());
        }
        Set installedExtensions = serverContainer.getInstalledExtensions();
        LOG.info("Installed extensions: " + installedExtensions.size());
    }

    public void contextDestroyed(ServletContextEvent event) {
        LOG.info("WebSocketInitializer context destroyed.");
    }
}

