/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.websocket;

import com.cisco.aci.vcplugin.event.VcpObserver;
import com.cisco.aci.vcplugin.log.VcpLogger;
import com.cisco.aci.vcplugin.swagger.model.EventType;
import com.cisco.aci.vcplugin.swagger.model.VcpEvent;
import com.cisco.aci.vcplugin.swagger.model.WsMessage;
import com.cisco.aci.vcplugin.swagger.model.WsMessageAction;
import com.cisco.aci.vcplugin.swagger.model.WsTicket;
import com.cisco.aci.vcplugin.websocket.WsSessionManager;
import com.google.gson.Gson;
import io.swagger.util.Json;
import java.util.ArrayList;
import java.util.List;
import javax.websocket.CloseReason;
import javax.websocket.MessageHandler;
import javax.websocket.Session;

public class WsSession
extends VcpObserver
implements MessageHandler.Whole<String> {
    private final Session _session;
    private final VcpLogger log;
    private boolean _authenticated = false;
    private final WsSessionManager _wsSessionManager;
    private String _username;
    private List<String> _subscribedApis;

    public WsSession(Session s, WsSessionManager wsSessionManager) {
        this._session = s;
        this._session.addMessageHandler((MessageHandler)this);
        this._wsSessionManager = wsSessionManager;
        this._subscribedApis = new ArrayList<String>();
        this.log = new VcpLogger(s.getId());
        this.log.info("ws session initialized");
        this.onOpen();
    }

    public void onOpen() {
        WsMessage n = new WsMessage();
        n.setAction(WsMessageAction.REQUEST_AUTH);
        n.setData("Provide websocket authentication ticket");
        this._authenticated = false;
        this.send(n);
    }

    public void onMessage(String s) {
        WsMessage message = this.decodeJSON(WsMessage.class, s);
        if (message == null) {
            if (!this._authenticated) {
                this.closeSocket();
            }
            return;
        }
        this.log.info("received message:" + message.getAction().toString());
        if (!this._authenticated) {
            try {
                this.performClientAuthentication(message);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.log.info(e.getMessage());
            }
            return;
        }
        this.processMessage(message);
    }

    private void performClientAuthentication(WsMessage message) {
        WsTicket ticket;
        if (message.getAction() != WsMessageAction.AUTH) {
            this.log.info("first message received wasn't an auth message, closing socket");
            this.closeSocket();
        }
        if ((ticket = this.decodeData(WsTicket.class, message.getData())) == null) {
            this.log.info("the auth message payload wasn't a ticket");
            this.closeSocket();
            return;
        }
        if (this._wsSessionManager.validateTicket(ticket, this)) {
            this.log.info("ticket was valid, ws now authenticated");
            this._authenticated = true;
            this._wsSessionManager.addSession(this);
            WsMessage helloMsg = new WsMessage();
            helloMsg.setAction(WsMessageAction.HELLO);
            this.send(helloMsg);
            return;
        }
        this.log.info("invalid ticket!");
        this.closeSocket();
    }

    public boolean isSubscribeToApi(String api) {
        boolean isSubscribed = this._subscribedApis.contains(api);
        this.log.info("is session " + this.getId() + " subscribed to api " + api + "?:" + isSubscribed);
        return isSubscribed;
    }

    public void processMessage(WsMessage message) {
        if (message.getAction() == WsMessageAction.EVENTS) {
            for (VcpEvent e : message.getEvents()) {
                if (e.getEventType() == EventType.API_SUBSCRIBE) {
                    this.onSubscribe(e);
                }
                if (e.getEventType() == EventType.API_UNSUBSCRIBE) {
                    this.onUnsubscribe(e);
                }
                this.newEvent(e);
            }
        }
    }

    public void onSubscribe(VcpEvent e) {
        for (String api : e.getAffectedApis()) {
            if (this._subscribedApis.contains(api)) continue;
            this._subscribedApis.add(api);
        }
    }

    public void onUnsubscribe(VcpEvent e) {
        for (String api : e.getAffectedApis()) {
            if (!this._subscribedApis.contains(api)) continue;
            this._subscribedApis.remove(api);
        }
    }

    public void onClose(CloseReason closeReason) {
        if (this._authenticated) {
            this._wsSessionManager.removeSession(this);
        }
        this.log.info(closeReason.toString());
        this._subscribedApis.clear();
        this.newEvent(EventType.API_UNSUBSCRIBE, null, null, null);
    }

    public void onError(Throwable thr) {
        this.log.error(thr.toString());
    }

    public synchronized void send(WsMessage o) {
        String s = Json.pretty((Object)o);
        this.log.info("sending messsage: " + o.getAction().toString());
        Throwable ex = null;
        for (int attempt = 0; attempt < 3; ++attempt) {
            try {
                this._session.getBasicRemote().sendText(s);
                return;
            }
            catch (Exception e) {
                this.log.warn("sending message on attempt " + attempt + "failed: " + e.getMessage());
                ex = e;
                continue;
            }
        }
        if (ex != null) {
            ex.printStackTrace();
        }
    }

    private <T> T decodeData(Class<T> clazz, Object data) {
        try {
            String jsonData = new Gson().toJson(data);
            this.log.info("jsonData:" + jsonData);
            Object obj = new Gson().fromJson(jsonData, clazz);
            return (T)obj;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.error("cloud not decode the data:" + e.getMessage());
            return null;
        }
    }

    private <T> T decodeJSON(Class<T> clazz, String message) {
        try {
            Object obj = new Gson().fromJson(message, clazz);
            return (T)obj;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.error("cloud not decode the message");
            return null;
        }
    }

    private void closeSocket() {
        try {
            this.log.info("closing socket");
            this._session.close();
        }
        catch (Exception e2) {
            this.log.error("failed to close the socket:" + e2.getMessage());
            return;
        }
    }

    public String getId() {
        return this._session.getId();
    }

    public String toString() {
        return "WsSession-" + this._username + "-[" + this.getId() + "]";
    }

    public void setUsername(String value) {
        this._username = value;
    }

    public String getUsername() {
        return this._username;
    }
}

