/*
 * Decompiled with CFR 0.152.
 */
package com.novell.netmessenger.admin.agent;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.application.console.snapin.MainShell;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.Shell;
import com.novell.netmessenger.admin.common.Debug;
import com.novell.netmessenger.admin.common.NDSNegotiator;
import com.novell.netmessenger.admin.common.StaticUtilities;
import java.util.Vector;

public class NNMAgentNSObject {
    private long m_lDirtyBits = 0L;
    private long m_lAgentSettingsBits = 0L;
    private static final int I_ATTR_TYPE_UNKNOWN = 0;
    private static final int I_ATTR_TYPE_INT = 1;
    private static final int I_ATTR_TYPE_STRING = 2;
    private static final int I_ATTR_TYPE_VECTOR = 3;
    private static final int I_ATTR_TYPE_BOOLEAN = 4;
    public static final int I_DEFAULT_CSP_MESSAGING = 8300;
    public static final int I_DEFAULT_MTP_MESSAGING = 0;
    public static final int I_DEFAULT_CSP_ARCHIVE = 8310;
    public static final int I_DEFAULT_MTP_ARCHIVE = 8312;
    public static final int I_DEFAULT_CSP_SESSION = 8320;
    public static final int I_DEFAULT_MTP_SESSION = 0;
    public static final int I_DEFAULT_WEB_CONSOLE_PORT = 0;
    public static final int I_AGENT_TYPE_MESSAGING = 1;
    public static final int I_AGENT_TYPE_ARCHIVE = 2;
    public static final int I_AGENT_TYPE_SESSION = 3;
    public static final boolean B_DEFAULT_LOG_TO_DISK = true;
    public static final int I_DEFAULT_DISK_CHECK_INTERVAL = 10;
    public static final int I_DEFAULT_DISK_CHECK_DELAY = 1;
    public static final int I_DEFAULT_LOG_LEVEL = 0;
    public static final int I_DEFAULT_LOG_MAX_AGE = 14;
    public static final int I_DEFAULT_LOG_MAX_SIZE = 128;
    public static final int I_AGENT_DESCRIPTION = 0;
    public static final int I_AGENT_IP_ADDRESS = 1;
    public static final int I_AGENT_IP_ADDRESS_BIND = 2;
    public static final int I_AGENT_SSL = 3;
    public static final int I_AGENT_SSL_CERT_FILE = 4;
    public static final int I_AGENT_SSL_KEY_FILE = 5;
    public static final int I_AGENT_SSL_KEY_CREDENTIALS = 6;
    public static final int I_AGENT_CERT_PATH = 7;
    public static final int I_AGENT_SERVICES = 8;
    public static final int I_AGENT_SNMP = 9;
    public static final int I_AGENT_DISK_CHECK_INTERVAL = 10;
    public static final int I_AGENT_DISK_CHECK_DELAY = 11;
    public static final int I_AGENT_LDAP_PROFILE_DN = 12;
    public static final int I_AGENT_WORK_PATH = 13;
    public static final int I_AGENT_PORT = 14;
    public static final int I_AGENT_LOG_TO_DISK = 15;
    public static final int I_AGENT_LOG_LEVEL = 16;
    public static final int I_AGENT_LOG_MAX_AGE = 17;
    public static final int I_AGENT_LOG_MAX_SIZE = 18;
    public static final int I_AGENT_LOG_PATH = 19;
    public static final int I_AGENT_WEB_CONSOLE_PORT = 20;
    public static final int I_AGENT_WEB_CONSOLE_SSL = 21;
    public static final int I_AGENT_WEB_CONSOLE_CREDENTIALS = 22;
    public static final int I_AGENT_AGENT_SETTINGS = 23;
    public static final int I_AGENT_THREADS = 24;
    public static final int I_AGENT_MAX_USERS = 25;
    public static final String S_PORT_TAG_MTP = "MTP:";
    public static final String S_PORT_TAG_CSP = "C/S:";
    public static final String[] SA_AGENT_ATTRIBUTES = new String[]{"nnmDescription", "nnmIPAddress", "nnmIPAddressBind", "nnmSSL", "nnmSSLCertFile", "nnmSSLKeyFile", "nnmSSLKeyCredentials", "nnmCertPath", "nnmServices", "nnmSNMP", "nnmDiskCheckInterval", "nnmDiskCheckDelay", "nnmLDAPProfileDN", "nnmWorkPath", "nnmPort", "nnmLogToDisk", "nnmLogLevel", "nnmLogMaxAge", "nnmLogMaxSize", "nnmLogPath", "nnmWebConsolePort", "nnmWebConsoleSSL", "nnmWebConsoleCredentials", "nnmAgentSettings", "nnmThreads", "nnmMaxUsers"};
    public static final long[] IA_MASK_ATTRIBUTES = new long[]{1L, 2L, 4L, 8L, 16L, 32L, 64L, 128L, 256L, 512L, 1024L, 2048L, 4096L, 8192L, 16384L, 32768L, 65536L, 131072L, 262144L, 524288L, 0x100000L, 0x200000L, 0x400000L, 0x800000L, 0x1000000L, 0x2000000L};
    private int m_iAgentType;
    private int m_iDiskCheckInterval;
    private int m_iDiskCheckDelay;
    private int m_iLogLevel;
    private int m_iLogMaxAge;
    private int m_iLogMaxSize;
    private int m_iWebConsolePort;
    private int m_iMTPort;
    private int m_iCSPort;
    private int m_iMaxUsers;
    private int m_iCSThreads;
    private int m_iMaxMemory;
    private int m_iIdleTimeout;
    private int m_iMaxConnections;
    private int m_iDefaultConnections;
    private int m_iQueryMaxResults;
    private boolean m_bIPAddressBind;
    private boolean m_bSSL;
    private boolean m_bSSL_MTP;
    private boolean m_bServices;
    private boolean m_bSNMP;
    private boolean m_bLogToDisk;
    private boolean m_bWebConsoleSSL;
    private String m_sDescription;
    private String m_sSSLCertFile;
    private String m_sSSLKeyFile;
    private String m_sSSLKeyCredentials;
    private String m_sCertPath;
    private String m_sLDAPProfile;
    private String m_sLogPath;
    private String m_sWebConsoleCredentials;
    private String m_sWorkPath;
    private String m_sIPAddress;
    private Vector m_vIPAddress;
    private Vector m_vPort;
    private Vector m_vAgentSettingsOriginal;
    private NSObject m_nsObj;
    private NDSNegotiator m_neg;
    private Shell m_shell;
    private static final int I_DEFAULT_MAX_USERS = 5120;
    private static final int I_DEFAULT_CS_THREADS = 15;
    private static final int I_DEFAULT_MAX_MEMORY = 10;
    private static final int I_DEFAULT_IDLE_TIMEOUT = 30;
    private static final int I_DEFAULT_QUERY_MAX_RESULT = 100;
    private static final int I_DEFAULT_MAX_CONNECTIONS = 50;
    private static final int I_DEFAULT_DEFAULT_CONNECTIONS = 10;
    private static final String S_TAG_MAX_MEMORY = "MaxArchiveMemorySize:";
    private static final String S_TAG_IDLE_TIMEOUT = "DirIdleTimeout:";
    private static final String S_TAG_QUERY_MAX_RESULT = "DirQueryMaxResults:";
    private static final String S_TAG_MAX_CONNECTIONS = "DirMaxConnections:";
    private static final String S_TAG_DEFAULT_CONNECTIONS = "DirDefConnections:";
    private static final String S_TAG_MTP_SSL = "MTPSSL:";
    public static final long L_MASK_MAX_MEMORY = 1L;
    public static final long L_MASK_IDLE_TIMEOUT = 2L;
    public static final long L_MASK_QUERY_MAX_RESULT = 4L;
    public static final long L_MASK_MAX_CONNECTIONS = 8L;
    public static final long L_MASK_DEFAULT_CONNECTIONS = 16L;
    public static final long L_MASK_MTP_SSL = 32L;

    public void setDescription(String string) {
        this.m_sDescription = string;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[0];
    }

    public String getDescription() {
        return this.m_sDescription;
    }

    public void setSSLCertFile(String string) {
        this.m_sSSLCertFile = string;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[4];
    }

    public String getSSLCertFile() {
        return this.m_sSSLCertFile;
    }

    public void setSSLKeyFile(String string) {
        this.m_sSSLKeyFile = string;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[5];
    }

    public String getSSLKeyFile() {
        return this.m_sSSLKeyFile;
    }

    public void setSSLKeyCredentials(String string) {
        this.m_sSSLKeyCredentials = string;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[6];
    }

    public String getSSLKeyCredentials() {
        return this.m_sSSLKeyCredentials;
    }

    public void setCertPath(String string) {
        this.m_sCertPath = string;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[7];
    }

    public String getCertPath() {
        return this.m_sCertPath;
    }

    public void setLDAPProfile(String string) {
        this.m_sLDAPProfile = string;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[12];
    }

    public String getLDAPProfile() {
        return this.m_sLDAPProfile;
    }

    public void setWorkPath(String string) {
        this.m_sWorkPath = string;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[13];
    }

    public String getWorkPath() {
        return this.m_sWorkPath;
    }

    public void setLogPath(String string) {
        this.m_sLogPath = string;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[19];
    }

    public String getLogPath() {
        return this.m_sLogPath;
    }

    public void setWebConsoleCredentials(String string) {
        this.m_sWebConsoleCredentials = string;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[22];
    }

    public String getWebConsoleCredentials() {
        return this.m_sWebConsoleCredentials;
    }

    public void setDiskCheckInterval(int n) {
        this.m_iDiskCheckInterval = n;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[10];
    }

    public int getDiskCheckInterval() {
        return this.m_iDiskCheckInterval;
    }

    public void setDiskCheckDelay(int n) {
        this.m_iDiskCheckDelay = n;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[11];
    }

    public int getDiskCheckDelay() {
        return this.m_iDiskCheckDelay;
    }

    public void setLogLevel(int n) {
        this.m_iLogLevel = n;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[16];
    }

    public int getLogLevel() {
        return this.m_iLogLevel;
    }

    public void setLogMaxAge(int n) {
        this.m_iLogMaxAge = n;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[17];
    }

    public int getLogMaxAge() {
        return this.m_iLogMaxAge;
    }

    public void setLogMaxSize(int n) {
        this.m_iLogMaxSize = n;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[18];
    }

    public int getLogMaxSize() {
        return this.m_iLogMaxSize;
    }

    public void setMaxUsers(int n) {
        this.m_iMaxUsers = n;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[25];
    }

    public int getMaxUsers() {
        return this.m_iMaxUsers;
    }

    public void setCSThreads(int n) {
        this.m_iCSThreads = n;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[24];
    }

    public int getCSThreads() {
        return this.m_iCSThreads;
    }

    public void setMaxMemory(int n) {
        this.m_iMaxMemory = n;
        this.m_lAgentSettingsBits |= 1L;
    }

    public int getMaxMemory() {
        return this.m_iMaxMemory;
    }

    public void setIdleTimeout(int n) {
        this.m_iIdleTimeout = n;
        this.m_lAgentSettingsBits |= 2L;
    }

    public int getIdleTimeout() {
        return this.m_iIdleTimeout;
    }

    public void setMaxConnections(int n) {
        this.m_iMaxConnections = n;
        this.m_lAgentSettingsBits |= 8L;
    }

    public int getMaxConnections() {
        return this.m_iMaxConnections;
    }

    public void setDefaultConnections(int n) {
        this.m_iDefaultConnections = n;
        this.m_lAgentSettingsBits |= 0x10L;
    }

    public int getDefaultConnections() {
        return this.m_iDefaultConnections;
    }

    public void setSSL_MTP(boolean bl) {
        this.m_bSSL_MTP = bl;
        this.m_lAgentSettingsBits |= 0x20L;
    }

    public boolean getSSL_MTP() {
        return this.m_bSSL_MTP;
    }

    public void setQueryMaxResults(int n) {
        this.m_iQueryMaxResults = n;
        this.m_lAgentSettingsBits |= 4L;
    }

    public int getQueryMaxResults() {
        return this.m_iQueryMaxResults;
    }

    public void setWebConsolePort(int n) {
        this.m_iWebConsolePort = n;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[20];
    }

    public int getWebConsolePort() {
        return this.m_iWebConsolePort;
    }

    public void setIPAddress(String string) {
        this.m_sIPAddress = string;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[1];
    }

    public String getIPAddress() {
        return this.m_sIPAddress;
    }

    public void setIPAddressBind(boolean bl) {
        this.m_bIPAddressBind = bl;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[2];
    }

    public boolean getIPAddressBind() {
        return this.m_bIPAddressBind;
    }

    public void setSSL(boolean bl) {
        this.m_bSSL = bl;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[3];
    }

    public boolean getSSL() {
        return this.m_bSSL;
    }

    public void setServices(boolean bl) {
        this.m_bServices = bl;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[8];
    }

    public boolean getServices() {
        return this.m_bServices;
    }

    public void setSNMP(boolean bl) {
        this.m_bSNMP = bl;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[9];
    }

    public boolean getSNMP() {
        return this.m_bSNMP;
    }

    public void setLogToDisk(boolean bl) {
        this.m_bLogToDisk = bl;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[15];
    }

    public boolean getLogToDisk() {
        return this.m_bLogToDisk;
    }

    public void setWebConsoleSSL(boolean bl) {
        this.m_bWebConsoleSSL = bl;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[21];
    }

    public boolean getWebConsoleSSL() {
        return this.m_bWebConsoleSSL;
    }

    public void setMTPort(int n) {
        this.m_iMTPort = n;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[14];
    }

    public int getMTPort() {
        return this.m_iMTPort;
    }

    public void setCSPort(int n) {
        this.m_iCSPort = n;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[14];
    }

    public int getCSPort() {
        int n = this.m_iCSPort == 0 ? (this.m_iAgentType == 1 ? 8300 : (this.m_iAgentType == 2 ? 8310 : 8320)) : this.m_iCSPort;
        return n;
    }

    private void setIPAddressVector(Vector vector) {
        if (vector != null && vector.size() > 0) {
            this.m_sIPAddress = (String)vector.elementAt(0);
        }
    }

    private Vector getIPAddressVector() {
        Vector<String> vector = null;
        if (this.m_sIPAddress != null) {
            vector = new Vector<String>(1);
            vector.addElement(this.m_sIPAddress);
        }
        return vector;
    }

    private void setPort(Vector vector) {
        if (vector != null) {
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                int n2;
                int n3;
                String string;
                String string2;
                String string3 = (String)vector.elementAt(i);
                int n4 = string3.indexOf(58);
                if (n4 == -1) continue;
                try {
                    string2 = string3.substring(0, n4 + 1);
                    string = string3.substring(n4 + 1);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    continue;
                }
                if (this.m_iAgentType == 1) {
                    n3 = 8300;
                    n2 = 0;
                } else if (this.m_iAgentType == 2) {
                    n3 = 8310;
                    n2 = 8312;
                } else {
                    n3 = 8320;
                    n2 = 0;
                }
                if (string2.equalsIgnoreCase(S_PORT_TAG_MTP)) {
                    this.setMTPort(StaticUtilities.parseInt2(string, n2));
                    continue;
                }
                if (string2.equalsIgnoreCase(S_PORT_TAG_CSP)) {
                    this.setCSPort(StaticUtilities.parseInt2(string, n3));
                    continue;
                }
                Debug.trace("NNMAgentNSObject.setPort: UNKNOWN sKey = " + string2);
            }
        }
    }

    private Vector getPort() {
        Vector<String> vector = new Vector<String>();
        vector.addElement(S_PORT_TAG_MTP + this.getMTPort());
        vector.addElement(S_PORT_TAG_CSP + this.getCSPort());
        return vector;
    }

    private void setAgentSettings(Vector vector) {
        Debug.trace("\n NNMAgentNSObject.setAgentSettings: vec= " + vector);
        this.m_vAgentSettingsOriginal = vector;
        if (vector != null) {
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                String string;
                String string2;
                String string3 = (String)vector.elementAt(i);
                int n2 = string3.indexOf(58);
                if (n2 == -1) continue;
                try {
                    string2 = string3.substring(0, n2 + 1);
                    string = string3.substring(n2 + 1);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    continue;
                }
                if (string2.equalsIgnoreCase(S_TAG_MAX_MEMORY)) {
                    this.setMaxMemory(StaticUtilities.parseInt2(string, 10));
                    continue;
                }
                if (string2.equalsIgnoreCase(S_TAG_IDLE_TIMEOUT)) {
                    this.setIdleTimeout(StaticUtilities.parseInt2(string, 30));
                    continue;
                }
                if (string2.equalsIgnoreCase(S_TAG_MAX_CONNECTIONS)) {
                    this.setMaxConnections(StaticUtilities.parseInt2(string, 50));
                    continue;
                }
                if (string2.equalsIgnoreCase(S_TAG_DEFAULT_CONNECTIONS)) {
                    this.setDefaultConnections(StaticUtilities.parseInt2(string, 10));
                    continue;
                }
                if (string2.equalsIgnoreCase(S_TAG_QUERY_MAX_RESULT)) {
                    this.setQueryMaxResults(StaticUtilities.parseInt2(string, 100));
                    continue;
                }
                if (string2.equalsIgnoreCase(S_TAG_MTP_SSL)) {
                    this.setSSL_MTP(this.strValToBoolean(string));
                    continue;
                }
                Debug.trace("NNMAgentNSObject.setAgentSettings: UNKNOWN sKey= " + string2);
            }
        }
        if ((this.m_lAgentSettingsBits & 1L) == 0L) {
            this.setMaxMemory(10);
        }
        if ((this.m_lAgentSettingsBits & 2L) == 0L) {
            this.setIdleTimeout(30);
        }
        if ((this.m_lAgentSettingsBits & 8L) == 0L) {
            this.setMaxConnections(50);
        }
        if ((this.m_lAgentSettingsBits & 0x10L) == 0L) {
            this.setDefaultConnections(10);
        }
        if ((this.m_lAgentSettingsBits & 4L) == 0L) {
            this.setQueryMaxResults(100);
        }
        if ((this.m_lAgentSettingsBits & 0x20L) == 0L) {
            this.setSSL_MTP(this.strValToBoolean(this.getServerSSL()));
        }
    }

    private Vector getAgentSettings() {
        Vector<String> vector = new Vector<String>();
        if ((this.m_lAgentSettingsBits & 1L) > 0L) {
            vector.addElement(S_TAG_MAX_MEMORY + this.getMaxMemory());
            this.removeEntry(this.m_vAgentSettingsOriginal, S_TAG_MAX_MEMORY);
        }
        if ((this.m_lAgentSettingsBits & 2L) > 0L) {
            vector.addElement(S_TAG_IDLE_TIMEOUT + this.getIdleTimeout());
            this.removeEntry(this.m_vAgentSettingsOriginal, S_TAG_IDLE_TIMEOUT);
        }
        if ((this.m_lAgentSettingsBits & 8L) > 0L) {
            vector.addElement(S_TAG_MAX_CONNECTIONS + this.getMaxConnections());
            this.removeEntry(this.m_vAgentSettingsOriginal, S_TAG_MAX_CONNECTIONS);
        }
        if ((this.m_lAgentSettingsBits & 0x10L) > 0L) {
            vector.addElement(S_TAG_DEFAULT_CONNECTIONS + this.getDefaultConnections());
            this.removeEntry(this.m_vAgentSettingsOriginal, S_TAG_DEFAULT_CONNECTIONS);
        }
        if ((this.m_lAgentSettingsBits & 4L) > 0L) {
            vector.addElement(S_TAG_QUERY_MAX_RESULT + this.getQueryMaxResults());
            this.removeEntry(this.m_vAgentSettingsOriginal, S_TAG_QUERY_MAX_RESULT);
        }
        if ((this.m_lAgentSettingsBits & 0x20L) > 0L) {
            vector.addElement(S_TAG_MTP_SSL + this.booleanValToString(this.getSSL_MTP()));
            this.removeEntry(this.m_vAgentSettingsOriginal, S_TAG_MTP_SSL);
        }
        if (this.m_vAgentSettingsOriginal != null) {
            for (int i = 0; i < this.m_vAgentSettingsOriginal.size(); ++i) {
                vector.addElement((String)this.m_vAgentSettingsOriginal.elementAt(i));
            }
        }
        return vector;
    }

    protected void removeEntry(Vector vector, String string) {
        if (vector != null && string != null && string.trim().length() > 0) {
            for (int i = vector.size() - 1; i >= 0; --i) {
                String string2 = (String)vector.elementAt(i);
                if (!string2.startsWith(string)) continue;
                vector.remove(i);
            }
        }
    }

    protected String getServerSSL() {
        String string = null;
        ObjectEntry objectEntry = this.m_nsObj.getObjectEntry().getParent();
        if (objectEntry != null) {
            NDSNamespace nDSNamespace = (NDSNamespace)objectEntry.getNamespace();
            try {
                NSObject nSObject = nDSNamespace.getDetails(objectEntry);
                string = this.m_neg.getAttribute(nSObject, SA_AGENT_ATTRIBUTES[3]);
            }
            catch (SPIException sPIException) {
                string = null;
            }
        }
        return string;
    }

    protected int getAttributeType(int n) {
        int n2;
        switch (n) {
            case 10: 
            case 11: 
            case 17: 
            case 18: 
            case 20: 
            case 24: 
            case 25: {
                n2 = 1;
                break;
            }
            case 0: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 13: 
            case 16: 
            case 19: 
            case 22: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 15: 
            case 21: {
                n2 = 4;
                break;
            }
            case 1: 
            case 14: 
            case 23: {
                n2 = 3;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        return n2;
    }

    public void setAttribute(int n, int n2) {
        switch (n) {
            case 10: {
                this.setDiskCheckInterval(n2);
                break;
            }
            case 11: {
                this.setDiskCheckDelay(n2);
                break;
            }
            case 16: {
                this.setLogLevel(n2);
                break;
            }
            case 17: {
                this.setLogMaxAge(n2);
                break;
            }
            case 18: {
                this.setLogMaxSize(n2);
                break;
            }
            case 20: {
                this.setWebConsolePort(n2);
                break;
            }
            case 24: {
                this.setCSThreads(n2);
                break;
            }
            case 25: {
                this.setMaxUsers(n2);
                break;
            }
            default: {
                System.out.println("Unhandled attribute: AgentNSObject/setAttribute/" + n);
            }
        }
    }

    public void setAttribute(int n, boolean bl) {
        switch (n) {
            case 2: {
                this.setIPAddressBind(bl);
                break;
            }
            case 3: {
                this.setSSL(bl);
                break;
            }
            case 8: {
                this.setServices(bl);
                break;
            }
            case 9: {
                this.setSNMP(bl);
                break;
            }
            case 15: {
                this.setLogToDisk(bl);
                break;
            }
            case 21: {
                this.setWebConsoleSSL(bl);
                break;
            }
            default: {
                System.out.println("Unhandled attribute: AgentNSObject/setAttribute/" + n);
            }
        }
    }

    public void setAttribute(int n, String string) {
        int n2 = this.getAttributeType(n);
        if (n2 == 1) {
            int n3;
            try {
                n3 = Integer.parseInt(string);
            }
            catch (Exception exception) {
                n3 = -1;
            }
            this.setAttribute(n, n3);
        } else if (n2 == 4) {
            this.setAttribute(n, this.strValToBoolean(string));
        } else {
            switch (n) {
                case 0: {
                    this.setDescription(string);
                    break;
                }
                case 4: {
                    this.setSSLCertFile(string);
                    break;
                }
                case 5: {
                    this.setSSLKeyFile(string);
                    break;
                }
                case 6: {
                    this.setSSLKeyCredentials(string);
                    break;
                }
                case 7: {
                    this.setCertPath(string);
                    break;
                }
                case 12: {
                    this.setLDAPProfile(string);
                    break;
                }
                case 13: {
                    this.setWorkPath(string);
                    break;
                }
                case 19: {
                    this.setLogPath(string);
                    break;
                }
                case 22: {
                    this.setWebConsoleCredentials(string);
                    break;
                }
                default: {
                    System.out.println("Unhandled attribute: AgentNSObject/setAttribute/" + n);
                }
            }
        }
    }

    public void setAttribute(int n, Vector vector) {
        switch (n) {
            case 1: {
                this.setIPAddressVector(vector);
                break;
            }
            case 14: {
                this.setPort(vector);
                break;
            }
            case 23: {
                this.setAgentSettings(vector);
                break;
            }
            default: {
                System.out.println("Unhandled attribute: AgentNSObject/setAttribute/" + n);
            }
        }
    }

    public boolean resetAttribute(int n) {
        boolean bl;
        int n2 = this.getAttributeType(n);
        if (n2 == 0) {
            bl = false;
        } else if (n2 == 3) {
            this.m_neg.setMultiValuedAttribute(this.m_nsObj, SA_AGENT_ATTRIBUTES[n], null);
            bl = this.m_neg.update(this.m_nsObj);
            if (bl) {
                Vector vector = this.mergeMultiValuedAttribute(SA_AGENT_ATTRIBUTES[n]);
                this.setAttribute(n, vector);
            }
        } else {
            this.m_neg.setAttribute(this.m_nsObj, SA_AGENT_ATTRIBUTES[n], null);
            bl = this.m_neg.update(this.m_nsObj);
            if (bl) {
                String string = this.mergeAttribute(SA_AGENT_ATTRIBUTES[n]);
                this.setAttribute(n, string);
            }
        }
        return bl;
    }

    public boolean resetAttributes(int[] nArray) {
        boolean bl = true;
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                bl &= this.resetAttribute(nArray[i]);
            }
        }
        return bl;
    }

    private boolean strValToBoolean(String string) {
        return string != null && string.equals("1");
    }

    private String booleanValToString(boolean bl) {
        return bl ? "1" : "0";
    }

    private String mergeAttribute(String string) {
        ObjectEntry objectEntry;
        ObjectEntry objectEntry2;
        String string2 = this.m_neg.getAttribute(this.m_nsObj, string);
        if (string2 == null && (objectEntry2 = (objectEntry = this.m_nsObj.getObjectEntry()).getParent()) != null) {
            NDSNamespace nDSNamespace = (NDSNamespace)objectEntry2.getNamespace();
            try {
                NSObject nSObject = nDSNamespace.getDetails(objectEntry2);
                string2 = this.m_neg.getAttribute(nSObject, string);
                Debug.trace("NNMAgentNSObject.mergeAttribute:  SERVER value= " + string2);
            }
            catch (SPIException sPIException) {
                // empty catch block
            }
        }
        return string2;
    }

    private Vector mergeMultiValuedAttribute(String string) {
        ObjectEntry objectEntry;
        ObjectEntry objectEntry2;
        Vector vector = this.m_neg.getMultiValuedAttribute(this.m_nsObj, string);
        Debug.trace("NNMAgentNSObject.mergeMultiValuedAttribute: attr= " + string + "\n   AGENT value= " + vector);
        if (vector == null && (objectEntry2 = (objectEntry = this.m_nsObj.getObjectEntry()).getParent()) != null) {
            NDSNamespace nDSNamespace = (NDSNamespace)objectEntry2.getNamespace();
            try {
                NSObject nSObject = nDSNamespace.getDetails(objectEntry2);
                vector = this.m_neg.getMultiValuedAttribute(nSObject, string);
                Debug.trace("NNMAgentNSObject.mergeMultiValuedAttribute:  SERVER value= " + vector);
            }
            catch (SPIException sPIException) {
                // empty catch block
            }
        }
        return vector;
    }

    public int getAgentType() {
        return this.m_iAgentType;
    }

    protected boolean load(NSObject nSObject) {
        Debug.trace("  ==================== NNMAgentNSObject.load ======================");
        this.m_shell = MainShell.getInstance();
        this.m_neg = new NDSNegotiator();
        this.m_nsObj = nSObject;
        if (nSObject.getObjectEntry().getObjectType().getName().equals("nnmMessagingAgent")) {
            this.m_iAgentType = 1;
        } else if (nSObject.getObjectEntry().getObjectType().getName().equals("nnmArchiveAgent")) {
            this.m_iAgentType = 2;
        } else if (nSObject.getObjectEntry().getObjectType().getName().equals("nnmSessionAgent")) {
            this.m_iAgentType = 3;
        } else {
            System.out.println("Unknown agent type: AgentNSObject/load/" + nSObject.getObjectEntry().getObjectType().getName());
            return false;
        }
        this.setPort(this.m_neg.getMultiValuedAttribute(nSObject, SA_AGENT_ATTRIBUTES[14]));
        this.setDescription(this.m_neg.getAttribute(nSObject, SA_AGENT_ATTRIBUTES[0]));
        this.setIPAddressVector(this.mergeMultiValuedAttribute(SA_AGENT_ATTRIBUTES[1]));
        this.setSSLCertFile(this.mergeAttribute(SA_AGENT_ATTRIBUTES[4]));
        this.setSSLKeyFile(this.mergeAttribute(SA_AGENT_ATTRIBUTES[5]));
        this.setSSLKeyCredentials(this.mergeAttribute(SA_AGENT_ATTRIBUTES[6]));
        this.setCertPath(this.mergeAttribute(SA_AGENT_ATTRIBUTES[7]));
        this.setLDAPProfile(this.mergeAttribute(SA_AGENT_ATTRIBUTES[12]));
        this.setWorkPath(this.mergeAttribute(SA_AGENT_ATTRIBUTES[13]));
        String string = this.mergeAttribute(SA_AGENT_ATTRIBUTES[2]);
        this.setIPAddressBind(this.strValToBoolean(string));
        string = this.mergeAttribute(SA_AGENT_ATTRIBUTES[3]);
        this.setSSL(this.strValToBoolean(string));
        string = this.mergeAttribute(SA_AGENT_ATTRIBUTES[8]);
        this.setServices(this.strValToBoolean(string));
        string = this.mergeAttribute(SA_AGENT_ATTRIBUTES[9]);
        this.setSNMP(this.strValToBoolean(string));
        string = this.mergeAttribute(SA_AGENT_ATTRIBUTES[10]);
        this.setDiskCheckInterval(StaticUtilities.parseInt2(string, 10));
        string = this.mergeAttribute(SA_AGENT_ATTRIBUTES[11]);
        this.setDiskCheckDelay(StaticUtilities.parseInt2(string, 1));
        this.setLogPath(this.m_neg.getAttribute(nSObject, SA_AGENT_ATTRIBUTES[19]));
        string = this.m_neg.getAttribute(nSObject, SA_AGENT_ATTRIBUTES[15]);
        this.setLogToDisk(this.strValToBoolean(string));
        string = this.m_neg.getAttribute(nSObject, SA_AGENT_ATTRIBUTES[16]);
        this.setLogLevel(StaticUtilities.parseInt2(string, 0));
        string = this.m_neg.getAttribute(nSObject, SA_AGENT_ATTRIBUTES[17]);
        this.setLogMaxAge(StaticUtilities.parseInt2(string, 14));
        string = this.m_neg.getAttribute(nSObject, SA_AGENT_ATTRIBUTES[18]);
        this.setLogMaxSize(StaticUtilities.parseInt2(string, 128));
        this.setWebConsoleCredentials(this.m_neg.getAttribute(nSObject, SA_AGENT_ATTRIBUTES[22]));
        string = this.m_neg.getAttribute(nSObject, SA_AGENT_ATTRIBUTES[21]);
        if (string == null) {
            string = this.getServerSSL();
        }
        this.setWebConsoleSSL(this.strValToBoolean(string));
        string = this.m_neg.getAttribute(nSObject, SA_AGENT_ATTRIBUTES[20]);
        this.setWebConsolePort(StaticUtilities.parseInt2(string, 0));
        string = this.m_neg.getAttribute(nSObject, SA_AGENT_ATTRIBUTES[25]);
        this.setMaxUsers(StaticUtilities.parseInt2(string, 5120));
        string = this.m_neg.getAttribute(nSObject, SA_AGENT_ATTRIBUTES[24]);
        this.setCSThreads(StaticUtilities.parseInt2(string, 15));
        this.setAgentSettings(this.m_neg.getMultiValuedAttribute(nSObject, SA_AGENT_ATTRIBUTES[23]));
        this.m_lDirtyBits = 0L;
        this.m_lAgentSettingsBits = 0L;
        return true;
    }

    protected boolean save(NSObject nSObject) {
        boolean bl;
        String string;
        Debug.trace("\n\n================== NNMAgentNSObject.save: m_lDirtyBits= 0x" + Long.toHexString(this.m_lDirtyBits));
        if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[0]) != 0L) {
            this.m_neg.setAttribute(nSObject, SA_AGENT_ATTRIBUTES[0], this.getDescription());
        }
        if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[4]) != 0L) {
            this.m_neg.setAttribute(nSObject, SA_AGENT_ATTRIBUTES[4], this.getSSLCertFile());
        }
        if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[5]) != 0L) {
            this.m_neg.setAttribute(nSObject, SA_AGENT_ATTRIBUTES[5], this.getSSLKeyFile());
        }
        if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[6]) != 0L) {
            this.m_neg.setAttribute(nSObject, SA_AGENT_ATTRIBUTES[6], this.getSSLKeyCredentials());
        }
        if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[7]) != 0L) {
            this.m_neg.setAttribute(nSObject, SA_AGENT_ATTRIBUTES[7], this.getCertPath());
        }
        if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[22]) != 0L) {
            this.m_neg.setAttribute(nSObject, SA_AGENT_ATTRIBUTES[22], this.getWebConsoleCredentials());
        }
        if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[12]) != 0L) {
            this.m_neg.setAttribute(nSObject, SA_AGENT_ATTRIBUTES[12], this.getLDAPProfile());
        }
        if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[13]) != 0L) {
            this.m_neg.setAttribute(nSObject, SA_AGENT_ATTRIBUTES[13], this.getWorkPath());
        }
        if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[8]) != 0L) {
            string = this.booleanValToString(this.getServices());
            this.m_neg.setAttribute(nSObject, SA_AGENT_ATTRIBUTES[8], string);
        }
        if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[2]) != 0L) {
            string = this.booleanValToString(this.getIPAddressBind());
            this.m_neg.setAttribute(nSObject, SA_AGENT_ATTRIBUTES[2], string);
        }
        if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[15]) != 0L) {
            string = this.booleanValToString(this.getLogToDisk());
            this.m_neg.setAttribute(nSObject, SA_AGENT_ATTRIBUTES[15], string);
        }
        if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[3]) != 0L) {
            string = this.booleanValToString(this.getSSL());
            this.m_neg.setAttribute(nSObject, SA_AGENT_ATTRIBUTES[3], string);
        }
        if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[9]) != 0L) {
            string = this.booleanValToString(this.getSNMP());
            this.m_neg.setAttribute(nSObject, SA_AGENT_ATTRIBUTES[9], string);
        }
        if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[21]) != 0L) {
            string = this.booleanValToString(this.getWebConsoleSSL());
            this.m_neg.setAttribute(nSObject, SA_AGENT_ATTRIBUTES[21], string);
        }
        if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[20]) != 0L) {
            this.m_neg.setAttribute(nSObject, SA_AGENT_ATTRIBUTES[20], String.valueOf(this.getWebConsolePort()));
        }
        if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[19]) != 0L) {
            this.m_neg.setAttribute(nSObject, SA_AGENT_ATTRIBUTES[19], this.getLogPath());
        }
        if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[16]) != 0L) {
            this.m_neg.setAttribute(nSObject, SA_AGENT_ATTRIBUTES[16], String.valueOf(this.getLogLevel()));
        }
        if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[17]) != 0L) {
            this.m_neg.setAttribute(nSObject, SA_AGENT_ATTRIBUTES[17], String.valueOf(this.getLogMaxAge()));
        }
        if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[18]) != 0L) {
            this.m_neg.setAttribute(nSObject, SA_AGENT_ATTRIBUTES[18], String.valueOf(this.getLogMaxSize()));
        }
        if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[10]) != 0L) {
            this.m_neg.setAttribute(nSObject, SA_AGENT_ATTRIBUTES[10], String.valueOf(this.getDiskCheckInterval()));
        }
        if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[11]) != 0L) {
            this.m_neg.setAttribute(nSObject, SA_AGENT_ATTRIBUTES[11], String.valueOf(this.getDiskCheckDelay()));
        }
        if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[1]) != 0L) {
            this.m_neg.setMultiValuedAttribute(nSObject, SA_AGENT_ATTRIBUTES[1], this.getIPAddressVector());
        }
        if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[14]) != 0L) {
            this.m_neg.setMultiValuedAttribute(nSObject, SA_AGENT_ATTRIBUTES[14], this.getPort());
        }
        if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[25]) > 0L) {
            this.m_neg.setAttribute(nSObject, SA_AGENT_ATTRIBUTES[25], String.valueOf(this.getMaxUsers()));
        }
        if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[24]) > 0L) {
            this.m_neg.setAttribute(nSObject, SA_AGENT_ATTRIBUTES[24], String.valueOf(this.getCSThreads()));
        }
        if (this.m_lAgentSettingsBits > 0L) {
            this.m_neg.setMultiValuedAttribute(nSObject, SA_AGENT_ATTRIBUTES[23], this.getAgentSettings());
        }
        if (!(bl = this.m_neg.update(nSObject)) && Debug.trace) {
            Debug.trace("\n=================" + this.toString());
            Debug.traceDlg("NNMAgentNSObject.save: Error on update of " + nSObject);
        }
        return bl;
    }
}

