/*
 * Decompiled with CFR 0.152.
 */
package com.novell.netmessenger.admin.agent;

import com.novell.admin.common.security.NSetPasswordDlg;
import com.novell.admin.common.snapins.AdminPageSnapin;
import com.novell.admin.ns.NSObject;
import com.novell.application.console.snapin.InitSnapinInfo;
import com.novell.application.console.snapin.PageSnapin;
import com.novell.netmessenger.admin.agent.NNMAgentPage;
import com.novell.netmessenger.admin.agent.NNMAgentResource;
import com.novell.netmessenger.admin.common.FilePathTextField;
import com.novell.netmessenger.admin.common.StaticUtilities;
import com.novell.netmessenger.admin.server.NNMServerResource;
import com.novell.netmessenger.admin.swingext.JButtonExt;
import com.novell.netmessenger.admin.swingext.JCheckBoxExt;
import com.novell.netmessenger.admin.swingext.JLabelExt;
import com.novell.utility.nmsgbox.NMsgBox;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.text.Document;

public class NNMAgentPanelSecurity
extends NNMAgentPage {
    private static final NNMServerResource m_serverRes = NNMServerResource.getInstance();
    private JCheckBoxExt m_cbSSL;
    private JCheckBoxExt m_cbSSL_MTP;
    private JButtonExt m_btnPassword;
    private JButtonExt m_btnResetAttributes;
    private FilePathTextField m_tfSSLCertFile;
    private FilePathTextField m_tfSSLKeyFile;
    private FilePathTextField m_tfCertPath;
    private String m_sPassword;

    public NNMAgentPanelSecurity(InitSnapinInfo initSnapinInfo, AdminPageSnapin adminPageSnapin, NSObject nSObject) {
        super(initSnapinInfo, adminPageSnapin, nSObject);
    }

    protected void init() {
        this.m_cbSSL = new JCheckBoxExt(NNMAgentResource.get("AgentSecuritySSL"));
        this.m_cbSSL_MTP = new JCheckBoxExt(NNMAgentResource.get("AgentSecuritySSLForMTP"));
        this.m_btnPassword = new JButtonExt(NNMServerResource.get("ServerSecurityPasswordButton"));
        this.m_btnPassword.addActionListener(this);
        this.m_tfSSLCertFile = new FilePathTextField(this.propertyBook.getComponent(), 0);
        this.m_tfSSLKeyFile = new FilePathTextField(this.propertyBook.getComponent(), 0);
        this.m_tfCertPath = new FilePathTextField(this.propertyBook.getComponent(), 1);
        this.m_btnResetAttributes = new JButtonExt(NNMAgentResource.get("AgentResetAttributes"));
        this.m_btnResetAttributes.addActionListener(this);
    }

    public void layoutControls() {
        this.init();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(NNMServerResource.get("ServerSecuritySSLPanel")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 18;
        JLabelExt jLabelExt = new JLabelExt(NNMServerResource.get("ServerSecurityCertFile"), this.m_tfSSLCertFile);
        JLabelExt jLabelExt2 = new JLabelExt(NNMServerResource.get("ServerSecurityKeyFile"), this.m_tfSSLKeyFile);
        JLabelExt jLabelExt3 = new JLabelExt(NNMServerResource.get("ServerSecurityPassword"));
        JLabelExt jLabelExt4 = new JLabelExt(NNMServerResource.get("ServerSecurityCertPath"), this.m_tfCertPath);
        this.setLayout(new GridBagLayout());
        int n = 1;
        this.setGBC(gridBagConstraints, 1, n, 1, 1, 0, 0.3, 0.0);
        this.add(jLabelExt4, gridBagConstraints);
        gridBagConstraints.insets.left = 2;
        this.setGBC(gridBagConstraints, 2, n, 1, 1, 2, 0.7, 0.0);
        this.add(this.m_tfCertPath, gridBagConstraints);
        ++n;
        this.setGBC(gridBagConstraints, 1, 1, 1, 1, 0, 0.3, 0.0);
        jPanel.add((Component)jLabelExt, gridBagConstraints);
        this.setGBC(gridBagConstraints, 2, 1, 1, 1, 2, 0.7, 0.0);
        jPanel.add((Component)this.m_tfSSLCertFile, gridBagConstraints);
        this.setGBC(gridBagConstraints, 1, 2, 1, 1, 0, 0.3, 0.0);
        jPanel.add((Component)jLabelExt2, gridBagConstraints);
        this.setGBC(gridBagConstraints, 2, 2, 1, 1, 2, 0.7, 0.0);
        jPanel.add((Component)this.m_tfSSLKeyFile, gridBagConstraints);
        this.setGBC(gridBagConstraints, 2, 3, 1, 1, 0, 0.7, 0.0);
        jPanel.add((Component)this.m_btnPassword, gridBagConstraints);
        this.setGBC(gridBagConstraints, 1, n, 2, 1, 2, 0.0, 0.0);
        this.add(jPanel, gridBagConstraints);
        this.setGBC(gridBagConstraints, 1, ++n, 2, 1, 0, 0.0, 0.0);
        this.add(this.m_cbSSL, gridBagConstraints);
        ++n;
        if (this.m_agentNSObject.getAgentType() == 2) {
            this.setGBC(gridBagConstraints, 1, n, 2, 1, 0, 0.0, 0.0);
            this.add(this.m_cbSSL_MTP, gridBagConstraints);
            ++n;
        }
        this.setGBC(gridBagConstraints, 1, n, 2, 1, 0, 0.0, 0.0);
        this.add(this.m_btnResetAttributes, gridBagConstraints);
        this.setGBC(gridBagConstraints, 1, ++n, 2, 1, 0, 0.0, 1.0);
        this.add(new JLabelExt(""), gridBagConstraints);
    }

    protected void addListeners() {
        this.m_cbSSL.addItemListener(this);
        this.m_cbSSL_MTP.addItemListener(this);
        this.m_tfSSLCertFile.addDocumentListener(this);
        this.m_tfSSLKeyFile.addDocumentListener(this);
        this.m_tfCertPath.addDocumentListener(this);
    }

    protected void removeListeners() {
        this.m_cbSSL.removeItemListener(this);
        this.m_cbSSL_MTP.removeItemListener(this);
        this.m_tfSSLCertFile.removeDocumentListener(this);
        this.m_tfSSLKeyFile.removeDocumentListener(this);
        this.m_tfCertPath.removeDocumentListener(this);
    }

    public void readData() {
        this.m_cbSSL.setSelected(this.m_agentNSObject.getSSL());
        this.m_cbSSL_MTP.setSelected(this.m_agentNSObject.getSSL_MTP());
        this.m_tfSSLCertFile.setText(this.m_agentNSObject.getSSLCertFile());
        this.m_tfSSLKeyFile.setText(this.m_agentNSObject.getSSLKeyFile());
        String string = this.m_agentNSObject.getSSLKeyCredentials();
        if (string != null) {
            try {
                this.m_sPassword = StaticUtilities.decodeDecrypt(string);
            }
            catch (Exception exception) {
                this.m_sPassword = null;
            }
        }
        this.m_tfCertPath.setText(this.m_agentNSObject.getCertPath());
        this.updateUI(this.m_tfSSLCertFile.getDocument());
        this.updateUI(this.m_tfSSLKeyFile.getDocument());
        this.addListeners();
    }

    public boolean saveData() {
        String string;
        String string2 = null;
        if (this.m_cbSSL.isModified()) {
            this.m_agentNSObject.setSSL(this.m_cbSSL.isSelected());
        }
        if (this.m_cbSSL_MTP.isModified()) {
            this.m_agentNSObject.setSSL_MTP(this.m_cbSSL_MTP.isSelected());
        }
        if (this.m_tfSSLCertFile.isModified()) {
            string = this.m_tfSSLCertFile.getText();
            if (string == null || string.trim().length() == 0) {
                this.m_tfSSLKeyFile.setText(null);
                this.m_tfSSLKeyFile.setModified(true);
                this.m_sPassword = null;
            }
            this.m_agentNSObject.setSSLCertFile(string);
        }
        if (this.m_tfSSLKeyFile.isModified()) {
            string = this.m_tfSSLKeyFile.getText();
            if (string == null || string.trim().length() == 0) {
                this.m_sPassword = null;
            }
            this.m_agentNSObject.setSSLKeyFile(string);
        }
        if (this.m_tfCertPath.isModified()) {
            this.m_agentNSObject.setCertPath(this.m_tfCertPath.getText());
        }
        try {
            string2 = StaticUtilities.encryptEncode(this.m_sPassword);
        }
        catch (Exception exception) {
            string2 = null;
        }
        this.m_agentNSObject.setSSLKeyCredentials(string2);
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.m_btnPassword)) {
            NSetPasswordDlg nSetPasswordDlg = new NSetPasswordDlg(this.shell);
            if (nSetPasswordDlg.launch() == 1) {
                this.m_sPassword = nSetPasswordDlg.getNewPassword();
                this.propertyBook.setModified(true, (PageSnapin)this.pageSnapin);
            }
            this.fixFocus();
        } else if (actionEvent.getSource() == this.m_btnResetAttributes) {
            NMsgBox nMsgBox = new NMsgBox(this.propertyBook.getComponent(), NNMAgentResource.get("AgentResetTitle"), NNMAgentResource.get("AgentResetMessage"), 2);
            int n = nMsgBox.launch();
            this.fixFocus();
            if (n == 8) {
                int[] nArray = new int[]{3, 5, 4, 6, 7};
                this.removeListeners();
                this.resetAttributes(nArray);
            }
        }
    }

    protected void updateUI(Document document) {
        if (document.equals(this.m_tfSSLCertFile.getDocument())) {
            if (this.m_tfSSLCertFile.getText() == null || this.m_tfSSLCertFile.getText().trim().length() == 0) {
                this.m_tfSSLKeyFile.setEnabled(false);
                this.m_btnPassword.setEnabled(false);
            } else {
                this.m_tfSSLKeyFile.setEnabled(true);
                if (this.m_tfSSLKeyFile.getText() != null && this.m_tfSSLKeyFile.getText().trim().length() > 0) {
                    this.m_btnPassword.setEnabled(true);
                }
            }
        } else if (document.equals(this.m_tfSSLKeyFile.getDocument())) {
            if (this.m_tfSSLKeyFile.getText() == null || this.m_tfSSLKeyFile.getText().trim().length() == 0) {
                this.m_btnPassword.setEnabled(false);
            } else {
                this.m_btnPassword.setEnabled(true);
            }
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        super.changedUpdate(documentEvent);
        this.updateUI(documentEvent.getDocument());
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        super.insertUpdate(documentEvent);
        this.updateUI(documentEvent.getDocument());
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        super.removeUpdate(documentEvent);
        this.updateUI(documentEvent.getDocument());
    }
}

