/*
 * Decompiled with CFR 0.152.
 */
package com.novell.netmessenger.admin.agent;

import com.novell.admin.common.security.NSetPasswordDlg;
import com.novell.admin.common.snapins.AdminPageSnapin;
import com.novell.admin.ns.NSObject;
import com.novell.application.console.snapin.InitSnapinInfo;
import com.novell.application.console.snapin.PageSnapin;
import com.novell.netmessenger.admin.agent.NNMAgentPage;
import com.novell.netmessenger.admin.agent.NNMAgentResource;
import com.novell.netmessenger.admin.common.NIncrementBox;
import com.novell.netmessenger.admin.common.StaticUtilities;
import com.novell.netmessenger.admin.server.NNMServerResource;
import com.novell.netmessenger.admin.swingext.JButtonExt;
import com.novell.netmessenger.admin.swingext.JCheckBoxExt;
import com.novell.netmessenger.admin.swingext.JLabelExt;
import com.novell.netmessenger.admin.swingext.JTextFieldExt;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class NNMAgentPanelWeb
extends NNMAgentPage
implements ActionListener {
    private static final NNMServerResource m_serverRes = NNMServerResource.getInstance();
    NIncrementBox m_incConsolePort;
    JTextFieldExt m_tfUsername;
    JButtonExt m_btnPassword;
    private JCheckBoxExt m_cbSSL;
    String m_sPassword;

    public NNMAgentPanelWeb(InitSnapinInfo initSnapinInfo, AdminPageSnapin adminPageSnapin, NSObject nSObject) {
        super(initSnapinInfo, adminPageSnapin, nSObject);
    }

    protected void init() {
        this.m_incConsolePort = new NIncrementBox(0, Integer.MAX_VALUE, 0);
        this.m_tfUsername = new JTextFieldExt(new PlainDocumentExt(), "", 30);
        this.m_btnPassword = new JButtonExt(NNMServerResource.get("ServerSecurityPasswordButton"));
        this.m_btnPassword.addActionListener(this);
        this.m_cbSSL = new JCheckBoxExt(NNMAgentResource.get("AgentSecuritySSLWeb"));
    }

    public void layoutControls() {
        this.init();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(NNMAgentResource.get("AgentWebConsoleCredentials")));
        JLabelExt jLabelExt = new JLabelExt(NNMAgentResource.get("AgentWebConsolePort"), this.m_incConsolePort);
        JLabelExt jLabelExt2 = new JLabelExt(NNMAgentResource.get("AgentWebUsername"), this.m_tfUsername);
        JLabelExt jLabelExt3 = new JLabelExt(NNMAgentResource.get("AgentWebPassword"));
        this.setLayout(new GridBagLayout());
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        this.add(jLabelExt, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.9;
        this.add(this.m_incConsolePort, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.2;
        jPanel.add((Component)jLabelExt2, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.8;
        jPanel.add((Component)this.m_tfUsername, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.2;
        jPanel.add((Component)jLabelExt3, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.8;
        jPanel.add((Component)this.m_btnPassword, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        this.add(jPanel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        this.add(this.m_cbSSL, gridBagConstraints);
    }

    public void readData() {
        String string = this.m_agentNSObject.getWebConsoleCredentials();
        if (string != null) {
            StringTokenizer stringTokenizer;
            String string2;
            try {
                string2 = StaticUtilities.decodeDecrypt(string);
            }
            catch (Exception exception) {
                string2 = null;
            }
            if (string2 != null && (stringTokenizer = new StringTokenizer(string2, ":")).countTokens() == 2) {
                this.m_tfUsername.setText(stringTokenizer.nextToken());
                this.m_sPassword = stringTokenizer.nextToken();
            }
        }
        this.m_incConsolePort.setValue(this.m_agentNSObject.getWebConsolePort());
        this.m_cbSSL.setSelected(this.m_agentNSObject.getWebConsoleSSL());
        this.m_tfUsername.addDocumentListener(this);
        this.m_incConsolePort.addDocumentListener(this);
        this.m_cbSSL.addItemListener(this);
    }

    public boolean saveData() {
        if (this.m_incConsolePort.isModified()) {
            this.m_agentNSObject.setWebConsolePort(this.m_incConsolePort.getValue());
        }
        if (this.m_tfUsername.isModified()) {
            String string = this.m_tfUsername.getText().trim();
            if (string.length() != 0) {
                String string2;
                String string3 = this.m_sPassword == null ? "" : this.m_sPassword.trim();
                String string4 = string + ":" + string3;
                try {
                    string2 = StaticUtilities.encryptEncode(string4);
                }
                catch (Exception exception) {
                    string2 = null;
                }
                this.m_agentNSObject.setWebConsoleCredentials(string2);
            } else {
                this.m_agentNSObject.setWebConsoleCredentials(null);
            }
        }
        if (this.m_cbSSL.isModified()) {
            this.m_agentNSObject.setWebConsoleSSL(this.m_cbSSL.isSelected());
        }
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.m_btnPassword)) {
            NSetPasswordDlg nSetPasswordDlg = new NSetPasswordDlg(this.shell);
            if (nSetPasswordDlg.launch() == 1) {
                this.m_sPassword = nSetPasswordDlg.getNewPassword();
                this.m_tfUsername.setModified(true);
                this.propertyBook.setModified(true, (PageSnapin)this.pageSnapin);
            }
            this.fixFocus();
        }
    }

    private class PlainDocumentExt
    extends PlainDocument {
        private PlainDocumentExt() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string.indexOf(58) >= 0) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            super.insertString(n, string.trim(), attributeSet);
        }
    }
}

