/*
 * Decompiled with CFR 0.152.
 */
package com.novell.netmessenger.admin.agent;

import com.novell.admin.common.snapins.AdminPageSnapin;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.application.console.snapin.InitSnapinInfo;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.netmessenger.admin.agent.NNMAgentResource;
import com.novell.netmessenger.admin.agent.NNMArchivePage;
import com.novell.netmessenger.admin.common.Debug;
import com.novell.netmessenger.admin.common.FilePathTextField;
import com.novell.netmessenger.admin.common.NDSNegotiator;
import com.novell.netmessenger.admin.common.NIncrementBox;
import com.novell.netmessenger.admin.common.StaticUtilities;
import com.novell.netmessenger.admin.swingext.JLabelExt;
import com.novell.netmessenger.admin.swingext.JTextFieldExt;
import com.novell.netmessenger.admin.system.NNMSystemNSObject;
import com.novell.utility.nmsgbox.NMsgBox;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class NNMArchivePanelArchive
extends NNMArchivePage {
    private FilePathTextField m_tfQueuePath;
    private JTextFieldExt m_tfArchivePassphrase;
    private NIncrementBox m_incArchiveDelay;
    private NIncrementBox m_incArchiveInterval;
    private NIncrementBox m_incArchiveExpire;

    public NNMArchivePanelArchive(InitSnapinInfo initSnapinInfo, AdminPageSnapin adminPageSnapin, NSObject nSObject) {
        super(initSnapinInfo, adminPageSnapin, nSObject);
        this.m_tfQueuePath = new FilePathTextField(this.propertyBook.getComponent(), 1);
        this.m_tfArchivePassphrase = new JTextFieldExt(25);
        this.m_incArchiveDelay = new NIncrementBox(0, Integer.MAX_VALUE, 0);
        this.m_incArchiveInterval = new NIncrementBox(0, Integer.MAX_VALUE, 0);
        this.m_incArchiveExpire = new NIncrementBox(0, Integer.MAX_VALUE, 0);
    }

    public void layoutControls() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 18;
        JLabelExt jLabelExt = new JLabelExt(NNMAgentResource.get("AgentArchiveQueuePath"), this.m_tfQueuePath);
        JLabelExt jLabelExt2 = new JLabelExt(NNMAgentResource.get("AgentArchivePassphrase"), this.m_tfArchivePassphrase);
        this.setLayout(new GridBagLayout());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.2;
        this.add(jLabelExt, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.8;
        gridBagConstraints.fill = 2;
        this.add(this.m_tfQueuePath, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.fill = 0;
        this.add(jLabelExt2, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 0.8;
        gridBagConstraints.fill = 2;
        this.add(this.m_tfArchivePassphrase, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        this.add(this.getStoreMaintenancePanel(), gridBagConstraints);
    }

    private JPanel getStoreMaintenancePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(NNMAgentResource.get("AgentArchiveStoreMaintenance")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 18;
        JLabelExt jLabelExt = new JLabelExt(NNMAgentResource.get("AgentArchiveDelay"), this.m_incArchiveDelay);
        JLabelExt jLabelExt2 = new JLabelExt(NNMAgentResource.get("AgentArchiveInterval"), this.m_incArchiveInterval);
        JLabelExt jLabelExt3 = new JLabelExt(NNMAgentResource.get("AgentArchiveExpire"), this.m_incArchiveExpire);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 0.1;
        jPanel.add((Component)jLabelExt, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 0.9;
        jPanel.add((Component)this.m_incArchiveDelay, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.weightx = 0.1;
        jPanel.add((Component)jLabelExt2, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.weightx = 0.9;
        jPanel.add((Component)this.m_incArchiveInterval, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.weightx = 0.1;
        jPanel.add((Component)jLabelExt3, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.weightx = 0.9;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)this.m_incArchiveExpire, gridBagConstraints);
        return jPanel;
    }

    public void readData() {
        String string;
        this.m_tfQueuePath.setText(this.m_archiveNSObject.getArchiveQueuePath());
        try {
            string = StaticUtilities.decodeDecrypt(this.m_archiveNSObject.getArchivePassphrase());
        }
        catch (Exception exception) {
            string = null;
        }
        this.m_tfArchivePassphrase.setText(string);
        this.m_incArchiveDelay.setValue(this.m_archiveNSObject.getArchiveDelay());
        this.m_incArchiveInterval.setValue(this.m_archiveNSObject.getArchiveInterval());
        this.m_incArchiveExpire.setValue(this.m_archiveNSObject.getArchiveExpire());
        this.m_tfQueuePath.addDocumentListener(this);
        this.m_tfArchivePassphrase.addDocumentListener(this);
        this.m_incArchiveDelay.addDocumentListener(this);
        this.m_incArchiveInterval.addDocumentListener(this);
        this.m_incArchiveExpire.addDocumentListener(this);
    }

    public boolean killActive() {
        ObjectEntry objectEntry;
        String string = this.m_tfArchivePassphrase.getText().trim();
        if (string.length() == 0) {
            objectEntry = null;
            try {
                objectEntry = this.nsObj.getObjectEntry().getParent().getParent();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (objectEntry != null) {
                NDSNegotiator nDSNegotiator = new NDSNegotiator();
                try {
                    NSObject nSObject = nDSNegotiator.getNSObject((NDSNamespace)objectEntry.getNamespace(), objectEntry.getFullName());
                    string = nDSNegotiator.getAttribute(nSObject, NNMSystemNSObject.SA_SYSTEM_ATTRIBUTES[9]);
                }
                catch (Exception exception) {
                    string = null;
                    exception.printStackTrace();
                }
            }
        }
        if (string == null || string.length() < 7) {
            objectEntry = new NMsgBox((Component)((Object)this), NNMAgentResource.get("AgentArchivePassphraseLengthTitle"), NNMAgentResource.get("AgentArchivePassphraseLength"), 3);
            objectEntry.launch();
            this.fixFocus();
            this.m_tfArchivePassphrase.requestFocus();
            return false;
        }
        if (this.m_incArchiveExpire.isModified() && this.m_incArchiveExpire.getValue() == 0) {
            objectEntry = new NMsgBox((Component)((Object)this), NNMAgentResource.get("AgentArchiveExpireWarnTitle"), NNMAgentResource.get("AgentArchiveExpireWarn"), 0);
            if (objectEntry.launch() == 16) {
                this.fixFocus();
                this.m_incArchiveExpire.requestFocus();
                return false;
            }
            this.fixFocus();
        }
        return super.killActive();
    }

    public boolean saveData() {
        if (this.m_tfQueuePath.isModified()) {
            this.m_archiveNSObject.setArchiveQueuePath(this.m_tfQueuePath.getText());
        }
        if (this.m_incArchiveDelay.isModified()) {
            this.m_archiveNSObject.setArchiveDelay(this.m_incArchiveDelay.getValue());
        }
        if (this.m_incArchiveInterval.isModified()) {
            this.m_archiveNSObject.setArchiveInterval(this.m_incArchiveInterval.getValue());
        }
        if (this.m_incArchiveExpire.isModified()) {
            this.m_archiveNSObject.setArchiveExpire(this.m_incArchiveExpire.getValue());
        }
        if (this.m_tfArchivePassphrase.isModified()) {
            String string;
            try {
                string = StaticUtilities.encryptEncode(this.m_tfArchivePassphrase.getText().trim());
            }
            catch (Exception exception) {
                Debug.trace("NNMArchivePanelArchive.saveData: ex= " + exception);
                string = null;
            }
            this.m_archiveNSObject.setArchivePassphrase(string);
        }
        return true;
    }
}

