/*
 * Decompiled with CFR 0.152.
 */
package com.novell.netmessenger.admin.agent;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.netmessenger.admin.agent.NNMAgentNSObject;
import com.novell.netmessenger.admin.common.NDSNegotiator;

public class NNMMessagingNSObject
extends NNMAgentNSObject {
    private static final int I_MESSAGING_FILE_TRANSFER_PATH = 0;
    private static final int I_MESSAGING_QUEUE_PATH = 1;
    private static final int I_MESSAGING_CLIENT_DOWNLOAD = 2;
    private static final int I_MASK_FILE_TRANSFER_PATH = 1;
    private static final int I_MASK_QUEUE_PATH = 2;
    private static final int I_MASK_CLIENT_DOWNLOAD = 4;
    public static final boolean B_DEFAULT_SERVICES = true;
    public static final String S_DEFAULT_LOG_PATH = "\\novell\\nm\\ma\\logs";
    public static final String S_DEFAULT_QUEUE_PATH = "\\novell\\nm\\ma\\queue";
    public static final String S_DEFAULT_FILE_TRANSFER_PATH = "\\novell\\nm\\ma\\upload";
    public static final String S_UNIX_DEFAULT_LOG_PATH = "/var/opt/novell/log/messenger";
    public static final String S_UNIX_DEFAULT_QUEUE_PATH = "/var/opt/novell/messenger/ma/queue";
    public static final String S_UNIX_DEFAULT_FILE_TRANSFER_PATH = "/var/opt/novell/messenger/ma/upload";
    private long I_DIRTY_BITS;
    private String m_sFileTransferPath;
    private String m_sQueuePath;
    private boolean m_bClientDownloadBrowser;
    private boolean m_bClientAutoUpdate;
    public static final String[] SA_MESSAGING_ATTRIBUTES = new String[]{"nnmFileTransferPath", "nnmQueuePath", "nnmClientDownload"};

    public void setFileTransferPath(String string) {
        this.m_sFileTransferPath = string;
        this.I_DIRTY_BITS |= 1L;
    }

    public String getFileTransferPath() {
        return this.m_sFileTransferPath;
    }

    public void setQueuePath(String string) {
        this.m_sQueuePath = string;
        this.I_DIRTY_BITS |= 2L;
    }

    public String getQueuePath() {
        return this.m_sQueuePath;
    }

    public void setClientDownload(boolean bl) {
        this.m_bClientDownloadBrowser = bl;
        this.I_DIRTY_BITS |= 4L;
    }

    public boolean getClientDownload() {
        return this.m_bClientDownloadBrowser;
    }

    public void setClientAutoUpdate(boolean bl) {
        this.m_bClientAutoUpdate = bl;
        this.I_DIRTY_BITS |= 4L;
    }

    public boolean getClientAutoUpdate() {
        return this.m_bClientAutoUpdate;
    }

    private String readSystemClientSettings(NDSNegotiator nDSNegotiator, NSObject nSObject) {
        String string = null;
        String string2 = SA_MESSAGING_ATTRIBUTES[2];
        ObjectEntry objectEntry = nSObject.getObjectEntry();
        if (objectEntry == null) {
            return null;
        }
        ObjectEntry objectEntry2 = objectEntry.getParent();
        if (objectEntry2 == null) {
            return null;
        }
        ObjectEntry objectEntry3 = objectEntry2.getParent();
        if (objectEntry3 == null) {
            return null;
        }
        NDSNamespace nDSNamespace = (NDSNamespace)objectEntry3.getNamespace();
        try {
            NSObject nSObject2 = nDSNamespace.getDetails(objectEntry3);
            string = nDSNegotiator.getAttribute(nSObject2, string2);
        }
        catch (SPIException sPIException) {
            System.out.println("readSystemClientSettings exception");
            sPIException.printStackTrace();
        }
        return string;
    }

    public boolean load(NSObject nSObject) {
        boolean bl;
        boolean bl2;
        NDSNegotiator nDSNegotiator = new NDSNegotiator();
        if (!super.load(nSObject)) {
            return false;
        }
        this.setFileTransferPath(nDSNegotiator.getAttribute(nSObject, SA_MESSAGING_ATTRIBUTES[0]));
        this.setQueuePath(nDSNegotiator.getAttribute(nSObject, SA_MESSAGING_ATTRIBUTES[1]));
        String string = nDSNegotiator.getAttribute(nSObject, SA_MESSAGING_ATTRIBUTES[2]);
        if (string == null) {
            string = this.readSystemClientSettings(nDSNegotiator, nSObject);
        }
        if (string == null) {
            bl2 = false;
            bl = false;
        } else if (string.equals("0")) {
            bl2 = false;
            bl = false;
        } else if (string.equals("1")) {
            bl2 = true;
            bl = false;
        } else if (string.equals("2")) {
            bl2 = false;
            bl = true;
        } else {
            bl2 = true;
            bl = true;
        }
        this.setClientDownload(bl2);
        this.setClientAutoUpdate(bl);
        this.I_DIRTY_BITS = 0L;
        return true;
    }

    public boolean save(NSObject nSObject) {
        NDSNegotiator nDSNegotiator = new NDSNegotiator();
        if (!super.save(nSObject)) {
            return false;
        }
        if ((this.I_DIRTY_BITS & 1L) != 0L) {
            nDSNegotiator.setAttribute(nSObject, SA_MESSAGING_ATTRIBUTES[0], this.getFileTransferPath());
        }
        if ((this.I_DIRTY_BITS & 2L) != 0L) {
            nDSNegotiator.setAttribute(nSObject, SA_MESSAGING_ATTRIBUTES[1], this.getQueuePath());
        }
        if ((this.I_DIRTY_BITS & 4L) != 0L) {
            boolean bl = this.getClientDownload();
            boolean bl2 = this.getClientAutoUpdate();
            String string = !bl && !bl2 ? "0" : (bl && !bl2 ? "1" : (!bl && bl2 ? "2" : "3"));
            nDSNegotiator.setAttribute(nSObject, SA_MESSAGING_ATTRIBUTES[2], string);
        }
        return nDSNegotiator.update(nSObject);
    }
}

