/*
 * Decompiled with CFR 0.152.
 */
package com.novell.netmessenger.admin.chat;

import com.novell.admin.common.snapins.AdminPageSnapin;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.application.console.snapin.DefaultObjectEntryCollection;
import com.novell.application.console.snapin.InitSnapinInfo;
import com.novell.application.console.snapin.NamespaceSnapin;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectEntryCollection;
import com.novell.application.console.snapin.PageSnapin;
import com.novell.netmessenger.admin.chat.ChatContainerPage;
import com.novell.netmessenger.admin.chat.ChatResource;
import com.novell.netmessenger.admin.chat.ChatSearch;
import com.novell.netmessenger.admin.swingext.JLabelExt;
import com.novell.netmessenger.admin.swingext.JTableExt;
import com.novell.netmessenger.admin.swingext.JTextFieldExt;
import com.novell.utility.nmsgbox.NActivityBox;
import com.novell.utility.nmsgbox.NMsgBox;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class ChatContainerPanelSearch
extends ChatContainerPage
implements ActionListener,
MouseListener,
ListSelectionListener {
    private JTextFieldExt m_tfName;
    private JButton m_btnSearch;
    private ChatSearchTableModel m_model;
    private JTableExt m_table;
    private JButton m_btnEdit;
    private JButton m_btnRemove;
    private ArrayList m_tableRows;
    private NamespaceSnapin m_ns;

    public ChatContainerPanelSearch(InitSnapinInfo initSnapinInfo, AdminPageSnapin adminPageSnapin, NSObject nSObject) {
        super(initSnapinInfo, adminPageSnapin, nSObject);
        this.m_ns = nSObject.getObjectEntry().getNamespace();
    }

    public void layoutControls() {
        this.m_tfName = new JTextFieldExt(40);
        this.m_btnSearch = new JButton(ChatResource.get("ChatSearch"));
        this.m_btnEdit = new JButton(ChatResource.get("ChatEdit"));
        this.m_btnRemove = new JButton(ChatResource.get("ChatRemove"));
        this.m_tfName.addActionListener(this);
        this.m_btnSearch.addActionListener(this);
        this.m_btnEdit.addActionListener(this);
        this.m_btnRemove.addActionListener(this);
        this.m_model = new ChatSearchTableModel();
        this.m_table = new JTableExt(this.m_model);
        JScrollPane jScrollPane = new JScrollPane(this.m_table);
        jScrollPane.setPreferredSize(new Dimension(225, 300));
        this.m_table.addMouseListener(this);
        this.m_table.getSelectionModel().addListSelectionListener(this);
        this.buildColumns();
        JLabelExt jLabelExt = new JLabelExt(ChatResource.get("ChatGeneralChatName"), this.m_tfName);
        JLabelExt jLabelExt2 = new JLabelExt(ChatResource.get("ChatResults"), this.m_table);
        JLabelExt jLabelExt3 = new JLabelExt("");
        this.enableBottom();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        this.add(jLabelExt, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        this.add(this.m_tfName, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        this.add(this.m_btnSearch, gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.9;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        this.add(jLabelExt3, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        this.add(jLabelExt2, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.7;
        gridBagConstraints.weighty = 0.7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        this.add(jScrollPane, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        this.add(this.m_btnEdit, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        this.add(this.m_btnRemove, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 0.7;
        gridBagConstraints.weighty = 0.3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        this.add(jLabelExt3, gridBagConstraints);
        this.m_tfName.requestFocus();
    }

    private void buildColumns() {
        TableColumn tableColumn = new TableColumn(0);
        TableColumn tableColumn2 = new TableColumn(1);
        String string = ChatResource.get("ChatName");
        tableColumn.setHeaderValue(string);
        this.m_table.getColumnModel().addColumn(tableColumn);
        string = ChatResource.get("ChatCN");
        tableColumn2.setHeaderValue(string);
        this.m_table.getColumnModel().addColumn(tableColumn2);
    }

    private void doSearch() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        NActivityBox nActivityBox = new NActivityBox((Component)((Object)this), ChatResource.get("ChatSearching"));
        nActivityBox.showImmediately();
        this.m_table.removeAll();
        this.m_model.setRowCount(0);
        this.m_tableRows = new ArrayList();
        ChatSearch.findMatches(this.nsObj, this.m_tfName.getText(), this.m_tableRows);
        this.m_model.setRowCount(this.m_tableRows.size());
        this.m_model.fireTableDataChanged();
        nActivityBox.dispose();
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.enableBottom();
    }

    private void doEdit() {
        int n = this.m_table.getSelectedRow();
        String string = (String)this.m_model.getValueAt(n, 2);
        try {
            ObjectEntry objectEntry = this.m_ns.getObjectEntry(string);
            this.shell.showDetails((ObjectEntryCollection)new DefaultObjectEntryCollection(objectEntry), false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    private void doRemove() {
        NMsgBox nMsgBox = new NMsgBox(this.propertyBook.getComponent(), ChatResource.get("ChatRemoveConfirmTitle"), ChatResource.get("ChatRemoveConfirm"), 2);
        int n = nMsgBox.launch();
        this.fixFocus();
        if (n == 16) {
            return;
        }
        NDSNamespace nDSNamespace = (NDSNamespace)this.m_ns;
        int[] nArray = this.m_table.getSelectedRows();
        try {
            for (int i = nArray.length - 1; i >= 0; --i) {
                int n2 = nArray[i];
                String string = (String)this.m_model.getValueAt(n2, 2);
                ObjectEntry objectEntry = this.m_ns.getObjectEntry(string);
                nDSNamespace.delete(objectEntry);
                this.m_tableRows.remove(n2);
                this.m_model.removeRow(n2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void readData() {
    }

    public boolean saveData() {
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_btnSearch) {
            this.doSearch();
        } else if (object == this.m_btnEdit) {
            this.doEdit();
        } else if (object == this.m_btnRemove) {
            this.doRemove();
        } else if (object == this.m_tfName) {
            this.m_btnSearch.doClick();
        }
        this.propertyBook.setModified(false, (PageSnapin)this.pageSnapin);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() >= 2 && mouseEvent.getSource() == this.m_table && this.m_table.getSelectedRowCount() > 0) {
            this.m_btnEdit.doClick();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    private void enableBottom() {
        int n = this.m_table.getSelectedRowCount();
        if (this.m_table.getRowCount() == 0 || n == 0) {
            this.m_btnEdit.setEnabled(false);
            this.m_btnRemove.setEnabled(false);
        } else if (n > 1) {
            this.m_btnEdit.setEnabled(false);
            this.m_btnRemove.setEnabled(true);
        } else {
            this.m_btnEdit.setEnabled(true);
            this.m_btnRemove.setEnabled(true);
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.enableBottom();
    }

    private class ChatSearchTableModel
    extends DefaultTableModel {
        private ChatSearchTableModel() {
        }

        public void setValueAt(Object object, int n, int n2) {
        }

        public Object getValueAt(int n, int n2) {
            Object object = null;
            try {
                Object[] objectArray = (Object[])ChatContainerPanelSearch.this.m_tableRows.get(n);
                object = objectArray[n2];
            }
            catch (Exception exception) {
                System.out.println("Error in getValueAt: " + n + ", " + n2 + " - " + exception.getLocalizedMessage());
                exception.printStackTrace();
            }
            return object;
        }
    }
}

