/*
 * Decompiled with CFR 0.152.
 */
package com.novell.netmessenger.admin.chat;

import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.admin.ns.nds.NDSObjectAttribute;
import com.novell.admin.ns.nds.NDSSyntax;
import com.novell.application.console.snapin.MainShell;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.netmessenger.admin.chat.ChatResource;
import com.novell.netmessenger.admin.chat.ChatSearch;
import com.novell.netmessenger.admin.common.BaseDlg;
import com.novell.netmessenger.admin.common.ObjectInfo;
import com.novell.netmessenger.admin.common.Resource;
import com.novell.netmessenger.admin.swingext.JLabelExt;
import com.novell.netmessenger.admin.swingext.JTextFieldExt;
import com.novell.utility.nmsgbox.NActivityBox;
import com.novell.utility.nmsgbox.NMsgBox;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.JPanel;

public class ChatCreateDlg
extends BaseDlg {
    private JTextFieldExt m_tfCN;
    private JTextFieldExt m_tfDisplayName;
    private ObjectInfo m_objInfo;
    private ObjectEntry m_oeParent;

    public ChatCreateDlg(ObjectInfo objectInfo, ObjectEntry objectEntry) throws Exception {
        super((Frame)MainShell.getInstance().getShellFrame(), null, true, objectInfo.getHelpID());
        this.m_oeParent = objectEntry;
        if (objectInfo == null) {
            throw new Exception("A non-null ObjectInfo is required");
        }
        this.m_objInfo = objectInfo;
        this.layoutControls();
    }

    public void layoutControls() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.m_tfCN = new JTextFieldExt(30);
        this.m_tfCN.addActionListener(this);
        this.m_tfCN.disallowChars(".;+\\=");
        this.m_tfDisplayName = new JTextFieldExt(30);
        this.m_tfDisplayName.addActionListener(this);
        this.m_tfDisplayName.limitText(64);
        JLabelExt jLabelExt = new JLabelExt(ChatResource.get("ChatCreateCN"), this.m_tfCN);
        JLabelExt jLabelExt2 = new JLabelExt(ChatResource.get("ChatCreateDisplayName"), this.m_tfDisplayName);
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)jLabelExt, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.m_tfCN, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)jLabelExt2, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.m_tfDisplayName, gridBagConstraints);
        this.getContentPane().add((Component)jPanel, "North");
        super.layoutControls();
        this.setModal(true);
        this.setResizable(false);
        this.pack();
        this.setTitle(this.m_objInfo.getDialogTitle());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_tfCN || object == this.m_tfDisplayName) {
            this.okButtonAction();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    protected void okButtonAction() {
        String string = this.m_tfCN.getText().trim();
        String string2 = this.m_tfDisplayName.getText();
        if (string == null || string.length() == 0) {
            NMsgBox nMsgBox = new NMsgBox((Component)this, Resource.get("CreateNoNameTitle"), Resource.get("CreateNoName"), 3);
            nMsgBox.launch();
            this.m_tfCN.requestFocus();
            return;
        }
        if (string2 == null || string2.length() == 0) {
            NMsgBox nMsgBox = new NMsgBox((Component)this, ChatResource.get("ChatCreateNoDisplayNameTitle"), ChatResource.get("ChatCreateNoDisplayName"), 3);
            nMsgBox.launch();
            this.m_tfDisplayName.requestFocus();
            return;
        }
        NDSNamespace nDSNamespace = (NDSNamespace)this.m_shell.getNamespaceSnapin(NDSNamespace.name);
        try {
            if (nDSNamespace.doesExist(this.m_oeParent, string)) {
                NMsgBox nMsgBox = new NMsgBox((Component)this, Resource.get("CreateDuplicateTitle"), Resource.get("CreateDuplicate"), 3);
                nMsgBox.launch();
                this.m_tfCN.requestFocus();
                this.m_tfCN.selectAll();
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            NActivityBox nActivityBox = new NActivityBox((Component)this, ChatResource.get("PleaseWait"));
            nActivityBox.showImmediately();
            boolean bl = ChatSearch.roomExistsIn(string2, this.m_oeParent);
            nActivityBox.dispose();
            this.setCursor(Cursor.getPredefinedCursor(0));
            if (bl) {
                NMsgBox nMsgBox = new NMsgBox((Component)this, ChatResource.get("ChatDuplicateDisplayNameTitle"), ChatResource.get("ChatDuplicateDisplayName"), 3);
                nMsgBox.launch();
                this.m_tfDisplayName.requestFocus();
                return;
            }
            ValueComponent[] valueComponentArray = new ValueComponent[1];
            Vector<NDSObjectAttribute> vector = new Vector<NDSObjectAttribute>(5);
            valueComponentArray[0] = NDSSyntax.SYN_CLASS_NAME.createValueComponent((Object)this.m_objInfo.getObjectClass());
            NDSObjectAttribute nDSObjectAttribute = new NDSObjectAttribute(nDSNamespace.getAttributeDefinition(this.m_oeParent, "Object Class"), valueComponentArray);
            vector.addElement(nDSObjectAttribute);
            String string3 = this.m_objInfo.getNamedBy();
            valueComponentArray[0] = NDSSyntax.SYN_CI_STRING.createValueComponent((Object)string);
            NDSObjectAttribute nDSObjectAttribute2 = new NDSObjectAttribute(nDSNamespace.getAttributeDefinition(this.m_oeParent, string3), valueComponentArray);
            vector.addElement(nDSObjectAttribute2);
            valueComponentArray[0] = NDSSyntax.SYN_CI_STRING.createValueComponent((Object)string2);
            nDSObjectAttribute2 = new NDSObjectAttribute(nDSNamespace.getAttributeDefinition(this.m_oeParent, "nnmDisplayName"), valueComponentArray);
            vector.addElement(nDSObjectAttribute2);
            ObjectEntry objectEntry = nDSNamespace.createObjectEntry(this.m_oeParent, string, this.m_objInfo.getObjectClass());
            NSObject nSObject = nDSNamespace.createNSObject(objectEntry, vector);
            nDSNamespace.create(nSObject);
            this.m_objInfo.initDefaults(nSObject);
            this.dispose();
        }
        catch (Exception exception) {
            System.out.println(exception.getLocalizedMessage());
            NMsgBox nMsgBox = new NMsgBox((Component)this, Resource.get("CreateObjectFailedTitle"), Resource.get("CreateObjectFailed"), 3);
            nMsgBox.launch();
            this.m_tfCN.requestFocus();
            this.m_tfCN.selectAll();
            return;
        }
        this.m_shell.refreshCurrentTreeSelection();
    }

    protected void cancelButtonAction() {
        this.dispose();
    }
}

