/*
 * Decompiled with CFR 0.152.
 */
package com.novell.netmessenger.admin.chat;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.admin.snapins.creator.CreatorSnapinContext;
import com.novell.admin.snapins.creator.ExternalCreatorSnapin;
import com.novell.application.console.snapin.InitSnapinInfo;
import com.novell.application.console.snapin.NamespaceSnapin;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.netmessenger.admin.chat.ChatCreateDlg;
import com.novell.netmessenger.admin.chat.ChatNSObject;
import com.novell.netmessenger.admin.chat.ChatResource;
import com.novell.netmessenger.admin.common.ObjectInfo;
import com.novell.netmessenger.admin.common.StaticUtilities;
import java.util.Calendar;
import java.util.Date;

public class ChatCreatorSnapin
implements ExternalCreatorSnapin,
ObjectInfo {
    private ObjectEntry m_oeParent;

    public void execute() {
        ChatCreateDlg chatCreateDlg;
        try {
            chatCreateDlg = new ChatCreateDlg(this, this.m_oeParent);
        }
        catch (Exception exception) {
            System.out.println("ObjectInfo is null for ChatCreatorSnapin");
            return;
        }
        chatCreateDlg.show();
    }

    public String getObjectClass() {
        return "nnmChat";
    }

    public String getNamedBy() {
        return "CN";
    }

    public String getDialogTitle() {
        return ChatResource.get("ChatCreateTitle");
    }

    public String getHelpID() {
        return "chatcreate";
    }

    public void initDefaults(NSObject nSObject) {
        String string;
        ChatNSObject chatNSObject = new ChatNSObject();
        chatNSObject.setAlwaysArchive(false);
        chatNSObject.setSearchable(true);
        chatNSObject.setMaxParticipants(0);
        ObjectEntry objectEntry = null;
        ObjectEntry objectEntry2 = nSObject.getObjectEntry();
        NamespaceSnapin namespaceSnapin = objectEntry2.getNamespace();
        NDSNamespace nDSNamespace = (NDSNamespace)namespaceSnapin;
        try {
            objectEntry = nDSNamespace.getAuthenticatedIdentity(objectEntry2);
        }
        catch (SPIException sPIException) {
            System.out.println("Error getting the authenticated user DN");
            sPIException.printStackTrace();
        }
        if (objectEntry != null) {
            string = nDSNamespace.getFullyTypedName(objectEntry);
            String string2 = StaticUtilities.nameFromOE(objectEntry);
            chatNSObject.setOwner(string);
            chatNSObject.setCreator(string);
            chatNSObject.setCreatorName(string2);
        } else {
            System.out.println("chat.initDefaults: Unable to determine the current user");
        }
        Calendar calendar = Calendar.getInstance();
        Date date = calendar.getTime();
        long l = date.getTime() / 1000L;
        string = Integer.toString((int)l);
        chatNSObject.setCreateDate(string);
        chatNSObject.save(nSObject);
    }

    public String getSnapinDescription() {
        return "Chat Desc";
    }

    public String getSnapinName() {
        return "Chat";
    }

    public boolean initSnapin(InitSnapinInfo initSnapinInfo) {
        CreatorSnapinContext creatorSnapinContext = (CreatorSnapinContext)initSnapinInfo.getSnapinContext();
        this.m_oeParent = creatorSnapinContext.getObjectEntry();
        return true;
    }

    public void shutdownSnapin() {
    }
}

