/*
 * Decompiled with CFR 0.152.
 */
package com.novell.netmessenger.admin.chat;

import com.novell.admin.ns.NSObject;
import com.novell.netmessenger.admin.common.NDSNegotiator;
import java.util.Vector;

public class ChatNSObject {
    public static final int I_MAX_PARTICIPANTS_LIMIT = 500;
    public static final int I_DEFAULT_MAXPARTICIPANTS = 0;
    public static final int I_DEFAULT_MAXPARTICIPANTS_NONZERO = 32;
    public static final boolean B_DEFAULT_SEARCHABLE = true;
    public static final boolean B_DEFAULT_ALWAYSARCHIVE = false;
    public static final int I_CHAT_NAME = 0;
    public static final int I_CHAT_OWNER = 1;
    public static final int I_CHAT_DESCRIPTION = 2;
    public static final int I_CHAT_WELCOME = 3;
    public static final int I_CHAT_MAXPARTICIPANTS = 4;
    public static final int I_CHAT_ALWAYSARCHIVE = 5;
    public static final int I_CHAT_SEARCHABLE = 6;
    public static final int I_CHAT_ACL = 7;
    public static final int I_CHAT_CREATOR = 8;
    public static final int I_CHAT_CREATEDATE = 9;
    public static final int I_CHAT_ACCESSDATE = 10;
    public static final int I_CHAT_PASSWORD = 11;
    public static final int I_CHAT_CREATORNAME = 12;
    private static final long I_MASK_NAME = 1L;
    private static final long I_MASK_OWNER = 2L;
    private static final long I_MASK_DESCRIPTION = 4L;
    private static final long I_MASK_WELCOME = 8L;
    private static final long I_MASK_MAXPARTICIPANTS = 16L;
    private static final long I_MASK_ALWAYSARCHIVE = 32L;
    private static final long I_MASK_SEARCHABLE = 64L;
    private static final long I_MASK_ACL = 128L;
    private static final long I_MASK_CREATOR = 256L;
    private static final long I_MASK_CREATEDATE = 512L;
    private static final long I_MASK_ACCESSDATE = 1024L;
    private static final long I_MASK_PASSWORD = 2048L;
    private static final long I_MASK_CREATORNAME = 4096L;
    private long m_iDirtyBits = 0L;
    public static final String[] SA_CHAT_ATTRIBUTES = new String[]{"nnmDisplayName", "nnmChatOwnerDN", "nnmDescription", "nnmDisclaimer", "nnmMaxUsers", "nnmArchive", "nnmQuery", "nnmChatACL", "nnmCreatorDN", "nnmCreationTime", "nnmChatAccessDate", "nnmChatPassword", "nnmCreatorName"};
    private static final long[] LA_MASK_ATTRIBUTES = new long[]{1L, 2L, 4L, 8L, 16L, 32L, 64L, 128L, 256L, 512L, 1024L, 2048L, 4096L};
    private String m_sChatName;
    private String m_sOwner;
    private String m_sDescription;
    private String m_sWelcome;
    private Vector m_vACL;
    private String m_sCreator;
    private String m_sCreateDate;
    private String m_sAccessDate;
    private String m_sPassword;
    private String m_sCreatorName;
    private int m_iMaxParticipants;
    private boolean m_bAlwaysArchive;
    private boolean m_bSearchable;

    public void setChatName(String string) {
        this.m_sChatName = string;
        this.m_iDirtyBits |= 1L;
    }

    public String getChatName() {
        return this.m_sChatName;
    }

    public void setOwner(String string) {
        this.m_sOwner = string;
        this.m_iDirtyBits |= 2L;
    }

    public String getOwner() {
        return this.m_sOwner;
    }

    public void setDescription(String string) {
        this.m_sDescription = string;
        this.m_iDirtyBits |= 4L;
    }

    public String getDescription() {
        return this.m_sDescription;
    }

    public void setWelcome(String string) {
        this.m_sWelcome = string;
        this.m_iDirtyBits |= 8L;
    }

    public String getWelcome() {
        return this.m_sWelcome;
    }

    public void setMaxParticipants(int n) {
        this.m_iMaxParticipants = n;
        this.m_iDirtyBits |= 0x10L;
    }

    public int getMaxParticipants() {
        return this.m_iMaxParticipants;
    }

    public void setAlwaysArchive(boolean bl) {
        this.m_bAlwaysArchive = bl;
        this.m_iDirtyBits |= 0x20L;
    }

    public boolean getAlwaysArchive() {
        return this.m_bAlwaysArchive;
    }

    public void setSearchable(boolean bl) {
        this.m_bSearchable = bl;
        this.m_iDirtyBits |= 0x40L;
    }

    public boolean getSearchable() {
        return this.m_bSearchable;
    }

    public void setACL(Vector vector) {
        this.m_vACL = vector;
        this.m_iDirtyBits |= 0x80L;
    }

    public Vector getACL() {
        return this.m_vACL;
    }

    public void setCreator(String string) {
        this.m_sCreator = string;
        this.m_iDirtyBits |= 0x100L;
    }

    public String getCreator() {
        return this.m_sCreator;
    }

    public void setCreatorName(String string) {
        this.m_sCreatorName = string;
        this.m_iDirtyBits |= 0x1000L;
    }

    public String getCreatorName() {
        return this.m_sCreatorName;
    }

    public void setCreateDate(String string) {
        this.m_sCreateDate = string;
        this.m_iDirtyBits |= 0x200L;
    }

    public String getCreateDate() {
        return this.m_sCreateDate;
    }

    public void setAccessDate(String string) {
        this.m_sAccessDate = string;
        this.m_iDirtyBits |= 0x400L;
    }

    public String getAccessDate() {
        return this.m_sAccessDate;
    }

    public void setPassword(String string) {
        this.m_sPassword = string;
        this.m_iDirtyBits |= 0x800L;
    }

    public String getPassword() {
        return this.m_sPassword;
    }

    public void setStringAttribute(int n, String string) {
        switch (n) {
            case 0: {
                this.m_sChatName = string;
                break;
            }
            case 1: {
                this.m_sOwner = string;
                break;
            }
            case 2: {
                this.m_sDescription = string;
                break;
            }
            case 3: {
                this.m_sWelcome = string;
                break;
            }
            case 8: {
                this.m_sCreator = string;
                break;
            }
            case 9: {
                this.m_sCreateDate = string;
                break;
            }
            case 10: {
                this.m_sAccessDate = string;
                break;
            }
            case 11: {
                this.m_sPassword = string;
                break;
            }
            case 12: {
                this.m_sCreatorName = string;
                break;
            }
            default: {
                return;
            }
        }
        this.m_iDirtyBits |= LA_MASK_ATTRIBUTES[n];
    }

    public String getStringAttribute(int n) {
        String string;
        switch (n) {
            case 0: {
                string = this.m_sChatName;
                break;
            }
            case 1: {
                string = this.m_sOwner;
                break;
            }
            case 2: {
                string = this.m_sDescription;
                break;
            }
            case 3: {
                string = this.m_sWelcome;
                break;
            }
            case 8: {
                string = this.m_sCreator;
                break;
            }
            case 9: {
                string = this.m_sCreateDate;
                break;
            }
            case 10: {
                string = this.m_sAccessDate;
                break;
            }
            case 11: {
                string = this.m_sPassword;
                break;
            }
            case 12: {
                string = this.m_sCreatorName;
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    public boolean load(NSObject nSObject) {
        int n;
        NDSNegotiator nDSNegotiator = new NDSNegotiator();
        this.setChatName(nDSNegotiator.getAttribute(nSObject, SA_CHAT_ATTRIBUTES[0]));
        this.setOwner(nDSNegotiator.getAttribute(nSObject, SA_CHAT_ATTRIBUTES[1]));
        this.setDescription(nDSNegotiator.getAttribute(nSObject, SA_CHAT_ATTRIBUTES[2]));
        this.setWelcome(nDSNegotiator.getAttribute(nSObject, SA_CHAT_ATTRIBUTES[3]));
        this.setACL(nDSNegotiator.getMultiValuedAttribute(nSObject, SA_CHAT_ATTRIBUTES[7]));
        this.setCreator(nDSNegotiator.getAttribute(nSObject, SA_CHAT_ATTRIBUTES[8]));
        this.setCreateDate(nDSNegotiator.getAttribute(nSObject, SA_CHAT_ATTRIBUTES[9]));
        this.setAccessDate(nDSNegotiator.getAttribute(nSObject, SA_CHAT_ATTRIBUTES[10]));
        this.setPassword(nDSNegotiator.getAttribute(nSObject, SA_CHAT_ATTRIBUTES[11]));
        this.setCreatorName(nDSNegotiator.getAttribute(nSObject, SA_CHAT_ATTRIBUTES[12]));
        String string = nDSNegotiator.getAttribute(nSObject, SA_CHAT_ATTRIBUTES[4]);
        try {
            n = string == null ? 0 : Integer.parseInt(string);
        }
        catch (Exception exception) {
            System.out.println("Invalid value of " + string + " for MaxParticipants");
            n = 0;
        }
        this.setMaxParticipants(n);
        try {
            string = nDSNegotiator.getAttribute(nSObject, SA_CHAT_ATTRIBUTES[5]);
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            System.out.println("Invalid value of " + string + " for AlwaysArchive");
            n = 0;
        }
        this.setAlwaysArchive(n != 0);
        try {
            string = nDSNegotiator.getAttribute(nSObject, SA_CHAT_ATTRIBUTES[6]);
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            System.out.println("Invalid value of " + string + " for Searchable");
            n = 0;
        }
        this.setSearchable(n != 0);
        this.m_iDirtyBits = 0L;
        return true;
    }

    public boolean save(NSObject nSObject) {
        String string;
        NDSNegotiator nDSNegotiator = new NDSNegotiator();
        if ((this.m_iDirtyBits & 1L) > 0L) {
            nDSNegotiator.setAttribute(nSObject, SA_CHAT_ATTRIBUTES[0], this.getChatName());
        }
        if ((this.m_iDirtyBits & 2L) > 0L) {
            nDSNegotiator.setAttribute(nSObject, SA_CHAT_ATTRIBUTES[1], this.getOwner());
        }
        if ((this.m_iDirtyBits & 4L) > 0L) {
            nDSNegotiator.setAttribute(nSObject, SA_CHAT_ATTRIBUTES[2], this.getDescription());
        }
        if ((this.m_iDirtyBits & 8L) > 0L) {
            nDSNegotiator.setAttribute(nSObject, SA_CHAT_ATTRIBUTES[3], this.getWelcome());
        }
        if ((this.m_iDirtyBits & 0x10L) != 0L) {
            string = String.valueOf(this.getMaxParticipants());
            nDSNegotiator.setAttribute(nSObject, SA_CHAT_ATTRIBUTES[4], string);
        }
        if ((this.m_iDirtyBits & 0x20L) > 0L) {
            string = this.getAlwaysArchive() ? "1" : "0";
            nDSNegotiator.setAttribute(nSObject, SA_CHAT_ATTRIBUTES[5], string);
        }
        if ((this.m_iDirtyBits & 0x40L) > 0L) {
            string = this.getSearchable() ? "1" : "0";
            nDSNegotiator.setAttribute(nSObject, SA_CHAT_ATTRIBUTES[6], string);
        }
        if ((this.m_iDirtyBits & 0x80L) > 0L) {
            nDSNegotiator.setMultiValuedAttribute(nSObject, SA_CHAT_ATTRIBUTES[7], this.getACL());
        }
        if ((this.m_iDirtyBits & 0x100L) > 0L) {
            nDSNegotiator.setAttribute(nSObject, SA_CHAT_ATTRIBUTES[8], this.getCreator());
        }
        if ((this.m_iDirtyBits & 0x1000L) > 0L) {
            nDSNegotiator.setAttribute(nSObject, SA_CHAT_ATTRIBUTES[12], this.getCreatorName());
        }
        if ((this.m_iDirtyBits & 0x200L) > 0L) {
            nDSNegotiator.setAttribute(nSObject, SA_CHAT_ATTRIBUTES[9], this.getCreateDate());
        }
        if ((this.m_iDirtyBits & 0x400L) > 0L) {
            nDSNegotiator.setAttribute(nSObject, SA_CHAT_ATTRIBUTES[10], this.getAccessDate());
        }
        if ((this.m_iDirtyBits & 0x800L) > 0L) {
            nDSNegotiator.setAttribute(nSObject, SA_CHAT_ATTRIBUTES[11], this.getPassword());
        }
        this.m_iDirtyBits = 0L;
        boolean bl = nDSNegotiator.update(nSObject);
        this.load(nSObject);
        return bl;
    }
}

