/*
 * Decompiled with CFR 0.152.
 */
package com.novell.netmessenger.admin.chat;

import com.novell.admin.common.security.NSetPasswordDlg;
import com.novell.admin.common.snapins.AdminPageSnapin;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.application.console.snapin.InitSnapinInfo;
import com.novell.application.console.snapin.NamespaceSnapin;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectType;
import com.novell.application.console.snapin.PageSnapin;
import com.novell.application.console.snapin.SnapinException;
import com.novell.application.console.util.objectentryselector.ObjectEntrySelector;
import com.novell.netmessenger.admin.chat.ChatAdminPage;
import com.novell.netmessenger.admin.chat.ChatResource;
import com.novell.netmessenger.admin.chat.TitledPanel;
import com.novell.netmessenger.admin.common.Debug;
import com.novell.netmessenger.admin.common.StaticUtilities;
import com.novell.netmessenger.admin.swingext.JButtonExt;
import com.novell.netmessenger.admin.swingext.JCheckBoxExt;
import com.novell.netmessenger.admin.swingext.JLabelExt;
import com.novell.netmessenger.admin.swingext.JTableExt;
import com.novell.utility.nmsgbox.NMsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

public class ChatPanelAccess
extends ChatAdminPage
implements ListSelectionListener,
ActionListener {
    private static final char sg_ACL_DELIMITER = ';';
    private static final String sg_ACL_EVERYONE = "*";
    private static final String DN = "DN";
    private static final String RIGHTS = "RIGHTS";
    private static final int COLUMN_NAME = 0;
    private static final int COLUMN_RIGHTS_TEXT = 1;
    private static final int COLUMN_DN = 2;
    private static final int COLUMN_RIGHTS_NUM = 3;
    private JButtonExt m_btnAdd;
    private JButtonExt m_btnRemove;
    private JButtonExt m_btnClearPassword;
    private JButtonExt m_btnSetPassword;
    private JCheckBoxExt m_cbModerator;
    private JCheckBoxExt m_cbModifyRights;
    private JCheckBoxExt m_cbSend;
    private JCheckBoxExt m_cbView;
    private DefaultTableModel m_tableModel;
    private JScrollPane m_usersPane;
    private JTableExt m_table;
    private Vector m_vACL;
    private String m_sPassword;
    private ObjectEntry m_oeLastAddContext = null;
    private boolean m_bACLChanged = false;
    private boolean m_bPasswordChanged = false;

    public ChatPanelAccess(InitSnapinInfo initSnapinInfo, AdminPageSnapin adminPageSnapin, NSObject nSObject) {
        super(initSnapinInfo, adminPageSnapin, nSObject);
    }

    public void layoutControls() {
        this.m_btnSetPassword = new JButtonExt(ChatResource.get("ChatAccessSetPassword"));
        this.m_btnSetPassword.addActionListener(this);
        this.m_btnClearPassword = new JButtonExt(ChatResource.get("ChatAccessClearPassword"));
        this.m_btnClearPassword.addActionListener(this);
        this.m_cbView = new JCheckBoxExt(ChatResource.get("ChatAccessViewBtn"));
        this.m_cbView.addActionListener(this);
        this.m_cbSend = new JCheckBoxExt(ChatResource.get("ChatAccessSendBtn"));
        this.m_cbSend.addActionListener(this);
        this.m_cbModifyRights = new JCheckBoxExt(ChatResource.get("ChatAccessModifyRightsBtn"));
        this.m_cbModifyRights.addActionListener(this);
        this.m_cbModerator = new JCheckBoxExt(ChatResource.get("ChatAccessModeratorBtn"));
        this.m_cbModerator.addActionListener(this);
        this.buildTable();
        this.setLayout(new GridBagLayout());
        TitledPanel titledPanel = new TitledPanel((LayoutManager)new GridBagLayout(), ChatResource.get("ChatAccessUserList"));
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.buildUserListPanel(titledPanel);
        this.buildBottomPanel(jPanel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.add(titledPanel, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets.top = 2;
        this.add(jPanel, gridBagConstraints);
    }

    public void readData() {
        if (this.m_vACL == null) {
            this.m_vACL = new Vector();
        } else {
            this.m_vACL.clear();
        }
        this.m_vACL = this.m_chatNSObject.getACL();
        if (this.m_vACL != null) {
            for (int i = 0; i < this.m_vACL.size(); ++i) {
                String string = (String)this.m_vACL.get(i);
                ChatAccessRights chatAccessRights = new ChatAccessRights(string);
                if (chatAccessRights.getDN().equals(sg_ACL_EVERYONE)) {
                    this.addGeneralUser(chatAccessRights.getRights());
                    continue;
                }
                this.addUser(chatAccessRights);
            }
        } else {
            this.addGeneralUser(3);
        }
        this.m_bACLChanged = false;
        try {
            this.m_sPassword = StaticUtilities.decodeDecrypt(this.m_chatNSObject.getPassword());
        }
        catch (Exception exception) {
            this.m_sPassword = null;
        }
        this.m_bPasswordChanged = false;
        this.m_btnClearPassword.setEnabled(this.m_sPassword != null && this.m_sPassword.length() > 0);
    }

    public boolean saveData() {
        int n = 0;
        if (this.m_bACLChanged) {
            int n2 = this.m_tableModel.getRowCount();
            if (this.m_vACL == null) {
                this.m_vACL = new Vector(n2);
            } else {
                this.m_vACL.clear();
            }
            for (int i = 0; i < n2; ++i) {
                String string = (String)this.m_tableModel.getValueAt(i, 3);
                if (string != null) {
                    n = Integer.valueOf(string);
                }
                String string2 = (String)this.m_tableModel.getValueAt(i, 2);
                ChatAccessRights chatAccessRights = new ChatAccessRights(n);
                chatAccessRights.setDN(string2);
                this.m_vACL.add(chatAccessRights.toString());
            }
            this.m_chatNSObject.setACL(this.m_vACL);
        }
        if (this.m_bPasswordChanged) {
            String string;
            try {
                string = StaticUtilities.encryptEncode(this.m_sPassword.trim());
            }
            catch (Exception exception) {
                Debug.trace("ChatPanelAccess.saveData: ex= " + exception);
                string = null;
            }
            this.m_chatNSObject.setPassword(string);
            this.m_bPasswordChanged = false;
        }
        return true;
    }

    private void changeSelectedRights(int n, int n2, int n3, int n4) {
        ChatAccessRights chatAccessRights = new ChatAccessRights();
        int n5 = this.m_table.getSelectedRowCount();
        int[] nArray = this.m_table.getSelectedRows();
        for (int i = 0; i < n5; ++i) {
            int n6 = nArray[i];
            String string = (String)this.m_tableModel.getValueAt(n6, 3);
            if (string == null) continue;
            Integer n7 = Integer.valueOf(string);
            int n8 = n7;
            chatAccessRights.setRights(n8);
            if (n > 0) {
                chatAccessRights.setView(true);
            } else if (n < 0) {
                chatAccessRights.setView(false);
            }
            if (n2 > 0) {
                chatAccessRights.setSend(true);
                if (!chatAccessRights.canView()) {
                    chatAccessRights.setView(true);
                }
            } else if (n2 < 0) {
                chatAccessRights.setSend(false);
            }
            if (n3 > 0) {
                chatAccessRights.setModify(true);
            } else if (n3 < 0) {
                chatAccessRights.setModify(false);
            }
            if (n4 > 0) {
                chatAccessRights.setModerator(true);
            } else if (n4 < 0) {
                chatAccessRights.setModerator(false);
            }
            string = chatAccessRights.buildRightsString();
            this.m_tableModel.setValueAt(string, n6, 1);
            this.m_tableModel.setValueAt(String.valueOf(chatAccessRights.getRights()), n6, 3);
        }
        this.m_bACLChanged = true;
        this.propertyBook.setModified(true, (PageSnapin)this.pageSnapin);
    }

    private void moderatorButtonAction() {
        boolean bl = this.m_cbModerator.isSelected();
        this.changeSelectedRights(0, 0, 0, bl ? 1 : -1);
    }

    private void modifyButtonAction() {
        boolean bl = this.m_cbModifyRights.isSelected();
        this.changeSelectedRights(0, 0, bl ? 1 : -1, 0);
    }

    private void sendButtonAction() {
        boolean bl = this.m_cbSend.isSelected();
        if (bl) {
            this.m_cbView.setSelected(true);
            this.m_cbView.setEnabled(false);
        } else {
            this.m_cbView.setEnabled(true);
        }
        this.changeSelectedRights(0, bl ? 1 : -1, 0, 0);
    }

    private void viewButtonAction() {
        boolean bl = this.m_cbView.isSelected();
        this.changeSelectedRights(bl ? 1 : -1, 0, 0, 0);
    }

    private void addUserAction() {
        ObjectEntrySelector objectEntrySelector = new ObjectEntrySelector((Frame)this.parentFrame, this.nsObj.getObjectEntry().getRoot());
        NamespaceSnapin namespaceSnapin = this.nsObj.getObjectEntry().getNamespace();
        ObjectType[] objectTypeArray = new ObjectType[]{new ObjectType("User", namespaceSnapin, false)};
        objectEntrySelector.setFilter("", objectTypeArray);
        objectEntrySelector.setSelectionMode(2);
        objectEntrySelector.setFederationMode(1);
        if (this.m_oeLastAddContext != null) {
            objectEntrySelector.setInitialContext(this.m_oeLastAddContext);
        }
        objectEntrySelector.show();
        this.fixFocus();
        ObjectEntry[] objectEntryArray = objectEntrySelector.getSelectedObjectEntries();
        if (objectEntryArray == null) {
            return;
        }
        this.m_oeLastAddContext = objectEntrySelector.getContext();
        int n = this.getGeneralRights();
        NDSNamespace nDSNamespace = (NDSNamespace)namespaceSnapin;
        int n2 = this.m_table.getRowCount();
        for (int i = 0; i < objectEntryArray.length; ++i) {
            ObjectEntry objectEntry = objectEntryArray[i];
            if (objectEntry == null) continue;
            String string = StaticUtilities.nameFromOE(objectEntry);
            String string2 = nDSNamespace.getFullyTypedName(objectEntry);
            if (this.exists(string2 = StaticUtilities.DNToLDAPFormat(string2))) {
                NMsgBox nMsgBox = new NMsgBox((Component)((Object)this), ChatResource.get("ChatErrorDNExistsTitle"), ChatResource.get("ChatErrorDNExists"), 3);
                nMsgBox.launch();
                return;
            }
            this.addUser(string, string2, n);
        }
        if (this.m_table.getRowCount() > n2) {
            this.m_table.setRowSelectionInterval(n2, n2);
        }
        this.m_bACLChanged = true;
        this.propertyBook.setModified(true, (PageSnapin)this.pageSnapin);
    }

    private void removeUserAction() {
        int n;
        int n2 = 0;
        int[] nArray = this.m_table.getSelectedRows();
        if (nArray == null) {
            return;
        }
        int n3 = nArray.length;
        for (n = n3 - 1; n >= 0; --n) {
            int n4;
            n2 = n4 = nArray[n];
            this.m_tableModel.removeRow(n4);
        }
        this.m_bACLChanged = true;
        this.propertyBook.setModified(true, (PageSnapin)this.pageSnapin);
        n3 = this.m_table.getRowCount();
        if (n3 > 0) {
            n = n2 < n3 ? n2 : n3 - 1;
            this.m_table.setRowSelectionInterval(n, n);
        }
    }

    private void clearPwdButtonAction() {
        this.m_sPassword = null;
        this.m_bPasswordChanged = true;
        this.propertyBook.setModified(true, (PageSnapin)this.pageSnapin);
        this.m_btnClearPassword.setEnabled(false);
    }

    private void setPwdButtonAction() {
        NSetPasswordDlg nSetPasswordDlg = new NSetPasswordDlg(this.shell);
        if (nSetPasswordDlg.launch() == 1) {
            this.m_sPassword = nSetPasswordDlg.getNewPassword();
            this.m_bPasswordChanged = true;
            this.propertyBook.setModified(true, (PageSnapin)this.pageSnapin);
            this.m_btnClearPassword.setEnabled(this.m_sPassword != null && this.m_sPassword.length() > 0);
        }
        this.fixFocus();
    }

    private void setRightsCheckboxes(int n) {
        ChatAccessRights chatAccessRights = new ChatAccessRights(n);
        if (chatAccessRights.canSend()) {
            chatAccessRights.setView(true);
            this.m_cbView.setEnabled(false);
        } else {
            this.m_cbView.setEnabled(true);
        }
        this.m_cbModifyRights.setSelected(chatAccessRights.canModify());
        this.m_cbModerator.setSelected(chatAccessRights.isModerator());
        this.m_cbSend.setSelected(chatAccessRights.canSend());
        this.m_cbView.setSelected(chatAccessRights.canView());
    }

    private void updateRights() {
        int n = this.getSelectedRights();
        this.setRightsCheckboxes(n);
    }

    private void addGeneralUser(int n) {
        String string = ChatResource.get("ChatAccessGeneralAccess");
        this.addUser(string, sg_ACL_EVERYONE, n);
        this.m_table.setRowSelectionInterval(0, 0);
    }

    private void addUser(String string, String string2, int n) {
        Object[] objectArray = new String[]{string, this.buildRightsString(n), string2, String.valueOf(n)};
        this.m_tableModel.addRow(objectArray);
    }

    private void addUser(ChatAccessRights chatAccessRights) {
        String string;
        Object[] objectArray = new String[4];
        String string2 = chatAccessRights.getDN();
        NamespaceSnapin namespaceSnapin = this.nsObj.getObjectEntry().getNamespace();
        try {
            ObjectEntry objectEntry = namespaceSnapin.getObjectEntry(StaticUtilities.LDAPToDNFormat(string2));
            string = StaticUtilities.nameFromOE(objectEntry);
        }
        catch (SnapinException snapinException) {
            System.out.println("Error getting name from access entry DN");
            snapinException.printStackTrace();
            return;
        }
        objectArray[0] = string;
        objectArray[1] = this.buildRightsString(chatAccessRights.getRights());
        objectArray[2] = string2;
        objectArray[3] = String.valueOf(chatAccessRights.getRights());
        this.m_tableModel.addRow(objectArray);
    }

    private void buildBottomPanel(JPanel jPanel) {
        JLabel jLabel = new JLabel("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        gridBagConstraints.insets.top = 15;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)this.m_btnSetPassword, gridBagConstraints);
        gridBagConstraints.insets.left = 15;
        gridBagConstraints.gridx = 2;
        jPanel.add((Component)this.m_btnClearPassword, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)jLabel, gridBagConstraints);
    }

    private void buildUserListPanel(JPanel jPanel) {
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        this.buildRightsListPanel(jPanel2);
        JLabelExt jLabelExt = new JLabelExt();
        this.m_btnAdd = new JButtonExt(ChatResource.get("ChatAccessAdd"));
        this.m_btnAdd.addActionListener(this);
        this.m_btnRemove = new JButtonExt(ChatResource.get("ChatAccessRemove"));
        this.m_btnRemove.addActionListener(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)this.m_usersPane, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)this.m_btnAdd, gridBagConstraints);
        gridBagConstraints.insets.left = 15;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)this.m_btnRemove, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jLabelExt, gridBagConstraints);
        gridBagConstraints.insets.left = 3;
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets.top = 5;
        jPanel.add((Component)jPanel2, gridBagConstraints);
    }

    private void buildRightsListPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)this.m_cbView, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        jPanel.add((Component)this.m_cbSend, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        jPanel.add((Component)this.m_cbModifyRights, gridBagConstraints);
        gridBagConstraints.gridx = 4;
        jPanel.add((Component)this.m_cbModerator, gridBagConstraints);
    }

    private String buildRightsString(int n) {
        ChatAccessRights chatAccessRights = new ChatAccessRights(n);
        return chatAccessRights.buildRightsString();
    }

    private void buildTable() {
        Object[] objectArray = new String[4];
        String string = ChatResource.get("ChatAccessName");
        String string2 = ChatResource.get("ChatAccessRights");
        objectArray[0] = string;
        objectArray[1] = string2;
        objectArray[2] = DN;
        objectArray[3] = RIGHTS;
        this.m_tableModel = new DefaultTableModel(objectArray, 0);
        this.m_table = new JTableExt(this.m_tableModel);
        this.m_usersPane = new JScrollPane(this.m_table, 20, 30);
        this.m_table.getSelectionModel().addListSelectionListener(this);
        this.m_table.setShowGrid(false);
        JViewport jViewport = this.m_usersPane.getViewport();
        jViewport.setBackground(Color.white);
        jViewport.setOpaque(true);
        JTableHeader jTableHeader = this.m_table.getTableHeader();
        DefaultTableCellRenderer defaultTableCellRenderer = (DefaultTableCellRenderer)jTableHeader.getDefaultRenderer();
        defaultTableCellRenderer.setHorizontalAlignment(10);
        TableColumn tableColumn = this.m_table.getColumn(string);
        tableColumn.setMinWidth(60);
        tableColumn.setPreferredWidth(140);
        tableColumn.setMaxWidth(250);
        tableColumn = this.m_table.getColumn(DN);
        tableColumn.setMinWidth(0);
        tableColumn.setPreferredWidth(0);
        tableColumn.setMaxWidth(0);
        tableColumn = this.m_table.getColumn(RIGHTS);
        tableColumn.setMinWidth(0);
        tableColumn.setPreferredWidth(0);
        tableColumn.setMaxWidth(0);
        Class<?> clazz = this.m_table.getColumnClass(0);
        defaultTableCellRenderer = (DefaultTableCellRenderer)this.m_table.getDefaultRenderer(clazz);
        defaultTableCellRenderer.setHorizontalAlignment(10);
    }

    private boolean exists(String string) {
        int n = this.m_tableModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            String string2 = (String)this.m_tableModel.getValueAt(i, 2);
            if (string2 == null || !string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private int getSelectedRights() {
        int n = this.m_table.getSelectedRow();
        String string = (String)this.m_tableModel.getValueAt(n, 3);
        if (string != null) {
            Integer n2 = Integer.valueOf(string);
            return n2;
        }
        return 0;
    }

    private int getGeneralRights() {
        int n = this.m_table.getRowCount();
        for (int i = 0; i < n; ++i) {
            String string;
            String string2 = (String)this.m_tableModel.getValueAt(i, 2);
            if (string2 != null && !string2.equals(sg_ACL_EVERYONE) || (string = (String)this.m_tableModel.getValueAt(i, 3)) == null) continue;
            int n2 = Integer.valueOf(string);
            return n2;
        }
        return 0;
    }

    private boolean isGeneralSelected() {
        int[] nArray = this.m_table.getSelectedRows();
        if (nArray == null) {
            return false;
        }
        for (int i = 0; i < nArray.length; ++i) {
            String string = (String)this.m_tableModel.getValueAt(nArray[i], 2);
            if (string != null && !string.equals(sg_ACL_EVERYONE)) continue;
            return true;
        }
        return false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == null) {
            return;
        }
        if (object.equals(this.m_cbModerator)) {
            this.moderatorButtonAction();
        } else if (object.equals(this.m_cbModifyRights)) {
            this.modifyButtonAction();
        } else if (object.equals(this.m_cbSend)) {
            this.sendButtonAction();
        } else if (object.equals(this.m_cbView)) {
            this.viewButtonAction();
        } else if (object.equals(this.m_btnSetPassword)) {
            this.setPwdButtonAction();
        } else if (object.equals(this.m_btnClearPassword)) {
            this.clearPwdButtonAction();
        } else if (object.equals(this.m_btnAdd)) {
            this.addUserAction();
        } else if (object.equals(this.m_btnRemove)) {
            this.removeUserAction();
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        boolean bl;
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        int n = this.m_table.getSelectedRowCount();
        if (n == 1) {
            this.updateRights();
        }
        this.m_btnRemove.setEnabled(!(bl = this.isGeneralSelected()));
    }

    private class ChatAccessRights {
        private static final byte RIGHTS_VIEW = 1;
        private static final byte RIGHTS_SEND = 2;
        private static final byte RIGHTS_MODIFY = 4;
        private static final byte RIGHTS_MODERATOR = 8;
        private static final int RIGHTS_VIEW_SEND = 3;
        private int m_nRights;
        private String m_strDN;

        public ChatAccessRights() {
            this.m_nRights = 0;
        }

        public ChatAccessRights(int n) {
            this.m_nRights = n;
        }

        public ChatAccessRights(String string) {
            if (string == null) {
                return;
            }
            int n = string.indexOf(59);
            String string2 = string.substring(0, n);
            String string3 = n > 0 ? string.substring(n + 1) : "0";
            this.m_strDN = string2;
            this.m_nRights = Integer.valueOf(string3);
        }

        public String toString() {
            String string = this.m_strDN + ';' + this.m_nRights;
            return string;
        }

        public String buildRightsString() {
            String string = "";
            if (this.canView()) {
                string = ChatResource.get("ChatAccessView");
            }
            if (this.canSend()) {
                if (string.length() > 0) {
                    string = string + ", ";
                }
                string = string + ChatResource.get("ChatAccessSend");
            }
            if (this.canModify()) {
                if (string.length() > 0) {
                    string = string + ", ";
                }
                string = string + ChatResource.get("ChatAccessModifyRights");
            }
            if (this.isModerator()) {
                if (string.length() > 0) {
                    string = string + ", ";
                }
                string = string + ChatResource.get("ChatAccessModerator");
            }
            return string;
        }

        public boolean canModify() {
            return (this.m_nRights & 4) > 0;
        }

        public boolean canSend() {
            return (this.m_nRights & 2) > 0;
        }

        public boolean canView() {
            return (this.m_nRights & 1) > 0;
        }

        public String getDN() {
            return this.m_strDN;
        }

        public int getRights() {
            return this.m_nRights;
        }

        public boolean isModerator() {
            return (this.m_nRights & 8) > 0;
        }

        public void setDN(String string) {
            this.m_strDN = string;
        }

        public void setModerator(boolean bl) {
            this.m_nRights = bl ? (this.m_nRights |= 8) : (this.m_nRights &= 0xFFFFFFF7);
        }

        public void setModify(boolean bl) {
            this.m_nRights = bl ? (this.m_nRights |= 4) : (this.m_nRights &= 0xFFFFFFFB);
        }

        public void setRights(int n) {
            this.m_nRights = n;
        }

        public void setSend(boolean bl) {
            this.m_nRights = bl ? (this.m_nRights |= 2) : (this.m_nRights &= 0xFFFFFFFD);
        }

        public void setView(boolean bl) {
            this.m_nRights = bl ? (this.m_nRights |= 1) : (this.m_nRights &= 0xFFFFFFFE);
        }
    }
}

