/*
 * Decompiled with CFR 0.152.
 */
package com.novell.netmessenger.admin.chat;

import com.novell.admin.common.snapins.AdminPageSnapin;
import com.novell.admin.ns.NSObject;
import com.novell.application.console.snapin.InitSnapinInfo;
import com.novell.netmessenger.admin.chat.ChatAdminPage;
import com.novell.netmessenger.admin.chat.ChatResource;
import com.novell.netmessenger.admin.chat.ChatSearch;
import com.novell.netmessenger.admin.common.NIncrementBox;
import com.novell.netmessenger.admin.common.OESTextField;
import com.novell.netmessenger.admin.common.StaticUtilities;
import com.novell.netmessenger.admin.swingext.JCheckBoxExt;
import com.novell.netmessenger.admin.swingext.JLabelExt;
import com.novell.netmessenger.admin.swingext.JTextAreaExt;
import com.novell.netmessenger.admin.swingext.JTextFieldExt;
import com.novell.utility.nmsgbox.NActivityBox;
import com.novell.utility.nmsgbox.NMsgBox;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JScrollPane;

public class ChatPanelGeneral
extends ChatAdminPage
implements ActionListener {
    private OESTextField m_tfOwner;
    private JTextFieldExt m_tfChatName;
    private NIncrementBox m_incMaxParticipants;
    private JTextAreaExt m_taDescription;
    private JTextAreaExt m_taWelcome;
    private JCheckBoxExt m_cbAlwaysArchive;
    private JCheckBoxExt m_cbMaxParticipants;
    private JCheckBoxExt m_cbSearchable;

    public ChatPanelGeneral(InitSnapinInfo initSnapinInfo, AdminPageSnapin adminPageSnapin, NSObject nSObject) {
        super(initSnapinInfo, adminPageSnapin, nSObject);
    }

    public void layoutControls() {
        this.setLayout(new GridBagLayout());
        this.m_tfOwner = new OESTextField(this.propertyBook.getComponent(), this.nsObj.getObjectEntry());
        this.m_tfOwner.setFilter(StaticUtilities.SA_OBJECT_TYPE_USER);
        this.m_tfChatName = new JTextFieldExt(25);
        this.m_tfChatName.limitText(64);
        if (this.pageSnapin.isMOD()) {
            this.m_tfChatName.setEnabled(false);
        }
        this.m_incMaxParticipants = new NIncrementBox(0, 500, 0);
        this.m_taDescription = new JTextAreaExt(3, 0);
        this.m_taDescription.setLineWrap(true);
        this.m_taDescription.setWrapStyleWord(true);
        this.m_taDescription.setFont(this.m_tfChatName.getFont());
        this.m_taDescription.limitText(1024);
        this.m_taWelcome = new JTextAreaExt(3, 55);
        this.m_taWelcome.setLineWrap(true);
        this.m_taWelcome.setWrapStyleWord(true);
        this.m_taWelcome.setMinimumSize(new Dimension(50, 36));
        this.m_taWelcome.setFont(this.m_tfChatName.getFont());
        this.m_taWelcome.limitText(1024);
        this.m_cbMaxParticipants = new JCheckBoxExt(ChatResource.get("ChatGeneralMaxParticipants"));
        this.m_cbAlwaysArchive = new JCheckBoxExt(ChatResource.get("ChatGeneralAlwaysArchive"));
        this.m_cbSearchable = new JCheckBoxExt(ChatResource.get("ChatGeneralSearchable"));
        this.m_cbMaxParticipants.addActionListener(this);
        JLabelExt jLabelExt = new JLabelExt(ChatResource.get("ChatGeneralOwner"), this.m_tfOwner);
        JLabelExt jLabelExt2 = new JLabelExt(ChatResource.get("ChatGeneralChatName"), this.m_tfChatName);
        JLabelExt jLabelExt3 = new JLabelExt(ChatResource.get("ChatGeneralDescription"), this.m_taDescription);
        JLabelExt jLabelExt4 = new JLabelExt(ChatResource.get("ChatGeneralWelcome"), this.m_taWelcome);
        JLabelExt jLabelExt5 = new JLabelExt("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        this.add(jLabelExt, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 2;
        this.add(this.m_tfOwner, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        this.add(jLabelExt2, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 2;
        this.add(this.m_tfChatName, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        this.add(jLabelExt3, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 2;
        this.add(new JScrollPane(this.m_taDescription), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        this.add(jLabelExt4, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 2;
        this.add(new JScrollPane(this.m_taWelcome), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        this.add(this.m_cbMaxParticipants, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        this.add(this.m_incMaxParticipants, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 1;
        this.add(jLabelExt5, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 3;
        this.add(this.m_cbAlwaysArchive, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 3;
        this.add(this.m_cbSearchable, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.3;
        gridBagConstraints.fill = 1;
        this.add(jLabelExt5, gridBagConstraints);
    }

    public void readData() {
        this.m_tfOwner.setText(this.m_chatNSObject.getOwner());
        this.m_tfChatName.setText(this.m_chatNSObject.getChatName());
        this.m_taDescription.setText(this.m_chatNSObject.getDescription());
        this.m_taWelcome.setText(this.m_chatNSObject.getWelcome());
        int n = this.m_chatNSObject.getMaxParticipants();
        this.m_incMaxParticipants.setMinValue(1);
        this.m_incMaxParticipants.setMaxValue(500);
        if (n > 0) {
            this.m_cbMaxParticipants.setSelected(true);
            this.m_incMaxParticipants.setEnabled(true);
            this.m_incMaxParticipants.setValue(n);
        } else {
            this.m_cbMaxParticipants.setSelected(false);
            this.m_incMaxParticipants.setValue(32);
            this.m_incMaxParticipants.setEnabled(false);
        }
        this.m_cbAlwaysArchive.setSelected(this.m_chatNSObject.getAlwaysArchive());
        this.m_cbSearchable.setSelected(this.m_chatNSObject.getSearchable());
        this.m_tfOwner.addDocumentListener(this);
        this.m_tfChatName.addDocumentListener(this);
        this.m_taDescription.addDocumentListener(this);
        this.m_taWelcome.addDocumentListener(this);
        this.m_incMaxParticipants.addDocumentListener(this);
        this.m_cbMaxParticipants.addItemListener(this);
        this.m_cbAlwaysArchive.addItemListener(this);
        this.m_cbSearchable.addItemListener(this);
    }

    public boolean saveData() {
        if (!this.m_bOKToSave) {
            this.m_bOKToSave = true;
            return false;
        }
        String string = this.m_tfChatName.getText().trim();
        if (!(this.pageSnapin.isMOD() || string != null && string.length() != 0)) {
            NMsgBox nMsgBox = new NMsgBox((Component)((Object)this), ChatResource.get("ChatCreateNoDisplayNameTitle"), ChatResource.get("ChatCreateNoDisplayName"), 3);
            nMsgBox.launch();
            this.m_tfChatName.requestFocus();
            this.m_bOKToSave = false;
            return false;
        }
        if (this.m_tfChatName.isModified()) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            NActivityBox nActivityBox = new NActivityBox((Component)((Object)this), ChatResource.get("PleaseWait"));
            nActivityBox.showImmediately();
            boolean bl = ChatSearch.roomExists(string, this.nsObj);
            nActivityBox.dispose();
            this.setCursor(Cursor.getPredefinedCursor(0));
            if (bl) {
                NMsgBox nMsgBox = new NMsgBox((Component)((Object)this), ChatResource.get("ChatDuplicateDisplayNameTitle"), ChatResource.get("ChatDuplicateDisplayName"), 3);
                nMsgBox.launch();
                this.m_tfChatName.requestFocus();
                this.m_bOKToSave = false;
                return false;
            }
        }
        if (this.m_tfOwner.isModified()) {
            this.m_chatNSObject.setOwner(this.m_tfOwner.getText());
        }
        if (this.m_tfChatName.isModified()) {
            this.m_chatNSObject.setChatName(string);
        }
        if (this.m_taDescription.isModified()) {
            this.m_chatNSObject.setDescription(this.m_taDescription.getText());
        }
        if (this.m_taWelcome.isModified()) {
            this.m_chatNSObject.setWelcome(this.m_taWelcome.getText());
        }
        if (this.m_incMaxParticipants.isModified()) {
            this.m_chatNSObject.setMaxParticipants(this.m_incMaxParticipants.getValue());
        }
        if (this.m_cbMaxParticipants.isModified() || this.m_incMaxParticipants.isModified()) {
            if (this.m_cbMaxParticipants.isSelected()) {
                this.m_chatNSObject.setMaxParticipants(this.m_incMaxParticipants.getValue());
            } else {
                this.m_chatNSObject.setMaxParticipants(0);
            }
        }
        if (this.m_cbAlwaysArchive.isModified()) {
            this.m_chatNSObject.setAlwaysArchive(this.m_cbAlwaysArchive.isSelected());
        }
        if (this.m_cbSearchable.isModified()) {
            this.m_chatNSObject.setSearchable(this.m_cbSearchable.isSelected());
        }
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_cbMaxParticipants) {
            if (this.m_cbMaxParticipants.isSelected()) {
                this.m_incMaxParticipants.setEnabled(true);
            } else {
                this.m_incMaxParticipants.setEnabled(false);
            }
        }
    }
}

