/*
 * Decompiled with CFR 0.152.
 */
package com.novell.netmessenger.admin.common;

import com.novell.application.console.snapin.MainShell;
import com.novell.application.console.snapin.Shell;
import com.novell.netmessenger.admin.common.Debug;
import com.novell.netmessenger.admin.common.Resource;
import com.novell.netmessenger.admin.common.StaticUtilities;
import com.novell.netmessenger.admin.swingext.JButtonExt;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JPanel;

public abstract class BaseDlg
extends JDialog
implements ActionListener {
    protected JButtonExt m_okButton;
    protected JButtonExt m_cancelButton;
    protected JButtonExt m_helpButton;
    protected Shell m_shell;
    private String m_sHelpID = null;

    public BaseDlg(Frame frame, String string, boolean bl, String string2) {
        super(frame, string, bl);
        this.init(string2);
    }

    public BaseDlg(Dialog dialog, String string, boolean bl, String string2) {
        super(dialog, string, bl);
        this.init(string2);
    }

    private void init(String string) {
        this.m_sHelpID = string;
        if (Debug.trace && this.m_sHelpID == null) {
            new Throwable().printStackTrace();
            Debug.traceDlg(this.getParent(), "ZZZ HELP DEFINE NEEDED HERE");
        }
        this.m_shell = MainShell.getInstance();
        this.setContentPane(new JPanelExtInner(new BorderLayout(5, 5)));
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Debug.trace("BaseDlg.windowClosing calling cancelButtonAction()");
                BaseDlg.this.cancelButtonAction();
            }
        };
        this.addWindowListener(windowAdapter);
    }

    protected void layoutControls() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        JPanel jPanel2 = new JPanel(new GridLayout(0, 3, 5, 5));
        this.m_okButton = new JButtonExt(Resource.get("ButtonLabelOK"));
        this.m_okButton.addActionListener(this);
        jPanel2.add(this.m_okButton);
        this.m_cancelButton = new JButtonExt(Resource.get("ButtonLabelCancel"));
        this.m_cancelButton.addActionListener(this);
        jPanel2.add(this.m_cancelButton);
        this.m_helpButton = new JButtonExt(Resource.get("ButtonLabelHelp"));
        this.m_helpButton.addActionListener(this);
        jPanel2.add(this.m_helpButton);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this.getContentPane().add((Component)jPanel, "South");
    }

    public void show() {
        this.setLocationRelativeTo(this.getParent());
        super.show();
    }

    public void dispose() {
        super.dispose();
        this.getParent().requestFocus();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_okButton) {
            this.okButtonAction();
        } else if (object == this.m_cancelButton) {
            this.cancelButtonAction();
        } else if (object == this.m_helpButton) {
            this.helpButtonAction();
        }
    }

    protected abstract void okButtonAction();

    protected abstract void cancelButtonAction();

    protected void helpButtonAction() {
        StaticUtilities.showHelp(this.m_sHelpID, this);
    }

    private class JPanelExtInner
    extends JPanel {
        public JPanelExtInner(LayoutManager layoutManager) {
            super(layoutManager);
        }

        public Insets getInsets() {
            return new Insets(5, 5, 5, 5);
        }
    }
}

