/*
 * Decompiled with CFR 0.152.
 */
package com.novell.netmessenger.admin.common;

import com.novell.netmessenger.admin.common.BaseDlg;
import com.novell.netmessenger.admin.common.OESTextField;
import com.novell.netmessenger.admin.common.Resource;
import com.novell.netmessenger.admin.common.StaticUtilities;
import com.novell.netmessenger.admin.swingext.JCheckBoxExt;
import com.novell.netmessenger.admin.swingext.JLabelExt;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;

public class ContextEntryDlg
extends BaseDlg {
    private OESTextField m_tfContextEntry;
    private JCheckBoxExt m_cbSubContexts;
    private String m_sContextEntry;

    public ContextEntryDlg(Component component, String string) {
        super((Dialog)component, null, true, "contextlistentry");
        this.m_sContextEntry = string;
        this.m_tfContextEntry = new OESTextField(this);
        this.m_tfContextEntry.setVisible(1, false);
        this.m_tfContextEntry.setNameType(2);
        this.m_tfContextEntry.setFilter(StaticUtilities.SA_OBJECT_TYPE_CONTEXT);
        this.m_cbSubContexts = new JCheckBoxExt(Resource.get("ContextListSubContexts"));
        this.layoutControls();
        this.setTitle(Resource.get("ContextListEntryDlgTitle"));
        this.setContextEntry(this.m_sContextEntry);
    }

    public void layoutControls() {
        JLabelExt jLabelExt = new JLabelExt(Resource.get("ContextListEntry"), this.m_tfContextEntry);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 2, 5);
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)jLabelExt, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.m_tfContextEntry, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets.top = 2;
        gridBagConstraints.insets.bottom = 5;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)this.m_cbSubContexts, gridBagConstraints);
        this.getContentPane().add((Component)jPanel, "North");
        super.layoutControls();
        this.setModal(true);
        this.setResizable(false);
        this.pack();
    }

    public String getContextEntry() {
        return this.m_sContextEntry;
    }

    public void setContextEntry(String string) {
        if (string != null && string.length() > 0) {
            if (string.startsWith("*.")) {
                this.m_tfContextEntry.setText(string.substring("*.".length()));
                this.m_cbSubContexts.setSelected(true);
            } else if (string.startsWith("*,")) {
                this.m_tfContextEntry.setText(string.substring("*,".length()));
                this.m_cbSubContexts.setSelected(true);
            } else {
                this.m_tfContextEntry.setText(string);
            }
        }
    }

    protected void okButtonAction() {
        String string = this.m_tfContextEntry.getText();
        if (string != null && string.length() > 0) {
            this.m_sContextEntry = this.m_cbSubContexts.isSelected() ? "*." + string : string;
        }
        this.dispose();
    }

    protected void cancelButtonAction() {
        this.m_sContextEntry = null;
        this.dispose();
    }
}

