/*
 * Decompiled with CFR 0.152.
 */
package com.novell.netmessenger.admin.common;

import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.nds.NDSAttributeDefinition;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.admin.ns.nds.NDSObjectAttribute;
import com.novell.admin.ns.nds.NDSSyntax;
import com.novell.application.console.snapin.DefaultObjectEntryCollection;
import com.novell.application.console.snapin.MainShell;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectEntryCollection;
import com.novell.netmessenger.admin.common.BaseDlg;
import com.novell.netmessenger.admin.common.ObjectInfo;
import com.novell.netmessenger.admin.common.Resource;
import com.novell.netmessenger.admin.swingext.JCheckBoxExt;
import com.novell.netmessenger.admin.swingext.JLabelExt;
import com.novell.netmessenger.admin.swingext.JTextFieldExt;
import com.novell.utility.nmsgbox.NMsgBox;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.JPanel;

public class CreateDlg
extends BaseDlg {
    protected JTextFieldExt m_tfCN;
    private JCheckBoxExt m_cbProperties;
    private ObjectInfo m_objInfo;
    private ObjectEntry m_oeParent;

    public CreateDlg(ObjectInfo objectInfo, ObjectEntry objectEntry) throws Exception {
        super((Frame)MainShell.getInstance().getShellFrame(), null, true, objectInfo.getHelpID());
        this.m_oeParent = objectEntry;
        if (objectInfo == null) {
            throw new Exception("A non-null ObjectInfo is required");
        }
        this.m_objInfo = objectInfo;
        this.layoutControls();
    }

    public void layoutControls() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.m_tfCN = new JTextFieldExt(30);
        this.m_tfCN.disallowChars(".;+\\=");
        this.m_tfCN.addActionListener(this);
        this.m_cbProperties = new JCheckBoxExt(Resource.get("CreateAdditionalProperties"));
        JLabelExt jLabelExt = new JLabelExt(Resource.get("CreateCN"), this.m_tfCN);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)jLabelExt, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.m_tfCN, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)this.m_cbProperties, gridBagConstraints);
        this.getContentPane().add((Component)jPanel, "North");
        super.layoutControls();
        this.setModal(true);
        this.setResizable(false);
        this.pack();
        this.setTitle(this.m_objInfo.getDialogTitle());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_tfCN) {
            this.okButtonAction();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    protected void okButtonAction() {
        String string = this.m_tfCN.getText().trim();
        if (string.length() > 0) {
            NDSNamespace nDSNamespace = (NDSNamespace)this.m_shell.getNamespaceSnapin(NDSNamespace.name);
            try {
                ValueComponent[] valueComponentArray = new ValueComponent[]{NDSSyntax.SYN_CLASS_NAME.createValueComponent((Object)this.m_objInfo.getObjectClass())};
                NDSObjectAttribute nDSObjectAttribute = new NDSObjectAttribute((AttributeDefinition)((NDSAttributeDefinition)nDSNamespace.getAttributeDefinition(this.m_oeParent, "Object Class")), valueComponentArray);
                valueComponentArray[0] = NDSSyntax.SYN_CI_STRING.createValueComponent((Object)string);
                NDSObjectAttribute nDSObjectAttribute2 = new NDSObjectAttribute((AttributeDefinition)((NDSAttributeDefinition)nDSNamespace.getAttributeDefinition(this.m_oeParent, this.m_objInfo.getNamedBy())), valueComponentArray);
                if (nDSNamespace.doesExist(this.m_oeParent, string)) {
                    NMsgBox nMsgBox = new NMsgBox((Component)this, Resource.get("CreateDuplicateTitle"), Resource.get("CreateDuplicate"), 3);
                    nMsgBox.launch();
                    this.m_tfCN.requestFocus();
                    this.m_tfCN.selectAll();
                    return;
                }
                Vector<NDSObjectAttribute> vector = new Vector<NDSObjectAttribute>(2);
                vector.addElement(nDSObjectAttribute);
                vector.addElement(nDSObjectAttribute2);
                ObjectEntry objectEntry = nDSNamespace.createObjectEntry(this.m_oeParent, string, this.m_objInfo.getObjectClass());
                NSObject nSObject = nDSNamespace.createNSObject(objectEntry, vector);
                nDSNamespace.create(nSObject);
                if (this.m_cbProperties.isSelected()) {
                    this.m_shell.showDetails((ObjectEntryCollection)new DefaultObjectEntryCollection(objectEntry), false);
                }
                this.m_objInfo.initDefaults(nSObject);
                this.dispose();
            }
            catch (Exception exception) {
                NMsgBox nMsgBox = new NMsgBox((Component)this, Resource.get("CreateObjectFailedTitle"), Resource.get("CreateObjectFailed"), 3);
                nMsgBox.launch();
                this.m_tfCN.requestFocus();
                this.m_tfCN.selectAll();
                return;
            }
            this.m_shell.refreshCurrentTreeSelection();
            return;
        }
        NMsgBox nMsgBox = new NMsgBox((Component)this, Resource.get("CreateNoNameTitle"), Resource.get("CreateNoName"), 3);
        nMsgBox.launch();
        this.m_tfCN.requestFocus();
    }

    protected void cancelButtonAction() {
        this.dispose();
    }
}

