/*
 * Decompiled with CFR 0.152.
 */
package com.novell.netmessenger.admin.common;

import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Stack;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JOptionPane;

public class Debug {
    private static final String TIMESTAMP = "com.novell.gw.util.Debug.code";
    private static final String TRACE = "com.novell.gw.util.Debug.trace";
    private static final String TRACE_DLG = "com.novell.gw.util.Debug.trace.dialog";
    private static final String STACK_TRACE = "com.novell.gw.util.Debug.stackTrace";
    public static boolean trace = false;
    public static boolean traceDlg = false;
    public static boolean stackTrace = false;
    public static long timestamp = 0L;
    private static PrintWriter debugStream = new PrintWriter(System.out, true);
    private static String lineSeparator = System.getProperty("line.separator");
    protected static Object lock = new Object();
    private static Hashtable threadContext = new Hashtable();
    private static Stack traceContext = new Stack();
    private static final String TRACE_PREFIX = "";
    private static final String INDENT = "   ";
    private static final String EXCEPTION_HEADER = "============== Exception (begin) ===========================";
    private static final String EXCEPTION_FOOTER = "============== Exception (end) =============================";
    private static final String SEPARATOR = "============================================================";

    private static void setOutput(PrintWriter printWriter) {
        debugStream = printWriter;
    }

    private static void restoreOutput() {
        debugStream = new PrintWriter(System.out, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void trace(String string) {
        if (trace) {
            boolean bl = false;
            Object object = lock;
            synchronized (object) {
                if (!traceContext.empty()) {
                    bl = true;
                    Vector vector = (Vector)traceContext.peek();
                    vector.addElement(Debug.getTraceHeader() + string);
                }
            }
            if (!bl) {
                object = lock;
                synchronized (object) {
                    debugStream.print(Debug.getTraceHeader() + string + lineSeparator);
                    debugStream.flush();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void print(String string) {
        if (trace) {
            boolean bl = false;
            Object object = lock;
            synchronized (object) {
                if (!traceContext.empty()) {
                    bl = true;
                    Vector vector = (Vector)traceContext.peek();
                    vector.addElement(Debug.getTraceHeader() + string);
                }
            }
            if (!bl) {
                object = lock;
                synchronized (object) {
                    debugStream.print(string);
                    debugStream.flush();
                }
            }
        }
    }

    public static void traceDlg(Component component, String string) {
        Debug.trace(string);
        if (traceDlg) {
            new JButton().getToolkit().beep();
            JOptionPane.showMessageDialog(component, Debug.getTraceHeader() + string, "Debug.traceDlg", 2);
        }
    }

    public static void traceDlg(String string) {
        Debug.traceDlg(null, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dump(Object object) {
        if (trace) {
            boolean bl = false;
            String string = object == null ? "null" : object.toString();
            Object object2 = lock;
            synchronized (object2) {
                if (!traceContext.empty()) {
                    bl = true;
                    Vector vector = (Vector)traceContext.peek();
                    vector.addElement(Debug.getTraceHeader() + string);
                }
            }
            if (!bl) {
                object2 = lock;
                synchronized (object2) {
                    debugStream.print(Debug.getTraceHeader() + string + lineSeparator);
                    debugStream.flush();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void traceException(Throwable throwable, String string) {
        if (!trace && !stackTrace) {
            return;
        }
        if (throwable == null) {
            return;
        }
        boolean bl = Debug.exitContext();
        Object object = lock;
        synchronized (object) {
            if (trace) {
                debugStream.print(EXCEPTION_HEADER + lineSeparator);
                debugStream.flush();
            }
            if (stackTrace) {
                if (string != null) {
                    debugStream.print("[message: " + string + "]" + lineSeparator);
                    debugStream.flush();
                }
                throwable.printStackTrace(debugStream);
            } else if (trace) {
                debugStream.print(Debug.getThreadTrace() + " " + throwable + lineSeparator);
                debugStream.flush();
                if (string != null) {
                    debugStream.print("[message: " + string + "]" + lineSeparator);
                    debugStream.flush();
                }
            }
            if (trace) {
                debugStream.print(EXCEPTION_FOOTER + lineSeparator);
                debugStream.flush();
            }
        }
        if (bl) {
            Debug.enterContext();
        }
    }

    private static void traceProperties(String string, Properties properties) {
        if (trace) {
            if (string != null) {
                Debug.trace(string);
            }
            Debug.dump(properties);
            Debug.trace(TRACE_PREFIX);
        }
    }

    public static void traceException(Throwable throwable) {
        Debug.traceException(throwable, null);
    }

    private static void setProperties(Properties properties) {
        int n = 0;
        int n2 = 0;
        if (properties.containsKey(TIMESTAMP)) {
            n = 1;
            timestamp = Long.valueOf(properties.getProperty(TIMESTAMP));
            GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT-8:00"));
            long l = gregorianCalendar.getTime().getTime() / 1000L;
            if (l <= timestamp) {
                gregorianCalendar.setTime(new Date(timestamp * 1000L));
                n2 = gregorianCalendar.get(5);
                if (n2 == 13) {
                    n = 2;
                }
            }
        }
        switch (n) {
            case 0: {
                System.out.println("GroupWise Administration debugging is OFF - no code.");
                return;
            }
            case 1: {
                System.out.println("GroupWise Administration debugging is OFF - invalid code: " + timestamp + ", " + n2);
                return;
            }
        }
        System.out.println("GroupWise Administration debugging is ON.");
        if (properties.containsKey(TRACE)) {
            trace = Boolean.valueOf(properties.getProperty(TRACE));
        }
        if (properties.containsKey(TRACE_DLG)) {
            traceDlg = Boolean.valueOf(properties.getProperty(TRACE_DLG));
        }
        if (properties.containsKey(STACK_TRACE)) {
            stackTrace = Boolean.valueOf(properties.getProperty(STACK_TRACE));
        }
    }

    private static Properties getDefaultProperties() {
        Properties properties = new Properties();
        properties.put(TRACE, System.getProperty(TRACE, "false"));
        properties.put(TRACE_DLG, System.getProperty(TRACE_DLG, "false"));
        properties.put(STACK_TRACE, System.getProperty(STACK_TRACE, "false"));
        return properties;
    }

    private static void loadProperties(String string) {
        Debug debug = new Debug();
        InputStream inputStream = debug.getClass().getResourceAsStream("/" + string);
        if (inputStream == null) {
            return;
        }
        try {
            Properties properties = new Properties(Debug.getDefaultProperties());
            properties.load(new BufferedInputStream(inputStream));
            Debug.setProperties(properties);
        }
        catch (IOException iOException) {
            System.out.println("Debug.loadProperties: ex= " + iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void enterContext(String string) {
        if (!trace) {
            return;
        }
        Vector<String> vector = new Vector<String>();
        Object object = lock;
        synchronized (object) {
            traceContext.push(vector);
        }
        if (string != null) {
            vector.addElement(Debug.getTraceHeader() + string);
        }
    }

    private static void enterContext() {
        Debug.enterContext(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean exitContext(String string) {
        if (!trace) {
            return false;
        }
        Vector vector = null;
        boolean bl = false;
        Object object = lock;
        synchronized (object) {
            if (!traceContext.empty()) {
                vector = (Vector)traceContext.pop();
                bl = true;
            }
        }
        if (vector != null) {
            Debug.trace(vector);
        }
        return bl;
    }

    private static boolean exitContext() {
        return Debug.exitContext(null);
    }

    private static void exitAllContext() {
        while (Debug.exitContext()) {
        }
    }

    private static String getTraceHeader() {
        StringBuffer stringBuffer = new StringBuffer(TRACE_PREFIX);
        int n = Debug.getIndentLevel(Thread.currentThread().getName());
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(INDENT);
        }
        return stringBuffer.toString();
    }

    private static String getThreadTrace() {
        return Thread.currentThread().getName();
    }

    public static void separator() {
        Debug.trace(SEPARATOR);
    }

    private static void incrementIndentLevel(String string) {
        if (trace) {
            int n = threadContext.containsKey(string) ? (Integer)threadContext.get(string) : 0;
            threadContext.put(string, new Integer(++n));
        }
    }

    private static void decrementIndentLevel(String string) {
        if (trace) {
            int n = threadContext.containsKey(string) ? (Integer)threadContext.get(string) : 1;
            if (--n == 0) {
                threadContext.remove(string);
            } else {
                threadContext.put(string, new Integer(n));
            }
        }
    }

    private static int getIndentLevel(String string) {
        if (trace) {
            return 0;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void trace(Vector vector) {
        Object object = lock;
        synchronized (object) {
            debugStream.print(SEPARATOR + lineSeparator);
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                debugStream.print((String)enumeration.nextElement() + lineSeparator);
            }
            debugStream.print(SEPARATOR + lineSeparator);
            debugStream.flush();
        }
    }

    public static String dumpString() {
        return "com.novell.netmessenger.admin.common\n timestamp = " + timestamp + "\n trace     = " + trace + "\n traceDlg  = " + traceDlg + "\n stackTrace= " + stackTrace;
    }

    static {
        Debug.loadProperties("debug.properties");
    }
}

