/*
 * Decompiled with CFR 0.152.
 */
package com.novell.netmessenger.admin.common;

import com.novell.application.console.snapin.MainShell;
import com.novell.netmessenger.admin.common.Resource;
import com.novell.netmessenger.admin.common.UNCFileChooser;
import com.novell.netmessenger.admin.swingext.JButtonExt;
import com.novell.netmessenger.admin.swingext.JTextFieldExt;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.io.File;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.Document;

public class FilePathTextField
extends JPanel
implements ActionListener {
    private JTextFieldExt m_tfFilePath;
    private JButtonExt m_btnFilePath;
    private int m_iFileMode;
    private FileFilter m_fileFilter = null;
    private Component m_cmpParent;

    public FilePathTextField(int n) {
        this(MainShell.getInstance().getShellFrame(), n);
    }

    public FilePathTextField(Component component, int n) {
        ImageIcon imageIcon;
        this.m_iFileMode = n;
        this.m_cmpParent = component;
        this.m_tfFilePath = new JTextFieldExt(30);
        if (this.m_iFileMode == 1) {
            imageIcon = new ImageIcon(this.getClass().getResource("/com/novell/netmessenger/admin/common/images/folder.gif"));
        } else {
            if (this.m_iFileMode != 0 && this.m_iFileMode != 2) {
                this.m_iFileMode = 2;
            }
            imageIcon = new ImageIcon(this.getClass().getResource("/com/novell/netmessenger/admin/common/images/file.gif"));
        }
        this.m_btnFilePath = new JButtonExt(imageIcon, Resource.get("FilePathTextFieldPath"));
        this.layoutControls();
    }

    private void layoutControls() {
        Icon icon = this.m_btnFilePath.getIcon();
        Dimension dimension = new Dimension(icon.getIconWidth() + 10, icon.getIconHeight() + 5);
        this.m_btnFilePath.setPreferredSize(dimension);
        this.m_btnFilePath.setMinimumSize(dimension);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = 2;
        gridBagConstraints.fill = 2;
        this.add((Component)this.m_tfFilePath, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.left = 2;
        gridBagConstraints.fill = 3;
        this.add((Component)this.m_btnFilePath, gridBagConstraints);
        this.m_btnFilePath.addActionListener(this);
    }

    public void setFileFilter(FileFilter fileFilter) {
        this.m_fileFilter = fileFilter;
    }

    public void setText(String string) {
        this.m_tfFilePath.setText(string);
    }

    public String getText() {
        return this.m_tfFilePath.getText();
    }

    public void setModified(boolean bl) {
        this.m_tfFilePath.setModified(bl);
    }

    public boolean isModified() {
        return this.m_tfFilePath.isModified();
    }

    public void setEditable(boolean bl) {
        this.m_tfFilePath.setEditable(bl);
    }

    public void setEnabled(boolean bl) {
        this.m_tfFilePath.setEnabled(bl);
        this.m_btnFilePath.setEnabled(bl);
    }

    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    public Insets getInsets(Insets insets) {
        return new Insets(0, 0, 0, 0);
    }

    public void requestFocus() {
        this.m_tfFilePath.requestFocus();
    }

    public Document getDocument() {
        return this.m_tfFilePath.getDocument();
    }

    public void addKeyListener(KeyListener keyListener) {
        this.m_tfFilePath.addKeyListener(keyListener);
    }

    public void addDocumentListener(DocumentListener documentListener) {
        this.m_tfFilePath.addDocumentListener(documentListener);
    }

    public void removeDocumentListener(DocumentListener documentListener) {
        this.m_tfFilePath.removeDocumentListener(documentListener);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == null) {
            return;
        }
        if (object.equals(this.m_btnFilePath)) {
            File file = new File(this.getText());
            String string = file.getParent();
            if (string == null) {
                string = file.getPath();
            }
            UNCFileChooser uNCFileChooser = new UNCFileChooser(string);
            uNCFileChooser.setFileSelectionMode(this.m_iFileMode);
            uNCFileChooser.setFileFilter(this.m_fileFilter);
            uNCFileChooser.setMultiSelectionEnabled(false);
            int n = uNCFileChooser.showOpenDialog(this.m_cmpParent);
            this.m_cmpParent.requestFocus();
            if (n == 0) {
                String string2 = null;
                string2 = uNCFileChooser.getUNCPath(uNCFileChooser.getSelectedFile());
                if (string2 == null) {
                    string2 = uNCFileChooser.getSelectedFile().getPath();
                }
                this.m_tfFilePath.setText(string2);
            }
        }
    }
}

