/*
 * Decompiled with CFR 0.152.
 */
package com.novell.netmessenger.admin.common;

import com.novell.netmessenger.admin.swingext.JLabelExt;
import com.novell.netmessenger.admin.swingext.JTextFieldExt;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.StringTokenizer;
import javax.swing.FocusManager;
import javax.swing.JPanel;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class IPComponent
extends JPanel
implements FocusListener,
KeyListener {
    JTextFieldExt[] m_tfOctet = new JTextFieldExt[4];
    JLabelExt[] m_labelDot = new JLabelExt[3];

    public IPComponent() {
        this.layoutControls();
    }

    public void layoutControls() {
        this.setLayout(new FlowLayout(0, 0, 0));
        for (int i = 0; i < 4; ++i) {
            this.m_tfOctet[i] = new JTextFieldExt(new DigitOnlyDocument(), "", 4);
            this.m_tfOctet[i].setHorizontalAlignment(0);
            this.m_tfOctet[i].addKeyListener(this);
            this.m_tfOctet[i].addFocusListener(this);
            this.add(this.m_tfOctet[i]);
            if (i == 3) continue;
            this.m_labelDot[i] = new JLabelExt(" . ");
            this.add(this.m_labelDot[i]);
        }
    }

    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    public Insets getInsets(Insets insets) {
        return new Insets(0, 0, 0, 0);
    }

    public boolean setText(String string) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            if (stringTokenizer.countTokens() != 4) {
                return false;
            }
            for (int i = 0; i < 4; ++i) {
                int n;
                String string2 = stringTokenizer.nextToken().trim();
                try {
                    n = Integer.parseInt(string2);
                }
                catch (Exception exception) {
                    for (int j = 0; j < i; ++j) {
                        this.m_tfOctet[j].setText("");
                    }
                    return false;
                }
                if (n < 0 || n > 255) {
                    for (int j = 0; j < i; ++j) {
                        this.m_tfOctet[j].setText("");
                    }
                    return false;
                }
                this.m_tfOctet[i].setText(string2);
            }
            return true;
        }
        return true;
    }

    public String getText() {
        String string = new String();
        String[] stringArray = new String[4];
        for (int i = 0; i < 4; ++i) {
            stringArray[i] = this.m_tfOctet[i].getText();
            stringArray[i] = stringArray[i].length() == 0 ? "0" : stringArray[i];
            string = string.concat(stringArray[i]);
            if (i == 3) continue;
            string = string.concat(".");
        }
        if (string.equals("0.0.0.0")) {
            string = null;
        }
        return string;
    }

    public void setEnabled(boolean bl) {
        for (int i = 0; i < 4; ++i) {
            this.m_tfOctet[i].setEnabled(bl);
            if (i == 3) continue;
            this.m_labelDot[i].setEnabled(bl);
        }
    }

    public void requestFocus() {
        this.m_tfOctet[0].requestFocus();
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public boolean isRequestFocusEnabled() {
        return true;
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void addDocumentListener(DocumentListener documentListener) {
        for (int i = 0; i < 4; ++i) {
            this.m_tfOctet[i].addDocumentListener(documentListener);
        }
    }

    public void removeDocumentListener(DocumentListener documentListener) {
        for (int i = 0; i < 4; ++i) {
            this.m_tfOctet[i].removeDocumentListener(documentListener);
        }
    }

    public boolean isModified() {
        boolean bl = this.m_tfOctet[0].isModified() || this.m_tfOctet[1].isModified() || this.m_tfOctet[2].isModified() || this.m_tfOctet[3].isModified();
        return bl;
    }

    private class DigitOnlyDocument
    extends PlainDocument {
        private DigitOnlyDocument() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            int n2;
            for (n2 = 0; n2 < string.length(); ++n2) {
                if (string.charAt(n2) == '.') {
                    JTextFieldExt jTextFieldExt = null;
                    if (IPComponent.this.m_tfOctet[0].hasFocus()) {
                        jTextFieldExt = IPComponent.this.m_tfOctet[0];
                    } else if (IPComponent.this.m_tfOctet[1].hasFocus()) {
                        jTextFieldExt = IPComponent.this.m_tfOctet[1];
                    } else if (IPComponent.this.m_tfOctet[2].hasFocus()) {
                        jTextFieldExt = IPComponent.this.m_tfOctet[2];
                    }
                    if (jTextFieldExt != null) {
                        FocusManager focusManager = FocusManager.getCurrentManager();
                        focusManager.focusNextComponent(jTextFieldExt);
                    }
                    return;
                }
                if (Character.isDigit(string.charAt(n2))) continue;
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            if (this.getLength() + string.length() < 4) {
                if (this.getLength() + string.length() == 3) {
                    try {
                        String string2 = n == 0 ? string + this.getText(0, this.getLength()) : (n == this.getLength() ? this.getText(0, this.getLength()) + string : this.getText(0, n) + string + this.getText(n, this.getLength() - n));
                        n2 = Integer.parseInt(string2);
                    }
                    catch (BadLocationException badLocationException) {
                        return;
                    }
                    if (n2 > 255) {
                        Toolkit.getDefaultToolkit().beep();
                        return;
                    }
                }
            } else {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            super.insertString(n, string, attributeSet);
        }
    }
}

