/*
 * Decompiled with CFR 0.152.
 */
package com.novell.netmessenger.admin.common;

import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.BooleanValue;
import com.novell.admin.ns.InputStreamFactory;
import com.novell.admin.ns.LongValue;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.StreamValue;
import com.novell.admin.ns.StringValue;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.admin.ns.nds.NDSSyntax;
import com.novell.admin.ns.nds.NetAddressFacade;
import com.novell.admin.ns.nds.PathFacade;
import com.novell.admin.ns.nds.TypedNameFacade;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.netmessenger.admin.common.Debug;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class NDSNegotiator {
    public NSObject getNSObject(NDSNamespace nDSNamespace, String string) throws Exception {
        if (nDSNamespace == null || string == null) {
            return null;
        }
        try {
            ObjectEntry objectEntry = nDSNamespace.getObjectEntry(string);
            NSObject nSObject = nDSNamespace.getDetails(objectEntry);
            return nSObject;
        }
        catch (Exception exception) {
            Debug.trace("NDSNegotiator.getNSObject: throwing " + exception);
            throw exception;
        }
    }

    public boolean doesObjectExist(NDSNamespace nDSNamespace, String string) {
        if (nDSNamespace == null || string == null) {
            return false;
        }
        try {
            int n = string.indexOf(47);
            if (n != -1) {
                string = string.substring(n + 1, string.length());
            }
            String string2 = null;
            String string3 = null;
            int n2 = string.indexOf(46);
            if (n2 == -1) {
                return false;
            }
            string2 = string.substring(0, n2);
            string3 = string.substring(n2 + 1, string.length());
            ObjectEntry objectEntry = nDSNamespace.getObjectEntry(string3);
            return nDSNamespace.doesExist(objectEntry, string2);
        }
        catch (Exception exception) {
            Debug.trace("NDSNegotiator.doesObjectExist: e= " + exception);
            return false;
        }
    }

    public Date getLastModificationTime(NDSNamespace nDSNamespace, String string) {
        if (nDSNamespace == null || string == null) {
            return null;
        }
        try {
            int n = string.indexOf(47);
            if (n != -1) {
                string = string.substring(n + 1, string.length());
            }
            ObjectEntry objectEntry = nDSNamespace.getObjectEntry(string);
            return nDSNamespace.getLastModificationTime(objectEntry);
        }
        catch (Exception exception) {
            Debug.trace("NDSNegotiator.getLastModificationTime: ex= " + exception);
            Debug.traceException(exception);
            return null;
        }
    }

    public Vector getMultiValuedAttribute(NDSNamespace nDSNamespace, String string, String string2) {
        if (nDSNamespace == null || string == null || string2 == null) {
            return null;
        }
        try {
            ObjectEntry objectEntry = nDSNamespace.getObjectEntry(string);
            NSObject nSObject = nDSNamespace.getDetails(objectEntry);
            return this.getMultiValuedAttribute(nSObject, string2);
        }
        catch (Exception exception) {
            Debug.trace("NDSNegotiator.getMultiValueAttribute1: ex= " + exception);
            Debug.traceException(exception);
            return null;
        }
    }

    public Vector getMultiValuedAttribute(NSObject nSObject, String string) {
        try {
            ObjectAttribute objectAttribute = nSObject.getAttribute(string);
            if (objectAttribute == null) {
                return null;
            }
            AttributeDefinition attributeDefinition = objectAttribute.getAttributeDefinition();
            Enumeration enumeration = objectAttribute.getValueComponents();
            NDSSyntax nDSSyntax = (NDSSyntax)attributeDefinition.getSyntax();
            int n = nDSSyntax.getId();
            Vector<String> vector = new Vector<String>();
            if (n == NDSSyntax.SYN_CI_STRING.getId() || n == NDSSyntax.SYN_DIST_NAME.getId()) {
                while (enumeration.hasMoreElements()) {
                    vector.addElement(((StringValue)enumeration.nextElement()).getValue());
                }
                return vector;
            }
            if (n == NDSSyntax.SYN_BOOLEAN.getId()) {
                while (enumeration.hasMoreElements()) {
                    vector.addElement(((StringValue)enumeration.nextElement()).getValue());
                }
                return vector;
            }
            if (n == NDSSyntax.SYN_INTEGER.getId()) {
                while (enumeration.hasMoreElements()) {
                    vector.addElement(((StringValue)enumeration.nextElement()).getValue());
                }
                return vector;
            }
            if (n == NDSSyntax.SYN_TYPED_NAME.getId()) {
                int n2;
                TypedNameFacade typedNameFacade;
                Vector<TypedNameFacade> vector2 = new Vector<TypedNameFacade>();
                while (enumeration.hasMoreElements()) {
                    typedNameFacade = new TypedNameFacade((ValueList)enumeration.nextElement());
                    for (n2 = 0; n2 < vector2.size(); ++n2) {
                        TypedNameFacade typedNameFacade2 = (TypedNameFacade)vector2.elementAt(n2);
                        if (typedNameFacade.getLevel() < typedNameFacade2.getLevel()) break;
                    }
                    vector2.insertElementAt(typedNameFacade, n2);
                }
                for (n2 = 0; n2 < vector2.size(); ++n2) {
                    typedNameFacade = (TypedNameFacade)vector2.elementAt(n2);
                    vector.addElement(typedNameFacade.getObject());
                }
                return vector;
            }
            if (n == NDSSyntax.SYN_PATH.getId()) {
                while (enumeration.hasMoreElements()) {
                    PathFacade pathFacade = new PathFacade((ValueList)enumeration.nextElement());
                    vector.addElement(pathFacade.getPath());
                }
                return vector;
            }
            if (n == NDSSyntax.SYN_NET_ADDRESS.getId()) {
                while (enumeration.hasMoreElements()) {
                    NetAddressFacade netAddressFacade = new NetAddressFacade((ValueList)enumeration.nextElement());
                    if (netAddressFacade.getAddressType() != 1L) continue;
                    vector.addElement(new String(netAddressFacade.getAddress()));
                }
                return vector;
            }
        }
        catch (Exception exception) {
            Debug.trace("NDSNegotiator.getMultiValueAttribute2: ex= " + exception);
            Debug.traceException(exception);
        }
        return null;
    }

    public String getAttribute(NDSNamespace nDSNamespace, String string, String string2) {
        if (nDSNamespace == null || string == null || string2 == null) {
            return null;
        }
        try {
            ObjectEntry objectEntry = nDSNamespace.getObjectEntry(string);
            NSObject nSObject = nDSNamespace.getDetails(objectEntry);
            return this.getAttribute(nSObject, string2);
        }
        catch (Exception exception) {
            Debug.trace("NDSNegotiator.getAttribute1: ex= " + exception);
            Debug.traceException(exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAttribute(NSObject nSObject, String string) {
        ObjectAttribute objectAttribute = nSObject.getAttribute(string);
        Object var4_4 = null;
        if (objectAttribute == null) {
            return null;
        }
        AttributeDefinition attributeDefinition = objectAttribute.getAttributeDefinition();
        NDSSyntax nDSSyntax = (NDSSyntax)attributeDefinition.getSyntax();
        int n = nDSSyntax.getId();
        if (n == NDSSyntax.SYN_CI_STRING.getId() || n == NDSSyntax.SYN_DIST_NAME.getId()) {
            return objectAttribute.toString();
        }
        if (n == NDSSyntax.SYN_BOOLEAN.getId()) {
            Enumeration enumeration = objectAttribute.getValueComponents();
            if (enumeration.hasMoreElements()) {
                Boolean bl = new Boolean(((BooleanValue)enumeration.nextElement()).getValue());
                return bl.toString();
            }
            return "false";
        }
        if (n == NDSSyntax.SYN_INTEGER.getId()) {
            Enumeration enumeration = objectAttribute.getValueComponents();
            if (enumeration.hasMoreElements()) {
                Long l = new Long(((LongValue)enumeration.nextElement()).getValue());
                return l.toString();
            }
            return "0";
        }
        if (n == NDSSyntax.SYN_TYPED_NAME.getId()) {
            Enumeration enumeration = objectAttribute.getValueComponents();
            try {
                TypedNameFacade typedNameFacade = new TypedNameFacade((ValueList)enumeration.nextElement());
                return typedNameFacade.getObject();
            }
            catch (Exception exception) {
                Debug.trace("NDSNegotiator.getAttribute: ex= " + exception);
                Debug.traceException(exception);
            }
        } else if (n == NDSSyntax.SYN_PATH.getId()) {
            Enumeration enumeration = objectAttribute.getValueComponents();
            try {
                PathFacade pathFacade = new PathFacade((ValueList)enumeration.nextElement());
                return pathFacade.getPath();
            }
            catch (Exception exception) {
                Debug.trace("NDSNegotiator.getAttribute: ex= " + exception);
                Debug.traceException(exception);
            }
        } else if (n == NDSSyntax.SYN_NET_ADDRESS.getId()) {
            Enumeration enumeration = objectAttribute.getValueComponents();
            try {
                NetAddressFacade netAddressFacade = new NetAddressFacade((ValueList)enumeration.nextElement());
                return new String(netAddressFacade.getAddress());
            }
            catch (Exception exception) {
                Debug.trace("NDSNegotiator.getAttribute: ex= " + exception);
                Debug.traceException(exception);
            }
        } else if (n == NDSSyntax.SYN_STREAM.getId()) {
            InputStream inputStream = this.getAttributeStream(nSObject, string);
            if (inputStream != null) {
                int n2 = 0;
                byte[] byArray = new byte[256];
                StringBuffer stringBuffer = new StringBuffer(256);
                try {
                    while ((n2 = inputStream.read(byArray, 0, byArray.length)) != -1) {
                        stringBuffer.append(new String(byArray, 0, n2));
                    }
                }
                catch (Exception exception) {
                    Debug.trace("NDSNegotiator.getAttribute: IGNORE this ex= " + exception);
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {
                        Debug.trace("NDSNegotiator.getAttribute: IGNORE this ex= " + exception);
                    }
                }
                return stringBuffer.toString();
            }
        } else {
            Debug.trace("UNKNOWN SYNTAX");
        }
        return null;
    }

    public InputStream getAttributeStream(NSObject nSObject, String string) {
        ObjectAttribute objectAttribute = nSObject.getAttribute(string);
        Object var4_4 = null;
        if (objectAttribute == null) {
            return null;
        }
        Enumeration enumeration = objectAttribute.getValueComponents();
        InputStream inputStream = null;
        if (enumeration.hasMoreElements()) {
            try {
                inputStream = ((StreamValue)enumeration.nextElement()).getValue();
            }
            catch (Exception exception) {
                Debug.trace("NDSNegotiator.getAttributeStream: ex= " + exception);
                Debug.traceException(exception);
                return null;
            }
        }
        return inputStream;
    }

    public boolean setMultiValuedAttribute(NDSNamespace nDSNamespace, String string, String string2, Vector vector) {
        if (nDSNamespace == null || string == null || string2 == null) {
            return false;
        }
        try {
            ObjectEntry objectEntry = nDSNamespace.getObjectEntry(string);
            NSObject nSObject = nDSNamespace.getDetails(objectEntry);
            boolean bl = this.setMultiValuedAttribute(nSObject, string2, vector);
            nDSNamespace.update(nSObject);
            return bl;
        }
        catch (Exception exception) {
            Debug.trace("NDSNegotiator.setMultiValuedAttribute: e= " + exception);
            Debug.traceException(exception);
            return false;
        }
    }

    public boolean setMultiValuedAttribute(NSObject nSObject, String string, Vector vector) {
        try {
            ObjectEntry objectEntry = nSObject.getObjectEntry();
            NDSNamespace nDSNamespace = (NDSNamespace)objectEntry.getObjectType().getNamespace();
            ObjectAttribute objectAttribute = nSObject.getAttribute(string);
            AttributeDefinition attributeDefinition = null;
            NDSSyntax nDSSyntax = null;
            int n = 0;
            ValueComponent[] valueComponentArray = null;
            if (objectAttribute != null) {
                attributeDefinition = objectAttribute.getAttributeDefinition();
                nDSSyntax = (NDSSyntax)attributeDefinition.getSyntax();
                n = nDSSyntax.getId();
            } else {
                attributeDefinition = nDSNamespace.getAttributeDefinition(objectEntry, string);
                nDSSyntax = (NDSSyntax)attributeDefinition.getSyntax();
                n = nDSSyntax.getId();
            }
            if (vector == null) {
                Debug.trace("NDSNegotiator.setMultiValuedAttribute: vec is NULL");
            } else if (vector.size() == 1 && vector.elementAt(0) == null) {
                Debug.trace("NDSNegotiator.setMultiValuedAttribute: vec's element is NULL");
                vector = null;
            } else {
                valueComponentArray = new ValueComponent[vector.size()];
                if (n == NDSSyntax.SYN_CI_STRING.getId() || n == NDSSyntax.SYN_DIST_NAME.getId()) {
                    for (int i = 0; i < vector.size(); ++i) {
                        valueComponentArray[i] = nDSSyntax.createValueComponent(vector.elementAt(i));
                    }
                } else if (n == NDSSyntax.SYN_INTEGER.getId()) {
                    for (int i = 0; i < vector.size(); ++i) {
                        Long l = new Long((String)vector.elementAt(i));
                        valueComponentArray[i] = nDSSyntax.createValueComponent((Object)l);
                    }
                } else if (n == NDSSyntax.SYN_TYPED_NAME.getId()) {
                    long l = 0L;
                    long l2 = 0L;
                    for (int i = 0; i < vector.size(); ++i) {
                        valueComponentArray[i] = TypedNameFacade.createValueList((String)((String)vector.elementAt(i)), (long)(i + 1), (long)l2);
                    }
                } else if (n == NDSSyntax.SYN_PATH.getId()) {
                    String string2 = nDSNamespace.getUnrootedName(objectEntry);
                    for (int i = 0; i < vector.size(); ++i) {
                        valueComponentArray[i] = PathFacade.createValueList((long)4L, (String)string2, (String)((String)vector.elementAt(i)));
                    }
                } else if (n == NDSSyntax.SYN_NET_ADDRESS.getId()) {
                    for (int i = 0; i < vector.size(); ++i) {
                        String string3 = (String)vector.elementAt(i);
                        valueComponentArray[i] = NetAddressFacade.createValueList((long)1L, (byte[])string3.getBytes());
                    }
                } else {
                    Debug.trace("setMultiValuedAttribute: Unknown attribute type - " + string);
                }
            }
            if (objectAttribute != null && vector != null && vector.size() > 0) {
                objectAttribute.removeAllComponents();
                objectAttribute.addComponents(valueComponentArray);
            } else if (objectAttribute == null && vector != null && vector.size() > 0) {
                objectAttribute = new ObjectAttribute(attributeDefinition);
                objectAttribute.addComponents(valueComponentArray);
                nSObject.addAttribute(objectAttribute);
            } else if (objectAttribute != null && (vector == null || vector.size() == 0)) {
                Debug.trace("NDSNegotiator.setMultiValuedAttribute: deleting sAttrib= " + string);
                nSObject.deleteAttribute(string);
            }
        }
        catch (Exception exception) {
            Debug.trace("NDSNegotiator.setMultiValuedAttribute: ex= " + exception);
            Debug.traceException(exception);
            return false;
        }
        return true;
    }

    public boolean setAttribute(NSObject nSObject, String string, String string2) {
        Debug.trace("NDSNegotiator.setAttribute:  attr= " + string + ", val= " + string2);
        try {
            ObjectEntry objectEntry = nSObject.getObjectEntry();
            NDSNamespace nDSNamespace = (NDSNamespace)objectEntry.getObjectType().getNamespace();
            ObjectAttribute objectAttribute = nSObject.getAttribute(string);
            AttributeDefinition attributeDefinition = null;
            NDSSyntax nDSSyntax = null;
            int n = 0;
            if (objectAttribute != null) {
                attributeDefinition = objectAttribute.getAttributeDefinition();
                nDSSyntax = (NDSSyntax)attributeDefinition.getSyntax();
                n = nDSSyntax.getId();
            } else {
                attributeDefinition = nDSNamespace.getAttributeDefinition(objectEntry, string);
                nDSSyntax = (NDSSyntax)attributeDefinition.getSyntax();
                n = nDSSyntax.getId();
            }
            ValueComponent valueComponent = null;
            if (string2 != null && string2.length() > 0) {
                if (n == NDSSyntax.SYN_CI_STRING.getId() || n == NDSSyntax.SYN_DIST_NAME.getId()) {
                    valueComponent = nDSSyntax.createValueComponent((Object)string2);
                } else if (n == NDSSyntax.SYN_BOOLEAN.getId()) {
                    Boolean bl = new Boolean(string2);
                    valueComponent = nDSSyntax.createValueComponent((Object)bl);
                } else if (n == NDSSyntax.SYN_INTEGER.getId()) {
                    Long l = new Long(string2);
                    valueComponent = nDSSyntax.createValueComponent((Object)l);
                } else if (n == NDSSyntax.SYN_TYPED_NAME.getId()) {
                    long l = 0L;
                    long l2 = 0L;
                    valueComponent = TypedNameFacade.createValueList((String)string2, (long)l, (long)l2);
                } else if (n == NDSSyntax.SYN_PATH.getId()) {
                    String string3 = nDSNamespace.getUnrootedName(objectEntry);
                    valueComponent = PathFacade.createValueList((long)4L, (String)string3, (String)string2);
                } else if (n == NDSSyntax.SYN_NET_ADDRESS.getId()) {
                    valueComponent = NetAddressFacade.createValueList((long)1L, (byte[])string2.getBytes());
                } else if (n == NDSSyntax.SYN_STREAM.getId()) {
                    valueComponent = this.setAttributeStream(nSObject, string, string2);
                } else {
                    Debug.trace("setAttribute: Unknown attribute type - " + string);
                }
            }
            if (objectAttribute != null && string2 != null && string2.length() > 0) {
                if (string2.trim().length() == 0) {
                    nSObject.deleteAttribute(string);
                } else {
                    objectAttribute.removeAllComponents();
                    objectAttribute.addComponent(valueComponent);
                }
            } else if (objectAttribute == null && string2 != null && string2.trim().length() > 0) {
                objectAttribute = new ObjectAttribute(attributeDefinition);
                objectAttribute.addComponent(valueComponent);
                nSObject.addAttribute(objectAttribute);
            } else if (objectAttribute != null && (string2 == null || string2.trim().length() == 0)) {
                nSObject.deleteAttribute(string);
            }
        }
        catch (Exception exception) {
            Debug.trace("NDSNegotiator.setAttribute:  ex= " + exception);
            Debug.traceException(exception);
            return false;
        }
        return true;
    }

    protected ValueComponent setAttributeStream(NSObject nSObject, String string, String string2) {
        ValueComponent valueComponent = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeBytes(string2);
            StreamFactory streamFactory = new StreamFactory(byteArrayOutputStream.toByteArray());
            valueComponent = NDSSyntax.SYN_STREAM.createValueComponent((Object)streamFactory);
        }
        catch (Exception exception) {
            Debug.trace("NDSNegotiator.setAttributeStream: ex= " + exception);
            return null;
        }
        return valueComponent;
    }

    public boolean update(NSObject nSObject) {
        NDSNamespace nDSNamespace = null;
        boolean bl = true;
        try {
            nDSNamespace = (NDSNamespace)nSObject.getObjectEntry().getObjectType().getNamespace();
            nDSNamespace.update(nSObject);
        }
        catch (Exception exception) {
            Debug.trace("NDSNegotiator.update: ex= " + exception);
            Debug.traceException(exception);
            bl = false;
        }
        return bl;
    }

    private class StreamFactory
    implements InputStreamFactory {
        private byte[] m_byteArray;

        public StreamFactory(byte[] byArray) {
            this.m_byteArray = byArray;
        }

        public InputStream getInputStream() {
            return new ByteArrayInputStream(this.m_byteArray);
        }
    }
}

