/*
 * Decompiled with CFR 0.152.
 */
package com.novell.netmessenger.admin.common;

import com.novell.netmessenger.admin.common.Resource;
import com.novell.netmessenger.admin.swingext.JButtonExt;
import com.novell.netmessenger.admin.swingext.JTextFieldExt;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class NIncrementBox
extends JPanel
implements ActionListener,
FocusListener,
KeyListener,
MouseListener {
    private int m_iMin;
    private int m_iMax;
    private JTextFieldExt m_tfInc;
    private JButtonExt m_btnUp;
    private JButtonExt m_btnDown;
    private Timer m_timer;
    private boolean m_bIncrement;

    public NIncrementBox(int n) {
        this(Integer.MIN_VALUE, Integer.MAX_VALUE, n);
    }

    public NIncrementBox(int n, int n2, int n3) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (n > n2) {
            n = Integer.MIN_VALUE;
            n2 = Integer.MAX_VALUE;
        }
        n3 = n3 > n ? n3 : n;
        n3 = n3 < n2 ? n3 : n2;
        this.m_iMin = n;
        this.m_iMax = n2;
        this.layoutControls(n3);
        this.m_timer = new Timer(25, this);
        this.m_timer.setInitialDelay(300);
        this.m_bIncrement = false;
    }

    private void layoutControls(int n) {
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/com/novell/netmessenger/admin/common/images/upArrow.gif"));
        ImageIcon imageIcon2 = new ImageIcon(this.getClass().getResource("/com/novell/netmessenger/admin/common/images/downArrow.gif"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        this.m_tfInc = new JTextFieldExt(new DigitOnlyDocument(), String.valueOf(n), 10);
        this.m_tfInc.setHorizontalAlignment(4);
        this.m_tfInc.addKeyListener(this);
        this.m_tfInc.addFocusListener(this);
        Dimension dimension = new Dimension(imageIcon.getIconWidth() + 10, imageIcon.getIconHeight() * 3 / 4);
        this.m_btnUp = new JButtonExt(imageIcon, Resource.get("NIncrementBoxUp"));
        this.m_btnUp.addActionListener(this);
        this.m_btnUp.addMouseListener(this);
        this.m_btnUp.setPreferredSize(dimension);
        this.m_btnUp.setMinimumSize(dimension);
        this.m_btnDown = new JButtonExt(imageIcon2, Resource.get("NIncrementBoxDown"));
        this.m_btnDown.addActionListener(this);
        this.m_btnDown.addMouseListener(this);
        this.m_btnDown.setPreferredSize(dimension);
        this.m_btnDown.setMinimumSize(dimension);
        this.setLayout(new GridBagLayout());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridheight = 2;
        this.add((Component)this.m_tfInc, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridheight = 1;
        this.add((Component)this.m_btnUp, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.m_btnDown, gridBagConstraints);
    }

    public String getText() {
        return this.m_tfInc.getText();
    }

    public void setText(String string) {
        this.m_tfInc.setText(string);
    }

    public void setValue(int n) {
        this.m_tfInc.setText(String.valueOf(n));
    }

    public int getValue() {
        int n = 0;
        try {
            n = Integer.parseInt(this.m_tfInc.getText());
        }
        catch (Exception exception) {
            n = this.m_iMin;
        }
        if (n > this.m_iMax) {
            n = this.m_iMax;
            this.setValue(this.m_iMax);
        }
        if (n < this.m_iMin) {
            n = this.m_iMin;
            this.setValue(this.m_iMin);
        }
        return n;
    }

    public void setMinValue(int n) {
        if (n < this.m_iMax) {
            this.m_iMin = n;
        }
    }

    public void setMaxValue(int n) {
        if (n > this.m_iMin) {
            this.m_iMax = n;
        }
    }

    protected void incrementValue() {
        try {
            int n = Integer.parseInt(this.m_tfInc.getText());
            if (++n > this.m_iMax) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            this.m_tfInc.setText(String.valueOf(n));
        }
        catch (Exception exception) {
            System.out.println("The data entered in the text field is invalid");
            this.m_tfInc.setText(String.valueOf(this.m_iMin));
            return;
        }
    }

    protected void decrementValue() {
        try {
            int n = Integer.parseInt(this.m_tfInc.getText());
            if (--n < this.m_iMin) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            this.m_tfInc.setText(String.valueOf(n));
        }
        catch (Exception exception) {
            System.out.println("The data entered in the text field is invalid");
            this.m_tfInc.setText(String.valueOf(this.m_iMax));
            return;
        }
    }

    public void setEnabled(boolean bl) {
        this.m_tfInc.setEnabled(bl);
        this.m_btnUp.setEnabled(bl);
        this.m_btnDown.setEnabled(bl);
    }

    public void requestFocus() {
        this.m_tfInc.requestFocus();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_btnUp) {
            this.incrementValue();
        } else if (actionEvent.getSource() == this.m_btnDown) {
            this.decrementValue();
        } else if (actionEvent.getSource() == this.m_timer) {
            if (this.m_bIncrement) {
                this.incrementValue();
            } else {
                this.decrementValue();
            }
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        if (this.m_tfInc.getText().length() == 0) {
            this.m_tfInc.setText("0");
        }
        if (this.getValue() < this.m_iMin) {
            this.setValue(this.m_iMin);
        }
        if (this.getValue() > this.m_iMax) {
            this.setValue(this.m_iMax);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 38) {
            this.incrementValue();
            this.m_bIncrement = true;
        } else if (n == 40) {
            this.decrementValue();
            this.m_bIncrement = false;
        } else {
            return;
        }
        this.m_timer.start();
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.m_timer.stop();
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (object == this.m_btnUp && this.m_btnUp.isEnabled()) {
            this.m_bIncrement = true;
        } else if (object == this.m_btnDown && this.m_btnUp.isEnabled()) {
            this.m_bIncrement = false;
        } else {
            return;
        }
        this.m_timer.start();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.m_timer.stop();
    }

    public void setModified(boolean bl) {
        this.m_tfInc.setModified(bl);
    }

    public boolean isModified() {
        return this.m_tfInc.isModified();
    }

    public void addDocumentListener(DocumentListener documentListener) {
        this.m_tfInc.addDocumentListener(documentListener);
    }

    public void removeDocumentListener(DocumentListener documentListener) {
        this.m_tfInc.removeDocumentListener(documentListener);
    }

    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    public Insets getInsets(Insets insets) {
        return new Insets(0, 0, 0, 0);
    }

    private class DigitOnlyDocument
    extends PlainDocument {
        private DigitOnlyDocument() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            for (int i = 0; i < string.length(); ++i) {
                if (Character.isDigit(string.charAt(i))) continue;
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            String string2 = this.getLength() > 0 ? (n == 0 ? string + this.getText(0, this.getLength()) : (n == this.getLength() ? this.getText(0, this.getLength()) + string : this.getText(0, n) + string + this.getText(n, this.getLength() - n))) : string;
            try {
                int n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            super.insertString(n, string, attributeSet);
        }
    }
}

