/*
 * Decompiled with CFR 0.152.
 */
package com.novell.netmessenger.admin.common;

import com.novell.application.console.snapin.MainShell;
import com.novell.application.console.snapin.Shell;
import com.novell.netmessenger.admin.common.Debug;
import com.novell.netmessenger.admin.common.Resource;
import com.novell.netmessenger.admin.swingext.JButtonExt;
import com.novell.netmessenger.admin.swingext.JListExt;
import com.novell.utility.nmsgbox.NMsgBox;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class OEList
extends JPanel
implements ActionListener,
KeyListener,
ListSelectionListener,
MouseListener {
    protected JListExt m_list;
    protected JButtonExt m_btnAdd;
    protected JButtonExt m_btnEdit;
    protected JButtonExt m_btnRemove;
    protected JButtonExt m_btnUp;
    protected JButtonExt m_btnDown;
    protected Vector m_vAdditionalButtons;
    protected DefaultListModel m_listModel;
    protected boolean m_bSequencing;
    protected Component m_cmpParentWindow;
    protected Shell m_shell;

    public OEList(Component component, boolean bl) {
        this.m_cmpParentWindow = component;
        this.m_bSequencing = bl;
        this.m_listModel = new DefaultListModel();
        this.m_list = new JListExt((ListModel)this.m_listModel);
        this.m_list.addKeyListener(this);
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/com/novell/netmessenger/admin/common/images/browser.gif"));
        this.m_btnAdd = new JButtonExt(Resource.get("OEListAdd"));
        ImageIcon imageIcon2 = new ImageIcon(this.getClass().getResource("/com/novell/netmessenger/admin/common/images/oes.gif"));
        this.m_btnEdit = new JButtonExt(Resource.get("OEListEdit"));
        ImageIcon imageIcon3 = new ImageIcon(this.getClass().getResource("/com/novell/netmessenger/admin/common/images/remove.gif"));
        this.m_btnRemove = new JButtonExt(Resource.get("OEListRemove"));
        if (this.m_bSequencing) {
            ImageIcon imageIcon4 = new ImageIcon(this.getClass().getResource("/com/novell/netmessenger/admin/common/images/up.gif"));
            this.m_btnUp = new JButtonExt(Resource.get("OEListUp"));
            ImageIcon imageIcon5 = new ImageIcon(this.getClass().getResource("/com/novell/netmessenger/admin/common/images/down.gif"));
            this.m_btnDown = new JButtonExt(Resource.get("OEListDown"));
        }
        this.setButtonsEnabled(false);
        this.m_shell = MainShell.getInstance();
    }

    protected void layoutControls() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 18;
        this.setGBC(gridBagConstraints, 1, 1, 1, 0, 1, 1.0, 1.0);
        this.add((Component)new JScrollPane(this.m_list), gridBagConstraints);
        this.setGBC(gridBagConstraints, 2, 1, 1, 1, 2, 0.0, 0.0);
        this.add((Component)this.m_btnAdd, gridBagConstraints);
        this.setGBC(gridBagConstraints, 2, 2, 1, 1, 2, 0.0, 0.0);
        this.add((Component)this.m_btnEdit, gridBagConstraints);
        this.setGBC(gridBagConstraints, 2, 3, 1, 1, 2, 0.0, 0.0);
        this.add((Component)this.m_btnRemove, gridBagConstraints);
        if (this.m_bSequencing) {
            this.setGBC(gridBagConstraints, 2, 4, 1, 1, 2, 0.0, 0.0);
            this.add((Component)this.m_btnUp, gridBagConstraints);
            this.setGBC(gridBagConstraints, 2, 5, 1, 1, 2, 0.0, 1.0);
            this.add((Component)this.m_btnDown, gridBagConstraints);
        }
        if (this.m_vAdditionalButtons != null) {
            for (int i = 0; i < this.m_vAdditionalButtons.size(); ++i) {
                JButton jButton = (JButton)this.m_vAdditionalButtons.elementAt(i);
                this.setGBC(gridBagConstraints, 2, i + 6, 1, 1, 2, 0.0, 0.0);
                this.add((Component)jButton, gridBagConstraints);
            }
        }
        this.m_list.addListSelectionListener(this);
        this.m_list.addMouseListener(this);
        this.m_btnAdd.addActionListener(this);
        this.m_btnEdit.addActionListener(this);
        this.m_btnRemove.addActionListener(this);
        if (this.m_bSequencing) {
            this.m_btnUp.addActionListener(this);
            this.m_btnDown.addActionListener(this);
        }
    }

    protected void setGBC(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, double d, double d2) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.fill = n5;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
    }

    protected void addButton(JButton jButton) {
        if (this.m_vAdditionalButtons == null) {
            this.m_vAdditionalButtons = new Vector();
        }
        this.m_vAdditionalButtons.addElement(jButton);
    }

    public Vector getListData() {
        Vector vector = null;
        Enumeration enumeration = this.m_listModel.elements();
        if (enumeration != null && enumeration.hasMoreElements()) {
            vector = new Vector();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
        }
        return vector;
    }

    public void setListData(Vector vector) {
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                this.m_listModel.addElement(vector.elementAt(i));
            }
        }
    }

    public ListModel getModel() {
        return this.m_list.getModel();
    }

    public void setModified(boolean bl) {
        this.m_list.setModified(bl);
    }

    public boolean isModified() {
        return this.m_list.isModified();
    }

    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    public Insets getInsets(Insets insets) {
        return new Insets(0, 0, 0, 0);
    }

    protected abstract void addButtonAction();

    protected abstract void editButtonAction();

    protected void removeButtonAction() {
        Debug.trace("OEList.removeButtonAction");
        int[] nArray = this.m_list.getSelectedIndices();
        for (int i = nArray.length; i > 0; --i) {
            this.m_listModel.removeElementAt(nArray[i - 1]);
        }
        this.setButtonsEnabled(false);
    }

    public boolean addElement(Object object) {
        boolean bl = false;
        if (this.m_listModel.contains(object)) {
            NMsgBox nMsgBox = new NMsgBox((Component)this, Resource.get("SelectContext"), Resource.get("ContextAlreadyThere"), 1);
            nMsgBox.launch();
        } else {
            this.m_listModel.addElement(object);
            bl = true;
        }
        Debug.trace("OEList.addElement returning " + bl);
        return bl;
    }

    public void requestFocus() {
        if (this.m_listModel.getSize() > 0) {
            this.m_list.requestFocus();
        } else {
            this.m_btnAdd.requestFocus();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int[] nArray;
        Object object = actionEvent.getSource();
        if (object == this.m_btnAdd) {
            this.addButtonAction();
        } else if (object == this.m_btnEdit) {
            this.editButtonAction();
        } else if (object == this.m_btnRemove) {
            this.removeButtonAction();
        } else if (object == this.m_btnUp) {
            int[] nArray2 = this.m_list.getSelectedIndices();
            if (nArray2.length > 0) {
                if (nArray2[0] == 0) {
                    return;
                }
                int n = 0;
                while (n <= nArray2.length - 1) {
                    this.m_listModel.insertElementAt(this.m_listModel.remove(nArray2[n]), nArray2[n] - 1);
                    int n2 = n++;
                    nArray2[n2] = nArray2[n2] - 1;
                }
                this.m_list.setSelectedIndices(nArray2);
            }
        } else if (object == this.m_btnDown && (nArray = this.m_list.getSelectedIndices()).length > 0) {
            if (nArray[nArray.length - 1] == this.m_listModel.getSize() - 1) {
                return;
            }
            int n = nArray.length - 1;
            while (n >= 0) {
                this.m_listModel.insertElementAt(this.m_listModel.remove(nArray[n]), nArray[n] + 1);
                int n3 = n--;
                nArray[n3] = nArray[n3] + 1;
            }
            this.m_list.setSelectedIndices(nArray);
        }
    }

    protected void setButtonsEnabled(boolean bl) {
        this.m_btnEdit.setEnabled(bl);
        this.m_btnRemove.setEnabled(bl);
        if (this.m_bSequencing) {
            this.m_btnUp.setEnabled(bl);
            this.m_btnDown.setEnabled(bl);
        }
        if (this.m_vAdditionalButtons != null) {
            for (int i = 0; i < this.m_vAdditionalButtons.size(); ++i) {
                JButton jButton = (JButton)this.m_vAdditionalButtons.elementAt(i);
                jButton.setEnabled(bl);
            }
        }
    }

    public void setEnabled(boolean bl) {
        this.m_list.setEnabled(bl);
        this.m_btnAdd.setEnabled(bl);
        this.setButtonsEnabled(bl);
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 127) {
            this.removeButtonAction();
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.m_list.isSelectionEmpty()) {
            this.setButtonsEnabled(false);
        } else {
            this.setButtonsEnabled(true);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() >= 2 && !this.m_list.isSelectionEmpty()) {
            this.m_btnEdit.doClick();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void addListDataListener(ListDataListener listDataListener) {
        this.m_list.addListDataListener(listDataListener);
    }

    public void removeListDataListener(ListDataListener listDataListener) {
        this.m_list.removeListDataListener(listDataListener);
    }
}

