/*
 * Decompiled with CFR 0.152.
 */
package com.novell.netmessenger.admin.common;

import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.application.console.snapin.DefaultObjectEntryCollection;
import com.novell.application.console.snapin.MainShell;
import com.novell.application.console.snapin.NamespaceSnapin;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectEntryCollection;
import com.novell.application.console.snapin.ObjectType;
import com.novell.application.console.snapin.Shell;
import com.novell.application.console.util.objectentryselector.ObjectEntrySelector;
import com.novell.netmessenger.admin.common.StaticUIUtilities;
import com.novell.netmessenger.admin.swingext.JTextFieldExt;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class OESTextField
extends JPanel
implements ActionListener {
    private JTextFieldExt m_tfOES;
    private JButton m_btnOES;
    private JButton m_btnOESEdit;
    protected int m_iNameType;
    private Shell m_shell = MainShell.getInstance();
    private NamespaceSnapin m_ns;
    private ObjectEntry m_oe;
    private String[] m_saFilter;
    protected Component m_cmpParentWindow;
    public static final int BUTTON_EDIT = 1;

    public OESTextField(Component component) {
        this(component, null);
    }

    public OESTextField(Component component, ObjectEntry objectEntry) {
        this.m_oe = objectEntry;
        if (this.m_oe == null) {
            this.m_oe = this.m_shell.getTreeSelection();
        }
        this.m_ns = this.m_oe.getNamespace();
        this.m_iNameType = 1;
        this.m_cmpParentWindow = component;
        this.m_tfOES = new JTextFieldExt(30);
        this.m_btnOES = new JButton(StaticUIUtilities.getCommonIcon("browser.gif"));
        this.m_btnOESEdit = new JButton(StaticUIUtilities.getCommonIcon("oes.gif"));
        this.layoutControls();
    }

    private void layoutControls() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = 2;
        gridBagConstraints.fill = 2;
        this.add((Component)this.m_tfOES, gridBagConstraints);
        if (this.m_shell != null && this.m_ns != null) {
            Icon icon = this.m_btnOES.getIcon();
            Dimension dimension = new Dimension(icon.getIconWidth() + 10, icon.getIconHeight() + 5);
            this.m_btnOES.setPreferredSize(dimension);
            this.m_btnOES.setMinimumSize(dimension);
            this.m_btnOESEdit.setPreferredSize(dimension);
            this.m_btnOESEdit.setMinimumSize(dimension);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets.left = 2;
            gridBagConstraints.fill = 3;
            this.add((Component)this.m_btnOES, gridBagConstraints);
            gridBagConstraints.gridx = 3;
            gridBagConstraints.insets.right = 0;
            this.add((Component)this.m_btnOESEdit, gridBagConstraints);
            this.m_btnOES.addActionListener(this);
            this.m_btnOESEdit.addActionListener(this);
        }
    }

    public void setText(String string) {
        this.m_tfOES.setText(string);
    }

    public String getText() {
        return this.m_tfOES.getText();
    }

    public void setFilter(String[] stringArray) {
        this.m_saFilter = stringArray;
    }

    public void setModified(boolean bl) {
        this.m_tfOES.setModified(bl);
    }

    public boolean isModified() {
        return this.m_tfOES.isModified();
    }

    public void setEditable(boolean bl) {
        this.m_tfOES.setEditable(bl);
    }

    public void setEnabled(boolean bl) {
        this.m_tfOES.setEnabled(bl);
        if (this.m_shell != null && this.m_ns != null) {
            this.m_btnOES.setEnabled(bl);
            this.m_btnOESEdit.setEnabled(bl);
        }
    }

    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    public Insets getInsets(Insets insets) {
        return new Insets(0, 0, 0, 0);
    }

    public void setNameType(int n) {
        if (n == 1 || n == 2) {
            this.m_iNameType = n;
        }
    }

    public void setDocument(Document document) {
        this.m_tfOES.setDocument(document);
    }

    public void requestFocus() {
        if (!this.m_tfOES.isEditable()) {
            this.m_btnOES.requestFocus();
        } else {
            this.m_tfOES.requestFocus();
        }
    }

    public void addKeyListener(KeyListener keyListener) {
        this.m_tfOES.addKeyListener(keyListener);
    }

    public void addDocumentListener(DocumentListener documentListener) {
        this.m_tfOES.addDocumentListener(documentListener);
    }

    public void removeDocumentListener(DocumentListener documentListener) {
        this.m_tfOES.removeDocumentListener(documentListener);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        Object object = actionEvent.getSource();
        if (object == this.m_btnOES) {
            String string2 = this.selectObject();
            if (string2 != null) {
                this.m_tfOES.setText(string2);
            }
        } else if (object == this.m_btnOESEdit && (string = this.m_tfOES.getText().trim()) != null && string.length() > 0) {
            try {
                ObjectEntry objectEntry = this.m_ns.getObjectEntry(string);
                this.m_shell.showDetails((ObjectEntryCollection)new DefaultObjectEntryCollection(objectEntry), false);
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    public void setVisible(int n, boolean bl) {
        if (n == 1) {
            this.m_btnOESEdit.setVisible(bl);
        }
    }

    private String selectObject() {
        ObjectType[] objectTypeArray;
        String string = null;
        ObjectEntrySelector objectEntrySelector = new ObjectEntrySelector((Frame)this.m_shell.getShellFrame(), this.m_oe.getRoot());
        if (this.m_saFilter != null) {
            objectTypeArray = new ObjectType[this.m_saFilter.length];
            for (int i = 0; i < this.m_saFilter.length; ++i) {
                objectTypeArray[i] = new ObjectType(this.m_saFilter[i], this.m_ns, false);
            }
            objectEntrySelector.setFilter("", objectTypeArray);
        }
        objectEntrySelector.setSelectionMode(0);
        objectEntrySelector.setFederationMode(1);
        objectEntrySelector.show();
        this.m_cmpParentWindow.requestFocus();
        objectTypeArray = objectEntrySelector.getSelectedObjectEntries();
        if (objectTypeArray != null && objectTypeArray.length > 0) {
            string = this.m_iNameType == 2 ? ((NDSNamespace)this.m_ns).getFullyTypedName((ObjectEntry)objectTypeArray[0]) : ((NDSNamespace)this.m_ns).getUnrootedName((ObjectEntry)objectTypeArray[0]);
        }
        return string;
    }
}

