/*
 * Decompiled with CFR 0.152.
 */
package com.novell.netmessenger.admin.common;

import com.novell.netmessenger.admin.common.Debug;
import com.novell.netmessenger.admin.common.I18NLocale;
import com.novell.netmessenger.admin.common.I18NPropertyBundle;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.MissingResourceException;

public class ResourceBase {
    private static final ResourceBase colonRes = ResourceBase.getBundle("com.novell.netmessenger.admin.common.CommonResources");
    public static final String COLON_STR = colonRes.getString("colon");
    protected I18NPropertyBundle bundle = null;

    public ResourceBase(I18NPropertyBundle i18NPropertyBundle) {
        this.bundle = i18NPropertyBundle;
        if (i18NPropertyBundle == null && Debug.trace) {
            new Throwable().printStackTrace();
            Debug.traceDlg("ResourceBase.Constructor: NULL I18NPropertyBundle passed");
        }
    }

    public static ResourceBase getBundle(String string) throws RuntimeException {
        I18NLocale i18NLocale = new I18NLocale();
        try {
            return ResourceBase.getBundle(string, i18NLocale);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Throwable throwable) {
            if (Debug.trace) {
                Debug.traceException(throwable);
            }
            throw new MissingResourceException("", "", string);
        }
    }

    public static ResourceBase getBundle(String string, I18NLocale i18NLocale) throws RuntimeException {
        return new ResourceBase(I18NPropertyBundle.getI18NPropertyBundle(string, i18NLocale));
    }

    public static ResourceBase getBundle(String string, String string2, String string3, String string4) throws RuntimeException {
        I18NLocale i18NLocale = new I18NLocale(string2, string3, string4);
        return new ResourceBase(I18NPropertyBundle.getI18NPropertyBundle(string, i18NLocale));
    }

    public Enumeration getKeys() {
        return this.bundle.propertyNames();
    }

    public String getString(String string) {
        String string2;
        Throwable throwable = null;
        if (string == null) {
            throwable = new Throwable();
            Debug.trace("ResourceBase.getString: NULL reference passed in.");
            string2 = "1-BAD STRING from Resource.getString";
        } else {
            try {
                string2 = this.bundle.getProperty(string);
                if (string2 == null) {
                    throwable = new Throwable();
                    Debug.trace("ResourceBase.getString: NULL returned from getProperty().");
                    string2 = "2-BAD STRING from Resource.getString";
                }
            }
            catch (MissingResourceException missingResourceException) {
                throwable = missingResourceException;
                Debug.trace("ResourceBase.getString: mrex= " + missingResourceException);
                string2 = "3-BAD STRING from Resource.getString";
            }
        }
        if (throwable != null) {
            Debug.traceException(throwable);
            Debug.traceDlg("No resource string for reference [" + string + "]\n" + string2);
        }
        return string2;
    }

    public String getStringWithColon(String string) {
        String string2 = this.getString(string);
        if (!string2.endsWith(COLON_STR)) {
            string2 = string2 + COLON_STR;
        }
        return string2;
    }

    public String getStringWithoutColon(String string) {
        String string2 = this.getString(string);
        if (string2.endsWith(COLON_STR)) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    public String getStringInFormat(String string, String string2, String string3, String string4) {
        String string5 = this.getString(string);
        if (string5 == null) {
            new Throwable().printStackTrace();
            Debug.traceDlg("ResourceBase.getStringInFormat: NULL base - using YYYYY");
            string5 = "YYYYY {0}";
        }
        Object[] objectArray = new Object[]{string2, string3, string4};
        return MessageFormat.format(string5, objectArray);
    }

    public String getStringInFormat(String string, String string2) {
        return this.getStringInFormat(string, string2, null, null);
    }
}

