/*
 * Decompiled with CFR 0.152.
 */
package com.novell.netmessenger.admin.common;

import BlowfishJ.BlowfishECB;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.application.console.snapin.MainShell;
import com.novell.application.console.snapin.NamespaceSnapin;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectType;
import com.novell.application.console.snapin.Shell;
import com.novell.application.console.util.objectentryselector.ObjectEntrySelector;
import com.novell.netmessenger.admin.common.Debug;
import com.novell.netmessenger.admin.common.NDSNegotiator;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Vector;
import javax.swing.Box;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class StaticUtilities {
    public static final int I_PLATFORM_TYPE_WINDOWS = 1;
    public static final int I_PLATFORM_TYPE_NETWARE = 2;
    public static final int I_PLATFORM_TYPE_LINUX = 3;
    private static final String HELP_SET = "novellmessenger";
    public static final char C_DOT = '.';
    public static final char C_COMMA = ',';
    public static final char C_BACKSLASH = '\\';
    public static final char C_EQUAL_TO = '=';
    public static final char C_SEMI_COLON = ';';
    public static final int UNROOTED_NAME = 1;
    public static final int FULLY_TYPED_NAME = 2;
    public static final int SINGLE_SELECTION = 1;
    public static final int MULTIPLE_SELECTION = 2;
    public static final String S_MESSENGER_DATE_FORMAT = "dd/MM/yyyy HH:mm";
    public static final String[] SA_OBJECT_TYPE_HOST = new String[]{"nnmHost"};
    public static final String[] SA_OBJECT_TYPE_CHAT = new String[]{"nnmChat"};
    public static final String[] SA_OBJECT_TYPE_USER = new String[]{"User"};
    public static final String[] SA_OBJECT_TYPE_POLICY = new String[]{"nnmPolicy"};
    public static final String[] SA_OBJECT_TYPE_SYSTEM = new String[]{"nnmSystem"};
    public static final String[] SA_OBJECT_TYPE_CONTEXT = new String[]{"Country", "Locality", "Organization", "Organizational Unit", "domain"};
    public static final String[] SA_OBJECT_TYPE_LDAP_PROFILE = new String[]{"nnmLDAPProfile"};
    public static final String[] SA_OBJECT_TYPE_SCOPE_PROFILE = new String[]{"nnmScopeProfile"};
    public static final String[] SA_OBJECT_TYPE_ARCHIVE_AGENT = new String[]{"nnmArchiveAgent"};
    public static final String[] SA_OBJECT_TYPE_SESSION_AGENT = new String[]{"nnmSessionAgent"};
    public static final String S_NOVELL_MESSENGER_SYSTEM_DN = "Novell.Messenger.System.DN";
    public static final byte[] BA_SHARED_KEY = new byte[]{8, 92, 102, -52, -17, -122, -104};
    public static final String S_CHARACTER_ENCODING = "ISO-8859-1";
    public static final String NOVELL_MESSENGER_VERSION = "1.0";
    public static final String NOVELL_MESSENGER_PACAKGE_NAME = "com.novell.netmessenger";
    public static final int PORT_MAX_VALUE = 65535;

    public static String DNToLDAPFormat(String string) {
        if (string == null) {
            return null;
        }
        if (string.trim().length() == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        boolean bl = false;
        boolean bl2 = false;
        for (int i = stringBuffer.length() - 1; i >= 0; --i) {
            if (stringBuffer.charAt(i) == '=') {
                bl = true;
                continue;
            }
            if (stringBuffer.charAt(i) == '.') {
                if (bl) {
                    stringBuffer.setCharAt(i, ',');
                    bl = false;
                    continue;
                }
                bl2 = true;
                continue;
            }
            if (stringBuffer.charAt(i) != '\\' || !bl2) continue;
            stringBuffer = stringBuffer.deleteCharAt(i);
            bl2 = false;
        }
        return stringBuffer.toString();
    }

    public static String LDAPToDNFormat(String string) {
        Debug.trace("StaticUtilities.LDAPToDNFormat: sLDAP= " + string);
        if (string != null && string.trim().length() > 0) {
            StringBuffer stringBuffer = new StringBuffer(string);
            for (int i = stringBuffer.length() - 1; i >= 0; --i) {
                if (stringBuffer.charAt(i) == ',') {
                    stringBuffer.setCharAt(i, '.');
                    continue;
                }
                if (stringBuffer.charAt(i) != '.') continue;
                stringBuffer = stringBuffer.insert(i, '\\');
            }
            return stringBuffer.toString();
        }
        return null;
    }

    public static Calendar getCalendar(String string) throws Exception {
        Calendar calendar = null;
        if (string != null) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(S_MESSENGER_DATE_FORMAT);
            Date date = simpleDateFormat.parse(string);
            calendar = Calendar.getInstance();
            calendar.setTime(date);
        }
        return calendar;
    }

    public static Calendar getCalendar(long l) throws Exception {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(l));
        return calendar;
    }

    public static String toSimpleDateFormat(Calendar calendar) {
        String string = null;
        if (calendar != null) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(S_MESSENGER_DATE_FORMAT);
            string = simpleDateFormat.format(calendar.getTime());
        }
        return string;
    }

    public static String toLocaleFriendlyFormat(Calendar calendar) {
        String string = null;
        if (calendar != null) {
            DateFormat dateFormat = DateFormat.getDateTimeInstance(1, 1, Locale.getDefault());
            string = dateFormat.format(calendar.getTime());
        }
        return string;
    }

    public static String encryptEncode(String string) throws Exception {
        BlowfishECB blowfishECB;
        if (string.trim().length() == 0) {
            throw new Exception("Empty string was passed for encryption/encoding");
        }
        try {
            blowfishECB = new BlowfishECB(BA_SHARED_KEY);
        }
        catch (Exception exception) {
            return null;
        }
        byte[] byArray = string.getBytes(S_CHARACTER_ENCODING);
        int n = 8 - byArray.length % 8;
        byte[] byArray2 = new byte[byArray.length + n];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        byte[] byArray3 = new byte[byArray2.length];
        blowfishECB.encrypt(byArray2, byArray3);
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        String string2 = bASE64Encoder.encodeBuffer(byArray3).trim();
        return string2;
    }

    public static String decodeDecrypt(String string) throws Exception {
        int n;
        BlowfishECB blowfishECB;
        try {
            blowfishECB = new BlowfishECB(BA_SHARED_KEY);
        }
        catch (Exception exception) {
            return null;
        }
        BASE64Decoder bASE64Decoder = new BASE64Decoder();
        byte[] byArray = bASE64Decoder.decodeBuffer(string);
        byte[] byArray2 = new byte[byArray.length];
        blowfishECB.decrypt(byArray, byArray2);
        byte[] byArray3 = new byte[byArray.length];
        for (n = 0; n < byArray2.length && byArray2[n] != 0; ++n) {
            byArray3[n] = byArray2[n];
        }
        String string2 = new String(byArray3, 0, n, S_CHARACTER_ENCODING);
        return string2;
    }

    public static String toFormattedString(Vector vector) {
        if (vector == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            stringBuffer = stringBuffer.append(vector.elementAt(i));
            if (i == n - 1) continue;
            stringBuffer = stringBuffer.append(';');
        }
        return stringBuffer.toString();
    }

    public static Component getBoxVerticalSpacing(int n) {
        Component component = Box.createRigidArea(new Dimension(2, n));
        return component;
    }

    public static Component getBoxHorizontalSpacing(int n) {
        Component component = Box.createRigidArea(new Dimension(n, 2));
        return component;
    }

    public static int parseInt2(String string, int n) {
        int n2 = n;
        if (string == null) {
            return n;
        }
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            Debug.trace("StaticUtilities.parseInt2: BOGUS value= " + string);
        }
        return n2;
    }

    public String[] getObjectDNs() {
        return this.getObjectDNs(null, -1, -1);
    }

    public String[] getObjectDNs(String[] stringArray) {
        return this.getObjectDNs(stringArray, -1, -1);
    }

    public String[] getObjectDNs(String[] stringArray, int n) {
        return this.getObjectDNs(stringArray, n, -1);
    }

    public String[] getObjectDNs(String[] stringArray, int n, int n2) {
        int n3;
        ObjectType[] objectTypeArray;
        String[] stringArray2 = new String[]{};
        Shell shell = MainShell.getInstance();
        NamespaceSnapin namespaceSnapin = shell.getTreeSelection().getNamespace();
        ObjectEntrySelector objectEntrySelector = new ObjectEntrySelector((Frame)shell.getShellFrame(), shell.getTreeSelection().getRoot());
        if (stringArray != null) {
            objectTypeArray = new ObjectType[stringArray.length];
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                objectTypeArray[n3] = new ObjectType(stringArray[n3], namespaceSnapin, false);
            }
            objectEntrySelector.setFilter("", objectTypeArray);
        }
        n2 = n2 == 1 ? 0 : 2;
        objectEntrySelector.setSelectionMode(n2);
        objectEntrySelector.setFederationMode(1);
        objectEntrySelector.show();
        objectTypeArray = objectEntrySelector.getSelectedObjectEntries();
        if (objectTypeArray != null && objectTypeArray.length > 0) {
            stringArray2 = new String[objectTypeArray.length];
            for (n3 = 0; n3 < objectTypeArray.length; ++n3) {
                stringArray2[n3] = n == 2 ? ((NDSNamespace)namespaceSnapin).getFullyTypedName((ObjectEntry)objectTypeArray[0]) : ((NDSNamespace)namespaceSnapin).getUnrootedName((ObjectEntry)objectTypeArray[0]);
            }
        }
        return stringArray2;
    }

    public static String nameFromOE(ObjectEntry objectEntry) {
        String string;
        NSObject nSObject;
        String string2 = objectEntry.getFullName();
        NDSNamespace nDSNamespace = (NDSNamespace)objectEntry.getNamespace();
        NDSNegotiator nDSNegotiator = new NDSNegotiator();
        try {
            nSObject = nDSNegotiator.getNSObject(nDSNamespace, string2);
        }
        catch (Exception exception) {
            System.out.println("nameFromDN: exception on " + string2);
            System.out.println("nameFromDN: ex= " + exception);
            return null;
        }
        Vector vector = nDSNegotiator.getMultiValuedAttribute(nSObject, "Full Name");
        if (vector != null && (string = (String)vector.elementAt(0)) != null && string.length() > 0) {
            return string;
        }
        vector = nDSNegotiator.getMultiValuedAttribute(nSObject, "CN");
        if (vector != null && (string = (String)vector.elementAt(0)) != null && string.length() > 0) {
            return string;
        }
        return string2;
    }

    public static void showHelp(String string) {
        StaticUtilities.showHelp(string, null);
    }

    public static void showHelp(String string, Window window) {
        Shell shell = MainShell.getInstance();
        if (window == null) {
            window = shell.getShellFrame();
        }
        Debug.trace("StaticUtilities.showHelp: " + string);
        if (Debug.trace && string == null) {
            Debug.traceDlg("StaticUtilities.showHelp: HELP DEFINE NEEDED HERE");
            new Throwable().printStackTrace();
        }
        shell.launchHelp(HELP_SET, string, window);
    }

    public static int getPlatform() {
        return 3;
    }
}

