/*
 * Decompiled with CFR 0.152.
 */
package com.novell.netmessenger.admin.common;

import com.novell.netmessenger.admin.common.IPComponent;
import com.novell.netmessenger.admin.common.Resource;
import com.novell.netmessenger.admin.swingext.JCheckBoxExt;
import com.novell.netmessenger.admin.swingext.JRadioButtonExt;
import com.novell.netmessenger.admin.swingext.JTextFieldExt;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class TCPIPPanel
extends JPanel
implements ItemListener {
    private JRadioButtonExt m_rbIP = new JRadioButtonExt(Resource.get("AddressLabelIP"));
    private JRadioButtonExt m_rbDNS = new JRadioButtonExt(Resource.get("AddressLabelDNS"));
    private JTextFieldExt m_tfDNS;
    private IPComponent m_ipIP;
    private JCheckBoxExt m_cbIPAddressBind;

    public TCPIPPanel(String string, boolean bl) {
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_rbIP);
        buttonGroup.add(this.m_rbDNS);
        this.m_rbIP.addItemListener(this);
        this.m_rbDNS.addItemListener(this);
        this.m_ipIP = new IPComponent();
        this.m_tfDNS = new JTextFieldExt(new PlainDocument(), "", 30);
        this.m_cbIPAddressBind = new JCheckBoxExt(Resource.get("AddressBind"));
        this.setText(string);
        this.setAddressBinded(bl);
        this.layoutControls();
        this.showBorder(true);
    }

    protected void layoutControls() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.setLayout(new GridBagLayout());
        this.setGBC(gridBagConstraints, 1, 1, 1, 1, 0, 0.3, 0.0, 18);
        this.add((Component)this.m_rbIP, gridBagConstraints);
        this.setGBC(gridBagConstraints, 2, 1, 1, 1, 0, 0.7, 0.0, 18);
        this.add((Component)this.m_ipIP, gridBagConstraints);
        this.setGBC(gridBagConstraints, 1, 2, 1, 1, 0, 0.3, 0.0, 18);
        this.add((Component)this.m_rbDNS, gridBagConstraints);
        this.setGBC(gridBagConstraints, 2, 2, 1, 1, 2, 0.7, 0.0, 18);
        this.add((Component)this.m_tfDNS, gridBagConstraints);
        this.setGBC(gridBagConstraints, 2, 3, 1, 1, 0, 0.7, 0.0, 18);
        this.add((Component)this.m_cbIPAddressBind, gridBagConstraints);
    }

    protected void setGBC(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, double d, double d2, int n6) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.fill = n5;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
        gridBagConstraints.anchor = n6;
    }

    public void setText(String string) {
        if (string != null) {
            if (this.m_ipIP.setText(string)) {
                this.m_rbIP.doClick();
            } else {
                this.m_rbDNS.doClick();
                this.m_tfDNS.setText(string);
            }
        } else {
            this.m_rbIP.doClick();
        }
    }

    public String getText() {
        String string;
        if (this.m_rbDNS.isSelected()) {
            string = this.m_tfDNS.getText();
            if (string == null || string.length() == 0) {
                string = this.m_ipIP.getText();
            }
        } else {
            string = this.m_ipIP.getText();
            if (string == null || string.length() == 0) {
                string = this.m_tfDNS.getText();
            }
        }
        return string;
    }

    public void showAddressBind(boolean bl) {
        this.m_cbIPAddressBind.setVisible(bl);
    }

    public void showBorder(boolean bl) {
        if (bl) {
            this.setBorder(new TitledBorder(Resource.get("AddressPanelTitle")));
        } else {
            this.setBorder(null);
        }
    }

    public void addDocumentListener(DocumentListener documentListener) {
        this.m_ipIP.addDocumentListener(documentListener);
        this.m_tfDNS.addDocumentListener(documentListener);
    }

    public void removeDocumentListener(DocumentListener documentListener) {
        this.m_ipIP.removeDocumentListener(documentListener);
        this.m_tfDNS.removeDocumentListener(documentListener);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.m_rbIP.isSelected()) {
            this.m_ipIP.setEnabled(true);
            this.m_tfDNS.setEnabled(false);
            this.m_ipIP.requestFocus();
        } else {
            this.m_ipIP.setEnabled(false);
            this.m_tfDNS.setEnabled(true);
            this.m_tfDNS.requestFocus();
        }
    }

    public boolean isModified() {
        return this.m_ipIP.isModified() || this.m_tfDNS.isModified() || this.m_cbIPAddressBind.isModified();
    }

    public void setAddressBinded(boolean bl) {
        this.m_cbIPAddressBind.setSelected(bl);
    }

    public boolean isAddressBinded() {
        return this.m_cbIPAddressBind.isSelected();
    }

    public void addItemListener(ItemListener itemListener) {
        this.m_cbIPAddressBind.addItemListener(itemListener);
    }

    public void removeItemListener(ItemListener itemListener) {
        this.m_cbIPAddressBind.removeItemListener(itemListener);
    }

    public void requestFocus() {
        if (this.m_rbIP.isSelected()) {
            this.m_ipIP.requestFocus();
        } else {
            this.m_tfDNS.requestFocus();
        }
    }

    private class PlainDocumentExt
    extends PlainDocument {
        private PlainDocumentExt() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            for (int i = 0; i < string.length(); ++i) {
                if (Character.isLetterOrDigit(string.charAt(i)) || string.charAt(i) == '.') continue;
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            super.insertString(n, string.trim(), attributeSet);
        }
    }
}

