/*
 * Decompiled with CFR 0.152.
 */
package com.novell.netmessenger.admin.host;

import com.novell.admin.ns.NSObject;
import com.novell.netmessenger.admin.common.NDSNegotiator;

public class HostNSObject {
    public static final int I_HOST_NAME = 0;
    public static final int I_HOST_SCOPE_PROFILE = 1;
    private static final long I_MASK_NAME = 1L;
    private static final long I_MASK_SCOPE_PROFILE = 2L;
    private long m_iDirtyBits = 0L;
    public static final String[] SA_HOST_ATTRIBUTES = new String[]{"nnmHostName", "nnmScopeProfileDN"};
    private static final long[] LA_MASK_ATTRIBUTES = new long[]{1L, 2L};
    private String m_sHostName;
    private String m_sScopeProfile;

    public void setHostName(String string) {
        this.m_sHostName = string;
        this.m_iDirtyBits |= 1L;
    }

    public String getHostName() {
        return this.m_sHostName;
    }

    public void setScopeProfile(String string) {
        this.m_sScopeProfile = string;
        this.m_iDirtyBits |= 2L;
    }

    public String getScopeProfile() {
        return this.m_sScopeProfile;
    }

    public void setStringAttribute(int n, String string) {
        switch (n) {
            case 0: {
                this.m_sHostName = string;
                break;
            }
            case 1: {
                this.m_sScopeProfile = string;
                break;
            }
            default: {
                return;
            }
        }
        this.m_iDirtyBits |= LA_MASK_ATTRIBUTES[n];
    }

    public String getStringAttribute(int n) {
        String string;
        switch (n) {
            case 0: {
                string = this.m_sHostName;
                break;
            }
            case 1: {
                string = this.m_sScopeProfile;
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    public boolean load(NSObject nSObject) {
        NDSNegotiator nDSNegotiator = new NDSNegotiator();
        this.setHostName(nDSNegotiator.getAttribute(nSObject, SA_HOST_ATTRIBUTES[0]));
        this.setScopeProfile(nDSNegotiator.getAttribute(nSObject, SA_HOST_ATTRIBUTES[1]));
        this.m_iDirtyBits = 0L;
        return true;
    }

    public boolean save(NSObject nSObject) {
        boolean bl = false;
        NDSNegotiator nDSNegotiator = new NDSNegotiator();
        if ((this.m_iDirtyBits & 1L) > 0L) {
            nDSNegotiator.setAttribute(nSObject, SA_HOST_ATTRIBUTES[0], this.getHostName());
        }
        if ((this.m_iDirtyBits & 2L) > 0L) {
            nDSNegotiator.setAttribute(nSObject, SA_HOST_ATTRIBUTES[1], this.getScopeProfile());
        }
        this.m_iDirtyBits = 0L;
        bl = nDSNegotiator.update(nSObject);
        this.load(nSObject);
        return bl;
    }
}

