/*
 * Decompiled with CFR 0.152.
 */
package com.novell.netmessenger.admin.ldap;

import java.util.StringTokenizer;

public class LDAPConnection {
    public static final int I_DEFAULT_PORT_NOT_SECURED = 389;
    public static final int I_DEFAULT_PORT_SECURED = 636;
    private int m_iPort;
    private int m_iWeight;
    private boolean m_bSSLEnabled;
    private String m_sAddress;
    private String m_sRootCert;

    LDAPConnection(String string) throws Exception {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            this.setAddress(stringTokenizer.nextToken());
            Integer n = new Integer(stringTokenizer.nextToken());
            this.setPort(n);
            String string2 = stringTokenizer.nextToken();
            string2 = string2.equals("1") ? "true" : "false";
            Boolean bl = new Boolean(string2);
            if (bl.booleanValue()) {
                this.setSSL(bl, stringTokenizer.nextToken());
            } else {
                this.setSSL(bl, null);
            }
            n = new Integer(stringTokenizer.nextToken());
            this.setWeight(n);
        }
    }

    LDAPConnection(String string, int n, boolean bl, String string2, int n2) throws Exception {
        this.setAddress(string);
        this.setPort(n);
        this.setSSL(bl, string2);
        this.setWeight(n2);
    }

    public void setAddress(String string) throws Exception {
        if (string == null || string.trim().length() == 0) {
            throw new Exception("Invalid LDAP Connection Address");
        }
        this.m_sAddress = string.trim();
    }

    public String getAddress() {
        return this.m_sAddress;
    }

    public void setPort(int n) {
        this.m_iPort = n;
    }

    public int getPort() {
        return this.m_iPort;
    }

    public void setSSL(boolean bl, String string) throws Exception {
        if (bl && string == null) {
            throw new Exception("Security Certificate is necesary when SSL is enabled");
        }
        this.m_bSSLEnabled = bl;
        this.m_sRootCert = string;
    }

    public boolean isSSLEnabled() {
        return this.m_bSSLEnabled;
    }

    public String getRootCert() {
        return this.m_sRootCert;
    }

    public void setWeight(int n) {
        this.m_iWeight = n;
    }

    public int getWeight() {
        return this.m_iWeight;
    }

    public String toString() {
        return this.m_sAddress;
    }

    public String getText() {
        String string = null;
        if (this.m_sAddress != null) {
            String string2;
            String string3;
            int n;
            if (this.m_bSSLEnabled) {
                n = this.m_iPort == 0 ? 636 : this.m_iPort;
                string3 = "1";
                string2 = this.m_sRootCert;
            } else {
                n = this.m_iPort == 0 ? 389 : this.m_iPort;
                string3 = "0";
                string2 = "";
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.m_sAddress + ",");
            stringBuffer.append(n + ",");
            stringBuffer.append(string3 + ",");
            stringBuffer.append(string2 + ",");
            stringBuffer.append(this.m_iWeight);
            string = stringBuffer.toString();
        }
        return string;
    }
}

