/*
 * Decompiled with CFR 0.152.
 */
package com.novell.netmessenger.admin.ldap;

import com.novell.netmessenger.admin.common.BaseDlg;
import com.novell.netmessenger.admin.common.FilePathTextField;
import com.novell.netmessenger.admin.common.NIncrementBox;
import com.novell.netmessenger.admin.common.TCPIPPanel;
import com.novell.netmessenger.admin.ldap.LDAPConnection;
import com.novell.netmessenger.admin.ldap.Resource;
import com.novell.netmessenger.admin.swingext.FileFilterExt;
import com.novell.netmessenger.admin.swingext.JCheckBoxExt;
import com.novell.netmessenger.admin.swingext.JLabelExt;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class LDAPConnectionDlg
extends BaseDlg
implements ItemListener {
    private LDAPConnection m_ldapConnection;
    private static final String[] SA_CERT_FILES_EXTENSION = new String[]{"der"};
    private JLabelExt m_labRootCert;
    private JCheckBoxExt m_cbSSLEnabled;
    private FilePathTextField m_tfRootCert;
    private NIncrementBox m_incPort;
    private NIncrementBox m_incWeight;
    private String m_sAddress;
    private TCPIPPanel m_tcpipCtrl;

    LDAPConnectionDlg(Component component, LDAPConnection lDAPConnection) {
        super((Dialog)component, Resource.get("LDAPConnectionCreateTitle"), true, "ldapprofileaddconnection");
        this.m_ldapConnection = lDAPConnection;
        this.layoutControls();
        this.setData();
    }

    public void layoutControls() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        this.m_tcpipCtrl = new TCPIPPanel(null, false);
        this.m_tcpipCtrl.showAddressBind(false);
        jPanel2.setBorder(new TitledBorder(Resource.get("LDAPConnectionSSLTitle")));
        this.m_incPort = new NIncrementBox(0, Integer.MAX_VALUE, 389);
        JLabelExt jLabelExt = new JLabelExt(Resource.get("LDAPConnectionLabelPort"), this.m_incPort);
        this.m_cbSSLEnabled = new JCheckBoxExt(Resource.get("LDAPConnectionLabelSSLEnabled"));
        this.m_cbSSLEnabled.addItemListener(this);
        this.m_tfRootCert = new FilePathTextField(this, 0);
        FileFilterExt fileFilterExt = new FileFilterExt(SA_CERT_FILES_EXTENSION);
        this.m_tfRootCert.setFileFilter(fileFilterExt);
        this.m_labRootCert = new JLabelExt(Resource.get("LDAPConnectionLabelRootCert"), this.m_tfRootCert);
        this.m_incWeight = new NIncrementBox(0, Integer.MAX_VALUE, 0);
        JLabelExt jLabelExt2 = new JLabelExt(Resource.get("LDAPConnectionLabelWeight"), this.m_incWeight);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(8, 8, 2, 8);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.m_tcpipCtrl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets.top = 8;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)jLabelExt, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)this.m_incPort, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets.top = 2;
        jPanel.add((Component)jLabelExt2, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        jPanel.add((Component)this.m_incWeight, gridBagConstraints);
        this.m_labRootCert.setEnabled(false);
        this.m_tfRootCert.setEnabled(false);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        jPanel2.add((Component)this.m_cbSSLEnabled, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.left = 20;
        jPanel2.add((Component)this.m_labRootCert, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.left = 2;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.m_tfRootCert, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets.bottom = 8;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this.getContentPane().add((Component)jPanel, "North");
        super.layoutControls();
        this.setResizable(false);
        this.pack();
    }

    private void setData() {
        if (this.m_ldapConnection != null) {
            this.m_tcpipCtrl.setText(this.m_ldapConnection.getAddress());
            this.m_incPort.setValue(this.m_ldapConnection.getPort());
            this.m_cbSSLEnabled.setSelected(this.m_ldapConnection.isSSLEnabled());
            this.m_tfRootCert.setText(this.m_ldapConnection.getRootCert());
            this.m_incWeight.setValue(this.m_ldapConnection.getWeight());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this.m_labRootCert.setEnabled(true);
            this.m_tfRootCert.setEnabled(true);
            if (this.m_incPort.getValue() == 389) {
                this.m_incPort.setValue(636);
            }
        } else {
            this.m_labRootCert.setEnabled(false);
            this.m_tfRootCert.setEnabled(false);
            if (this.m_incPort.getValue() == 636) {
                this.m_incPort.setValue(389);
            }
        }
    }

    public LDAPConnection getLDAPConnection() {
        return this.m_ldapConnection;
    }

    protected void okButtonAction() {
        String string;
        String string2 = this.m_tcpipCtrl.getText();
        Integer n = new Integer(this.m_incPort.getText());
        boolean bl = this.m_cbSSLEnabled.isSelected();
        if (bl) {
            string = this.m_tfRootCert.getText();
            if (string == null || string.trim().length() == 0) {
                return;
            }
        } else {
            string = "";
        }
        Integer n2 = new Integer(this.m_incWeight.getText());
        try {
            if (this.m_ldapConnection == null) {
                this.m_ldapConnection = new LDAPConnection(string2, n, bl, string, n2);
            } else {
                this.m_ldapConnection.setAddress(string2);
                this.m_ldapConnection.setPort(n);
                this.m_ldapConnection.setSSL(bl, string);
                this.m_ldapConnection.setWeight(n2);
            }
        }
        catch (Exception exception) {
            return;
        }
        this.dispose();
    }

    protected void cancelButtonAction() {
        this.m_ldapConnection = null;
        this.dispose();
    }

    private class PlainDocumentExt
    extends PlainDocument {
        private PlainDocumentExt() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string.indexOf(44) >= 0 || string.indexOf(32) >= 0 || string.indexOf(42) >= 0) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            super.insertString(n, string.trim(), attributeSet);
        }
    }
}

