/*
 * Decompiled with CFR 0.152.
 */
package com.novell.netmessenger.admin.ldap;

import com.novell.admin.common.snapins.AdminPageSnapin;
import com.novell.admin.ns.NSObject;
import com.novell.application.console.snapin.InitSnapinInfo;
import com.novell.netmessenger.admin.common.NIncrementBox;
import com.novell.netmessenger.admin.ldap.LDAPAdminPage;
import com.novell.netmessenger.admin.ldap.LDAPConnection;
import com.novell.netmessenger.admin.ldap.LDAPConnectionsList;
import com.novell.netmessenger.admin.ldap.Resource;
import com.novell.netmessenger.admin.swingext.JLabelExt;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class LDAPPanelConnections
extends LDAPAdminPage {
    LDAPConnectionsList m_listConnections;
    NIncrementBox m_incMaxConnections;
    NIncrementBox m_incDefaultConnections;
    NIncrementBox m_incIdleTimeout;

    public LDAPPanelConnections(InitSnapinInfo initSnapinInfo, AdminPageSnapin adminPageSnapin, NSObject nSObject) {
        super(initSnapinInfo, adminPageSnapin, nSObject);
    }

    protected void init() {
        this.m_incIdleTimeout = new NIncrementBox(0, 3600, 0);
        this.m_incMaxConnections = new NIncrementBox(0, 1000, 0);
        this.m_incDefaultConnections = new NIncrementBox(0, 100, 0);
        this.m_listConnections = new LDAPConnectionsList(this.propertyBook.getComponent());
    }

    public void layoutControls() {
        this.init();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(Resource.get("LabelConnectionSettingsPanel")));
        JLabelExt jLabelExt = new JLabelExt(Resource.get("LabelMaxConnections"), this.m_incMaxConnections);
        JLabelExt jLabelExt2 = new JLabelExt(Resource.get("LabelDefaultConnections"), this.m_incDefaultConnections);
        JLabelExt jLabelExt3 = new JLabelExt(Resource.get("LabelIdleTimeout"), this.m_incIdleTimeout);
        JLabelExt jLabelExt4 = new JLabelExt(Resource.get("LabelConnections"), this.m_listConnections);
        this.setLayout(new GridBagLayout());
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.setGBC(gridBagConstraints, 1, 1, 1, 1, 0, 0.0, 0.0);
        jPanel.add((Component)jLabelExt2, gridBagConstraints);
        this.setGBC(gridBagConstraints, 2, 1, 1, 1, 0, 1.0, 0.0);
        jPanel.add((Component)this.m_incDefaultConnections, gridBagConstraints);
        this.setGBC(gridBagConstraints, 1, 2, 1, 1, 0, 0.0, 0.0);
        jPanel.add((Component)jLabelExt3, gridBagConstraints);
        this.setGBC(gridBagConstraints, 2, 2, 1, 1, 0, 1.0, 0.0);
        jPanel.add((Component)this.m_incIdleTimeout, gridBagConstraints);
        this.setGBC(gridBagConstraints, 1, 3, 1, 1, 0, 0.0, 0.0);
        jPanel.add((Component)jLabelExt, gridBagConstraints);
        this.setGBC(gridBagConstraints, 2, 3, 1, 1, 0, 1.0, 0.0);
        jPanel.add((Component)this.m_incMaxConnections, gridBagConstraints);
        gridBagConstraints.fill = 2;
        this.setGBC(gridBagConstraints, 1, 1, 1, 1, 2, 1.0, 0.0);
        this.add(jPanel, gridBagConstraints);
        this.setGBC(gridBagConstraints, 1, 2, 1, 1, 0, 0.0, 0.0);
        this.add(jLabelExt4, gridBagConstraints);
        this.setGBC(gridBagConstraints, 1, 3, 1, 1, 1, 1.0, 1.0);
        this.add(this.m_listConnections, gridBagConstraints);
    }

    public void readData() {
        this.m_incIdleTimeout.setValue(this.m_ldapNSObject.getIdleTimeout());
        this.m_incDefaultConnections.setValue(this.m_ldapNSObject.getDefaultConnections());
        this.m_incMaxConnections.setValue(this.m_ldapNSObject.getMaxConnections());
        Vector vector = this.m_ldapNSObject.getConnections();
        if (vector != null) {
            DefaultListModel defaultListModel = (DefaultListModel)this.m_listConnections.getModel();
            for (int i = 0; i < vector.size(); ++i) {
                LDAPConnection lDAPConnection;
                try {
                    lDAPConnection = new LDAPConnection((String)vector.elementAt(i));
                }
                catch (Exception exception) {
                    continue;
                }
                defaultListModel.addElement(lDAPConnection);
            }
        }
        this.m_incIdleTimeout.addDocumentListener(this);
        this.m_incMaxConnections.addDocumentListener(this);
        this.m_incDefaultConnections.addDocumentListener(this);
        this.m_listConnections.addListDataListener(this);
    }

    public boolean saveData() {
        if (this.m_listConnections.isModified()) {
            Vector<String> vector = new Vector<String>();
            DefaultListModel defaultListModel = (DefaultListModel)this.m_listConnections.getModel();
            Enumeration enumeration = defaultListModel.elements();
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    LDAPConnection lDAPConnection = (LDAPConnection)enumeration.nextElement();
                    vector.addElement(lDAPConnection.getText());
                }
                this.m_ldapNSObject.setConnections(vector);
            }
        }
        if (this.m_incIdleTimeout.isModified()) {
            this.m_ldapNSObject.setIdleTimeout(this.m_incIdleTimeout.getValue());
        }
        if (this.m_incDefaultConnections.isModified()) {
            this.m_ldapNSObject.setDefaultConnections(this.m_incDefaultConnections.getValue());
        }
        if (this.m_incMaxConnections.isModified()) {
            this.m_ldapNSObject.setMaxConnections(this.m_incMaxConnections.getValue());
        }
        return true;
    }
}

