/*
 * Decompiled with CFR 0.152.
 */
package com.novell.netmessenger.admin.ldap;

import com.novell.admin.common.security.NSetPasswordDlg;
import com.novell.admin.common.snapins.AdminPageSnapin;
import com.novell.admin.ns.NSObject;
import com.novell.application.console.snapin.InitSnapinInfo;
import com.novell.application.console.snapin.PageSnapin;
import com.novell.netmessenger.admin.common.ContextList;
import com.novell.netmessenger.admin.common.NIncrementBox;
import com.novell.netmessenger.admin.common.OESTextField;
import com.novell.netmessenger.admin.common.StaticUtilities;
import com.novell.netmessenger.admin.ldap.LDAPAdminPage;
import com.novell.netmessenger.admin.ldap.Resource;
import com.novell.netmessenger.admin.swingext.JButtonExt;
import com.novell.netmessenger.admin.swingext.JCheckBoxExt;
import com.novell.netmessenger.admin.swingext.JComboBoxExt;
import com.novell.netmessenger.admin.swingext.JLabelExt;
import com.novell.netmessenger.admin.swingext.JTextFieldExt;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;

public class LDAPPanelGeneral
extends LDAPAdminPage
implements ActionListener {
    private OESTextField m_tfBaseDN;
    private JTextFieldExt m_tfUsername;
    private NIncrementBox m_incQueryMaxResults;
    private NIncrementBox m_incQueryTimeout;
    private JButtonExt m_btnPassword;
    private JCheckBoxExt m_cbReferral;
    private JComboBoxExt m_cmbBaseScope;
    private ContextList m_listAdditionalDNs;
    private Vector vBaseScope;
    private String m_sPassword;

    public LDAPPanelGeneral(InitSnapinInfo initSnapinInfo, AdminPageSnapin adminPageSnapin, NSObject nSObject) {
        super(initSnapinInfo, adminPageSnapin, nSObject);
    }

    protected void init() {
        this.vBaseScope = new Vector();
        this.vBaseScope.addElement(Resource.get("BaseScopeOption0"));
        this.vBaseScope.addElement(Resource.get("BaseScopeOption1"));
        this.vBaseScope.addElement(Resource.get("BaseScopeOption2"));
        this.m_tfBaseDN = new OESTextField(this.propertyBook.getComponent(), this.nsObj.getObjectEntry());
        this.m_tfBaseDN.setNameType(2);
        this.m_tfBaseDN.setFilter(StaticUtilities.SA_OBJECT_TYPE_CONTEXT);
        this.m_cmbBaseScope = new JComboBoxExt(this.vBaseScope);
        this.m_cmbBaseScope.setLightWeightPopupEnabled(false);
        this.m_listAdditionalDNs = new ContextList(this.propertyBook.getComponent(), true);
        this.m_listAdditionalDNs.setNameType(2);
        this.m_cbReferral = new JCheckBoxExt(Resource.get("LabelReferral"));
        this.m_tfUsername = new JTextFieldExt(25);
        this.m_btnPassword = new JButtonExt(Resource.get("LabelPasswordButton"));
        this.m_incQueryTimeout = new NIncrementBox(0, 30, 0);
        this.m_incQueryMaxResults = new NIncrementBox(0, 1000, 0);
    }

    public void layoutControls() {
        this.init();
        JPanelExtInner jPanelExtInner = new JPanelExtInner(new GridBagLayout());
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        JPanel jPanel = this.createDNPanel();
        this.setGBC(gridBagConstraints, 1, 1, 1, 1, 2, 1.0, 0.0);
        jPanelExtInner.add((Component)jPanel, gridBagConstraints);
        JPanel jPanel2 = this.createQueryPanel();
        this.setGBC(gridBagConstraints, 1, 2, 1, 1, 2, 1.0, 0.0);
        jPanelExtInner.add((Component)jPanel2, gridBagConstraints);
        JPanel jPanel3 = this.createProxyPanel();
        this.setGBC(gridBagConstraints, 1, 3, 1, 1, 2, 1.0, 0.0);
        jPanelExtInner.add((Component)jPanel3, gridBagConstraints);
        JScrollPane jScrollPane = new JScrollPane(jPanelExtInner, 20, 30);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.add(jScrollPane, gridBagConstraints);
    }

    private JPanel createDNPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabelExt jLabelExt = new JLabelExt(Resource.get("LabelBaseDN"), this.m_tfBaseDN);
        JLabelExt jLabelExt2 = new JLabelExt(Resource.get("LabelBaseScope"), this.m_cmbBaseScope);
        JLabelExt jLabelExt3 = new JLabelExt(Resource.get("LabelAdditionalDN"), this.m_listAdditionalDNs);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(Resource.get("PanelDNs")));
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.setGBC(gridBagConstraints, 1, 1, 1, 1, 0, 0.0, 0.0);
        jPanel.add((Component)jLabelExt, gridBagConstraints);
        gridBagConstraints.insets.left = 20;
        this.setGBC(gridBagConstraints, 2, 1, 1, 1, 2, 1.0, 0.0);
        jPanel.add((Component)this.m_tfBaseDN, gridBagConstraints);
        gridBagConstraints.insets.left = 2;
        this.setGBC(gridBagConstraints, 1, 2, 1, 1, 0, 0.0, 0.0);
        jPanel.add((Component)jLabelExt2, gridBagConstraints);
        gridBagConstraints.insets.left = 20;
        this.setGBC(gridBagConstraints, 2, 2, 1, 1, 0, 0.0, 0.0);
        jPanel.add((Component)this.m_cmbBaseScope, gridBagConstraints);
        gridBagConstraints.insets.left = 2;
        this.setGBC(gridBagConstraints, 1, 3, 1, 1, 0, 0.0, 0.0);
        jPanel.add((Component)jLabelExt3, gridBagConstraints);
        gridBagConstraints.insets.left = 20;
        this.setGBC(gridBagConstraints, 2, 3, 2, 1, 1, 1.0, 0.0);
        jPanel.add((Component)this.m_listAdditionalDNs, gridBagConstraints);
        gridBagConstraints.insets.left = 20;
        this.setGBC(gridBagConstraints, 2, 7, 0, 1, 0, 0.0, 0.0);
        jPanel.add((Component)this.m_cbReferral, gridBagConstraints);
        return jPanel;
    }

    private JPanel createProxyPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabelExt jLabelExt = new JLabelExt(Resource.get("LabelUsername"), this.m_tfUsername);
        JLabelExt jLabelExt2 = new JLabelExt(Resource.get("LabelPassword"));
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(Resource.get("PanelProxySettings")));
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.setGBC(gridBagConstraints, 1, 1, 1, 1, 0, 0.0, 0.0);
        jPanel.add((Component)jLabelExt, gridBagConstraints);
        gridBagConstraints.insets.left = 20;
        this.setGBC(gridBagConstraints, 2, 1, 1, 1, 2, 1.0, 0.0);
        jPanel.add((Component)this.m_tfUsername, gridBagConstraints);
        gridBagConstraints.insets.left = 2;
        this.setGBC(gridBagConstraints, 3, 1, 1, 1, 0, 0.0, 0.0);
        jPanel.add((Component)this.m_btnPassword, gridBagConstraints);
        return jPanel;
    }

    private JPanel createQueryPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabelExt jLabelExt = new JLabelExt(Resource.get("LabelQueryMaxResults"), this.m_incQueryMaxResults);
        JLabelExt jLabelExt2 = new JLabelExt(Resource.get("LabelQueryTimeout"), this.m_incQueryTimeout);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(Resource.get("PanelQuerySettings")));
        this.setGBC(gridBagConstraints, 1, 1, 1, 1, 0, 0.0, 0.0);
        jPanel.add((Component)jLabelExt, gridBagConstraints);
        gridBagConstraints.insets.left = 20;
        this.setGBC(gridBagConstraints, 2, 1, 1, 1, 0, 1.0, 0.0);
        jPanel.add((Component)this.m_incQueryMaxResults, gridBagConstraints);
        gridBagConstraints.insets.left = 2;
        this.setGBC(gridBagConstraints, 1, 2, 1, 1, 0, 0.0, 0.0);
        jPanel.add((Component)jLabelExt2, gridBagConstraints);
        gridBagConstraints.insets.left = 20;
        this.setGBC(gridBagConstraints, 2, 2, 1, 1, 0, 1.0, 0.0);
        jPanel.add((Component)this.m_incQueryTimeout, gridBagConstraints);
        return jPanel;
    }

    public void readData() {
        StringTokenizer stringTokenizer;
        String string;
        this.m_tfBaseDN.setText(this.m_ldapNSObject.getBaseDN());
        this.m_cmbBaseScope.setSelectedIndex(this.m_ldapNSObject.getBaseScope());
        String string2 = this.m_ldapNSObject.getProxy();
        try {
            string = StaticUtilities.decodeDecrypt(string2);
        }
        catch (Exception exception) {
            string = null;
        }
        if (string != null && (stringTokenizer = new StringTokenizer(string, ":")).countTokens() == 2) {
            this.m_tfUsername.setText(stringTokenizer.nextToken());
            this.m_sPassword = stringTokenizer.nextToken();
        }
        this.m_cbReferral.setSelected(this.m_ldapNSObject.getReferral());
        this.m_incQueryMaxResults.setValue(this.m_ldapNSObject.getQueryMaxResults());
        this.m_incQueryTimeout.setValue(this.m_ldapNSObject.getQueryTimeout());
        Vector vector = this.m_ldapNSObject.getAdditionalDNs();
        if (vector != null) {
            int n;
            DefaultListModel defaultListModel = (DefaultListModel)this.m_listAdditionalDNs.getModel();
            String[] stringArray = new String[vector.size()];
            for (n = 0; n < vector.size(); ++n) {
                StringTokenizer stringTokenizer2 = new StringTokenizer((String)vector.elementAt(n), ":");
                if (stringTokenizer2.countTokens() != 2) continue;
                try {
                    int n2 = Integer.parseInt(stringTokenizer2.nextToken());
                    stringArray[n2 - 1] = stringTokenizer2.nextToken();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            for (n = 0; n < vector.size(); ++n) {
                defaultListModel.addElement(stringArray[n]);
            }
        }
        this.m_listAdditionalDNs.addListDataListener(this);
        this.m_tfBaseDN.addDocumentListener(this);
        this.m_tfUsername.addDocumentListener(this);
        this.m_btnPassword.addActionListener(this);
        this.m_cbReferral.addItemListener(this);
        this.m_cmbBaseScope.addItemListener(this);
        this.m_incQueryTimeout.addDocumentListener(this);
        this.m_incQueryMaxResults.addDocumentListener(this);
    }

    public boolean saveData() {
        Object object;
        Object object2;
        Enumeration enumeration;
        String string;
        if (this.m_tfBaseDN.isModified()) {
            this.m_ldapNSObject.setBaseDN(this.m_tfBaseDN.getText().trim());
        }
        if (this.m_tfUsername.isModified()) {
            string = null;
            enumeration = this.m_tfUsername.getText().trim();
            if (((String)((Object)enumeration)).length() != 0) {
                object2 = this.m_sPassword == null ? "" : this.m_sPassword;
                object = (String)((Object)enumeration) + ":" + (String)object2;
                try {
                    string = StaticUtilities.encryptEncode((String)object);
                }
                catch (Exception exception) {
                    string = null;
                }
            }
            this.m_ldapNSObject.setProxy(string);
        }
        if (this.m_listAdditionalDNs.isModified()) {
            object = new Vector();
            object2 = (DefaultListModel)this.m_listAdditionalDNs.getModel();
            enumeration = ((DefaultListModel)object2).elements();
            if (enumeration != null) {
                int n = 1;
                while (enumeration.hasMoreElements()) {
                    string = (String)enumeration.nextElement();
                    String string2 = String.valueOf(n) + ":" + string;
                    ((Vector)object).addElement(string2);
                    ++n;
                }
                this.m_ldapNSObject.setAdditionalDNs((Vector)object);
            }
        }
        if (this.m_cbReferral.isModified()) {
            this.m_ldapNSObject.setReferral(this.m_cbReferral.isSelected());
        }
        if (this.m_cmbBaseScope.isModified()) {
            this.m_ldapNSObject.setBaseScope(this.m_cmbBaseScope.getSelectedIndex());
        }
        if (this.m_incQueryMaxResults.isModified()) {
            this.m_ldapNSObject.setQueryMaxResults(this.m_incQueryMaxResults.getValue());
        }
        if (this.m_incQueryTimeout.isModified()) {
            this.m_ldapNSObject.setQueryTimeout(this.m_incQueryTimeout.getValue());
        }
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.m_btnPassword)) {
            NSetPasswordDlg nSetPasswordDlg = new NSetPasswordDlg(this.shell);
            if (nSetPasswordDlg.launch() == 1) {
                this.m_sPassword = nSetPasswordDlg.getNewPassword();
                this.m_tfUsername.setModified(true);
                this.propertyBook.setModified(true, (PageSnapin)this.pageSnapin);
            }
            this.fixFocus();
        }
    }

    private class JPanelExtInner
    extends JPanel {
        public JPanelExtInner(LayoutManager layoutManager) {
            super(layoutManager);
        }

        public Insets getInsets() {
            return new Insets(5, 5, 5, 5);
        }
    }
}

