/*
 * Decompiled with CFR 0.152.
 */
package com.novell.netmessenger.admin.ldap;

import com.novell.admin.ns.NSObject;
import com.novell.netmessenger.admin.common.NDSNegotiator;
import java.util.Vector;

public class LDAPProfileNSObject {
    public static final int I_LDAP_BASE_DN = 0;
    public static final int I_LDAP_BASE_SCOPE = 1;
    public static final int I_LDAP_ADDITIONAL_DNS = 2;
    public static final int I_LDAP_REFERRAL = 3;
    public static final int I_LDAP_PROXY = 4;
    public static final int I_LDAP_QUERY_MAX_RESULTS = 5;
    public static final int I_LDAP_QUERY_TIMEOUT = 6;
    public static final int I_LDAP_IDLE_TIMEOUT = 7;
    public static final int I_LDAP_MAX_CONNECTIONS = 8;
    public static final int I_LDAP_DEFAULT_CONNECTIONS = 9;
    public static final int I_LDAP_CONNECTIONS = 10;
    private static final long I_MASK_BASE_DN = 1L;
    private static final long I_MASK_BASE_SCOPE = 2L;
    private static final long I_MASK_ADDITIONAL_DNS = 4L;
    private static final long I_MASK_REFERRAL = 8L;
    private static final long I_MASK_PROXY = 16L;
    private static final long I_MASK_QUERY_MAX_RESULTS = 32L;
    private static final long I_MASK_QUERY_TIMEOUT = 64L;
    private static final long I_MASK_IDLE_TIMEOUT = 128L;
    private static final long I_MASK_MAX_CONNECTIONS = 256L;
    private static final long I_MASK_DEFAULT_CONNECTIONS = 512L;
    private static final long I_MASK_CONNECTIONS = 1024L;
    public static final int I_DEFAULT_CONNECTIONS = 10;
    public static final int I_DEFAULT_MAX_CONNECTIONS = 30;
    public static final int I_DEFAULT_BASE_SCOPE = 0;
    public static final int I_DEFAULT_IDLE_TIMEOUT = 300;
    public static final int I_DEFAULT_QUERY_TIMEOUT = 30;
    public static final int I_DEFAULT_QUERY_MAX_RESULTS = 100;
    private long I_DIRTY_BITS = 0L;
    private boolean m_bReferral;
    private String m_sBaseDN;
    private String m_sProxy;
    private int m_iBaseScope;
    private int m_iQueryMaxResults;
    private int m_iQueryTimeout;
    private int m_iIdleTimeout;
    private int m_iMaxConnections;
    private int m_iDefaultConnections;
    private Vector m_vAdditionalDNs;
    private Vector m_vConnections;
    public static final String[] LDAP_PROFILE_ATTRIBUTES = new String[]{"nnmLDAPBaseDN", "nnmLDAPBaseScope", "nnmLDAPAdditionalDNs", "nnmLDAPReferral", "nnmLDAPProxy", "nnmLDAPQueryMaxResults", "nnmLDAPQueryTimeout", "nnmLDAPIdleTimeout", "nnmLDAPMaxConnections", "nnmLDAPDefaultConnections", "nnmLDAPConnection"};

    public void setBaseDN(String string) {
        this.m_sBaseDN = string;
        this.I_DIRTY_BITS |= 1L;
    }

    public String getBaseDN() {
        return this.m_sBaseDN;
    }

    public void setBaseScope(int n) {
        this.m_iBaseScope = n;
        this.I_DIRTY_BITS |= 2L;
    }

    public int getBaseScope() {
        return this.m_iBaseScope;
    }

    public void setAdditionalDNs(Vector vector) {
        this.m_vAdditionalDNs = vector;
        this.I_DIRTY_BITS |= 4L;
    }

    public Vector getAdditionalDNs() {
        return this.m_vAdditionalDNs;
    }

    public void setReferral(boolean bl) {
        this.m_bReferral = bl;
        this.I_DIRTY_BITS |= 8L;
    }

    public boolean getReferral() {
        return this.m_bReferral;
    }

    public void setProxy(String string) {
        this.m_sProxy = string;
        this.I_DIRTY_BITS |= 0x10L;
    }

    public String getProxy() {
        return this.m_sProxy;
    }

    public void setQueryMaxResults(int n) {
        this.m_iQueryMaxResults = n;
        this.I_DIRTY_BITS |= 0x20L;
    }

    public int getQueryMaxResults() {
        return this.m_iQueryMaxResults;
    }

    public void setQueryTimeout(int n) {
        this.m_iQueryTimeout = n;
        this.I_DIRTY_BITS |= 0x40L;
    }

    public int getQueryTimeout() {
        return this.m_iQueryTimeout;
    }

    public void setIdleTimeout(int n) {
        this.m_iIdleTimeout = n;
        this.I_DIRTY_BITS |= 0x80L;
    }

    public int getIdleTimeout() {
        return this.m_iIdleTimeout;
    }

    public void setMaxConnections(int n) {
        this.m_iMaxConnections = n;
        this.I_DIRTY_BITS |= 0x100L;
    }

    public int getMaxConnections() {
        return this.m_iMaxConnections;
    }

    public void setDefaultConnections(int n) {
        this.m_iDefaultConnections = n;
        this.I_DIRTY_BITS |= 0x200L;
    }

    public int getDefaultConnections() {
        return this.m_iDefaultConnections;
    }

    public void setConnections(Vector vector) {
        this.m_vConnections = vector;
        this.I_DIRTY_BITS |= 0x400L;
    }

    public Vector getConnections() {
        return this.m_vConnections;
    }

    public boolean load(NSObject nSObject) {
        int n;
        NDSNegotiator nDSNegotiator = new NDSNegotiator();
        this.setBaseDN(nDSNegotiator.getAttribute(nSObject, LDAP_PROFILE_ATTRIBUTES[0]));
        this.setProxy(nDSNegotiator.getAttribute(nSObject, LDAP_PROFILE_ATTRIBUTES[4]));
        String string = nDSNegotiator.getAttribute(nSObject, LDAP_PROFILE_ATTRIBUTES[3]);
        if (string != null) {
            string = string.equals("0") ? "false" : "true";
            Boolean bl = new Boolean(string);
            this.setReferral(bl);
        }
        try {
            n = Integer.parseInt(nDSNegotiator.getAttribute(nSObject, LDAP_PROFILE_ATTRIBUTES[1]));
        }
        catch (Exception exception) {
            n = 0;
        }
        this.setBaseScope(n);
        try {
            n = Integer.parseInt(nDSNegotiator.getAttribute(nSObject, LDAP_PROFILE_ATTRIBUTES[5]));
        }
        catch (Exception exception) {
            n = 100;
        }
        this.setQueryMaxResults(n);
        try {
            n = Integer.parseInt(nDSNegotiator.getAttribute(nSObject, LDAP_PROFILE_ATTRIBUTES[6]));
        }
        catch (Exception exception) {
            n = 30;
        }
        this.setQueryTimeout(n);
        try {
            n = Integer.parseInt(nDSNegotiator.getAttribute(nSObject, LDAP_PROFILE_ATTRIBUTES[7]));
        }
        catch (Exception exception) {
            n = 300;
        }
        this.setIdleTimeout(n);
        try {
            n = Integer.parseInt(nDSNegotiator.getAttribute(nSObject, LDAP_PROFILE_ATTRIBUTES[9]));
        }
        catch (Exception exception) {
            n = 10;
        }
        this.setDefaultConnections(n);
        try {
            n = Integer.parseInt(nDSNegotiator.getAttribute(nSObject, LDAP_PROFILE_ATTRIBUTES[8]));
        }
        catch (Exception exception) {
            n = 30;
        }
        this.setMaxConnections(n);
        this.setAdditionalDNs(nDSNegotiator.getMultiValuedAttribute(nSObject, LDAP_PROFILE_ATTRIBUTES[2]));
        this.setConnections(nDSNegotiator.getMultiValuedAttribute(nSObject, LDAP_PROFILE_ATTRIBUTES[10]));
        this.I_DIRTY_BITS = 0L;
        return true;
    }

    public boolean save(NSObject nSObject) {
        boolean bl = false;
        NDSNegotiator nDSNegotiator = new NDSNegotiator();
        if ((this.I_DIRTY_BITS & 1L) != 0L) {
            nDSNegotiator.setAttribute(nSObject, LDAP_PROFILE_ATTRIBUTES[0], this.getBaseDN());
        }
        if ((this.I_DIRTY_BITS & 0x10L) != 0L) {
            nDSNegotiator.setAttribute(nSObject, LDAP_PROFILE_ATTRIBUTES[4], this.getProxy());
        }
        if ((this.I_DIRTY_BITS & 4L) != 0L) {
            nDSNegotiator.setMultiValuedAttribute(nSObject, LDAP_PROFILE_ATTRIBUTES[2], this.getAdditionalDNs());
        }
        if ((this.I_DIRTY_BITS & 2L) != 0L) {
            nDSNegotiator.setAttribute(nSObject, LDAP_PROFILE_ATTRIBUTES[1], String.valueOf(this.getBaseScope()));
        }
        if ((this.I_DIRTY_BITS & 8L) != 0L) {
            String string = this.m_bReferral ? "1" : "0";
            nDSNegotiator.setAttribute(nSObject, LDAP_PROFILE_ATTRIBUTES[3], string);
        }
        if ((this.I_DIRTY_BITS & 0x20L) != 0L) {
            nDSNegotiator.setAttribute(nSObject, LDAP_PROFILE_ATTRIBUTES[5], String.valueOf(this.getQueryMaxResults()));
        }
        if ((this.I_DIRTY_BITS & 0x40L) != 0L) {
            nDSNegotiator.setAttribute(nSObject, LDAP_PROFILE_ATTRIBUTES[6], String.valueOf(this.getQueryTimeout()));
        }
        if ((this.I_DIRTY_BITS & 0x80L) != 0L) {
            nDSNegotiator.setAttribute(nSObject, LDAP_PROFILE_ATTRIBUTES[7], String.valueOf(this.getIdleTimeout()));
        }
        if ((this.I_DIRTY_BITS & 0x100L) != 0L) {
            nDSNegotiator.setAttribute(nSObject, LDAP_PROFILE_ATTRIBUTES[8], String.valueOf(this.getMaxConnections()));
        }
        if ((this.I_DIRTY_BITS & 0x200L) != 0L) {
            nDSNegotiator.setAttribute(nSObject, LDAP_PROFILE_ATTRIBUTES[9], String.valueOf(this.getDefaultConnections()));
        }
        if ((this.I_DIRTY_BITS & 0x400L) != 0L) {
            nDSNegotiator.setMultiValuedAttribute(nSObject, LDAP_PROFILE_ATTRIBUTES[10], this.getConnections());
        }
        if (!(bl = nDSNegotiator.update(nSObject))) {
            System.out.println("=================\n" + this.toString());
        }
        this.load(nSObject);
        return bl;
    }
}

