/*
 * Decompiled with CFR 0.152.
 */
package com.novell.netmessenger.admin.module;

import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.nds.NDSAttributeDefinition;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.admin.ns.nds.NDSObjectAttribute;
import com.novell.admin.ns.nds.NDSSyntax;
import com.novell.application.console.snapin.MainShell;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.SnapinVetoException;
import com.novell.netmessenger.admin.common.BaseDlg;
import com.novell.netmessenger.admin.common.Debug;
import com.novell.netmessenger.admin.common.StaticUtilities;
import com.novell.netmessenger.admin.module.ModuleNSObject;
import com.novell.netmessenger.admin.module.ModuleResource;
import com.novell.utility.nmsgbox.NMsgBox;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ModuleCreateDlg
extends BaseDlg {
    private JTextField m_tfCN;

    public ModuleCreateDlg() {
        super((Frame)MainShell.getInstance().getShellFrame(), ModuleResource.get("ModuleCreateTitle"), true, "modulecreate");
    }

    public void layoutControls() {
        JLabel jLabel = new JLabel(ModuleResource.get("ModuleCreateCN"));
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.m_tfCN = new JTextField(30);
        this.m_tfCN.addActionListener(this);
        gridBagConstraints.insets = new Insets(2, 2, 25, 2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.m_tfCN, gridBagConstraints);
        this.getContentPane().add((Component)jPanel, "North");
        super.layoutControls();
        this.setModal(true);
        this.setResizable(false);
        this.pack();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_tfCN) {
            this.okButtonAction();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    protected void okButtonAction() {
        String string = this.m_tfCN.getText().trim();
        if (string != null && string.length() > 0) {
            NDSNamespace nDSNamespace = (NDSNamespace)this.m_shell.getNamespaceSnapin(NDSNamespace.name);
            ObjectEntry objectEntry = this.m_shell.getCurrentSelections().getFirstElement();
            if (objectEntry == null) {
                objectEntry = this.m_shell.getTreeSelection();
            }
            try {
                ValueComponent[] valueComponentArray = new ValueComponent[]{NDSSyntax.SYN_CLASS_NAME.createValueComponent((Object)"nnmModule")};
                NDSObjectAttribute nDSObjectAttribute = new NDSObjectAttribute((AttributeDefinition)((NDSAttributeDefinition)nDSNamespace.getAttributeDefinition(objectEntry, "Object Class")), valueComponentArray);
                valueComponentArray[0] = NDSSyntax.SYN_CI_STRING.createValueComponent((Object)string);
                NDSObjectAttribute nDSObjectAttribute2 = new NDSObjectAttribute((AttributeDefinition)((NDSAttributeDefinition)nDSNamespace.getAttributeDefinition(objectEntry, "CN")), valueComponentArray);
                valueComponentArray[0] = NDSSyntax.SYN_CI_STRING.createValueComponent((Object)"FileModule");
                NDSObjectAttribute nDSObjectAttribute3 = new NDSObjectAttribute((AttributeDefinition)((NDSAttributeDefinition)nDSNamespace.getAttributeDefinition(objectEntry, "nnmModuleName")), valueComponentArray);
                valueComponentArray[0] = NDSSyntax.SYN_CI_STRING.createValueComponent((Object)"filemodule_linked_statically");
                NDSObjectAttribute nDSObjectAttribute4 = new NDSObjectAttribute((AttributeDefinition)((NDSAttributeDefinition)nDSNamespace.getAttributeDefinition(objectEntry, "nnmModuleBin")), valueComponentArray);
                if (nDSNamespace.doesExist(objectEntry, string)) {
                    NMsgBox nMsgBox = new NMsgBox((Component)this, ModuleResource.get("ModuleCreateDuplicateTitle"), ModuleResource.get("ModuleCreateDuplicate"), 3);
                    nMsgBox.launch();
                    this.m_tfCN.requestFocus();
                    this.m_tfCN.selectAll();
                    return;
                }
                Vector<NDSObjectAttribute> vector = new Vector<NDSObjectAttribute>();
                vector.addElement(nDSObjectAttribute);
                vector.addElement(nDSObjectAttribute2);
                vector.addElement(nDSObjectAttribute3);
                vector.addElement(nDSObjectAttribute4);
                ObjectEntry objectEntry2 = nDSNamespace.createObjectEntry(objectEntry, string, "nnmModule");
                NSObject nSObject = nDSNamespace.createNSObject(objectEntry2, vector);
                nDSNamespace.create(nSObject);
                this.initDefaults(nSObject);
                this.dispose();
            }
            catch (NamespaceException namespaceException) {
                NMsgBox nMsgBox = new NMsgBox((Component)this, ModuleResource.get("ModuleCreateInvalidNameTitle"), ModuleResource.get("ModuleCreateInvalidName"), 3);
                nMsgBox.launch();
                this.m_tfCN.requestFocus();
                this.m_tfCN.selectAll();
                return;
            }
            catch (SnapinVetoException snapinVetoException) {
                Debug.trace("SnapinVetoException CAUGHT: Please ignore this message");
                return;
            }
            catch (Exception exception) {
                Debug.trace("A generic exception CAUGHT: Please ignore this message");
                return;
            }
            this.m_shell.refreshCurrentTreeSelection();
            return;
        }
        NMsgBox nMsgBox = new NMsgBox((Component)this, ModuleResource.get("ModuleCreateNoNameTitle"), ModuleResource.get("ModuleCreateNoName"), 3);
        nMsgBox.launch();
        this.m_tfCN.requestFocus();
    }

    protected void initDefaults(NSObject nSObject) {
        ModuleNSObject moduleNSObject = new ModuleNSObject();
        String string = StaticUtilities.getPlatform() == 3 ? "/var/opt/novell/messenger/aa/store" : "\\novell\\nm\\aa\\store\\";
        moduleNSObject.setStorePath(string);
        moduleNSObject.setDelay(0);
        moduleNSObject.setUpdateInterval(2);
        moduleNSObject.setCompressInterval(24);
        moduleNSObject.setMaxFileSize(2);
        moduleNSObject.save(nSObject);
    }

    protected void cancelButtonAction() {
        this.dispose();
    }
}

