/*
 * Decompiled with CFR 0.152.
 */
package com.novell.netmessenger.admin.module;

import com.novell.admin.ns.NSObject;
import com.novell.netmessenger.admin.common.NDSNegotiator;
import com.novell.netmessenger.admin.common.StaticUtilities;
import java.util.Vector;

public class ModuleNSObject {
    public static final int I_DEFAULT_MAX_FILE_SIZE = 2;
    public static final int I_DEFAULT_DELAY = 0;
    public static final int I_DEFAULT_UPDATE_INTERVAL = 2;
    public static final int I_DEFAULT_COMPRESS_INTERVAL = 24;
    public static final String S_DEFAULT_STORE_PATH = "\\novell\\nm\\aa\\store\\";
    public static final String S_UNIX_DEFAULT_STORE_PATH = "/var/opt/novell/messenger/aa/store";
    public static final String S_TAG_AM_STORE_PATH = "AM_StorePath";
    public static final String S_TAG_AM_MAX_FILE_SIZE = "AM_MaxFileSize";
    public static final String S_TAG_AM_DELAY = "AM_QFDelay";
    public static final String S_TAG_AM_UPDATE_INTERVAL = "AM_QFUpdateInterval";
    public static final String S_TAG_AM_COMPRESS_INTERVAL = "AM_QFCompressInterval";
    private static final int I_MODULE_NAME = 0;
    private static final int I_MODULE_CODE = 1;
    private static final int I_MODULE_DESCRIPTION = 2;
    private static final int I_MODULE_SETTINGS = 3;
    private static final long I_MASK_NAME = 1L;
    private static final long I_MASK_CODE = 2L;
    private static final long I_MASK_DESCRIPTION = 4L;
    private static final long I_MASK_SETTINGS = 8L;
    public static final String[] SA_MODULE_ATTRIBUTES = new String[]{"nnmModuleName", "nnmModuleBin", "nnmModuleDescription", "nnmModuleSettings"};
    private long m_iDirtyBits;
    private int m_iMaxFileSize;
    private int m_iDelay;
    private int m_iUpdateInterval;
    private int m_iCompressInterval;
    private String m_sModuleName;
    private String m_sModuleCode;
    private String m_sModuleDescription;
    private String m_sStorePath;

    public void setModuleName(String string) {
        this.m_sModuleName = string;
        this.m_iDirtyBits |= 1L;
    }

    public String getModuleName() {
        return this.m_sModuleName;
    }

    public void setModuleCode(String string) {
        this.m_sModuleCode = string;
        this.m_iDirtyBits |= 2L;
    }

    public String getModuleCode() {
        return this.m_sModuleCode;
    }

    public void setModuleDescription(String string) {
        this.m_sModuleDescription = string;
        this.m_iDirtyBits |= 4L;
    }

    public String getModuleDescription() {
        return this.m_sModuleDescription;
    }

    public void setModuleSettings(Vector vector) {
        if (vector != null) {
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                String string;
                String string2;
                String string3 = (String)vector.elementAt(i);
                int n2 = string3.indexOf(58);
                if (n2 == -1) continue;
                try {
                    string2 = string3.substring(0, n2);
                    string = string3.substring(n2 + 1);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    continue;
                }
                if (string2.equalsIgnoreCase(S_TAG_AM_STORE_PATH)) {
                    this.setStorePath(string);
                    continue;
                }
                if (string2.equalsIgnoreCase(S_TAG_AM_MAX_FILE_SIZE)) {
                    this.setMaxFileSize(StaticUtilities.parseInt2(string, 2));
                    continue;
                }
                if (string2.equalsIgnoreCase(S_TAG_AM_DELAY)) {
                    this.setDelay(StaticUtilities.parseInt2(string, 0));
                    continue;
                }
                if (string2.equalsIgnoreCase(S_TAG_AM_UPDATE_INTERVAL)) {
                    this.setUpdateInterval(StaticUtilities.parseInt2(string, 2));
                    continue;
                }
                if (!string2.equalsIgnoreCase(S_TAG_AM_COMPRESS_INTERVAL)) continue;
                this.setCompressInterval(StaticUtilities.parseInt2(string, 24));
            }
        }
    }

    public Vector getModuleSettings() {
        Vector<String> vector = new Vector<String>();
        vector.addElement("AM_StorePath:" + this.getStorePath());
        vector.addElement("AM_MaxFileSize:" + this.getMaxFileSize());
        vector.addElement("AM_QFDelay:" + this.getDelay());
        vector.addElement("AM_QFUpdateInterval:" + this.getUpdateInterval());
        vector.addElement("AM_QFCompressInterval:" + this.getCompressInterval());
        return vector;
    }

    public void setStorePath(String string) {
        this.m_sStorePath = string;
        this.m_iDirtyBits |= 8L;
    }

    public String getStorePath() {
        String string = this.m_sStorePath == null ? S_DEFAULT_STORE_PATH : this.m_sStorePath;
        return string;
    }

    public void setMaxFileSize(int n) {
        this.m_iMaxFileSize = n;
        this.m_iDirtyBits |= 8L;
    }

    public int getMaxFileSize() {
        return this.m_iMaxFileSize > 0 ? this.m_iMaxFileSize : 2;
    }

    public void setDelay(int n) {
        this.m_iDelay = n;
        this.m_iDirtyBits |= 8L;
    }

    public int getDelay() {
        return this.m_iDelay;
    }

    public void setUpdateInterval(int n) {
        this.m_iUpdateInterval = n;
        this.m_iDirtyBits |= 8L;
    }

    public int getUpdateInterval() {
        return this.m_iUpdateInterval > 0 ? this.m_iUpdateInterval : 2;
    }

    public void setCompressInterval(int n) {
        this.m_iCompressInterval = n;
        this.m_iDirtyBits |= 8L;
    }

    public int getCompressInterval() {
        return this.m_iCompressInterval > 0 ? this.m_iCompressInterval : 24;
    }

    public boolean load(NSObject nSObject) {
        NDSNegotiator nDSNegotiator = new NDSNegotiator();
        this.m_iDirtyBits = 0L;
        this.setModuleName(nDSNegotiator.getAttribute(nSObject, SA_MODULE_ATTRIBUTES[0]));
        this.setModuleCode(nDSNegotiator.getAttribute(nSObject, SA_MODULE_ATTRIBUTES[1]));
        this.setModuleDescription(nDSNegotiator.getAttribute(nSObject, SA_MODULE_ATTRIBUTES[2]));
        this.setModuleSettings(nDSNegotiator.getMultiValuedAttribute(nSObject, SA_MODULE_ATTRIBUTES[3]));
        this.m_iDirtyBits = 0L;
        return true;
    }

    public boolean save(NSObject nSObject) {
        boolean bl = false;
        NDSNegotiator nDSNegotiator = new NDSNegotiator();
        if ((this.m_iDirtyBits & 1L) > 0L) {
            nDSNegotiator.setAttribute(nSObject, SA_MODULE_ATTRIBUTES[0], this.getModuleName());
        }
        if ((this.m_iDirtyBits & 2L) > 0L) {
            nDSNegotiator.setAttribute(nSObject, SA_MODULE_ATTRIBUTES[1], this.getModuleCode());
        }
        if ((this.m_iDirtyBits & 4L) > 0L) {
            nDSNegotiator.setAttribute(nSObject, SA_MODULE_ATTRIBUTES[2], this.getModuleDescription());
        }
        if ((this.m_iDirtyBits & 8L) > 0L) {
            nDSNegotiator.setMultiValuedAttribute(nSObject, SA_MODULE_ATTRIBUTES[3], this.getModuleSettings());
        }
        if (!(bl = nDSNegotiator.update(nSObject))) {
            System.out.println("=================\n" + this.toString());
        } else {
            this.m_iDirtyBits = 0L;
        }
        this.load(nSObject);
        return bl;
    }
}

