/*
 * Decompiled with CFR 0.152.
 */
package com.novell.netmessenger.admin.module;

import com.novell.admin.common.snapins.AdminPageSnapin;
import com.novell.admin.ns.NSObject;
import com.novell.application.console.snapin.InitSnapinInfo;
import com.novell.netmessenger.admin.common.FilePathTextField;
import com.novell.netmessenger.admin.common.NIncrementBox;
import com.novell.netmessenger.admin.module.ModuleAdminPage;
import com.novell.netmessenger.admin.module.ModuleResource;
import com.novell.netmessenger.admin.swingext.JLabelExt;
import com.novell.utility.nmsgbox.NMsgBox;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class ModulePanelStore
extends ModuleAdminPage {
    private FilePathTextField m_tfStorePath;
    private NIncrementBox m_incDelay;
    private NIncrementBox m_incUpdateInterval;
    private NIncrementBox m_incCompressInterval;
    private NIncrementBox m_incMaxFileSize;

    public ModulePanelStore(InitSnapinInfo initSnapinInfo, AdminPageSnapin adminPageSnapin, NSObject nSObject) {
        super(initSnapinInfo, adminPageSnapin, nSObject);
    }

    protected void init() {
        this.m_tfStorePath = new FilePathTextField(this.propertyBook.getComponent(), 1);
        this.m_incMaxFileSize = new NIncrementBox(1, Integer.MAX_VALUE, 2);
        this.m_incDelay = new NIncrementBox(0, Integer.MAX_VALUE, 0);
        this.m_incUpdateInterval = new NIncrementBox(1, Integer.MAX_VALUE, 2);
        this.m_incCompressInterval = new NIncrementBox(1, Integer.MAX_VALUE, 24);
    }

    public void layoutControls() {
        this.init();
        JLabelExt jLabelExt = new JLabelExt(ModuleResource.get("ModuleStorePath"), this.m_tfStorePath);
        JLabelExt jLabelExt2 = new JLabelExt(ModuleResource.get("ModuleStoreDelay"), this.m_incDelay);
        JLabelExt jLabelExt3 = new JLabelExt(ModuleResource.get("ModuleStoreUpdateInterval"), this.m_incUpdateInterval);
        JLabelExt jLabelExt4 = new JLabelExt(ModuleResource.get("ModuleStoreCompressInterval"), this.m_incCompressInterval);
        JLabelExt jLabelExt5 = new JLabelExt(ModuleResource.get("ModuleStoreFileSize"), this.m_incMaxFileSize);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(ModuleResource.get("ModuleStoreMaintenance")));
        this.setGBC(gridBagConstraints, 1, 1, 1, 1, 0, 0.2, 0.0, 18);
        this.add(jLabelExt, gridBagConstraints);
        this.setGBC(gridBagConstraints, 2, 1, 1, 1, 2, 0.8, 0.0, 18);
        this.add(this.m_tfStorePath, gridBagConstraints);
        this.setGBC(gridBagConstraints, 1, 2, 1, 1, 0, 0.2, 0.0, 18);
        this.add(jLabelExt5, gridBagConstraints);
        this.setGBC(gridBagConstraints, 2, 2, 1, 1, 0, 0.8, 0.0, 18);
        this.add(this.m_incMaxFileSize, gridBagConstraints);
        this.setGBC(gridBagConstraints, 1, 3, 1, 1, 0, 0.1, 0.0, 18);
        jPanel.add((Component)jLabelExt2, gridBagConstraints);
        this.setGBC(gridBagConstraints, 2, 3, 1, 1, 0, 0.9, 0.0, 18);
        jPanel.add((Component)this.m_incDelay, gridBagConstraints);
        this.setGBC(gridBagConstraints, 1, 4, 1, 1, 0, 0.1, 0.0, 18);
        jPanel.add((Component)jLabelExt3, gridBagConstraints);
        this.setGBC(gridBagConstraints, 2, 4, 1, 1, 0, 0.9, 0.0, 18);
        jPanel.add((Component)this.m_incUpdateInterval, gridBagConstraints);
        this.setGBC(gridBagConstraints, 1, 5, 1, 1, 0, 0.1, 1.0, 18);
        jPanel.add((Component)jLabelExt4, gridBagConstraints);
        this.setGBC(gridBagConstraints, 2, 5, 1, 1, 0, 0.9, 1.0, 18);
        jPanel.add((Component)this.m_incCompressInterval, gridBagConstraints);
        this.setGBC(gridBagConstraints, 1, 5, 0, 1, 2, 1.0, 1.0, 18);
        this.add(jPanel, gridBagConstraints);
    }

    public void readData() {
        this.m_tfStorePath.setText(this.m_moduleNSObject.getStorePath());
        this.m_incDelay.setValue(this.m_moduleNSObject.getDelay());
        this.m_incUpdateInterval.setValue(this.m_moduleNSObject.getUpdateInterval());
        this.m_incCompressInterval.setValue(this.m_moduleNSObject.getCompressInterval());
        this.m_incMaxFileSize.setValue(this.m_moduleNSObject.getMaxFileSize());
        this.m_tfStorePath.addDocumentListener(this);
        this.m_incDelay.addDocumentListener(this);
        this.m_incUpdateInterval.addDocumentListener(this);
        this.m_incCompressInterval.addDocumentListener(this);
        this.m_incMaxFileSize.addDocumentListener(this);
    }

    public boolean killActive() {
        String string = this.m_tfStorePath.getText();
        if (string == null || string.trim().length() == 0) {
            NMsgBox nMsgBox = new NMsgBox(this.propertyBook.getComponent(), ModuleResource.get("ModuleStorePathInvalidTitle"), ModuleResource.get("ModuleStorePathInvalid"), 3);
            nMsgBox.launch();
            this.fixFocus();
            return false;
        }
        return super.killActive();
    }

    public boolean saveData() {
        if (this.m_tfStorePath.isModified()) {
            this.m_moduleNSObject.setStorePath(this.m_tfStorePath.getText());
        }
        if (this.m_incDelay.isModified()) {
            this.m_moduleNSObject.setDelay(this.m_incDelay.getValue());
        }
        if (this.m_incUpdateInterval.isModified()) {
            this.m_moduleNSObject.setUpdateInterval(this.m_incUpdateInterval.getValue());
        }
        if (this.m_incCompressInterval.isModified()) {
            this.m_moduleNSObject.setCompressInterval(this.m_incCompressInterval.getValue());
        }
        if (this.m_incMaxFileSize.isModified()) {
            this.m_moduleNSObject.setMaxFileSize(this.m_incMaxFileSize.getValue());
        }
        return true;
    }
}

