/*
 * Decompiled with CFR 0.152.
 */
package com.novell.netmessenger.admin.policy;

import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.nds.NDSAttributeDefinition;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.admin.ns.nds.NDSObjectAttribute;
import com.novell.admin.ns.nds.NDSSyntax;
import com.novell.application.console.snapin.MainShell;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.netmessenger.admin.common.BaseDlg;
import com.novell.netmessenger.admin.common.OESTextField;
import com.novell.netmessenger.admin.common.ObjectInfo;
import com.novell.netmessenger.admin.common.Resource;
import com.novell.netmessenger.admin.common.StaticUtilities;
import com.novell.netmessenger.admin.policy.PolicyNSObject;
import com.novell.netmessenger.admin.policy.PolicyResource;
import com.novell.netmessenger.admin.swingext.JLabelExt;
import com.novell.utility.nmsgbox.NMsgBox;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PolicyCreateDlg
extends BaseDlg {
    private JTextField m_tfCN;
    private OESTextField m_tfSystemDN;
    private ObjectInfo m_objInfo;
    private ObjectEntry m_oeParent;

    public PolicyCreateDlg(ObjectInfo objectInfo, ObjectEntry objectEntry) throws Exception {
        super((Frame)MainShell.getInstance().getShellFrame(), null, true, objectInfo.getHelpID());
        this.m_oeParent = objectEntry;
        if (objectInfo == null) {
            throw new Exception("A non-null ObjectInfo is required");
        }
        this.m_objInfo = objectInfo;
        this.layoutControls();
    }

    public void layoutControls() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.m_tfCN = new JTextField(30);
        this.m_tfCN.addActionListener(this);
        this.m_tfSystemDN = new OESTextField(this, this.m_oeParent);
        this.m_tfSystemDN.setEditable(false);
        this.m_tfSystemDN.setFilter(StaticUtilities.SA_OBJECT_TYPE_SYSTEM);
        JLabelExt jLabelExt = new JLabelExt(Resource.get("CreateCN"), this.m_tfCN);
        JLabelExt jLabelExt2 = new JLabelExt(PolicyResource.get("PolicyCreateSystemDN"), this.m_tfSystemDN);
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)jLabelExt, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.m_tfCN, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)jLabelExt2, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.m_tfSystemDN, gridBagConstraints);
        this.getContentPane().add((Component)jPanel, "North");
        super.layoutControls();
        this.setModal(true);
        this.setResizable(false);
        this.pack();
        this.setTitle(this.m_objInfo.getDialogTitle());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_tfCN) {
            this.okButtonAction();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    protected void okButtonAction() {
        String string = this.m_tfCN.getText().trim();
        if (string.length() > 0) {
            if (this.m_tfSystemDN.getText() == null || this.m_tfSystemDN.getText().length() == 0) {
                NMsgBox nMsgBox = new NMsgBox((Component)this, PolicyResource.get("PolicyCreateNoSystemDN"), PolicyResource.get("PolicyCreateNoSystemDNTitle"), 3);
                nMsgBox.launch();
                return;
            }
            NDSNamespace nDSNamespace = (NDSNamespace)this.m_shell.getNamespaceSnapin(NDSNamespace.name);
            try {
                ValueComponent[] valueComponentArray = new ValueComponent[]{NDSSyntax.SYN_CLASS_NAME.createValueComponent((Object)this.m_objInfo.getObjectClass())};
                NDSObjectAttribute nDSObjectAttribute = new NDSObjectAttribute((AttributeDefinition)((NDSAttributeDefinition)nDSNamespace.getAttributeDefinition(this.m_oeParent, "Object Class")), valueComponentArray);
                valueComponentArray[0] = NDSSyntax.SYN_CI_STRING.createValueComponent((Object)string);
                NDSObjectAttribute nDSObjectAttribute2 = new NDSObjectAttribute((AttributeDefinition)((NDSAttributeDefinition)nDSNamespace.getAttributeDefinition(this.m_oeParent, this.m_objInfo.getNamedBy())), valueComponentArray);
                if (nDSNamespace.doesExist(this.m_oeParent, string)) {
                    NMsgBox nMsgBox = new NMsgBox((Component)this, Resource.get("CreateDuplicateTitle"), Resource.get("CreateDuplicate"), 3);
                    nMsgBox.launch();
                    this.m_tfCN.requestFocus();
                    this.m_tfCN.selectAll();
                    return;
                }
                Vector<NDSObjectAttribute> vector = new Vector<NDSObjectAttribute>(2);
                vector.addElement(nDSObjectAttribute);
                vector.addElement(nDSObjectAttribute2);
                ObjectEntry objectEntry = nDSNamespace.createObjectEntry(this.m_oeParent, string, this.m_objInfo.getObjectClass());
                NSObject nSObject = nDSNamespace.createNSObject(objectEntry, vector);
                nDSNamespace.create(nSObject);
                PolicyNSObject policyNSObject = new PolicyNSObject();
                policyNSObject.load(nSObject);
                policyNSObject.setSystemDN(this.m_tfSystemDN.getText());
                policyNSObject.setServices(true);
                policyNSObject.setArchive(false);
                policyNSObject.setPersonalHistory(true);
                policyNSObject.setPrintSave(true);
                policyNSObject.setQuery(true);
                policyNSObject.setBroadcast(true);
                policyNSObject.setBroadcastSystem(false);
                policyNSObject.setChat(true);
                policyNSObject.setChatCreate(false);
                policyNSObject.setMaxContacts(100);
                policyNSObject.setMaxFolders(50);
                policyNSObject.setConferencingEnabled(false);
                if (!policyNSObject.save(nSObject)) {
                    System.out.println("nnmSystemDN attribute could not set on the Policy object created");
                }
                this.dispose();
            }
            catch (Exception exception) {
                NMsgBox nMsgBox = new NMsgBox((Component)this, Resource.get("CreateObjectFailedTitle"), Resource.get("CreateObjectFailed"), 3);
                nMsgBox.launch();
                this.m_tfCN.requestFocus();
                this.m_tfCN.selectAll();
                return;
            }
            this.m_shell.refreshCurrentTreeSelection();
            return;
        }
        NMsgBox nMsgBox = new NMsgBox((Component)this, Resource.get("CreateNoNameTitle"), Resource.get("CreateNoName"), 3);
        nMsgBox.launch();
        this.m_tfCN.requestFocus();
    }

    protected void cancelButtonAction() {
        this.dispose();
    }
}

