/*
 * Decompiled with CFR 0.152.
 */
package com.novell.netmessenger.admin.policy;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.ClassDefinition;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.admin.ns.nds.NDSSchemaDefinition;
import com.novell.admin.ns.nds.NDSSyntax;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.netmessenger.admin.common.BaseDlg;
import com.novell.netmessenger.admin.common.QuickSort;
import com.novell.netmessenger.admin.policy.PolicyResource;
import com.novell.netmessenger.admin.swingext.JLabelExt;
import com.novell.netmessenger.admin.swingext.JListExt;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;

public class PolicyInformationAvailableDlg
extends BaseDlg {
    private JListExt m_listAvailableAttributes;
    private Vector m_vInformationList;
    private ObjectEntry oe;

    public PolicyInformationAvailableDlg(Component component, ObjectEntry objectEntry) {
        super((Dialog)component, PolicyResource.get("PolicyInformationListTitle"), true, "policyavailattributes");
        this.oe = objectEntry;
        this.m_listAvailableAttributes = new JListExt();
        this.m_listAvailableAttributes.setVisibleRowCount(10);
        this.layoutControls();
        this.init();
    }

    protected void init() {
        NDSSchemaDefinition nDSSchemaDefinition;
        NDSNamespace nDSNamespace = (NDSNamespace)this.oe.getObjectType().getNamespace();
        try {
            nDSSchemaDefinition = (NDSSchemaDefinition)nDSNamespace.getSchemaDefinition(this.oe);
        }
        catch (SPIException sPIException) {
            return;
        }
        if (nDSSchemaDefinition != null) {
            ClassDefinition classDefinition;
            try {
                classDefinition = nDSSchemaDefinition.getClassDefinition("User");
            }
            catch (NamespaceException namespaceException) {
                return;
            }
            if (classDefinition != null) {
                NDSSyntax nDSSyntax;
                int n;
                DefaultListModel defaultListModel = (DefaultListModel)this.m_listAvailableAttributes.getModel();
                Vector<String> vector = new Vector<String>();
                AttributeDefinition[] attributeDefinitionArray = classDefinition.getMandatoryAttributes();
                for (n = 0; n < attributeDefinitionArray.length - 1; ++n) {
                    nDSSyntax = (NDSSyntax)attributeDefinitionArray[n].getSyntax();
                    if (nDSSyntax.getId() != NDSSyntax.SYN_CI_STRING.getId() && nDSSyntax.getId() != NDSSyntax.SYN_DIST_NAME.getId() && nDSSyntax.getId() != NDSSyntax.SYN_TEL_NUMBER.getId() || attributeDefinitionArray[n].getName().startsWith("nnm")) continue;
                    vector.addElement(attributeDefinitionArray[n].getName());
                }
                AttributeDefinition[] attributeDefinitionArray2 = classDefinition.getOptionalAttributes();
                for (n = 0; n < attributeDefinitionArray2.length - 1; ++n) {
                    nDSSyntax = (NDSSyntax)attributeDefinitionArray2[n].getSyntax();
                    if (nDSSyntax.getId() != NDSSyntax.SYN_CI_STRING.getId() && nDSSyntax.getId() != NDSSyntax.SYN_DIST_NAME.getId() && nDSSyntax.getId() != NDSSyntax.SYN_TEL_NUMBER.getId() || attributeDefinitionArray2[n].getName().startsWith("nnm")) continue;
                    vector.addElement(attributeDefinitionArray2[n].getName());
                }
                QuickSort.sort(vector);
                int n2 = vector.size();
                for (n = 0; n < n2; ++n) {
                    defaultListModel.addElement((String)vector.elementAt(n));
                }
            }
        }
    }

    public void layoutControls() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 18;
        JLabelExt jLabelExt = new JLabelExt(PolicyResource.get("PolicyInformationListAvailableAttributes"), this.m_listAvailableAttributes);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)jLabelExt, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)new JScrollPane(this.m_listAvailableAttributes), gridBagConstraints);
        this.getContentPane().add((Component)jPanel, "Center");
        super.layoutControls();
        this.pack();
    }

    public Vector getInformationList() {
        return this.m_vInformationList;
    }

    protected void okButtonAction() {
        if (!this.m_listAvailableAttributes.isSelectionEmpty()) {
            ListModel listModel = this.m_listAvailableAttributes.getModel();
            int[] nArray = this.m_listAvailableAttributes.getSelectedIndices();
            this.m_vInformationList = new Vector(nArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                this.m_vInformationList.addElement(listModel.getElementAt(nArray[i]));
            }
        }
        this.dispose();
    }

    protected void cancelButtonAction() {
        this.m_vInformationList = null;
        this.dispose();
    }
}

