/*
 * Decompiled with CFR 0.152.
 */
package com.novell.netmessenger.admin.policy;

import com.novell.application.console.snapin.ObjectEntry;
import com.novell.netmessenger.admin.common.BaseDlg;
import com.novell.netmessenger.admin.common.StaticUtilities;
import com.novell.netmessenger.admin.policy.PolicyInformationAvailableDlg;
import com.novell.netmessenger.admin.policy.PolicyResource;
import com.novell.netmessenger.admin.swingext.JButtonExt;
import com.novell.netmessenger.admin.swingext.JLabelExt;
import com.novell.netmessenger.admin.swingext.JTextFieldExt;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class PolicyInformationDlg
extends BaseDlg {
    private JTextFieldExt m_tfAttribute = new JTextFieldExt(30);
    private JButtonExt m_btnInformationList;
    private Vector m_vInformationList;
    private ObjectEntry m_oe;

    public PolicyInformationDlg(Component component, ObjectEntry objectEntry) {
        super((Dialog)component, PolicyResource.get("PolicyInformationListTitle"), true, "policyaddattributes");
        this.m_oe = objectEntry;
        this.m_btnInformationList = new JButtonExt(PolicyResource.get("PolicyInformationSelect"));
        this.m_btnInformationList.addActionListener(this);
        this.setResizable(false);
        this.layoutControls();
    }

    public void layoutControls() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 18;
        JLabelExt jLabelExt = new JLabelExt(PolicyResource.get("PolicyInformationListSelectedAttributes"), this.m_tfAttribute);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)jLabelExt, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.m_tfAttribute, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets.bottom = 25;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 12;
        jPanel.add((Component)this.m_btnInformationList, gridBagConstraints);
        this.getContentPane().add((Component)jPanel, "Center");
        super.layoutControls();
        this.pack();
    }

    public void setInformationList(Vector vector) {
        this.m_vInformationList = vector;
        this.m_tfAttribute.setText(StaticUtilities.toFormattedString(this.m_vInformationList));
    }

    public Vector getInformationList() {
        return this.m_vInformationList;
    }

    public void edit(String string) {
        this.m_btnInformationList.setVisible(false);
        this.m_tfAttribute.setDocument(new PlainDocumentExt());
        this.m_tfAttribute.setText(string);
        this.pack();
    }

    protected void okButtonAction() {
        if (this.m_vInformationList == null) {
            this.m_vInformationList = new Vector();
        } else {
            this.m_vInformationList.removeAllElements();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.m_tfAttribute.getText(), ";");
        while (stringTokenizer.hasMoreTokens()) {
            this.m_vInformationList.addElement(stringTokenizer.nextToken());
        }
        this.dispose();
    }

    protected void cancelButtonAction() {
        this.m_vInformationList = null;
        this.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_btnInformationList) {
            PolicyInformationAvailableDlg policyInformationAvailableDlg = new PolicyInformationAvailableDlg((Component)this, this.m_oe);
            policyInformationAvailableDlg.show();
            Vector vector = policyInformationAvailableDlg.getInformationList();
            if (vector != null) {
                int n = vector.size();
                this.m_vInformationList = new Vector(n);
                for (int i = 0; i < n; ++i) {
                    this.m_vInformationList.addElement((String)vector.elementAt(i));
                }
                this.m_tfAttribute.setText(StaticUtilities.toFormattedString(this.m_vInformationList));
            }
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    private class PlainDocumentExt
    extends PlainDocument {
        private PlainDocumentExt() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string.indexOf(59) > 0) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            super.insertString(n, string.trim(), attributeSet);
        }
    }
}

