/*
 * Decompiled with CFR 0.152.
 */
package com.novell.netmessenger.admin.policy;

import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.netmessenger.admin.common.Debug;
import com.novell.netmessenger.admin.common.NDSNegotiator;
import com.novell.netmessenger.admin.system.NNMSystemNSObject;
import java.util.Vector;

public class PolicyNSObject {
    private static final int I_DEFAULT_FILE_TRANSFER = 0;
    private static final int I_DEFAULT_FILE_MAX_SEND_SIZE = 1024;
    private static final int I_DEFAULT_FILE_MAX_RECEIVE_SIZE = 1024;
    public static final int I_DEFAULT_MAX_CONTACTS = 100;
    public static final int I_DEFAULT_MAX_FOLDERS = 50;
    public static final boolean B_DEFAULT_SERVICES = true;
    public static final boolean B_DEFAULT_ARCHIVE = false;
    public static final boolean B_DEFAULT_PERSONALHISTORY = true;
    public static final boolean B_DEFAULT_PRINTSAVE = true;
    public static final boolean B_DEFAULT_QUERY = true;
    public static final boolean B_DEFAULT_CHAT = true;
    public static final boolean B_DEFAULT_CHATCREATE = false;
    public static final boolean B_DEFAULT_BROADCAST = true;
    public static final boolean B_DEFAULT_BROADCASTSYSTEM = false;
    public static final boolean B_DEFAULT_CONFERENCING = false;
    private static final int I_ATTR_TYPE_UNKNOWN = 0;
    private static final int I_ATTR_TYPE_INT = 1;
    private static final int I_ATTR_TYPE_STRING = 2;
    private static final int I_ATTR_TYPE_VECTOR = 3;
    private static final int I_ATTR_TYPE_BOOLEAN = 4;
    public static final int I_MAX_CONTACTS_LIMIT = 1000;
    public static final int I_MAX_FOLDERS_LIMIT = 100;
    public static final int I_SYSTEM_LEVEL_LOCK = 0;
    private static final int I_POLICY_LEVEL_LOCK = 1;
    public static final int I_POLICY_SERVICES = 0;
    private static final int I_POLICY_LOCKED_ATTR_LIST = 1;
    public static final int I_POLICY_SCOPE_PROFILE = 2;
    public static final int I_POLICY_BLOCKING = 3;
    public static final int I_POLICY_BLOCKING_ALLOW_LIST = 5;
    private static final int I_POLICY_BLOCKING_ALLOW_EXT_LIST = 6;
    public static final int I_POLICY_BLOCKING_DENY_LIST = 7;
    private static final int I_POLICY_BLOCKING_DENY_EXT_LIST = 8;
    public static final int I_POLICY_CONTACT_LIST = 9;
    public static final int I_POLICY_INFORMATION_DISPLAY_LIST = 10;
    public static final int I_POLICY_FILE_TRANSFER = 11;
    public static final int I_POLICY_FILE_MAX_SEND_SIZE = 12;
    public static final int I_POLICY_FILE_MAX_RECEIVE_SIZE = 13;
    public static final int I_POLICY_ARCHIVE = 14;
    public static final int I_POLICY_PASSWORD_CHANGE = 15;
    public static final int I_POLICY_PASSWORD_REMEMBER = 16;
    public static final int I_POLICY_QUERY = 17;
    public static final int I_POLICY_CUSTOM_STATUS_LIST = 18;
    public static final int I_POLICY_DEFAULT_HOST = 19;
    public static final int I_POLICY_SYSTEM_DN = 20;
    public static final int I_POLICY_REFERENCE_LIST = 21;
    public static final int I_POLICY_MAX_CONTACTS = 22;
    public static final int I_POLICY_MAX_FOLDERS = 23;
    public static final int I_POLICY_BROADCAST = 26;
    public static final int I_POLICY_BROADCASTSYSTEM = 27;
    public static final int I_POLICY_CHAT = 28;
    public static final int I_POLICY_CHATCREATE = 29;
    public static final int I_POLICY_PERSONALHISTORY = 30;
    public static final int I_POLICY_PRINTSAVE = 31;
    public static final int I_POLICY_CONFERENCING = 32;
    public static final String[] SA_POLICY_ATTRIBUTES = new String[]{"nnmServices", "nnmLockedAttrList", "nnmScopeProfileDN", "nnmBlocking", "nnmBlockingPrompt", "nnmBlockingAllowList", "nnmBlockingAllowExtList", "nnmBlockingDenyList", "nnmBlockingDenyExtList", "nnmContactList", "nnmInformationDisplayList", "nnmFileTransfer", "nnmFileMaxSendSize", "nnmFileMaxReceiveSize", "nnmArchive", "nnmPasswordChange", "nnmPasswordRemember", "nnmQuery", "nnmCustomStatusList", "nnmDefaultHost", "nnmSystemDN", "nnmReferenceList", "nnmMaxContacts", "nnmMaxFolders", "nnmBlockingAdminAllowList", "nnmBlockingAdminDenyList", "nnmBroadcast", "nnmSystemBroadcast", "nnmChatService", "nnmChatCreate", "nnmPersonalHistory", "nnmPrintSave", "nnmEnableConferencing"};
    private static final long[] IA_MASK_ATTRIBUTES = new long[]{1L, 2L, 4L, 8L, 16L, 32L, 64L, 128L, 256L, 512L, 1024L, 2048L, 4096L, 8192L, 16384L, 32768L, 65536L, 131072L, 262144L, 524288L, 0x100000L, 0x200000L, 0x400000L, 0x800000L, 0x1000000L, 0x2000000L, 0x4000000L, 0x8000000L, 0x10000000L, 0x20000000L, 0x40000000L, Integer.MIN_VALUE, 0x100000000L};
    private long m_lDirtyBits = 0L;
    private long m_lLockBits = 0L;
    private long m_lSystemLockBits = 0L;
    private long m_lSystemMergeBits = 0L;
    private NSObject m_nsObj;
    private NSObject m_sysNsObj;
    private NDSNegotiator neg;
    private NDSNamespace m_ndsNS;
    private boolean m_bRestoreDefaultSettings;
    private boolean m_bIsSystemPolicy;
    private int m_iFileTransfer;
    private int m_iFileMaxSendSize;
    private int m_iFileMaxReceiveSize;
    private int m_iMaxContacts;
    private int m_iMaxFolders;
    private boolean m_bServices;
    private boolean m_bArchive;
    private boolean m_bPersonalHistory;
    private boolean m_bPrintSave;
    private boolean m_bPasswordChange;
    private boolean m_bPasswordRemember;
    private boolean m_bQuery;
    private boolean m_bBroadcast;
    private boolean m_bBroadcastSystem;
    private boolean m_bChat;
    private boolean m_bChatCreate;
    private boolean m_bConferencingEnabled;
    private boolean m_bBlocking;
    private boolean m_bBlockingAllowListLocked = false;
    private boolean m_bBlockingDenyListLocked = false;
    private boolean m_bBlockingMerged;
    private boolean m_bBlockingAllowListMerged;
    private boolean m_bBlockingDenyListMerged;
    private String m_sScopeProfile;
    private String m_sDefaultHost;
    private String m_sSystemDN;
    private Vector m_vLockedAttrList;
    private Vector m_vContactList;
    private Vector m_vInformationDisplayList;
    private Vector m_vBlockingAllowList;
    private Vector m_vBlockingAllowExtList;
    private Vector m_vBlockingDenyList;
    private Vector m_vBlockingDenyExtList;
    private Vector m_vCustomStatusList;
    private Vector m_vReferenceList;
    private Vector m_vRefOrig = null;

    public void setFileTransfer(int n) {
        this.m_iFileTransfer = n;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[11];
    }

    public int getFileTransfer() {
        return this.m_iFileTransfer;
    }

    public void setFileMaxSendSize(int n) {
        this.m_iFileMaxSendSize = n;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[12];
    }

    public int getFileMaxSendSize() {
        return this.m_iFileMaxSendSize;
    }

    public void setFileMaxReceiveSize(int n) {
        this.m_iFileMaxReceiveSize = n;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[13];
    }

    public int getFileMaxReceiveSize() {
        return this.m_iFileMaxReceiveSize;
    }

    public void setServices(boolean bl) {
        this.m_bServices = bl;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[0];
    }

    public boolean getServices() {
        return this.m_bServices;
    }

    public void setArchive(boolean bl) {
        this.m_bArchive = bl;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[14];
    }

    public boolean getArchive() {
        return this.m_bArchive;
    }

    public void setPersonalHistory(boolean bl) {
        this.m_bPersonalHistory = bl;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[30];
    }

    public boolean getPersonalHistory() {
        return this.m_bPersonalHistory;
    }

    public void setPrintSave(boolean bl) {
        this.m_bPrintSave = bl;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[31];
    }

    public boolean getPrintSave() {
        return this.m_bPrintSave;
    }

    public void setPasswordChange(boolean bl) {
        this.m_bPasswordChange = bl;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[15];
    }

    public boolean getPasswordChange() {
        return this.m_bPasswordChange;
    }

    public void setPasswordRemember(boolean bl) {
        this.m_bPasswordRemember = bl;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[16];
    }

    public boolean getPasswordRemember() {
        return this.m_bPasswordRemember;
    }

    public void setQuery(boolean bl) {
        this.m_bQuery = bl;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[17];
    }

    public boolean getQuery() {
        return this.m_bQuery;
    }

    public void setBroadcast(boolean bl) {
        this.m_bBroadcast = bl;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[26];
    }

    public boolean getBroadcast() {
        return this.m_bBroadcast;
    }

    public void setBroadcastSystem(boolean bl) {
        this.m_bBroadcastSystem = bl;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[27];
    }

    public boolean getBroadcastSystem() {
        return this.m_bBroadcastSystem;
    }

    public void setChat(boolean bl) {
        this.m_bChat = bl;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[28];
    }

    public boolean getChat() {
        return this.m_bChat;
    }

    public void setChatCreate(boolean bl) {
        this.m_bChatCreate = bl;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[29];
    }

    public boolean getChatCreate() {
        return this.m_bChatCreate;
    }

    public void setConferencingEnabled(boolean bl) {
        this.m_bConferencingEnabled = bl;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[32];
    }

    public boolean getConferencingEnabled() {
        return this.m_bConferencingEnabled;
    }

    public void setBlocking(boolean bl) {
        this.m_bBlocking = bl;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[3];
    }

    public boolean getBlocking() {
        return this.m_bBlocking;
    }

    public void setScopeProfile(String string) {
        this.m_sScopeProfile = string;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[2];
    }

    public String getScopeProfile() {
        return this.m_sScopeProfile;
    }

    public void setSystemDN(String string) {
        this.m_sSystemDN = string;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[20];
    }

    private String getSystemDN() {
        return this.m_sSystemDN;
    }

    public void setDefaultHost(String string) {
        this.m_sDefaultHost = string;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[19];
    }

    public String getDefaultHost() {
        return this.m_sDefaultHost;
    }

    private void setLockedAttrList(Vector vector) {
        this.m_vLockedAttrList = vector;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[1];
    }

    private Vector getLockedAttrList() {
        return this.m_vLockedAttrList;
    }

    public void setContactList(Vector vector) {
        this.m_vContactList = vector;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[9];
    }

    public Vector getContactList() {
        return this.m_vContactList;
    }

    public void setInformationDisplayList(Vector vector) {
        this.m_vInformationDisplayList = vector;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[10];
    }

    public Vector getInformationDisplayList() {
        return this.m_vInformationDisplayList;
    }

    public void setBlockingAllowList(Vector vector) {
        this.m_vBlockingAllowList = vector;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[5];
    }

    public Vector getBlockingAllowList() {
        return this.m_vBlockingAllowList;
    }

    public boolean isBlockingAllowListLocked() {
        return this.m_bBlockingAllowListLocked;
    }

    private void setBlockingAllowExtList(Vector vector) {
        this.m_vBlockingAllowExtList = vector;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[6];
    }

    private Vector getBlockingAllowExtList() {
        return this.m_vBlockingAllowExtList;
    }

    public void setBlockingDenyList(Vector vector) {
        this.m_vBlockingDenyList = vector;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[7];
    }

    public Vector getBlockingDenyList() {
        return this.m_vBlockingDenyList;
    }

    private void setBlockingDenyExtList(Vector vector) {
        this.m_vBlockingDenyExtList = vector;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[8];
    }

    private Vector getBlockingDenyExtList() {
        return this.m_vBlockingDenyExtList;
    }

    public boolean isBlockingDenyListLocked() {
        return this.m_bBlockingDenyListLocked;
    }

    public void setCustomStatusList(Vector vector) {
        this.m_vCustomStatusList = vector;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[18];
    }

    public Vector getCustomStatusList() {
        return this.m_vCustomStatusList;
    }

    public void setReferenceList(Vector vector) {
        this.m_vReferenceList = vector;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[21];
    }

    public Vector getReferenceList() {
        return this.m_vReferenceList;
    }

    public void setMaxContacts(int n) {
        this.m_iMaxContacts = n;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[22];
    }

    public int getMaxContacts() {
        return this.m_iMaxContacts;
    }

    public void setMaxFolders(int n) {
        this.m_iMaxFolders = n;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[23];
    }

    public int getMaxFolders() {
        return this.m_iMaxFolders;
    }

    public boolean isSystemPolicy() {
        return this.m_bIsSystemPolicy;
    }

    private void readLocks() {
        if (this.m_vLockedAttrList != null) {
            int n = this.m_vLockedAttrList.size();
            for (int i = 0; i < n; ++i) {
                String string = (String)this.m_vLockedAttrList.elementAt(i);
                for (int j = 0; j < SA_POLICY_ATTRIBUTES.length; ++j) {
                    if (!string.equals(SA_POLICY_ATTRIBUTES[j])) continue;
                    this.m_lLockBits |= IA_MASK_ATTRIBUTES[j];
                }
            }
        }
    }

    public boolean isAttributeMerged(int n) {
        boolean bl;
        switch (n) {
            case 0: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                bl = (this.m_lSystemMergeBits & IA_MASK_ATTRIBUTES[n]) != 0L;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public boolean isAttributeLocked(int n) {
        return this.isAttributeLocked(n, 1);
    }

    public boolean isAttributeLocked(int n, int n2) {
        boolean bl;
        switch (n) {
            case 0: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                long l = n2 == 0 ? this.m_lSystemLockBits : this.m_lLockBits;
                bl = (l & IA_MASK_ATTRIBUTES[n]) != 0L;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public void lockAttribute(int n, boolean bl) {
        if (bl && this.m_vLockedAttrList == null) {
            this.m_vLockedAttrList = new Vector();
        }
        switch (n) {
            case 0: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                if (bl) {
                    this.m_vLockedAttrList.addElement(SA_POLICY_ATTRIBUTES[n]);
                } else if (this.m_vLockedAttrList != null) {
                    int n2 = this.m_vLockedAttrList.size();
                    for (int i = 0; i < n2; ++i) {
                        String string = (String)this.m_vLockedAttrList.elementAt(i);
                        if (!string.equals(SA_POLICY_ATTRIBUTES[n])) continue;
                        this.m_vLockedAttrList.removeElementAt(i);
                        break;
                    }
                }
                this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[1];
                break;
            }
        }
    }

    private void readSystemLocks(NDSNamespace nDSNamespace) {
        if (this.m_sSystemDN != null) {
            try {
                NSObject nSObject = this.neg.getNSObject(nDSNamespace, this.m_sSystemDN);
                String string = this.neg.getAttribute(nSObject, "nnmPolicyDN");
                if (string != null) {
                    ObjectEntry objectEntry;
                    ObjectEntry objectEntry2 = this.m_nsObj.getObjectEntry();
                    if (objectEntry2.equals((Object)(objectEntry = nDSNamespace.getObjectEntry(string)))) {
                        this.m_bIsSystemPolicy = true;
                        return;
                    }
                    NSObject nSObject2 = this.neg.getNSObject(nDSNamespace, string);
                    Vector vector = this.neg.getMultiValuedAttribute(nSObject2, "nnmLockedAttrList");
                    if (vector != null) {
                        int n = vector.size();
                        for (int i = 0; i < n; ++i) {
                            String string2 = (String)vector.elementAt(i);
                            for (int j = 0; j < SA_POLICY_ATTRIBUTES.length; ++j) {
                                if (!string2.equals(SA_POLICY_ATTRIBUTES[j])) continue;
                                this.m_lSystemLockBits |= IA_MASK_ATTRIBUTES[j];
                                int n2 = PolicyNSObject.getAttributeType(j);
                                if (n2 == 3) {
                                    Vector vector2 = this.neg.getMultiValuedAttribute(nSObject2, SA_POLICY_ATTRIBUTES[j]);
                                    this.mergeAttributeForced(j, vector2);
                                    continue;
                                }
                                String string3 = this.neg.getAttribute(nSObject2, SA_POLICY_ATTRIBUTES[j]);
                                this.mergeAttributeForced(j, string3, n2);
                            }
                        }
                    }
                }
            }
            catch (Exception exception) {
                Debug.trace("PolicyNSObject.readSystemLocks: Failed to get nsObj for the System: " + this.m_sSystemDN);
                Debug.traceException(exception);
            }
        }
    }

    public void restoreDefaultSettings(int n) {
        if (PolicyNSObject.getAttributeType(n) == 0) {
            return;
        }
        if (PolicyNSObject.getAttributeType(n) == 3) {
            this.neg.setMultiValuedAttribute(this.m_nsObj, SA_POLICY_ATTRIBUTES[n], null);
            this.mergeAttributeForced(n, this.mergeMultiValuedAttribute(n));
        } else {
            this.neg.setAttribute(this.m_nsObj, SA_POLICY_ATTRIBUTES[n], null);
            this.mergeAttributeForced(n, this.mergeAttribute(n));
        }
        this.m_bRestoreDefaultSettings = true;
    }

    private static int getAttributeType(int n) {
        int n2;
        switch (n) {
            case 11: 
            case 12: 
            case 13: 
            case 22: 
            case 23: {
                n2 = 1;
                break;
            }
            case 0: 
            case 3: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                n2 = 4;
                break;
            }
            case 2: 
            case 19: {
                n2 = 2;
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 18: {
                n2 = 3;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        return n2;
    }

    private void mergeAttributeForced(int n, String string) {
        this.mergeAttributeForced(n, string, PolicyNSObject.getAttributeType(n));
    }

    private void mergeAttributeForced(int n, String string, int n2) {
        if (n2 == 1) {
            int n3;
            try {
                n3 = Integer.parseInt(string);
            }
            catch (Exception exception) {
                n3 = 0;
            }
            switch (n) {
                case 11: {
                    this.setFileTransfer(n3);
                    break;
                }
                case 12: {
                    this.setFileMaxSendSize(n3);
                    break;
                }
                case 13: {
                    this.setFileMaxReceiveSize(n3);
                    break;
                }
                case 22: {
                    this.setMaxContacts(n3);
                    break;
                }
                case 23: {
                    this.setMaxFolders(n3);
                    break;
                }
            }
        } else if (n2 == 4) {
            boolean bl = string != null && string.equals("1");
            switch (n) {
                case 0: {
                    this.setServices(bl);
                    break;
                }
                case 3: {
                    this.setBlocking(bl);
                    break;
                }
                case 14: {
                    this.setArchive(bl);
                    break;
                }
                case 30: {
                    this.setPersonalHistory(bl);
                    break;
                }
                case 31: {
                    this.setPrintSave(bl);
                    break;
                }
                case 15: {
                    this.setPasswordChange(bl);
                    break;
                }
                case 16: {
                    this.setPasswordRemember(bl);
                    break;
                }
                case 17: {
                    this.setQuery(bl);
                    break;
                }
                case 26: {
                    this.setBroadcast(bl);
                    break;
                }
                case 27: {
                    this.setBroadcastSystem(bl);
                    break;
                }
                case 28: {
                    this.setChat(bl);
                    break;
                }
                case 29: {
                    this.setChatCreate(bl);
                    break;
                }
                case 32: {
                    this.setConferencingEnabled(bl);
                    break;
                }
            }
        } else {
            switch (n) {
                case 2: {
                    this.setScopeProfile(string);
                    break;
                }
                case 19: {
                    this.setDefaultHost(string);
                    break;
                }
            }
        }
    }

    protected boolean isConferencingURLSet() {
        Object object;
        try {
            object = (NDSNamespace)this.m_nsObj.getObjectEntry().getNamespace();
            this.m_sysNsObj = this.neg.getNSObject((NDSNamespace)object, this.m_sSystemDN);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.m_sysNsObj != null) {
            object = this.neg.getMultiValuedAttribute(this.m_sysNsObj, NNMSystemNSObject.SA_SYSTEM_ATTRIBUTES[23]);
            if (object == null) {
                return false;
            }
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                String string = (String)((Vector)object).elementAt(i);
                int n = string.indexOf(";");
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1, string.length());
                if (!string2.equals("url") || string3.length() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    private void mergeAttributeForced(int n, Vector vector) {
        switch (n) {
            case 5: {
                this.setBlockingAllowList(vector);
                break;
            }
            case 6: {
                this.setBlockingAllowExtList(vector);
                break;
            }
            case 7: {
                this.setBlockingDenyList(vector);
                break;
            }
            case 8: {
                this.setBlockingDenyExtList(vector);
                break;
            }
            case 9: {
                this.setContactList(vector);
                break;
            }
            case 10: {
                this.setInformationDisplayList(vector);
                break;
            }
            case 18: {
                this.setCustomStatusList(vector);
                break;
            }
        }
    }

    private String mergeAttribute(int n) {
        String string = this.neg.getAttribute(this.m_nsObj, SA_POLICY_ATTRIBUTES[n]);
        if (string == null) {
            NDSNamespace nDSNamespace = (NDSNamespace)this.m_nsObj.getObjectEntry().getNamespace();
            if (this.m_sysNsObj == null) {
                if (this.m_sSystemDN != null) {
                    try {
                        NSObject nSObject = this.neg.getNSObject(nDSNamespace, this.m_sSystemDN);
                        String string2 = this.neg.getAttribute(nSObject, NNMSystemNSObject.SA_SYSTEM_ATTRIBUTES[3]);
                        if (string2 == null) {
                            return null;
                        }
                        this.m_sysNsObj = this.neg.getNSObject(nDSNamespace, string2);
                    }
                    catch (Exception exception) {
                        return null;
                    }
                } else {
                    return null;
                }
            }
            string = this.neg.getAttribute(this.m_sysNsObj, SA_POLICY_ATTRIBUTES[n]);
            this.m_lSystemMergeBits |= IA_MASK_ATTRIBUTES[n];
        }
        return string;
    }

    private Vector mergeMultiValuedAttribute(int n) {
        Vector vector = this.neg.getMultiValuedAttribute(this.m_nsObj, SA_POLICY_ATTRIBUTES[n]);
        if (vector == null) {
            NDSNamespace nDSNamespace = (NDSNamespace)this.m_nsObj.getObjectEntry().getNamespace();
            if (this.m_sysNsObj == null) {
                if (this.m_sSystemDN != null) {
                    try {
                        NSObject nSObject = this.neg.getNSObject(nDSNamespace, this.m_sSystemDN);
                        String string = this.neg.getAttribute(nSObject, NNMSystemNSObject.SA_SYSTEM_ATTRIBUTES[3]);
                        if (string == null) {
                            return null;
                        }
                        this.m_sysNsObj = this.neg.getNSObject(nDSNamespace, string);
                    }
                    catch (Exception exception) {
                        return null;
                    }
                } else {
                    return null;
                }
            }
            vector = this.neg.getMultiValuedAttribute(this.m_sysNsObj, SA_POLICY_ATTRIBUTES[n]);
            this.m_lSystemMergeBits |= IA_MASK_ATTRIBUTES[n];
        }
        return vector;
    }

    public boolean load(NSObject nSObject) {
        int n;
        this.neg = new NDSNegotiator();
        this.m_nsObj = nSObject;
        this.m_ndsNS = (NDSNamespace)this.m_nsObj.getObjectEntry().getNamespace();
        this.m_bRestoreDefaultSettings = false;
        this.m_bIsSystemPolicy = false;
        this.setSystemDN(this.neg.getAttribute(this.m_nsObj, "nnmSystemDN"));
        this.setScopeProfile(this.mergeAttribute(2));
        this.setDefaultHost(this.mergeAttribute(19));
        String string = this.mergeAttribute(0);
        boolean bl = string != null && string.equals("1");
        this.setServices(bl);
        this.m_bBlockingMerged = false;
        string = this.neg.getAttribute(this.m_nsObj, SA_POLICY_ATTRIBUTES[3]);
        if (string == null) {
            string = this.mergeAttribute(3);
            this.m_bBlockingMerged = true;
        }
        bl = string != null && string.equals("1");
        this.setBlocking(bl);
        string = this.mergeAttribute(14);
        bl = string != null && string.equals("1");
        this.setArchive(bl);
        string = this.mergeAttribute(30);
        bl = string != null && string.equals("1");
        this.setPersonalHistory(bl);
        string = this.mergeAttribute(31);
        bl = string != null && string.equals("1");
        this.setPrintSave(bl);
        string = this.mergeAttribute(15);
        bl = string != null && string.equals("1");
        this.setPasswordChange(bl);
        string = this.mergeAttribute(16);
        bl = string != null && string.equals("1");
        this.setPasswordRemember(bl);
        string = this.mergeAttribute(17);
        bl = string != null && string.equals("1");
        this.setQuery(bl);
        string = this.mergeAttribute(26);
        bl = string != null && string.equals("1");
        this.setBroadcast(bl);
        string = this.mergeAttribute(27);
        bl = string != null && string.equals("1");
        this.setBroadcastSystem(bl);
        string = this.mergeAttribute(28);
        bl = string != null && string.equals("1");
        this.setChat(bl);
        string = this.mergeAttribute(29);
        bl = string != null && string.equals("1");
        this.setChatCreate(bl);
        string = this.mergeAttribute(32);
        bl = string != null && string.equals("1");
        this.setConferencingEnabled(bl);
        try {
            n = Integer.parseInt(this.mergeAttribute(11));
        }
        catch (Exception exception) {
            n = 0;
        }
        this.setFileTransfer(n);
        try {
            n = Integer.parseInt(this.mergeAttribute(12));
        }
        catch (Exception exception) {
            n = 1024;
        }
        this.setFileMaxSendSize(n);
        try {
            n = Integer.parseInt(this.mergeAttribute(13));
        }
        catch (Exception exception) {
            n = 1024;
        }
        this.setFileMaxReceiveSize(n);
        try {
            n = Integer.parseInt(this.mergeAttribute(22));
        }
        catch (Exception exception) {
            n = 100;
        }
        this.setMaxContacts(n);
        try {
            n = Integer.parseInt(this.mergeAttribute(23));
        }
        catch (Exception exception) {
            n = 50;
        }
        this.setMaxFolders(n);
        this.setContactList(this.mergeMultiValuedAttribute(9));
        this.setInformationDisplayList(this.mergeMultiValuedAttribute(10));
        this.setLockedAttrList(this.mergeMultiValuedAttribute(1));
        this.m_bBlockingAllowListMerged = false;
        Vector vector = this.neg.getMultiValuedAttribute(this.m_nsObj, SA_POLICY_ATTRIBUTES[5]);
        if (vector == null) {
            vector = this.mergeMultiValuedAttribute(5);
            this.m_bBlockingAllowListMerged = true;
        }
        this.setBlockingAllowList(vector);
        this.setBlockingAllowExtList(this.mergeMultiValuedAttribute(6));
        this.m_bBlockingDenyListMerged = false;
        vector = this.neg.getMultiValuedAttribute(this.m_nsObj, SA_POLICY_ATTRIBUTES[7]);
        if (vector == null) {
            vector = this.mergeMultiValuedAttribute(7);
            this.m_bBlockingDenyListMerged = true;
        }
        this.setBlockingDenyList(vector);
        this.setBlockingDenyExtList(this.mergeMultiValuedAttribute(8));
        this.setCustomStatusList(this.mergeMultiValuedAttribute(18));
        this.setReferenceList(this.neg.getMultiValuedAttribute(this.m_nsObj, SA_POLICY_ATTRIBUTES[21]));
        this.m_vRefOrig = this.m_vReferenceList;
        if (!(this.m_bBlockingMerged && this.m_bBlockingAllowListMerged && this.m_bBlockingDenyListMerged)) {
            if (this.m_bBlockingMerged) {
                this.setBlocking(false);
            }
            if (this.m_bBlockingAllowListMerged) {
                this.setBlockingAllowList(null);
            }
            if (this.m_bBlockingDenyListMerged) {
                this.setBlockingDenyList(null);
            }
        }
        this.readLocks();
        this.readSystemLocks((NDSNamespace)this.m_nsObj.getObjectEntry().getNamespace());
        this.m_lDirtyBits = 0L;
        return true;
    }

    private void updateVectorObjects(Vector vector, Vector vector2, String string) {
        Vector vector3 = vector == null ? new Vector() : (Vector)vector.clone();
        Vector vector4 = vector2 == null ? new Vector() : (Vector)vector2.clone();
        for (int i = 0; i < vector3.size(); ++i) {
            String string2 = (String)vector3.elementAt(i);
            if (vector4.contains(string2)) continue;
            try {
                NSObject nSObject = this.neg.getNSObject(this.m_ndsNS, string2);
                this.neg.setAttribute(nSObject, "nnmPolicyDN", string);
                this.neg.update(nSObject);
                continue;
            }
            catch (Exception exception) {
                Debug.trace("PolicyNSObject.updateVectorObjects: dn= " + string2);
                Debug.trace("   ex2= " + exception);
            }
        }
    }

    public boolean save(NSObject nSObject) {
        boolean bl = false;
        if (!this.m_bRestoreDefaultSettings) {
            String string;
            if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[2]) != 0L) {
                this.neg.setAttribute(this.m_nsObj, "nnmScopeProfileDN", this.getScopeProfile());
            }
            if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[19]) != 0L) {
                this.neg.setAttribute(this.m_nsObj, "nnmDefaultHost", this.getDefaultHost());
            }
            if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[20]) != 0L) {
                this.neg.setAttribute(this.m_nsObj, "nnmSystemDN", this.getSystemDN());
            }
            if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[0]) != 0L) {
                string = this.getServices() ? "1" : "0";
                this.neg.setAttribute(this.m_nsObj, "nnmServices", string);
            }
            if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[14]) != 0L) {
                string = this.getArchive() ? "1" : "0";
                this.neg.setAttribute(this.m_nsObj, "nnmArchive", string);
            }
            if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[30]) != 0L) {
                string = this.getPersonalHistory() ? "1" : "0";
                this.neg.setAttribute(this.m_nsObj, "nnmPersonalHistory", string);
            }
            if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[31]) != 0L) {
                string = this.getPrintSave() ? "1" : "0";
                this.neg.setAttribute(this.m_nsObj, "nnmPrintSave", string);
            }
            if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[3]) != 0L) {
                string = this.getBlocking() ? "1" : "0";
                this.neg.setAttribute(this.m_nsObj, "nnmBlocking", string);
            }
            if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[15]) != 0L) {
                string = this.getPasswordChange() ? "1" : "0";
                this.neg.setAttribute(this.m_nsObj, "nnmPasswordChange", string);
            }
            if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[16]) != 0L) {
                string = this.getPasswordRemember() ? "1" : "0";
                this.neg.setAttribute(this.m_nsObj, "nnmPasswordRemember", string);
            }
            if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[17]) != 0L) {
                string = this.getQuery() ? "1" : "0";
                this.neg.setAttribute(this.m_nsObj, "nnmQuery", string);
            }
            if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[26]) != 0L) {
                string = this.getBroadcast() ? "1" : "0";
                this.neg.setAttribute(this.m_nsObj, "nnmBroadcast", string);
            }
            if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[27]) != 0L) {
                string = this.getBroadcastSystem() ? "1" : "0";
                this.neg.setAttribute(this.m_nsObj, "nnmSystemBroadcast", string);
            }
            if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[28]) != 0L) {
                string = this.getChat() ? "1" : "0";
                this.neg.setAttribute(this.m_nsObj, "nnmChatService", string);
            }
            if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[29]) != 0L) {
                string = this.getChatCreate() ? "1" : "0";
                this.neg.setAttribute(this.m_nsObj, "nnmChatCreate", string);
            }
            if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[32]) != 0L) {
                string = this.getConferencingEnabled() ? "1" : "0";
                this.neg.setAttribute(this.m_nsObj, "nnmEnableConferencing", string);
            }
            if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[11]) != 0L) {
                string = String.valueOf(this.getFileTransfer());
                this.neg.setAttribute(this.m_nsObj, "nnmFileTransfer", string);
            }
            if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[12]) != 0L) {
                string = String.valueOf(this.getFileMaxSendSize());
                this.neg.setAttribute(this.m_nsObj, "nnmFileMaxSendSize", string);
            }
            if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[13]) != 0L) {
                string = String.valueOf(this.getFileMaxReceiveSize());
                this.neg.setAttribute(this.m_nsObj, "nnmFileMaxReceiveSize", string);
            }
            if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[22]) != 0L) {
                string = String.valueOf(this.getMaxContacts());
                this.neg.setAttribute(this.m_nsObj, "nnmMaxContacts", string);
            }
            if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[23]) != 0L) {
                string = String.valueOf(this.getMaxFolders());
                this.neg.setAttribute(this.m_nsObj, "nnmMaxFolders", string);
            }
            if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[9]) != 0L) {
                this.neg.setMultiValuedAttribute(this.m_nsObj, "nnmContactList", this.getContactList());
            }
            if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[10]) != 0L) {
                this.neg.setMultiValuedAttribute(this.m_nsObj, "nnmInformationDisplayList", this.getInformationDisplayList());
            }
            if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[1]) != 0L) {
                this.neg.setMultiValuedAttribute(this.m_nsObj, "nnmLockedAttrList", this.getLockedAttrList());
            }
            if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[5]) != 0L) {
                this.neg.setMultiValuedAttribute(this.m_nsObj, "nnmBlockingAllowList", this.getBlockingAllowList());
            }
            if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[6]) != 0L) {
                this.neg.setMultiValuedAttribute(this.m_nsObj, "nnmBlockingAllowExtList", this.getBlockingAllowExtList());
            }
            if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[7]) != 0L) {
                this.neg.setMultiValuedAttribute(this.m_nsObj, "nnmBlockingDenyList", this.getBlockingDenyList());
            }
            if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[8]) != 0L) {
                this.neg.setMultiValuedAttribute(this.m_nsObj, "nnmBlockingDenyExtList", this.getBlockingDenyExtList());
            }
            if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[18]) != 0L) {
                this.neg.setMultiValuedAttribute(this.m_nsObj, "nnmCustomStatusList", this.getCustomStatusList());
            }
            if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[21]) != 0L) {
                Vector vector = this.getReferenceList();
                this.neg.setMultiValuedAttribute(this.m_nsObj, "nnmReferenceList", vector);
                this.updateVectorObjects(this.m_vRefOrig, vector, null);
                this.updateVectorObjects(vector, this.m_vRefOrig, this.m_ndsNS.getUnrootedName(this.m_nsObj.getObjectEntry()));
            }
            this.m_lDirtyBits = 0L;
        }
        if (!(bl = this.neg.update(this.m_nsObj))) {
            System.out.println("================= Save failed");
        }
        this.load(this.m_nsObj);
        this.m_bRestoreDefaultSettings = false;
        return bl;
    }
}

