/*
 * Decompiled with CFR 0.152.
 */
package com.novell.netmessenger.admin.policy;

import com.novell.admin.common.snapins.AdminPageSnapin;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.application.console.snapin.InitSnapinInfo;
import com.novell.application.console.snapin.NamespaceSnapin;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectType;
import com.novell.application.console.snapin.PageSnapin;
import com.novell.application.console.util.objectentryselector.ObjectEntrySelector;
import com.novell.netmessenger.admin.policy.PolicyAdminPage;
import com.novell.netmessenger.admin.policy.PolicyResource;
import com.novell.netmessenger.admin.swingext.JButtonExt;
import com.novell.netmessenger.admin.swingext.JLabelExt;
import com.novell.netmessenger.admin.swingext.JListExt;
import com.novell.utility.nmsgbox.NMsgBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PolicyPanelBlocking
extends PolicyAdminPage
implements ActionListener,
FocusListener,
ListSelectionListener,
MouseListener {
    private JListExt m_listBlockingAllow;
    private JListExt m_listBlockingDeny;
    private JButton m_btnBlockingAllow;
    private JButton m_btnBlockingDeny;
    private JButton m_btnBlockingAdd;
    private JButton m_btnBlockingRemove;
    private JButton m_btnBlockingLock;
    private boolean m_bDenyEveryone;
    protected JButtonExt m_btnResetDefaultSettings;
    private Object m_objLastFocus;

    public PolicyPanelBlocking(InitSnapinInfo initSnapinInfo, AdminPageSnapin adminPageSnapin, NSObject nSObject) {
        super(initSnapinInfo, adminPageSnapin, nSObject);
    }

    protected void init() {
        this.m_listBlockingAllow = new JListExt(new DefaultListModel(), PolicyResource.get("PolicyBlockingAllowTip"));
        this.m_listBlockingDeny = new JListExt(new DefaultListModel(), PolicyResource.get("PolicyBlockingDenyTip"));
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/com/novell/netmessenger/admin/common/images/left.gif"));
        ImageIcon imageIcon2 = new ImageIcon(this.getClass().getResource("/com/novell/netmessenger/admin/common/images/right.gif"));
        ImageIcon imageIcon3 = new ImageIcon(this.getClass().getResource("/com/novell/netmessenger/admin/common/images/add.gif"));
        ImageIcon imageIcon4 = new ImageIcon(this.getClass().getResource("/com/novell/netmessenger/admin/common/images/remove.gif"));
        ImageIcon imageIcon5 = new ImageIcon(this.getClass().getResource("/com/novell/netmessenger/admin/common/images/default.gif"));
        Dimension dimension = new Dimension(this.m_iconSystemLevelLock.getIconWidth() + 10, this.m_iconSystemLevelLock.getIconHeight() + 10);
        this.m_btnBlockingLock = new JButton(this.m_iconLockOpen);
        this.m_btnBlockingLock.addActionListener(this);
        this.m_btnBlockingLock.setPreferredSize(dimension);
        this.m_btnBlockingLock.setMaximumSize(dimension);
        this.m_btnBlockingAllow = new JButton(imageIcon);
        this.m_btnBlockingAllow.addActionListener(this);
        this.m_btnBlockingAllow.setEnabled(false);
        this.m_btnBlockingAllow.setPreferredSize(dimension);
        this.m_btnBlockingAllow.setMaximumSize(dimension);
        this.m_btnBlockingDeny = new JButton(imageIcon2);
        this.m_btnBlockingDeny.addActionListener(this);
        this.m_btnBlockingDeny.setEnabled(false);
        this.m_btnBlockingDeny.setPreferredSize(dimension);
        this.m_btnBlockingDeny.setMaximumSize(dimension);
        this.m_btnBlockingAdd = new JButton(imageIcon3);
        this.m_btnBlockingAdd.addActionListener(this);
        this.m_btnBlockingAdd.setPreferredSize(dimension);
        this.m_btnBlockingAdd.setMaximumSize(dimension);
        this.m_btnBlockingRemove = new JButton(imageIcon4);
        this.m_btnBlockingRemove.addActionListener(this);
        this.m_btnBlockingRemove.setEnabled(false);
        this.m_btnBlockingRemove.setPreferredSize(dimension);
        this.m_btnBlockingRemove.setMaximumSize(dimension);
        this.m_btnResetDefaultSettings = new JButtonExt(PolicyResource.get("RestoreDefaultSettingsButton"));
        this.m_btnResetDefaultSettings.addActionListener(this);
        if (this.m_policyNSObject.isSystemPolicy()) {
            this.m_btnResetDefaultSettings.setVisible(false);
        }
    }

    public void layoutControls() {
        this.init();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.setLayout(new GridBagLayout());
        JPanel jPanel = this.createBlockingPanel();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.add(jPanel, gridBagConstraints);
    }

    private JPanel createBlockingPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        JLabelExt jLabelExt = new JLabelExt(PolicyResource.get("PolicyBlockingAllow"), this.m_listBlockingAllow);
        JLabelExt jLabelExt2 = new JLabelExt(PolicyResource.get("PolicyBlockingDeny"), this.m_listBlockingDeny);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        jPanel.add((Component)jLabelExt, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)jLabelExt2, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridheight = 6;
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane = new JScrollPane(this.m_listBlockingAllow);
        jScrollPane.setPreferredSize(new Dimension(250, 300));
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 15;
        jPanel.add((Component)this.m_btnBlockingAdd, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 15;
        jPanel.add((Component)this.m_btnBlockingAllow, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 11;
        jPanel.add((Component)this.m_btnBlockingDeny, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 11;
        jPanel.add((Component)this.m_btnBlockingRemove, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 11;
        jPanel.add((Component)this.m_btnBlockingLock, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridheight = 6;
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane2 = new JScrollPane(this.m_listBlockingDeny);
        jScrollPane2.setPreferredSize(new Dimension(250, 300));
        jPanel.add((Component)jScrollPane2, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)this.m_btnResetDefaultSettings, gridBagConstraints);
        return jPanel;
    }

    public void readData() {
        Vector vector = this.m_policyNSObject.getBlockingAllowList();
        DefaultListModel defaultListModel = (DefaultListModel)this.m_listBlockingAllow.getModel();
        if (vector != null) {
            defaultListModel.removeAllElements();
            for (int i = 0; i < vector.size(); ++i) {
                defaultListModel.addElement((String)vector.elementAt(i));
            }
        }
        Vector vector2 = this.m_policyNSObject.getBlockingDenyList();
        DefaultListModel defaultListModel2 = (DefaultListModel)this.m_listBlockingDeny.getModel();
        if (vector2 != null) {
            defaultListModel2.removeAllElements();
            for (int i = 0; i < vector2.size(); ++i) {
                defaultListModel2.addElement((String)vector2.elementAt(i));
            }
        }
        this.m_bDenyEveryone = this.m_policyNSObject.getBlocking();
        if (this.m_bDenyEveryone) {
            defaultListModel2.insertElementAt(PolicyResource.get("PolicyBlockingEveryoneElse"), 0);
        } else {
            defaultListModel.insertElementAt(PolicyResource.get("PolicyBlockingEveryoneElse"), 0);
        }
        this.initMergeIcons();
        this.initLocks();
        if (this.m_policyNSObject.isBlockingAllowListLocked() || this.m_policyNSObject.isBlockingDenyListLocked()) {
            this.setBlockingEnabled(false);
        }
        this.m_listBlockingAllow.addListSelectionListener(this);
        this.m_listBlockingAllow.addListDataListener(this);
        this.m_listBlockingAllow.addFocusListener(this);
        this.m_listBlockingAllow.addMouseListener(this);
        this.m_listBlockingDeny.addListSelectionListener(this);
        this.m_listBlockingDeny.addListDataListener(this);
        this.m_listBlockingDeny.addFocusListener(this);
        this.m_listBlockingDeny.addMouseListener(this);
    }

    protected void initMergeIcons() {
        if (this.m_policyNSObject.isAttributeMerged(5) && this.m_policyNSObject.isAttributeMerged(7) && this.m_policyNSObject.isAttributeMerged(3)) {
            this.m_btnBlockingLock.setIcon(this.m_iconSystemLockOpen);
            this.m_btnBlockingLock.setToolTipText(PolicyResource.get("PolicyGlobalSystemLevelUnlock"));
        } else {
            this.m_btnBlockingLock.setIcon(this.m_iconLockOpen);
            this.m_btnBlockingLock.setToolTipText(PolicyResource.get("PolicyNotLocked"));
        }
    }

    protected void initLocks() {
        if (this.m_policyNSObject.isAttributeLocked(5, 0) || this.m_policyNSObject.isAttributeLocked(7, 0) || this.m_policyNSObject.isAttributeLocked(3, 0)) {
            this.setUIEnabled(false);
            this.m_btnBlockingLock.setIcon(this.m_iconSystemLevelLock);
            this.m_btnBlockingLock.setToolTipText(PolicyResource.get("PolicyGlobalSystemLevelLock"));
        } else if (this.m_policyNSObject.isAttributeLocked(5) || this.m_policyNSObject.isAttributeLocked(7) || this.m_policyNSObject.isAttributeLocked(3)) {
            this.m_btnBlockingLock.setIcon(this.m_iconLockClosed);
            this.m_btnBlockingLock.setToolTipText(PolicyResource.get("PolicyLocked"));
        }
    }

    protected void setUIEnabled(boolean bl) {
        this.m_listBlockingAllow.setEnabled(bl);
        this.m_listBlockingDeny.setEnabled(bl);
        this.m_btnBlockingLock.setEnabled(bl);
        this.m_btnBlockingAdd.setEnabled(bl);
        this.m_btnBlockingRemove.setEnabled(bl);
        this.m_btnBlockingAllow.setEnabled(bl);
        this.m_btnBlockingDeny.setEnabled(bl);
        this.m_btnBlockingLock.setEnabled(bl);
        this.m_btnResetDefaultSettings.setEnabled(bl);
    }

    public boolean saveData() {
        Enumeration enumeration;
        DefaultListModel defaultListModel;
        Vector vector;
        if (this.m_listBlockingAllow.isModified()) {
            vector = new Vector();
            defaultListModel = (DefaultListModel)this.m_listBlockingAllow.getModel();
            enumeration = defaultListModel.elements();
            if (enumeration != null) {
                if (!this.m_bDenyEveryone) {
                    enumeration.nextElement();
                }
                while (enumeration.hasMoreElements()) {
                    vector.addElement(enumeration.nextElement());
                }
                this.m_policyNSObject.setBlockingAllowList(vector);
            }
        }
        if (this.m_listBlockingDeny.isModified()) {
            vector = new Vector();
            defaultListModel = (DefaultListModel)this.m_listBlockingDeny.getModel();
            enumeration = defaultListModel.elements();
            if (enumeration != null) {
                if (this.m_bDenyEveryone) {
                    enumeration.nextElement();
                }
                while (enumeration.hasMoreElements()) {
                    vector.addElement(enumeration.nextElement());
                }
                this.m_policyNSObject.setBlockingDenyList(vector);
            }
        }
        if (this.m_listBlockingAllow.isModified() || this.m_listBlockingDeny.isModified()) {
            this.m_policyNSObject.setBlocking(this.m_bDenyEveryone);
        }
        return true;
    }

    protected void restoreDefaultSettings() {
        this.m_policyNSObject.restoreDefaultSettings(3);
        this.m_policyNSObject.restoreDefaultSettings(5);
        this.m_policyNSObject.restoreDefaultSettings(7);
        this.m_listBlockingAllow.removeAllElements();
        this.m_listBlockingDeny.removeAllElements();
        this.readData();
    }

    private void setBlockingEnabled(boolean bl) {
        if (!bl) {
            this.m_listBlockingAllow.setEnabled(false);
            this.m_listBlockingDeny.setEnabled(false);
            this.m_btnBlockingAdd.setEnabled(false);
            this.m_btnBlockingAllow.setEnabled(false);
            this.m_btnBlockingDeny.setEnabled(false);
            this.m_btnBlockingRemove.setEnabled(false);
            this.m_btnBlockingLock.setEnabled(false);
            this.m_btnBlockingLock.setIcon(this.m_iconLockClosed);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_btnBlockingAdd) {
            String[] stringArray = this.selectObject();
            if (stringArray != null) {
                DefaultListModel defaultListModel;
                DefaultListModel defaultListModel2;
                if (this.m_objLastFocus == null || this.m_objLastFocus == this.m_listBlockingAllow) {
                    defaultListModel2 = (DefaultListModel)this.m_listBlockingAllow.getModel();
                    defaultListModel = (DefaultListModel)this.m_listBlockingDeny.getModel();
                    this.m_listBlockingAllow.setModified(true);
                } else {
                    defaultListModel2 = (DefaultListModel)this.m_listBlockingDeny.getModel();
                    defaultListModel = (DefaultListModel)this.m_listBlockingAllow.getModel();
                    this.m_listBlockingDeny.setModified(true);
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    if (defaultListModel2.contains(stringArray[i]) || defaultListModel.contains(stringArray[i])) continue;
                    defaultListModel2.addElement(stringArray[i]);
                }
                this.propertyBook.setModified(true, (PageSnapin)this.pageSnapin);
            }
        } else if (object == this.m_btnBlockingAllow) {
            DefaultListModel defaultListModel = (DefaultListModel)this.m_listBlockingAllow.getModel();
            DefaultListModel defaultListModel3 = (DefaultListModel)this.m_listBlockingDeny.getModel();
            int[] nArray = this.m_listBlockingDeny.getSelectedIndices();
            for (int i = nArray.length - 1; i >= 0; --i) {
                if (nArray[i] == 0 && this.m_bDenyEveryone) {
                    defaultListModel.insertElementAt(defaultListModel3.remove(nArray[i]), 0);
                    this.m_bDenyEveryone = false;
                    continue;
                }
                defaultListModel.addElement(defaultListModel3.remove(nArray[i]));
            }
            this.m_btnBlockingAllow.setEnabled(false);
            this.m_btnBlockingRemove.setEnabled(false);
            this.m_listBlockingAllow.setModified(true);
            this.m_listBlockingDeny.setModified(true);
            this.propertyBook.setModified(true, (PageSnapin)this.pageSnapin);
        } else if (object == this.m_btnBlockingDeny) {
            DefaultListModel defaultListModel = (DefaultListModel)this.m_listBlockingAllow.getModel();
            DefaultListModel defaultListModel4 = (DefaultListModel)this.m_listBlockingDeny.getModel();
            int[] nArray = this.m_listBlockingAllow.getSelectedIndices();
            for (int i = nArray.length - 1; i >= 0; --i) {
                if (nArray[i] == 0 && !this.m_bDenyEveryone) {
                    defaultListModel4.insertElementAt(defaultListModel.remove(nArray[i]), 0);
                    this.m_bDenyEveryone = true;
                    continue;
                }
                defaultListModel4.addElement(defaultListModel.remove(nArray[i]));
            }
            this.m_btnBlockingDeny.setEnabled(false);
            this.m_btnBlockingRemove.setEnabled(false);
            this.m_listBlockingAllow.setModified(true);
            this.m_listBlockingDeny.setModified(true);
            this.propertyBook.setModified(true, (PageSnapin)this.pageSnapin);
        } else if (object == this.m_btnBlockingRemove) {
            int[] nArray;
            DefaultListModel defaultListModel;
            boolean bl = false;
            if (this.m_objLastFocus == this.m_listBlockingAllow) {
                defaultListModel = (DefaultListModel)this.m_listBlockingAllow.getModel();
                nArray = this.m_listBlockingAllow.getSelectedIndices();
                this.m_listBlockingAllow.setModified(true);
                if (!this.m_bDenyEveryone) {
                    bl = true;
                }
            } else {
                defaultListModel = (DefaultListModel)this.m_listBlockingDeny.getModel();
                nArray = this.m_listBlockingDeny.getSelectedIndices();
                this.m_listBlockingDeny.setModified(true);
                if (this.m_bDenyEveryone) {
                    bl = true;
                }
            }
            for (int i = nArray.length - 1; i >= 0; --i) {
                if (nArray[i] == 0 && bl) continue;
                defaultListModel.remove(nArray[i]);
            }
            this.propertyBook.setModified(true, (PageSnapin)this.pageSnapin);
        } else if (object == this.m_btnBlockingLock) {
            boolean bl;
            boolean bl2;
            Icon icon = this.m_btnBlockingLock.getIcon();
            boolean bl3 = bl2 = this.m_policyNSObject.isAttributeMerged(3) || this.m_policyNSObject.isAttributeMerged(5) || this.m_policyNSObject.isAttributeMerged(7);
            if (icon == this.m_iconLockClosed) {
                bl = false;
                if (bl2) {
                    this.m_btnBlockingLock.setIcon(this.m_iconSystemLockOpen);
                    this.m_btnBlockingLock.setToolTipText(PolicyResource.get("PolicyGlobalSystemLevelUnlock"));
                } else {
                    this.m_btnBlockingLock.setIcon(this.m_iconLockOpen);
                    this.m_btnBlockingLock.setToolTipText(PolicyResource.get("PolicyNotLocked"));
                }
            } else {
                bl = true;
                if (icon == this.m_iconSystemLockOpen) {
                    this.m_btnBlockingLock.setIcon(this.m_iconLockClosed);
                    this.m_btnBlockingLock.setToolTipText(PolicyResource.get("PolicyLocked"));
                } else {
                    this.m_btnBlockingLock.setIcon(this.m_iconLockClosed);
                    this.m_btnBlockingLock.setToolTipText(PolicyResource.get("PolicyLocked"));
                }
            }
            this.m_policyNSObject.lockAttribute(3, bl);
            this.m_policyNSObject.lockAttribute(5, bl);
            this.m_policyNSObject.lockAttribute(7, bl);
            this.propertyBook.setModified(true, (PageSnapin)this.pageSnapin);
        } else if (object == this.m_btnResetDefaultSettings) {
            NMsgBox nMsgBox = new NMsgBox(this.propertyBook.getComponent(), PolicyResource.get("PolicyDefaultSettingsConfirmTitle"), PolicyResource.get("PolicyDefaultSettingsConfirm2"), 2);
            int n = nMsgBox.launch();
            this.fixFocus();
            if (n == 8) {
                this.restoreDefaultSettings();
                this.propertyBook.setModified(true, (PageSnapin)this.pageSnapin);
            }
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Object object = listSelectionEvent.getSource();
        if (object == this.m_listBlockingAllow) {
            if (this.m_listBlockingAllow.isSelectionEmpty()) {
                this.m_btnBlockingDeny.setEnabled(false);
                this.m_btnBlockingRemove.setEnabled(false);
            } else {
                this.m_btnBlockingDeny.setEnabled(true);
                this.m_btnBlockingRemove.setEnabled(true);
            }
        } else if (object == this.m_listBlockingDeny) {
            if (this.m_listBlockingDeny.isSelectionEmpty()) {
                this.m_btnBlockingAllow.setEnabled(false);
                this.m_btnBlockingRemove.setEnabled(false);
            } else {
                this.m_btnBlockingAllow.setEnabled(true);
                this.m_btnBlockingRemove.setEnabled(true);
            }
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        if (object == this.m_listBlockingAllow || object == this.m_listBlockingDeny) {
            // empty if block
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        this.m_objLastFocus = focusEvent.getSource();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() >= 2) {
            if (mouseEvent.getSource() == this.m_listBlockingAllow) {
                if (!this.m_listBlockingAllow.isSelectionEmpty()) {
                    this.m_btnBlockingDeny.doClick();
                }
            } else if (mouseEvent.getSource() == this.m_listBlockingDeny && !this.m_listBlockingDeny.isSelectionEmpty()) {
                this.m_btnBlockingAllow.doClick();
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    private String[] selectObject() {
        ObjectEntrySelector objectEntrySelector = new ObjectEntrySelector((Frame)this.parentFrame);
        NamespaceSnapin namespaceSnapin = this.nsObj.getObjectEntry().getNamespace();
        ObjectType[] objectTypeArray = new ObjectType[]{new ObjectType("User", namespaceSnapin, false)};
        objectEntrySelector.setFilter("", objectTypeArray);
        objectEntrySelector.setSelectionMode(2);
        objectEntrySelector.setFederationMode(1);
        objectEntrySelector.show();
        this.fixFocus();
        ObjectEntry[] objectEntryArray = objectEntrySelector.getSelectedObjectEntries();
        if (objectEntryArray != null) {
            String[] stringArray = new String[objectEntryArray.length];
            for (int i = 0; i < objectEntryArray.length; ++i) {
                ObjectEntry objectEntry = objectEntryArray[i];
                if (objectEntry == null) continue;
                stringArray[i] = ((NDSNamespace)namespaceSnapin).getUnrootedName(objectEntry);
            }
            return stringArray;
        }
        return null;
    }
}

