/*
 * Decompiled with CFR 0.152.
 */
package com.novell.netmessenger.admin.policy;

import com.novell.admin.common.snapins.AdminPageSnapin;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.application.console.snapin.InitSnapinInfo;
import com.novell.application.console.snapin.NamespaceSnapin;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectType;
import com.novell.application.console.snapin.PageSnapin;
import com.novell.application.console.util.objectentryselector.ObjectEntrySelector;
import com.novell.netmessenger.admin.common.Debug;
import com.novell.netmessenger.admin.common.NDSNegotiator;
import com.novell.netmessenger.admin.common.NIncrementBox;
import com.novell.netmessenger.admin.common.StaticUtilities;
import com.novell.netmessenger.admin.policy.ContactListItem;
import com.novell.netmessenger.admin.policy.PolicyAdminPage;
import com.novell.netmessenger.admin.policy.PolicyContactRenameDlg;
import com.novell.netmessenger.admin.policy.PolicyResource;
import com.novell.netmessenger.admin.swingext.JButtonExt;
import com.novell.netmessenger.admin.swingext.JLabelExt;
import com.novell.netmessenger.admin.swingext.JTreeExt;
import com.novell.utility.nmsgbox.NMsgBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class PolicyPanelContactList
extends PolicyAdminPage
implements ActionListener,
KeyListener {
    private JTreeExt m_tree;
    private DefaultTreeModel m_treeModel;
    private ImageIcon m_iconAddUser;
    private ImageIcon m_iconAddFolder;
    private JButton m_btnAddUser;
    private JButton m_btnAddFolder;
    private JButton m_btnEdit;
    private JButton m_btnRemove;
    private JButton m_btnLock;
    protected JButton m_btnResetDefaultSettings;
    private NIncrementBox m_incMaxContacts;
    private JButton m_btnLockMaxContacts;
    private NIncrementBox m_incMaxFolders;
    private JButton m_btnLockMaxFolders;
    private JButton m_btnUp;
    private JButton m_btnLeft;
    private JButton m_btnRight;
    private JButton m_btnDown;
    private Hashtable m_htContactList;
    private int m_iLastRecordedID;
    private int m_iLeafCountUser;
    private int m_iLeafCountFolder;
    private NamespaceSnapin m_ns;

    public PolicyPanelContactList(InitSnapinInfo initSnapinInfo, AdminPageSnapin adminPageSnapin, NSObject nSObject) {
        super(initSnapinInfo, adminPageSnapin, nSObject);
        this.m_ns = nSObject.getObjectEntry().getNamespace();
    }

    protected void init() {
        ContactListItem contactListItem;
        this.m_iLastRecordedID = 0;
        this.m_htContactList = new Hashtable();
        try {
            contactListItem = new ContactListItem(0, 0, 0, 1, 0, null, "Net Messenger", null);
        }
        catch (Exception exception) {
            contactListItem = null;
        }
        this.m_treeModel = new DefaultTreeModel(new DefaultMutableTreeNode(contactListItem));
        this.m_tree = new JTreeExt(this.m_treeModel);
        this.m_tree.setRootVisible(false);
        this.m_tree.setCellRenderer(new DefaultTreeCellRendererExt());
        DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)this.m_tree.getCellRenderer();
        this.m_incMaxContacts = new NIncrementBox(0, 1000, 0);
        this.m_incMaxFolders = new NIncrementBox(0, 100, 0);
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/com/novell/netmessenger/admin/common/images/folderClosed.gif"));
        defaultTreeCellRenderer.setClosedIcon(imageIcon);
        ImageIcon imageIcon2 = new ImageIcon(this.getClass().getResource("/com/novell/netmessenger/admin/common/images/folderOpened.gif"));
        defaultTreeCellRenderer.setOpenIcon(imageIcon2);
        this.m_iconAddUser = new ImageIcon(this.getClass().getResource("/com/novell/netmessenger/admin/common/images/user.gif"));
        Dimension dimension = new Dimension(this.m_iconLockOpen.getIconWidth() + 15, this.m_iconLockOpen.getIconHeight() + 10);
        this.m_btnAddUser = new JButtonExt(PolicyResource.get("PolicyContactAddUser"));
        this.m_iconAddFolder = new ImageIcon(this.getClass().getResource("/com/novell/netmessenger/admin/common/images/folder.gif"));
        this.m_btnAddFolder = new JButtonExt(PolicyResource.get("PolicyContactAddFolder"));
        ImageIcon imageIcon3 = new ImageIcon(this.getClass().getResource("/com/novell/netmessenger/admin/common/images/oes.gif"));
        this.m_btnEdit = new JButtonExt(PolicyResource.get("PolicyContactEditContact"));
        ImageIcon imageIcon4 = new ImageIcon(this.getClass().getResource("/com/novell/netmessenger/admin/common/images/remove.gif"));
        this.m_btnRemove = new JButtonExt(PolicyResource.get("PolicyContactRemoveContact"));
        ImageIcon imageIcon5 = new ImageIcon(this.getClass().getResource("/com/novell/netmessenger/admin/common/images/up.gif"));
        this.m_btnUp = new JButtonExt(PolicyResource.get("PolicyContactMoveUp"));
        ImageIcon imageIcon6 = new ImageIcon(this.getClass().getResource("/com/novell/netmessenger/admin/common/images/left.gif"));
        this.m_btnLeft = new JButtonExt(PolicyResource.get("PolicyContactMoveLeft"));
        ImageIcon imageIcon7 = new ImageIcon(this.getClass().getResource("/com/novell/netmessenger/admin/common/images/right.gif"));
        this.m_btnRight = new JButtonExt(PolicyResource.get("PolicyContactMoveRight"));
        ImageIcon imageIcon8 = new ImageIcon(this.getClass().getResource("/com/novell/netmessenger/admin/common/images/down.gif"));
        this.m_btnDown = new JButtonExt(PolicyResource.get("PolicyContactMoveDown"));
        ImageIcon imageIcon9 = new ImageIcon(this.getClass().getResource("/com/novell/netmessenger/admin/common/images/default.gif"));
        this.m_btnResetDefaultSettings = new JButtonExt(PolicyResource.get("RestoreDefaultSettingsButton"));
        if (this.m_policyNSObject.isSystemPolicy()) {
            this.m_btnResetDefaultSettings.setVisible(false);
        }
        this.m_btnLock = new JButtonExt(this.m_iconLockOpen, PolicyResource.get("PolicyUnlocked"));
        this.m_btnLock.setPreferredSize(dimension);
        dimension = new Dimension(this.m_iconLockOpen.getIconWidth() + 15, this.m_iconLockOpen.getIconHeight() + 6);
        this.m_btnLockMaxContacts = new JButtonExt(this.m_iconLockOpen, PolicyResource.get("PolicyUnlocked"));
        this.m_btnLockMaxContacts.setPreferredSize(dimension);
        this.m_btnLockMaxFolders = new JButtonExt(this.m_iconLockOpen, PolicyResource.get("PolicyUnlocked"));
        this.m_btnLockMaxFolders.setPreferredSize(dimension);
    }

    public void layoutControls() {
        this.init();
        JLabelExt jLabelExt = new JLabelExt(PolicyResource.get("PolicyContactList"), this.m_tree);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.setLayout(new GridBagLayout());
        this.setGBC(gridBagConstraints, 1, 1, 3, 1, 2, 1.0, 0.0);
        this.add(this.getMaxPanel(), gridBagConstraints);
        this.setGBC(gridBagConstraints, 1, 2, 1, 1, 0, 0.0, 0.0);
        this.add(jLabelExt, gridBagConstraints);
        this.setGBC(gridBagConstraints, 2, 2, 1, 1, 0, 0.0, 0.0);
        this.add(this.m_btnLock, gridBagConstraints);
        JScrollPane jScrollPane = new JScrollPane(this.m_tree);
        jScrollPane.setPreferredSize(new Dimension(400, 200));
        this.setGBC(gridBagConstraints, 1, 3, 3, 5, 1, 1.0, 1.0);
        this.add(jScrollPane, gridBagConstraints);
        this.setGBC(gridBagConstraints, 4, 3, 1, 1, 2, 0.0, 0.0);
        this.add(this.m_btnAddUser, gridBagConstraints);
        this.setGBC(gridBagConstraints, 4, 4, 1, 1, 2, 0.0, 0.0);
        this.add(this.m_btnAddFolder, gridBagConstraints);
        this.setGBC(gridBagConstraints, 4, 5, 1, 1, 2, 0.0, 0.0);
        this.add(this.m_btnEdit, gridBagConstraints);
        this.setGBC(gridBagConstraints, 4, 6, 1, 1, 2, 0.0, 0.0);
        this.add(this.m_btnRemove, gridBagConstraints);
        this.setGBC(gridBagConstraints, 1, 15, 5, 1, 0, 0.0, 0.0);
        this.add(this.m_btnResetDefaultSettings, gridBagConstraints);
    }

    protected JPanel getMaxPanel() {
        JLabelExt jLabelExt = new JLabelExt(PolicyResource.get("PolicyContactListMaxContacts"), this.m_incMaxContacts);
        JLabelExt jLabelExt2 = new JLabelExt(PolicyResource.get("PolicyContactListMaxFolders"), this.m_incMaxFolders);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.setGBC(gridBagConstraints, 1, 0, 1, 1, 0, 0.1, 0.0);
        jPanel.add((Component)jLabelExt, gridBagConstraints);
        this.setGBC(gridBagConstraints, 2, 0, 1, 1, 0, 0.0, 0.0);
        jPanel.add((Component)this.m_incMaxContacts, gridBagConstraints);
        this.setGBC(gridBagConstraints, 3, 0, 1, 1, 3, 0.9, 0.0);
        jPanel.add((Component)this.m_btnLockMaxContacts, gridBagConstraints);
        this.setGBC(gridBagConstraints, 1, 1, 2, 1, 0, 0.1, 0.0);
        jPanel.add((Component)jLabelExt2, gridBagConstraints);
        this.setGBC(gridBagConstraints, 2, 1, 1, 1, 0, 0.0, 0.0);
        jPanel.add((Component)this.m_incMaxFolders, gridBagConstraints);
        this.setGBC(gridBagConstraints, 3, 1, 1, 1, 3, 0.9, 0.0);
        jPanel.add((Component)this.m_btnLockMaxFolders, gridBagConstraints);
        return jPanel;
    }

    public void readData() {
        Vector vector = this.m_policyNSObject.getContactList();
        if (vector != null) {
            DefaultMutableTreeNode defaultMutableTreeNode;
            ContactListItem contactListItem;
            int n;
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)this.m_treeModel.getRoot();
            this.m_htContactList.clear();
            int n2 = vector.size();
            for (n = 0; n < n2; ++n) {
                String string = (String)vector.elementAt(n);
                try {
                    contactListItem = new ContactListItem(string);
                }
                catch (Exception exception) {
                    continue;
                }
                defaultMutableTreeNode = new DefaultMutableTreeNode(contactListItem);
                this.m_htContactList.put(defaultMutableTreeNode, new Integer(contactListItem.getID()));
            }
            Enumeration enumeration = this.m_htContactList.keys();
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
                    contactListItem = (ContactListItem)defaultMutableTreeNode.getUserObject();
                    if (contactListItem.getID() > this.m_iLastRecordedID) {
                        this.m_iLastRecordedID = contactListItem.getID();
                    }
                    this.addContactToTree(defaultMutableTreeNode);
                }
                defaultMutableTreeNode2 = (DefaultMutableTreeNode)this.m_treeModel.getRoot();
                this.m_tree.expandPath(new TreePath(defaultMutableTreeNode2.getPath()));
                n = this.m_tree.getRowCount();
                for (int i = 0; i < n; ++i) {
                    this.m_tree.expandRow(i);
                }
            }
        }
        this.m_incMaxContacts.setValue(this.m_policyNSObject.getMaxContacts());
        this.m_incMaxFolders.setValue(this.m_policyNSObject.getMaxFolders());
        this.m_iLeafCountUser = this.getTotalChildCount((DefaultMutableTreeNode)this.m_treeModel.getRoot(), 2);
        this.m_iLeafCountFolder = this.getTotalChildCount((DefaultMutableTreeNode)this.m_treeModel.getRoot(), 1);
        this.m_incMaxContacts.setMinValue(this.m_iLeafCountUser);
        this.m_incMaxFolders.setMinValue(this.m_iLeafCountFolder);
        this.initMergeIcons();
        this.initLocks();
        this.m_incMaxContacts.addDocumentListener(this);
        this.m_incMaxFolders.addDocumentListener(this);
        this.m_btnAddUser.addActionListener(this);
        this.m_btnAddFolder.addActionListener(this);
        this.m_btnEdit.addActionListener(this);
        this.m_btnRemove.addActionListener(this);
        this.m_btnLock.addActionListener(this);
        this.m_btnLockMaxContacts.addActionListener(this);
        this.m_btnLockMaxFolders.addActionListener(this);
        this.m_btnResetDefaultSettings.addActionListener(this);
        this.m_tree.addKeyListener(this);
        this.m_tree.addTreeModelListener(this);
    }

    protected int getTotalChildCount(DefaultMutableTreeNode defaultMutableTreeNode, int n) {
        int n2 = 0;
        if (defaultMutableTreeNode.getChildCount() > 0) {
            Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
                ContactListItem contactListItem = (ContactListItem)defaultMutableTreeNode2.getUserObject();
                if (contactListItem.getContactType() != n) continue;
                ++n2;
            }
        }
        return n2;
    }

    protected void initMergeIcons() {
        if (this.m_policyNSObject.isAttributeMerged(9)) {
            this.m_btnLock.setIcon(this.m_iconSystemLockOpen);
            this.m_btnLock.setToolTipText(PolicyResource.get("PolicyGlobalSystemLevelUnlock"));
        } else {
            this.m_btnLock.setIcon(this.m_iconLockOpen);
            this.m_btnLock.setToolTipText(PolicyResource.get("PolicyNotLocked"));
        }
        if (this.m_policyNSObject.isAttributeMerged(22)) {
            this.m_btnLockMaxContacts.setIcon(this.m_iconSystemLockOpen);
            this.m_btnLockMaxContacts.setToolTipText(PolicyResource.get("PolicyGlobalSystemLevelUnlock"));
        } else {
            this.m_btnLockMaxContacts.setIcon(this.m_iconLockOpen);
            this.m_btnLockMaxContacts.setToolTipText(PolicyResource.get("PolicyNotLocked"));
        }
        if (this.m_policyNSObject.isAttributeMerged(23)) {
            this.m_btnLockMaxFolders.setIcon(this.m_iconSystemLockOpen);
            this.m_btnLockMaxFolders.setToolTipText(PolicyResource.get("PolicyGlobalSystemLevelUnlock"));
        } else {
            this.m_btnLockMaxFolders.setIcon(this.m_iconLockOpen);
            this.m_btnLockMaxFolders.setToolTipText(PolicyResource.get("PolicyNotLocked"));
        }
    }

    protected void initLocks() {
        if (this.m_policyNSObject.isAttributeLocked(9, 0)) {
            this.setUIEnabled(false);
            this.m_btnLock.setIcon(this.m_iconSystemLevelLock);
            this.m_btnLock.setToolTipText(PolicyResource.get("PolicyGlobalSystemLevelLock"));
        } else if (this.m_policyNSObject.isAttributeLocked(9)) {
            this.m_btnLock.setIcon(this.m_iconLockClosed);
            this.m_btnLock.setToolTipText(PolicyResource.get("PolicyLocked"));
        }
        if (this.m_policyNSObject.isAttributeLocked(22, 0)) {
            this.m_incMaxContacts.setEnabled(false);
            this.m_btnLockMaxContacts.setEnabled(false);
            this.m_btnLockMaxContacts.setIcon(this.m_iconSystemLevelLock);
            this.m_btnLockMaxContacts.setToolTipText(PolicyResource.get("PolicyGlobalSystemLevelLock"));
        } else if (this.m_policyNSObject.isAttributeLocked(22)) {
            this.m_btnLockMaxContacts.setIcon(this.m_iconLockClosed);
            this.m_btnLockMaxContacts.setToolTipText(PolicyResource.get("PolicyLocked"));
        }
        if (this.m_policyNSObject.isAttributeLocked(23, 0)) {
            this.m_incMaxFolders.setEnabled(false);
            this.m_btnLockMaxFolders.setEnabled(false);
            this.m_btnLockMaxFolders.setIcon(this.m_iconSystemLevelLock);
            this.m_btnLockMaxFolders.setToolTipText(PolicyResource.get("PolicyGlobalSystemLevelLock"));
        } else if (this.m_policyNSObject.isAttributeLocked(23)) {
            this.m_btnLockMaxFolders.setIcon(this.m_iconLockClosed);
            this.m_btnLockMaxFolders.setToolTipText(PolicyResource.get("PolicyLocked"));
        }
    }

    protected void setUIEnabled(boolean bl) {
        this.m_tree.setEnabled(bl);
        this.m_btnAddUser.setEnabled(bl);
        this.m_btnAddFolder.setEnabled(bl);
        this.m_btnEdit.setEnabled(bl);
        this.m_btnRemove.setEnabled(bl);
        this.m_btnLock.setEnabled(bl);
        this.m_btnResetDefaultSettings.setEnabled(bl);
    }

    protected void addContactToTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode != null) {
            int n;
            Enumeration<TreeNode> enumeration;
            Object object;
            Object object2;
            Object object3 = null;
            ContactListItem contactListItem = (ContactListItem)defaultMutableTreeNode.getUserObject();
            if (contactListItem.getParentID() == 0) {
                object3 = (DefaultMutableTreeNode)this.m_treeModel.getRoot();
            } else if (contactListItem.getParentID() > 0) {
                object3 = this.getParentNode(null, contactListItem);
            }
            if (object3 == null) {
                object2 = this.m_htContactList.keys();
                while (object2.hasMoreElements()) {
                    object = (DefaultMutableTreeNode)object2.nextElement();
                    ContactListItem contactListItem2 = (ContactListItem)((DefaultMutableTreeNode)object).getUserObject();
                    if (contactListItem2.getID() != contactListItem.getParentID()) continue;
                    object3 = object;
                    break;
                }
                if (object3 == null) {
                    object3 = (DefaultMutableTreeNode)this.m_treeModel.getRoot();
                }
            }
            if ((enumeration = ((DefaultMutableTreeNode)object3).children()) != null) {
                n = 0;
                while (enumeration.hasMoreElements()) {
                    object2 = (DefaultMutableTreeNode)enumeration.nextElement();
                    object = (ContactListItem)((DefaultMutableTreeNode)object2).getUserObject();
                    if (contactListItem.getSequence() >= ((ContactListItem)object).getSequence()) {
                        ++n;
                        continue;
                    }
                    break;
                }
            } else {
                n = ((DefaultMutableTreeNode)object3).getChildCount();
            }
            this.m_treeModel.insertNodeInto(defaultMutableTreeNode, (MutableTreeNode)object3, n);
        }
    }

    protected DefaultMutableTreeNode getParentNode(DefaultMutableTreeNode defaultMutableTreeNode, ContactListItem contactListItem) {
        Enumeration<TreeNode> enumeration;
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        if (defaultMutableTreeNode == null) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_treeModel.getRoot();
        }
        if ((enumeration = defaultMutableTreeNode.children()).hasMoreElements()) {
            defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            ContactListItem contactListItem2 = (ContactListItem)defaultMutableTreeNode2.getUserObject();
            if (contactListItem2.getID() == contactListItem.getParentID()) {
                return defaultMutableTreeNode2;
            }
            return this.getParentNode(defaultMutableTreeNode2, contactListItem);
        }
        return defaultMutableTreeNode2;
    }

    public boolean saveData() {
        if (this.m_incMaxContacts.isModified()) {
            this.m_policyNSObject.setMaxContacts(this.m_incMaxContacts.getValue());
        }
        if (this.m_incMaxFolders.isModified()) {
            this.m_policyNSObject.setMaxFolders(this.m_incMaxFolders.getValue());
        }
        if (this.m_tree.isModified()) {
            Vector vector = new Vector();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_treeModel.getRoot();
            if (defaultMutableTreeNode != null) {
                this.createContactList(vector, defaultMutableTreeNode);
                this.m_policyNSObject.setContactList(vector);
            }
        }
        return true;
    }

    protected void createContactList(Vector vector, DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode != null && defaultMutableTreeNode.getChildCount() > 0) {
            Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
                this.createContactList(vector, defaultMutableTreeNode2);
                ContactListItem contactListItem = (ContactListItem)defaultMutableTreeNode2.getUserObject();
                vector.addElement(contactListItem.toStringExt());
            }
        }
    }

    protected void restoreDefaultSettings() {
        this.m_policyNSObject.restoreDefaultSettings(9);
        this.m_policyNSObject.restoreDefaultSettings(22);
        this.m_policyNSObject.restoreDefaultSettings(23);
        ((DefaultMutableTreeNode)this.m_treeModel.getRoot()).removeAllChildren();
        this.m_treeModel.reload();
        this.readData();
    }

    private void doEdit(ContactListItem contactListItem) {
        PolicyContactRenameDlg policyContactRenameDlg = new PolicyContactRenameDlg(this.propertyBook.getComponent(), PolicyResource.get("PolicyContactRenameTitle"), PolicyResource.get("PolicyContactRename"), "policycontactedit", contactListItem.getDisplayName());
        policyContactRenameDlg.show();
        this.fixFocus();
        String string = policyContactRenameDlg.getName();
        if (string != null) {
            if (this.isNodePresent(null, string)) {
                NMsgBox nMsgBox = new NMsgBox((Component)((Object)this), PolicyResource.get("PolicyContactDuplicateTitle"), PolicyResource.get("PolicyContactDuplicate"), 3);
                nMsgBox.launch();
                this.m_btnEdit.doClick();
                return;
            }
            contactListItem.setDisplayName(string);
            this.m_treeModel.reload();
            this.propertyBook.setModified(true, (PageSnapin)this.pageSnapin);
        }
    }

    private void doRemove() {
        TreePath[] treePathArray = this.m_tree.getSelectionPaths();
        if (treePathArray != null) {
            for (int i = 0; i < treePathArray.length; ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[i].getLastPathComponent();
                if (defaultMutableTreeNode == null) continue;
                ContactListItem contactListItem = (ContactListItem)defaultMutableTreeNode.getUserObject();
                if (contactListItem.getContactType() == 2) {
                    this.m_incMaxContacts.setMinValue(--this.m_iLeafCountUser);
                } else if (contactListItem.getContactType() == 1) {
                    this.m_incMaxContacts.setMinValue(--this.m_iLeafCountFolder);
                }
                this.m_treeModel.removeNodeFromParent(defaultMutableTreeNode);
                this.propertyBook.setModified(true, (PageSnapin)this.pageSnapin);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Debug.trace("PolicyPanelContactList.actionPerformed");
        Object object = actionEvent.getSource();
        if (object == this.m_btnAddUser) {
            Object object2;
            int n = this.m_incMaxContacts.getValue();
            if (this.m_iLeafCountUser >= n) {
                NMsgBox nMsgBox = new NMsgBox((Component)((Object)this), PolicyResource.get("PolicyContactListMaxContactsErrorTitle"), PolicyResource.get("PolicyContactListMaxContactsError") + n, 3);
                nMsgBox.launch();
                this.fixFocus();
                return;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_tree.getLastSelectedPathComponent();
            DefaultMutableTreeNode defaultMutableTreeNode2 = defaultMutableTreeNode != null ? (((ContactListItem)(object2 = (ContactListItem)defaultMutableTreeNode.getUserObject())).getContactType() == 1 ? defaultMutableTreeNode : (DefaultMutableTreeNode)this.m_treeModel.getRoot()) : (DefaultMutableTreeNode)this.m_treeModel.getRoot();
            ContactListItem contactListItem = (ContactListItem)defaultMutableTreeNode2.getUserObject();
            object2 = this.getContactVec(contactListItem.getID());
            if (object2 != null) {
                for (int i = 0; i < ((Vector)object2).size(); ++i) {
                    ContactListItem contactListItem2 = (ContactListItem)((Vector)object2).elementAt(i);
                    if (this.isNodePresent(null, contactListItem2.toString())) continue;
                    contactListItem2.setSequence(defaultMutableTreeNode2.getChildCount());
                    DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(contactListItem2);
                    defaultMutableTreeNode3.setAllowsChildren(false);
                    this.m_incMaxContacts.setMinValue(++this.m_iLeafCountUser);
                    this.m_treeModel.insertNodeInto(defaultMutableTreeNode3, defaultMutableTreeNode2, defaultMutableTreeNode2.getChildCount());
                }
                this.m_tree.expandPath(new TreePath(defaultMutableTreeNode2.getPath()));
                this.propertyBook.setModified(true, (PageSnapin)this.pageSnapin);
            }
        } else if (object == this.m_btnAddFolder) {
            ContactListItem contactListItem;
            int n = this.m_incMaxFolders.getValue();
            if (this.m_iLeafCountFolder >= n) {
                NMsgBox nMsgBox = new NMsgBox((Component)((Object)this), PolicyResource.get("PolicyContactListMaxFoldersErrorTitle"), PolicyResource.get("PolicyContactListMaxFoldersError") + n, 3);
                nMsgBox.launch();
                this.fixFocus();
                return;
            }
            int n2 = 2;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_treeModel.getRoot();
            try {
                String string = "New Folder";
                while (this.isNodePresent(null, string)) {
                    string = "New Folder " + n2++;
                }
                int n3 = defaultMutableTreeNode.getChildCount();
                contactListItem = new ContactListItem(++this.m_iLastRecordedID, 0, n3, 1, 0, null, string, null);
            }
            catch (Exception exception) {
                return;
            }
            DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(contactListItem);
            this.m_treeModel.insertNodeInto(defaultMutableTreeNode4, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
            this.m_tree.expandPath(new TreePath(defaultMutableTreeNode.getPath()));
            this.m_incMaxFolders.setMinValue(++this.m_iLeafCountFolder);
            this.propertyBook.setModified(true, (PageSnapin)this.pageSnapin);
        } else if (object == this.m_btnEdit) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_tree.getLastSelectedPathComponent();
            if (defaultMutableTreeNode == null) {
                return;
            }
            this.doEdit((ContactListItem)defaultMutableTreeNode.getUserObject());
        } else if (object == this.m_btnRemove) {
            this.doRemove();
        } else if (object == this.m_btnLock) {
            boolean bl;
            if (this.m_btnLock.getIcon() == this.m_iconLockOpen) {
                bl = true;
                this.m_btnLock.setIcon(this.m_iconLockClosed);
            } else {
                bl = false;
                this.m_btnLock.setIcon(this.m_iconLockOpen);
            }
            this.m_policyNSObject.lockAttribute(9, bl);
            if (bl) {
                this.m_btnLock.setToolTipText(PolicyResource.get("PolicyLocked"));
            } else {
                this.m_btnLock.setToolTipText(PolicyResource.get("PolicyNotLocked"));
            }
            this.propertyBook.setModified(true, (PageSnapin)this.pageSnapin);
        } else if (object == this.m_btnLockMaxContacts) {
            boolean bl;
            if (this.m_btnLockMaxContacts.getIcon() == this.m_iconLockOpen) {
                bl = true;
                this.m_btnLockMaxContacts.setIcon(this.m_iconLockClosed);
            } else {
                bl = false;
                this.m_btnLockMaxContacts.setIcon(this.m_iconLockOpen);
            }
            this.m_policyNSObject.lockAttribute(22, bl);
            if (bl) {
                this.m_btnLockMaxContacts.setToolTipText(PolicyResource.get("PolicyLocked"));
            } else if (this.m_policyNSObject.isAttributeMerged(22)) {
                this.m_btnLockMaxContacts.setToolTipText(PolicyResource.get("PolicyGlobalSystemLevelUnlock"));
            } else {
                this.m_btnLockMaxContacts.setToolTipText(PolicyResource.get("PolicyNotLocked"));
            }
            this.propertyBook.setModified(true, (PageSnapin)this.pageSnapin);
        } else if (object == this.m_btnLockMaxFolders) {
            boolean bl;
            if (this.m_btnLockMaxFolders.getIcon() == this.m_iconLockOpen) {
                bl = true;
                this.m_btnLockMaxFolders.setIcon(this.m_iconLockClosed);
            } else {
                bl = false;
                this.m_btnLockMaxFolders.setIcon(this.m_iconLockOpen);
            }
            this.m_policyNSObject.lockAttribute(23, bl);
            if (bl) {
                this.m_btnLockMaxFolders.setToolTipText(PolicyResource.get("PolicyLocked"));
            } else if (this.m_policyNSObject.isAttributeMerged(23)) {
                this.m_btnLockMaxFolders.setToolTipText(PolicyResource.get("PolicyGlobalSystemLevelUnlock"));
            } else {
                this.m_btnLockMaxFolders.setToolTipText(PolicyResource.get("PolicyNotLocked"));
            }
            this.propertyBook.setModified(true, (PageSnapin)this.pageSnapin);
        } else if (object == this.m_btnResetDefaultSettings) {
            NMsgBox nMsgBox = new NMsgBox(this.propertyBook.getComponent(), PolicyResource.get("PolicyDefaultSettingsConfirmTitle"), PolicyResource.get("PolicyDefaultSettingsConfirm2"), 2);
            int n = nMsgBox.launch();
            this.fixFocus();
            if (n == 8) {
                this.restoreDefaultSettings();
                this.propertyBook.setModified(true, (PageSnapin)this.pageSnapin);
            }
        } else {
            Debug.traceDlg("PolicyPanelContactList.actionPerformed: Deal with eventSource= " + object);
        }
    }

    protected boolean isNodePresent(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        boolean bl = false;
        if (defaultMutableTreeNode == null) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_treeModel.getRoot();
        }
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            ContactListItem contactListItem = (ContactListItem)defaultMutableTreeNode2.getUserObject();
            if (!string.equalsIgnoreCase(contactListItem.toString())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private boolean addUserToVec(NSObject nSObject, Vector vector, NDSNegotiator nDSNegotiator, int n) {
        Object object;
        ObjectEntry objectEntry = nSObject.getObjectEntry();
        String string = StaticUtilities.DNToLDAPFormat(((NDSNamespace)this.m_ns).getFullyTypedName(objectEntry));
        String string2 = nDSNegotiator.getAttribute(nSObject, "Full Name");
        if (string2 == null || string2.length() == 0) {
            object = nDSNegotiator.getMultiValuedAttribute(nSObject, "CN");
            string2 = (String)((Vector)object).elementAt(0);
        }
        object = nDSNegotiator.getAttribute(nSObject, "Internet Email Address");
        try {
            ContactListItem contactListItem = new ContactListItem(++this.m_iLastRecordedID, n, -1, 2, 0, string, string2, (String)object);
            vector.addElement(contactListItem);
        }
        catch (Exception exception) {
            Debug.trace("addUserToVec: Error creating ContactListItem for " + objectEntry);
            Debug.trace("addUserToVec: ex= " + exception);
            return true;
        }
        return false;
    }

    private Vector getContactVec(int n) {
        Vector vector = null;
        Debug.trace("getContactVec: iParentIndex= " + n);
        ObjectType[] objectTypeArray = new ObjectType[]{new ObjectType("User", this.m_ns, false), new ObjectType("Group", this.m_ns, false)};
        ObjectEntrySelector objectEntrySelector = new ObjectEntrySelector((Frame)this.shell.getShellFrame());
        objectEntrySelector.setFilter("", objectTypeArray);
        objectEntrySelector.setSelectionMode(2);
        objectEntrySelector.setFederationMode(1);
        objectEntrySelector.show();
        this.fixFocus();
        ObjectEntry[] objectEntryArray = objectEntrySelector.getSelectedObjectEntries();
        if (objectEntryArray != null) {
            vector = new Vector(50, 50);
            NDSNegotiator nDSNegotiator = new NDSNegotiator();
            for (int i = 0; i < objectEntryArray.length; ++i) {
                NSObject nSObject;
                ObjectEntry objectEntry = objectEntryArray[i];
                String string = objectEntry.getFullName();
                try {
                    nSObject = nDSNegotiator.getNSObject((NDSNamespace)this.m_ns, string);
                }
                catch (Exception exception) {
                    Debug.trace("getContactVec: exception on " + string);
                    Debug.trace("getContactVec: ex= " + exception);
                    continue;
                }
                String string2 = objectEntry.getObjectType().getName();
                if (string2.equalsIgnoreCase("User")) {
                    if (!this.addUserToVec(nSObject, vector, nDSNegotiator, n)) continue;
                    continue;
                }
                if (string2.equalsIgnoreCase("Group")) {
                    Debug.trace("getContactVec: Adding members of a group");
                    Vector vector2 = nDSNegotiator.getMultiValuedAttribute(nSObject, "Member");
                    for (int j = 0; j < vector2.size(); ++j) {
                        NSObject nSObject2;
                        string = (String)vector2.elementAt(j);
                        Debug.trace("   " + j + ": " + string);
                        try {
                            nSObject2 = nDSNegotiator.getNSObject((NDSNamespace)this.m_ns, string);
                        }
                        catch (Exception exception) {
                            Debug.trace("getContactVec: exception on group member " + string);
                            Debug.trace("getContactVec: ex= " + exception);
                            continue;
                        }
                        if (!this.addUserToVec(nSObject2, vector, nDSNegotiator, n)) continue;
                    }
                    continue;
                }
                Debug.traceDlg("getContactVec: Deal with this case of " + string2);
            }
        }
        return vector;
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 127) {
            this.doRemove();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    private class DefaultTreeCellRendererExt
    extends DefaultTreeCellRenderer {
        private ImageIcon iconAddUser = new ImageIcon(this.getClass().getResource("/com/novell/netmessenger/admin/common/images/user.gif"));
        private ImageIcon iconAddFolderExpanded = new ImageIcon(this.getClass().getResource("/com/novell/netmessenger/admin/common/images/folderOpened.gif"));
        private ImageIcon iconAddFolderCollapsed = new ImageIcon(this.getClass().getResource("/com/novell/netmessenger/admin/common/images/folderClosed.gif"));

        private DefaultTreeCellRendererExt() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            if (defaultMutableTreeNode.getUserObject() instanceof ContactListItem) {
                ContactListItem contactListItem = (ContactListItem)defaultMutableTreeNode.getUserObject();
                if (contactListItem.getContactType() == 2) {
                    this.setIcon(this.iconAddUser);
                } else if (contactListItem.getContactType() == 1) {
                    if (bl2) {
                        this.setIcon(this.iconAddFolderExpanded);
                    } else {
                        this.setIcon(this.iconAddFolderCollapsed);
                    }
                }
            }
            return this;
        }
    }
}

