/*
 * Decompiled with CFR 0.152.
 */
package com.novell.netmessenger.admin.policy;

import com.novell.admin.common.snapins.AdminPageSnapin;
import com.novell.admin.ns.NSObject;
import com.novell.application.console.snapin.InitSnapinInfo;
import com.novell.application.console.snapin.PageSnapin;
import com.novell.netmessenger.admin.common.Debug;
import com.novell.netmessenger.admin.policy.PolicyAdminPage;
import com.novell.netmessenger.admin.policy.PolicyResource;
import com.novell.netmessenger.admin.swingext.JButtonExt;
import com.novell.netmessenger.admin.swingext.JCheckBoxExt;
import com.novell.utility.nmsgbox.NMsgBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class PolicyPanelHistory
extends PolicyAdminPage
implements ActionListener {
    private JCheckBoxExt m_cbPersonalHistory;
    private JCheckBoxExt m_cbPrintSave;
    private JButtonExt m_btnPersonalHistory;
    private JButtonExt m_btnPrintSave;
    protected JButtonExt m_btnResetDefaultSettings;

    public PolicyPanelHistory(InitSnapinInfo initSnapinInfo, AdminPageSnapin adminPageSnapin, NSObject nSObject) {
        super(initSnapinInfo, adminPageSnapin, nSObject);
    }

    protected void init() {
        this.m_cbPersonalHistory = new JCheckBoxExt(PolicyResource.get("PolicyHistoryPersonalHistory"));
        this.m_cbPrintSave = new JCheckBoxExt(PolicyResource.get("PolicyHistoryPrintSave"));
        Dimension dimension = new Dimension(this.m_iconLockOpen.getIconWidth() + 10, this.m_iconLockOpen.getIconHeight() + 5);
        this.m_btnPersonalHistory = new JButtonExt(this.m_iconLockOpen, PolicyResource.get("PolicyUnlocked"));
        this.m_btnPersonalHistory.setPreferredSize(dimension);
        this.m_btnPrintSave = new JButtonExt(this.m_iconLockOpen, PolicyResource.get("PolicyUnlocked"));
        this.m_btnPrintSave.setPreferredSize(dimension);
        this.m_btnResetDefaultSettings = new JButtonExt(PolicyResource.get("RestoreDefaultSettingsButton"));
        this.m_btnResetDefaultSettings.addActionListener(this);
        if (this.m_policyNSObject.isSystemPolicy()) {
            this.m_btnResetDefaultSettings.setVisible(false);
        }
    }

    public void layoutControls() {
        this.init();
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.setGBC(gridBagConstraints, 1, 1, 2, 1, 0, 0.0, 0.0, 18);
        jPanel.add((Component)this.m_cbPrintSave, gridBagConstraints);
        this.setGBC(gridBagConstraints, 3, 1, 1, 1, 3, 0.3, 0.0, 12);
        jPanel.add((Component)this.m_btnPrintSave, gridBagConstraints);
        this.setGBC(gridBagConstraints, 1, 2, 2, 1, 0, 0.0, 0.0, 18);
        jPanel.add((Component)this.m_cbPersonalHistory, gridBagConstraints);
        this.setGBC(gridBagConstraints, 3, 2, 1, 1, 3, 0.3, 0.0, 12);
        jPanel.add((Component)this.m_btnPersonalHistory, gridBagConstraints);
        this.setGBC(gridBagConstraints, 1, 3, 2, 1, 0, 1.0, 0.0, 18);
        jPanel.add((Component)this.m_btnResetDefaultSettings, gridBagConstraints);
        this.setGBC(gridBagConstraints, 1, 1, 1, 1, 2, 1.0, 1.0, 18);
        this.add(jPanel, gridBagConstraints);
    }

    public void readData() {
        this.m_cbPersonalHistory.setSelected(this.m_policyNSObject.getPersonalHistory());
        this.m_cbPrintSave.setSelected(this.m_policyNSObject.getPrintSave());
        this.initMergeIcons();
        this.initLocks();
        this.m_cbPersonalHistory.addItemListener(this);
        this.m_cbPrintSave.addItemListener(this);
        this.m_btnPersonalHistory.addActionListener(this);
        this.m_btnPrintSave.addActionListener(this);
    }

    protected void initMergeIcons() {
        if (this.m_policyNSObject.isAttributeMerged(30)) {
            this.m_btnPersonalHistory.setIcon(this.m_iconSystemLockOpen);
            this.m_btnPersonalHistory.setToolTipText(PolicyResource.get("PolicyGlobalSystemLevelUnlock"));
        } else {
            this.m_btnPersonalHistory.setIcon(this.m_iconLockOpen);
            this.m_btnPersonalHistory.setToolTipText(PolicyResource.get("PolicyNotLocked"));
        }
        if (this.m_policyNSObject.isAttributeMerged(31)) {
            this.m_btnPrintSave.setIcon(this.m_iconSystemLockOpen);
            this.m_btnPrintSave.setToolTipText(PolicyResource.get("PolicyGlobalSystemLevelUnlock"));
        } else {
            this.m_btnPrintSave.setIcon(this.m_iconLockOpen);
            this.m_btnPrintSave.setToolTipText(PolicyResource.get("PolicyNotLocked"));
        }
    }

    protected void initLocks() {
        if (this.m_policyNSObject.isAttributeLocked(30, 0)) {
            this.m_cbPersonalHistory.setEnabled(false);
            this.m_btnPersonalHistory.setEnabled(false);
            this.m_btnPersonalHistory.setIcon(this.m_iconSystemLevelLock, PolicyResource.get("PolicyGlobalSystemLevelLock"));
            this.m_btnPersonalHistory.setToolTipText(PolicyResource.get("PolicyGlobalSystemLevelLock"));
        } else if (this.m_policyNSObject.isAttributeLocked(30)) {
            this.m_btnPersonalHistory.setIcon(this.m_iconLockClosed);
            this.m_btnPersonalHistory.setToolTipText(PolicyResource.get("PolicyLocked"));
        }
        if (this.m_policyNSObject.isAttributeLocked(31, 0)) {
            this.m_cbPrintSave.setEnabled(false);
            this.m_btnPrintSave.setEnabled(false);
            this.m_btnPrintSave.setIcon(this.m_iconSystemLevelLock, PolicyResource.get("PolicyGlobalSystemLevelLock"));
            this.m_btnPrintSave.setToolTipText(PolicyResource.get("PolicyGlobalSystemLevelLock"));
        } else if (this.m_policyNSObject.isAttributeLocked(31)) {
            this.m_btnPrintSave.setIcon(this.m_iconLockClosed);
            this.m_btnPrintSave.setToolTipText(PolicyResource.get("PolicyLocked"));
        }
    }

    public boolean saveData() {
        if (this.m_cbPersonalHistory.isModified()) {
            this.m_policyNSObject.setPersonalHistory(this.m_cbPersonalHistory.isSelected());
        }
        if (this.m_cbPrintSave.isModified()) {
            this.m_policyNSObject.setPrintSave(this.m_cbPrintSave.isSelected());
        }
        return true;
    }

    protected void restoreDefaultSettings() {
        this.m_policyNSObject.restoreDefaultSettings(30);
        this.m_policyNSObject.restoreDefaultSettings(31);
        this.readData();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        Object object = actionEvent.getSource();
        Debug.trace("PolicyPanelHistory.actionPerformed");
        if (object == this.m_btnPersonalHistory) {
            n = 30;
        } else if (object == this.m_btnPrintSave) {
            n = 31;
        } else {
            if (object == this.m_btnResetDefaultSettings) {
                NMsgBox nMsgBox = new NMsgBox(this.propertyBook.getComponent(), PolicyResource.get("PolicyDefaultSettingsConfirmTitle"), PolicyResource.get("PolicyDefaultSettingsConfirm"), 2);
                int n2 = nMsgBox.launch();
                if (n2 == 8) {
                    this.restoreDefaultSettings();
                    this.propertyBook.getComponent().requestFocus();
                    this.propertyBook.setModified(true, (PageSnapin)this.pageSnapin);
                }
                return;
            }
            Debug.traceDlg("PolicyPanelHistory.actionPerformed: deal with eventSource= " + object);
            return;
        }
        JButtonExt jButtonExt = (JButtonExt)object;
        ImageIcon imageIcon = (ImageIcon)jButtonExt.getIcon();
        if (imageIcon == this.m_iconLockClosed) {
            this.m_policyNSObject.lockAttribute(n, false);
            if (this.m_policyNSObject.isAttributeMerged(n)) {
                jButtonExt.setIcon(this.m_iconSystemLockOpen);
                jButtonExt.setToolTipText(PolicyResource.get("PolicyGlobalSystemLevelUnlock"));
            } else {
                jButtonExt.setIcon(this.m_iconLockOpen);
                jButtonExt.setToolTipText(PolicyResource.get("PolicyNotLocked"));
            }
        } else {
            this.m_policyNSObject.lockAttribute(n, true);
            if (imageIcon == this.m_iconSystemLockOpen) {
                jButtonExt.setIcon(this.m_iconLockClosed);
                jButtonExt.setToolTipText(PolicyResource.get("PolicyGlobalSystemLevelLock"));
            } else {
                jButtonExt.setIcon(this.m_iconLockClosed);
                jButtonExt.setToolTipText(PolicyResource.get("PolicyLocked"));
            }
        }
        this.propertyBook.setModified(true, (PageSnapin)this.pageSnapin);
    }
}

