/*
 * Decompiled with CFR 0.152.
 */
package com.novell.netmessenger.admin.policy;

import com.novell.netmessenger.admin.common.BaseDlg;
import com.novell.netmessenger.admin.policy.PolicyResource;
import com.novell.netmessenger.admin.policy.PolicyStatusItem;
import com.novell.netmessenger.admin.swingext.JComboBoxExt;
import com.novell.netmessenger.admin.swingext.JLabelExt;
import com.novell.netmessenger.admin.swingext.JTextAreaExt;
import com.novell.netmessenger.admin.swingext.JTextFieldExt;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class PolicyStatusDlg
extends BaseDlg {
    private JComboBoxExt m_cmbStatusType;
    private JTextFieldExt m_tfStatusName;
    private JTextAreaExt m_taStatusReply;
    private PolicyStatusItem m_objStatusItem;
    private static String[] SA_STATUS_TYPES = new String[]{PolicyResource.get("PolicyStatusTypeAway"), PolicyResource.get("PolicyStatusTypeBusy"), PolicyResource.get("PolicyStatusTypeOnline")};

    public PolicyStatusDlg(Component component, PolicyStatusItem policyStatusItem) {
        super((Dialog)component, PolicyResource.get("PolicyStatusTitle"), true, "customavailstatus");
        this.layoutControls();
        this.setStatusItem(policyStatusItem);
    }

    public void layoutControls() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.m_cmbStatusType = new JComboBoxExt(SA_STATUS_TYPES);
        StatusChangeListener statusChangeListener = new StatusChangeListener();
        this.m_cmbStatusType.addItemListener(statusChangeListener);
        this.m_tfStatusName = new JTextFieldExt(new PlainDocumentExt(), "", 30);
        this.m_tfStatusName.disallowChars(";'\"");
        this.m_taStatusReply = new JTextAreaExt(5, 30);
        this.m_taStatusReply.setLineWrap(true);
        this.m_taStatusReply.setWrapStyleWord(true);
        Font font = this.getFont();
        this.m_taStatusReply.setFont(font);
        JLabelExt jLabelExt = new JLabelExt(PolicyResource.get("PolicyStatusType"), this.m_cmbStatusType);
        JLabelExt jLabelExt2 = new JLabelExt(PolicyResource.get("PolicyStatusName"), this.m_tfStatusName);
        JLabelExt jLabelExt3 = new JLabelExt(PolicyResource.get("PolicyStatusAutoReply"), this.m_taStatusReply);
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)jLabelExt2, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)this.m_tfStatusName, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)jLabelExt, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.m_cmbStatusType, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)jLabelExt3, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)new JScrollPane(this.m_taStatusReply), gridBagConstraints);
        this.getContentPane().add((Component)jPanel, "North");
        super.layoutControls();
        this.setModal(true);
        this.pack();
    }

    private void setStatusItem(PolicyStatusItem policyStatusItem) {
        if (policyStatusItem != null) {
            if (policyStatusItem.getType() == 4) {
                this.m_cmbStatusType.setSelectedIndex(0);
            } else if (policyStatusItem.getType() == 3) {
                this.m_cmbStatusType.setSelectedIndex(1);
            } else if (policyStatusItem.getType() == 2) {
                this.m_cmbStatusType.setSelectedIndex(2);
            } else {
                return;
            }
            this.m_tfStatusName.setText(policyStatusItem.getName());
            this.m_taStatusReply.setText(policyStatusItem.getDescription());
        }
    }

    public PolicyStatusItem getStatusItem() {
        return this.m_objStatusItem;
    }

    protected void okButtonAction() {
        int n = this.m_cmbStatusType.getSelectedIndex();
        if (n == 0) {
            n = 4;
        } else if (n == 1) {
            n = 3;
        } else if (n == 2) {
            n = 2;
        }
        String string = this.m_tfStatusName.getText();
        String string2 = this.m_taStatusReply.getText();
        try {
            if (this.m_objStatusItem != null) {
                this.m_objStatusItem.setType(n);
                this.m_objStatusItem.setName(string);
                this.m_objStatusItem.setDescription(string2);
            } else {
                this.m_objStatusItem = new PolicyStatusItem(n, string, string2);
            }
        }
        catch (Exception exception) {
            this.m_objStatusItem = null;
            return;
        }
        this.dispose();
    }

    protected void cancelButtonAction() {
        this.m_objStatusItem = null;
        this.dispose();
    }

    private class StatusChangeListener
    implements ItemListener {
        private StatusChangeListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            int n = PolicyStatusDlg.this.m_cmbStatusType.getSelectedIndex();
            if (n == 2) {
                PolicyStatusDlg.this.m_taStatusReply.setEnabled(false);
                PolicyStatusDlg.this.m_taStatusReply.setEditable(false);
            } else {
                PolicyStatusDlg.this.m_taStatusReply.setEnabled(true);
                PolicyStatusDlg.this.m_taStatusReply.setEditable(true);
            }
        }
    }

    private class PlainDocumentExt
    extends PlainDocument {
        private PlainDocumentExt() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string.indexOf(59) >= 0) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            super.insertString(n, string, attributeSet);
        }
    }
}

