/*
 * Decompiled with CFR 0.152.
 */
package com.novell.netmessenger.admin.policy;

import java.util.StringTokenizer;

public class PolicyStatusItem {
    public static final int I_STATUS_TYPE_ONLINE = 2;
    public static final int I_STATUS_TYPE_BUSY = 3;
    public static final int I_STATUS_TYPE_AWAY = 4;
    private static final String S_STATUS_TYPE_DELIMITER = ";";
    private int m_iType;
    private String m_sName;
    private String m_sDescription;

    public PolicyStatusItem(int n, String string, String string2) throws Exception {
        this.setType(n);
        this.setName(string);
        this.setDescription(string2);
    }

    public PolicyStatusItem(String string) throws Exception {
        Integer n;
        String string2 = null;
        String string3 = null;
        StringTokenizer stringTokenizer = null;
        stringTokenizer = new StringTokenizer(string, S_STATUS_TYPE_DELIMITER);
        if (stringTokenizer.countTokens() < 2) {
            throw new Exception("Custom status item not in a valid format: " + string);
        }
        try {
            n = new Integer(stringTokenizer.nextToken());
        }
        catch (Exception exception) {
            throw new Exception("Custom status item not in a valid format: " + string);
        }
        string2 = stringTokenizer.nextToken();
        if (stringTokenizer.countTokens() > 0) {
            string3 = "";
            while (stringTokenizer.countTokens() > 0) {
                string3 = string3 + stringTokenizer.nextToken() + S_STATUS_TYPE_DELIMITER;
            }
            string3 = string3.substring(0, string3.length() - 1);
        }
        this.setType(n);
        this.setName(string2);
        this.setDescription(string3);
    }

    public void setType(int n) throws Exception {
        if (n != 4 && n != 3 && n != 2) {
            throw new Exception("Invalid status type provided: " + n);
        }
        this.m_iType = n;
    }

    public int getType() {
        return this.m_iType;
    }

    public void setName(String string) throws Exception {
        if (string == null || string.trim().length() == 0) {
            throw new Exception("An invalid name was provided for custom status: " + string);
        }
        this.m_sName = string;
    }

    public String getName() {
        return this.m_sName;
    }

    public void setDescription(String string) {
        this.m_sDescription = string;
    }

    public String getDescription() {
        return this.m_sDescription;
    }

    public String toString() {
        return this.m_sName;
    }

    public String toStringExt() {
        String string = this.m_sDescription == null ? "" : this.m_sDescription;
        return this.m_iType + S_STATUS_TYPE_DELIMITER + this.m_sName + S_STATUS_TYPE_DELIMITER + string;
    }
}

