/*
 * Decompiled with CFR 0.152.
 */
package com.novell.netmessenger.admin.server;

import com.novell.admin.ns.NSObject;
import com.novell.netmessenger.admin.common.NDSNegotiator;
import java.util.Vector;

public class NNMServerNSObject {
    public static final boolean B_DEFAULT_SERVICES = true;
    public static final int I_DEFAULT_DISK_CHECK_DELAY = 1;
    public static final int I_DEFAULT_DISK_CHECK_INTERVAL = 10;
    public static final String S_DEFAULT_SOFTWARE_PATH = "\\novell\\nm\\software\\";
    public static final String S_DEFAULT_WORK_PATH = "\\novell\\nm\\temp\\";
    public static final String S_UNIX_DEFAULT_SOFTWARE_PATH = "/opt/novell/messenger/software";
    public static final String S_UNIX_DEFAULT_WORK_PATH = "/var/opt/novell/messenger/temp";
    private long m_lDirtyBits = 0L;
    private int m_iDiskCheckInterval;
    private int m_iDiskCheckDelay;
    private boolean m_bIPAddressBind;
    private boolean m_bSSL;
    private boolean m_bServices;
    private boolean m_bSNMP;
    private String m_sDescription;
    private String m_sSSLCertFile;
    private String m_sSSLKeyFile;
    private String m_sSSLKeyCredentials;
    private String m_sCertPath;
    private String m_sLDAPProfile;
    private String m_sWorkPath;
    private String m_sSoftwarePath;
    private String m_sSNMPCommunity;
    private String m_sIPAddress;
    public static final int I_SERVER_DESCRIPTION = 0;
    public static final int I_SERVER_IP_ADDRESS = 1;
    public static final int I_SERVER_IP_ADDRESS_BIND = 2;
    public static final int I_SERVER_SSL = 3;
    public static final int I_SERVER_SSL_CERT_FILE = 4;
    public static final int I_SERVER_SSL_KEY_FILE = 5;
    public static final int I_SERVER_SSL_KEY_CREDENTIALS = 6;
    public static final int I_SERVER_CERT_PATH = 7;
    public static final int I_SERVER_SERVICES = 8;
    public static final int I_SERVER_SNMP = 9;
    public static final int I_SERVER_DISK_CHECK_INTERVAL = 10;
    public static final int I_SERVER_DISK_CHECK_DELAY = 11;
    public static final int I_SERVER_LDAP_PROFILE_DN = 12;
    public static final int I_SERVER_WORK_PATH = 13;
    public static final int I_SERVER_SOFTWARE_PATH = 14;
    public static final int I_SERVER_SNMP_COMMUNITY = 15;
    public static final String[] SA_SERVER_ATTRIBUTES = new String[]{"nnmDescription", "nnmIPAddress", "nnmIPAddressBind", "nnmSSL", "nnmSSLCertFile", "nnmSSLKeyFile", "nnmSSLKeyCredentials", "nnmCertPath", "nnmServices", "nnmSNMP", "nnmDiskCheckInterval", "nnmDiskCheckDelay", "nnmLDAPProfileDN", "nnmWorkPath", "nnmSoftwarePath", "nnmSNMPCommunity"};
    public static final long[] IA_MASK_ATTRIBUTES = new long[]{1L, 2L, 4L, 8L, 16L, 32L, 64L, 128L, 256L, 512L, 1024L, 2048L, 4096L, 8192L, 16384L, 32768L};

    public void setDescription(String string) {
        this.m_sDescription = string;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[0];
    }

    public String getDescription() {
        return this.m_sDescription;
    }

    private void setIPAddressVector(Vector vector) {
        if (vector != null && vector.size() > 0) {
            this.m_sIPAddress = (String)vector.elementAt(0);
        }
    }

    private Vector getIPAddressVector() {
        Vector<String> vector = null;
        if (this.m_sIPAddress != null) {
            vector = new Vector<String>(1);
            vector.addElement(this.m_sIPAddress);
        }
        return vector;
    }

    public void setIPAddress(String string) {
        this.m_sIPAddress = string;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[1];
    }

    public String getIPAddress() {
        return this.m_sIPAddress;
    }

    public void setSSLCertFile(String string) {
        this.m_sSSLCertFile = string;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[4];
    }

    public String getSSLCertFile() {
        return this.m_sSSLCertFile;
    }

    public void setSSLKeyFile(String string) {
        this.m_sSSLKeyFile = string;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[5];
    }

    public String getSSLKeyFile() {
        return this.m_sSSLKeyFile;
    }

    public void setSSLKeyCredentials(String string) {
        this.m_sSSLKeyCredentials = string;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[6];
    }

    public String getSSLKeyCredentials() {
        return this.m_sSSLKeyCredentials;
    }

    public void setCertPath(String string) {
        this.m_sCertPath = string;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[7];
    }

    public String getCertPath() {
        return this.m_sCertPath;
    }

    public void setLDAPProfile(String string) {
        this.m_sLDAPProfile = string;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[12];
    }

    public String getLDAPProfile() {
        return this.m_sLDAPProfile;
    }

    public void setDiskCheckInterval(int n) {
        this.m_iDiskCheckInterval = n;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[10];
    }

    public int getDiskCheckInterval() {
        return this.m_iDiskCheckInterval;
    }

    public void setDiskCheckDelay(int n) {
        this.m_iDiskCheckDelay = n;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[11];
    }

    public int getDiskCheckDelay() {
        return this.m_iDiskCheckDelay;
    }

    public void setIPAddressBind(boolean bl) {
        this.m_bIPAddressBind = bl;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[2];
    }

    public boolean getIPAddressBind() {
        return this.m_bIPAddressBind;
    }

    public void setSSL(boolean bl) {
        this.m_bSSL = bl;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[3];
    }

    public boolean getSSL() {
        return this.m_bSSL;
    }

    public void setServices(boolean bl) {
        this.m_bServices = bl;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[8];
    }

    public boolean getServices() {
        return this.m_bServices;
    }

    public void setSNMP(boolean bl) {
        this.m_bSNMP = bl;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[9];
    }

    public boolean getSNMP() {
        return this.m_bSNMP;
    }

    public void setWorkPath(String string) {
        this.m_sWorkPath = string;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[13];
    }

    public String getWorkPath() {
        return this.m_sWorkPath;
    }

    public void setSoftwarePath(String string) {
        this.m_sSoftwarePath = string;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[14];
    }

    public String getSoftwarePath() {
        return this.m_sSoftwarePath;
    }

    public void setSNMPCommunity(String string) {
        this.m_sSNMPCommunity = string;
        this.m_lDirtyBits |= IA_MASK_ATTRIBUTES[15];
    }

    public String getSNMPCommunity() {
        return this.m_sSNMPCommunity;
    }

    protected boolean load(NSObject nSObject) {
        int n;
        NDSNegotiator nDSNegotiator = new NDSNegotiator();
        this.setDescription(nDSNegotiator.getAttribute(nSObject, SA_SERVER_ATTRIBUTES[0]));
        this.setSSLCertFile(nDSNegotiator.getAttribute(nSObject, SA_SERVER_ATTRIBUTES[4]));
        this.setSSLKeyFile(nDSNegotiator.getAttribute(nSObject, SA_SERVER_ATTRIBUTES[5]));
        this.setSSLKeyCredentials(nDSNegotiator.getAttribute(nSObject, SA_SERVER_ATTRIBUTES[6]));
        this.setCertPath(nDSNegotiator.getAttribute(nSObject, SA_SERVER_ATTRIBUTES[7]));
        this.setLDAPProfile(nDSNegotiator.getAttribute(nSObject, SA_SERVER_ATTRIBUTES[12]));
        String string = nDSNegotiator.getAttribute(nSObject, SA_SERVER_ATTRIBUTES[13]);
        if (string == null) {
            string = S_DEFAULT_WORK_PATH;
        }
        this.setWorkPath(string);
        string = nDSNegotiator.getAttribute(nSObject, SA_SERVER_ATTRIBUTES[14]);
        if (string == null) {
            string = S_DEFAULT_SOFTWARE_PATH;
        }
        this.setSoftwarePath(string);
        this.setSNMPCommunity(nDSNegotiator.getAttribute(nSObject, SA_SERVER_ATTRIBUTES[15]));
        string = nDSNegotiator.getAttribute(nSObject, SA_SERVER_ATTRIBUTES[2]);
        boolean bl = string != null && string.equals("1");
        this.setIPAddressBind(bl);
        string = nDSNegotiator.getAttribute(nSObject, SA_SERVER_ATTRIBUTES[3]);
        bl = string != null && string.equals("1");
        this.setSSL(bl);
        string = nDSNegotiator.getAttribute(nSObject, SA_SERVER_ATTRIBUTES[8]);
        bl = string != null && string.equals("1");
        this.setServices(bl);
        string = nDSNegotiator.getAttribute(nSObject, SA_SERVER_ATTRIBUTES[9]);
        bl = string != null && string.equals("1");
        this.setSNMP(bl);
        try {
            n = Integer.parseInt(nDSNegotiator.getAttribute(nSObject, SA_SERVER_ATTRIBUTES[10]));
        }
        catch (Exception exception) {
            n = 10;
        }
        this.setDiskCheckInterval(n);
        try {
            n = Integer.parseInt(nDSNegotiator.getAttribute(nSObject, SA_SERVER_ATTRIBUTES[11]));
        }
        catch (Exception exception) {
            n = 1;
        }
        this.setDiskCheckDelay(n);
        this.setIPAddressVector(nDSNegotiator.getMultiValuedAttribute(nSObject, SA_SERVER_ATTRIBUTES[1]));
        this.m_lDirtyBits = 0L;
        return true;
    }

    protected boolean save(NSObject nSObject) {
        String string;
        boolean bl = false;
        NDSNegotiator nDSNegotiator = new NDSNegotiator();
        if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[0]) > 0L) {
            nDSNegotiator.setAttribute(nSObject, SA_SERVER_ATTRIBUTES[0], this.getDescription());
        }
        if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[4]) > 0L) {
            nDSNegotiator.setAttribute(nSObject, SA_SERVER_ATTRIBUTES[4], this.getSSLCertFile());
        }
        if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[5]) > 0L) {
            nDSNegotiator.setAttribute(nSObject, SA_SERVER_ATTRIBUTES[5], this.getSSLKeyFile());
        }
        if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[6]) > 0L) {
            nDSNegotiator.setAttribute(nSObject, SA_SERVER_ATTRIBUTES[6], this.getSSLKeyCredentials());
        }
        if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[7]) > 0L) {
            nDSNegotiator.setAttribute(nSObject, SA_SERVER_ATTRIBUTES[7], this.getCertPath());
        }
        if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[12]) > 0L) {
            nDSNegotiator.setAttribute(nSObject, SA_SERVER_ATTRIBUTES[12], this.getLDAPProfile());
        }
        if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[13]) > 0L) {
            nDSNegotiator.setAttribute(nSObject, SA_SERVER_ATTRIBUTES[13], this.getWorkPath());
        }
        if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[14]) > 0L) {
            nDSNegotiator.setAttribute(nSObject, SA_SERVER_ATTRIBUTES[14], this.getSoftwarePath());
        }
        if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[15]) > 0L) {
            nDSNegotiator.setAttribute(nSObject, SA_SERVER_ATTRIBUTES[15], this.getSNMPCommunity());
        }
        if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[8]) > 0L) {
            string = this.getServices() ? "1" : "0";
            nDSNegotiator.setAttribute(nSObject, SA_SERVER_ATTRIBUTES[8], string);
        }
        if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[2]) > 0L) {
            string = this.getIPAddressBind() ? "1" : "0";
            nDSNegotiator.setAttribute(nSObject, SA_SERVER_ATTRIBUTES[2], string);
        }
        if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[3]) > 0L) {
            string = this.getSSL() ? "1" : "0";
            nDSNegotiator.setAttribute(nSObject, SA_SERVER_ATTRIBUTES[3], string);
        }
        if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[9]) > 0L) {
            string = this.getSNMP() ? "1" : "0";
            nDSNegotiator.setAttribute(nSObject, SA_SERVER_ATTRIBUTES[9], string);
        }
        if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[10]) > 0L) {
            nDSNegotiator.setAttribute(nSObject, SA_SERVER_ATTRIBUTES[10], String.valueOf(this.getDiskCheckInterval()));
        }
        if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[11]) > 0L) {
            nDSNegotiator.setAttribute(nSObject, SA_SERVER_ATTRIBUTES[11], String.valueOf(this.getDiskCheckDelay()));
        }
        if ((this.m_lDirtyBits & IA_MASK_ATTRIBUTES[1]) > 0L) {
            nDSNegotiator.setMultiValuedAttribute(nSObject, SA_SERVER_ATTRIBUTES[1], this.getIPAddressVector());
        }
        if (!(bl = nDSNegotiator.update(nSObject))) {
            System.out.println("=================\n" + this.toString());
        } else {
            this.m_lDirtyBits = 0L;
        }
        this.load(nSObject);
        return true;
    }
}

