/*
 * Decompiled with CFR 0.152.
 */
package com.novell.netmessenger.admin.server;

import com.novell.admin.common.security.NSetPasswordDlg;
import com.novell.admin.common.snapins.AdminPageSnapin;
import com.novell.admin.ns.NSObject;
import com.novell.application.console.snapin.InitSnapinInfo;
import com.novell.application.console.snapin.PageSnapin;
import com.novell.netmessenger.admin.common.FilePathTextField;
import com.novell.netmessenger.admin.common.StaticUtilities;
import com.novell.netmessenger.admin.server.NNMServerPage;
import com.novell.netmessenger.admin.server.NNMServerResource;
import com.novell.netmessenger.admin.swingext.JButtonExt;
import com.novell.netmessenger.admin.swingext.JCheckBoxExt;
import com.novell.netmessenger.admin.swingext.JLabelExt;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.text.Document;

public class NNMServerPanelSecurity
extends NNMServerPage
implements ActionListener,
KeyListener,
ItemListener {
    private JCheckBoxExt m_cbSSL;
    private JButtonExt m_btnPassword;
    private FilePathTextField m_tfSSLCertFile;
    private FilePathTextField m_tfSSLKeyFile;
    private FilePathTextField m_tfCertPath;
    private String m_sPassword;

    public NNMServerPanelSecurity(InitSnapinInfo initSnapinInfo, AdminPageSnapin adminPageSnapin, NSObject nSObject) {
        super(initSnapinInfo, adminPageSnapin, nSObject);
    }

    protected void init() {
        this.m_cbSSL = new JCheckBoxExt(NNMServerResource.get("ServerSecuritySSL"));
        this.m_btnPassword = new JButtonExt(NNMServerResource.get("ServerSecurityPasswordButton"));
        this.m_btnPassword.addActionListener(this);
        this.m_tfSSLCertFile = new FilePathTextField(this.propertyBook.getComponent(), 0);
        this.m_tfSSLKeyFile = new FilePathTextField(this.propertyBook.getComponent(), 0);
        this.m_tfCertPath = new FilePathTextField(this.propertyBook.getComponent(), 1);
    }

    public void layoutControls() {
        this.init();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(NNMServerResource.get("ServerSecuritySSLPanel")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 18;
        JLabelExt jLabelExt = new JLabelExt(NNMServerResource.get("ServerSecurityCertFile"), this.m_tfSSLCertFile);
        JLabelExt jLabelExt2 = new JLabelExt(NNMServerResource.get("ServerSecurityKeyFile"), this.m_tfSSLKeyFile);
        JLabelExt jLabelExt3 = new JLabelExt(NNMServerResource.get("ServerSecurityCertPath"), this.m_tfCertPath);
        this.setLayout(new GridBagLayout());
        this.setGBC(gridBagConstraints, 1, 2, 1, 1, 0, 0.3, 0.0, 18);
        this.add(jLabelExt3, gridBagConstraints);
        this.setGBC(gridBagConstraints, 2, 2, 1, 1, 2, 0.7, 0.0, 18);
        this.add(this.m_tfCertPath, gridBagConstraints);
        this.setGBC(gridBagConstraints, 1, 1, 1, 1, 0, 0.3, 0.0, 18);
        jPanel.add((Component)jLabelExt, gridBagConstraints);
        this.setGBC(gridBagConstraints, 2, 1, 1, 1, 2, 0.7, 0.0, 18);
        jPanel.add((Component)this.m_tfSSLCertFile, gridBagConstraints);
        this.setGBC(gridBagConstraints, 1, 2, 1, 1, 0, 0.3, 0.0, 18);
        jPanel.add((Component)jLabelExt2, gridBagConstraints);
        this.setGBC(gridBagConstraints, 2, 2, 1, 1, 2, 0.7, 0.0, 18);
        jPanel.add((Component)this.m_tfSSLKeyFile, gridBagConstraints);
        this.setGBC(gridBagConstraints, 2, 3, 1, 1, 0, 0.7, 0.0, 18);
        jPanel.add((Component)this.m_btnPassword, gridBagConstraints);
        this.setGBC(gridBagConstraints, 1, 3, 2, 1, 2, 1.0, 0.0, 18);
        this.add(jPanel, gridBagConstraints);
        this.setGBC(gridBagConstraints, 1, 4, 2, 1, 0, 0.0, 1.0, 18);
        this.add(this.m_cbSSL, gridBagConstraints);
    }

    public void readData() {
        this.m_cbSSL.setSelected(this.m_serverNSObject.getSSL());
        this.m_tfSSLCertFile.setText(this.m_serverNSObject.getSSLCertFile());
        this.m_tfSSLKeyFile.setText(this.m_serverNSObject.getSSLKeyFile());
        String string = this.m_serverNSObject.getSSLKeyCredentials();
        if (string != null) {
            try {
                this.m_sPassword = StaticUtilities.decodeDecrypt(string);
            }
            catch (Exception exception) {
                this.m_sPassword = null;
            }
        }
        this.m_tfCertPath.setText(this.m_serverNSObject.getCertPath());
        this.updateUI(this.m_tfSSLCertFile.getDocument());
        this.updateUI(this.m_tfSSLKeyFile.getDocument());
        this.m_cbSSL.addItemListener(this);
        this.m_tfSSLCertFile.addDocumentListener(this);
        this.m_tfSSLKeyFile.addDocumentListener(this);
        this.m_tfCertPath.addDocumentListener(this);
    }

    public boolean saveData() {
        String string;
        String string2 = null;
        if (this.m_cbSSL.isModified()) {
            this.m_serverNSObject.setSSL(this.m_cbSSL.isSelected());
        }
        if (this.m_tfSSLCertFile.isModified()) {
            string = this.m_tfSSLCertFile.getText();
            if (string == null || string.trim().length() == 0) {
                this.m_tfSSLKeyFile.setText(null);
                this.m_tfSSLKeyFile.setModified(true);
                this.m_sPassword = null;
            }
            this.m_serverNSObject.setSSLCertFile(string);
        }
        if (this.m_tfSSLKeyFile.isModified()) {
            string = this.m_tfSSLKeyFile.getText();
            if (string == null || string.trim().length() == 0) {
                this.m_sPassword = null;
            }
            this.m_serverNSObject.setSSLKeyFile(string);
        }
        try {
            string2 = StaticUtilities.encryptEncode(this.m_sPassword);
        }
        catch (Exception exception) {
            string2 = null;
        }
        this.m_serverNSObject.setSSLKeyCredentials(string2);
        if (this.m_tfCertPath.isModified()) {
            this.m_serverNSObject.setCertPath(this.m_tfCertPath.getText());
        }
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.m_btnPassword)) {
            NSetPasswordDlg nSetPasswordDlg = new NSetPasswordDlg(this.shell);
            if (nSetPasswordDlg.launch() == 1) {
                this.m_sPassword = nSetPasswordDlg.getNewPassword();
                this.propertyBook.setModified(true, (PageSnapin)this.pageSnapin);
            }
            this.fixFocus();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object != this.m_cbSSL || this.m_cbSSL.isSelected()) {
            // empty if block
        }
        this.propertyBook.setModified(true, (PageSnapin)this.pageSnapin);
    }

    protected void updateUI(Document document) {
        if (document.equals(this.m_tfSSLCertFile.getDocument())) {
            if (this.m_tfSSLCertFile.getText() == null || this.m_tfSSLCertFile.getText().trim().length() == 0) {
                this.m_tfSSLKeyFile.setEnabled(false);
                this.m_btnPassword.setEnabled(false);
            } else {
                this.m_tfSSLKeyFile.setEnabled(true);
                if (this.m_tfSSLKeyFile.getText() != null && this.m_tfSSLKeyFile.getText().trim().length() > 0) {
                    this.m_btnPassword.setEnabled(true);
                }
            }
        } else if (document.equals(this.m_tfSSLKeyFile.getDocument())) {
            if (this.m_tfSSLKeyFile.getText() == null || this.m_tfSSLKeyFile.getText().trim().length() == 0) {
                this.m_btnPassword.setEnabled(false);
            } else {
                this.m_btnPassword.setEnabled(true);
            }
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        super.changedUpdate(documentEvent);
        this.updateUI(documentEvent.getDocument());
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        super.insertUpdate(documentEvent);
        this.updateUI(documentEvent.getDocument());
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        super.removeUpdate(documentEvent);
        this.updateUI(documentEvent.getDocument());
    }
}

