/*
 * Decompiled with CFR 0.152.
 */
package com.novell.netmessenger.admin.swingext;

import com.novell.netmessenger.admin.swingext.SwingExtResource;
import java.awt.Color;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.accessibility.AccessibleContext;
import javax.swing.JCheckBox;

public class JCheckBoxExt
extends JCheckBox
implements ItemListener {
    private boolean m_bModified;

    public JCheckBoxExt(String string) {
        super(string);
        this.setMnemonic(string);
        this.m_bModified = false;
        AccessibleContext accessibleContext = this.getAccessibleContext();
        accessibleContext.setAccessibleName(string);
        accessibleContext.setAccessibleDescription(SwingExtResource.get("AccessibleDescriptionCheckBox"));
    }

    public void setModified(boolean bl) {
        this.m_bModified = bl;
        if (bl) {
            this.setForeground(Color.black);
        } else {
            this.setForeground(Color.black);
        }
    }

    public boolean isModified() {
        return this.m_bModified;
    }

    protected void setMnemonic(String string) {
        int n;
        if (string != null && string.length() > 0 && (n = string.indexOf(38)) != -1) {
            String string2 = n == 0 ? string.substring(1) : string.substring(0, n) + string.substring(n + 1);
            this.setText(string2);
            this.setMnemonic(string.charAt(n + 1));
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.setModified(true);
    }

    public void addItemListener(ItemListener itemListener) {
        super.addItemListener(itemListener);
        if (itemListener.getClass().getName().startsWith("com.novell.netmessenger")) {
            super.addItemListener(this);
        }
    }

    public void removeItemListener(ItemListener itemListener) {
        super.removeItemListener(itemListener);
        if (itemListener.getClass().getName().startsWith("com.novell.netmessenger")) {
            super.removeItemListener(this);
        }
    }
}

