/*
 * Decompiled with CFR 0.152.
 */
package com.novell.netmessenger.admin.swingext;

import com.novell.netmessenger.admin.common.Debug;
import com.novell.netmessenger.admin.swingext.SwingExtResource;
import java.awt.Color;
import javax.accessibility.AccessibleContext;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class JListExt
extends JList
implements ListDataListener {
    private boolean m_bModified;

    public JListExt() {
        this(new DefaultListModel(), null);
    }

    public JListExt(String string) {
        this(new DefaultListModel(), string);
    }

    public JListExt(ListModel listModel) {
        this(listModel, null);
    }

    public JListExt(ListModel listModel, String string) {
        super(listModel);
        this.init(string);
    }

    private void init(String string) {
        AccessibleContext accessibleContext = this.getAccessibleContext();
        accessibleContext.setAccessibleDescription(SwingExtResource.get("AccessibleDescriptionList"));
        if (string == null) {
            accessibleContext.setAccessibleName("");
        } else {
            accessibleContext.setAccessibleName(string);
            this.setToolTipText(string);
        }
        this.m_bModified = false;
    }

    public void grabFocus() {
        super.grabFocus();
        if (this.getModel().getSize() > 0) {
            this.setSelectedIndex(0);
        }
    }

    public void requestFocus() {
        super.requestFocus();
        if (this.getModel().getSize() > 0) {
            this.setSelectedIndex(0);
        }
    }

    public void setModified(boolean bl) {
        this.m_bModified = bl;
        if (bl) {
            this.setForeground(Color.black);
        } else {
            this.setForeground(Color.black);
        }
    }

    public boolean isModified() {
        return this.m_bModified;
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
        this.setModified(true);
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
        this.setModified(true);
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.setModified(true);
    }

    public void addListDataListener(ListDataListener listDataListener) {
        this.getModel().addListDataListener(listDataListener);
        this.getModel().addListDataListener(this);
    }

    public void removeListDataListener(ListDataListener listDataListener) {
        this.getModel().removeListDataListener(listDataListener);
        this.getModel().removeListDataListener(this);
    }

    public void removeAllElements() {
        if (this.getModel() instanceof DefaultListModel) {
            DefaultListModel defaultListModel = (DefaultListModel)this.getModel();
            defaultListModel.removeAllElements();
        } else {
            Debug.traceDlg("JListExt.removeAllElements: DefaultListModel not used, so doing nothing here.");
        }
    }

    public void selectAll() {
        int n = this.getModel().getSize();
        Debug.trace("JListExt.selectAll: size= " + n);
        if (n > 0) {
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = i;
            }
            this.setSelectedIndices(nArray);
        }
    }
}

