/*
 * Decompiled with CFR 0.152.
 */
package com.novell.netmessenger.admin.swingext;

import com.novell.netmessenger.admin.swingext.NPlainDocument;
import com.novell.netmessenger.admin.swingext.SwingExtResource;
import java.awt.Color;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import javax.accessibility.AccessibleContext;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class JTextFieldExt
extends JTextField
implements DocumentListener {
    public static final Insets TF_MARGIN = new Insets(0, 2, 0, 2);
    private boolean m_bModified = false;
    private NPlainDocument m_doc = new NPlainDocument();

    public JTextFieldExt() {
        this(null, null, 25);
    }

    public JTextFieldExt(String string) {
        this(null, string, 0);
    }

    public JTextFieldExt(int n) {
        this(null, null, n);
    }

    public JTextFieldExt(String string, int n) {
        this(null, string, n);
    }

    public JTextFieldExt(Document document, String string, int n) {
        super(document, string, n);
        this.setDocument(this.m_doc);
        this.setMargin(TF_MARGIN);
        this.m_bModified = false;
        AccessibleContext accessibleContext = this.getAccessibleContext();
        accessibleContext.setAccessibleName(string);
        accessibleContext.setAccessibleDescription(SwingExtResource.get("AccessibleDescriptionTextField"));
        this.enableEvents(8L);
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        boolean bl = true;
        if (!this.isEditable()) {
            int n = keyEvent.getKeyCode();
            switch (n) {
                case 86: {
                    if (!keyEvent.isControlDown()) break;
                    bl = false;
                    break;
                }
                case 155: {
                    if (!keyEvent.isShiftDown()) break;
                    bl = false;
                    break;
                }
            }
        }
        if (bl) {
            super.processKeyEvent(keyEvent);
        }
    }

    public void setText(String string) {
        super.setText(string);
        AccessibleContext accessibleContext = this.getAccessibleContext();
        accessibleContext.setAccessibleName(string);
    }

    public void setModified(boolean bl) {
        this.m_bModified = bl;
        if (bl) {
            this.setForeground(Color.black);
        } else {
            this.setForeground(Color.black);
        }
    }

    public boolean isModified() {
        return this.m_bModified;
    }

    public void setEditable(boolean bl) {
        super.setEditable(bl);
        this.setOpaque(bl);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.setOpaque(bl);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.setModified(true);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.setModified(true);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.setModified(true);
    }

    public void addDocumentListener(DocumentListener documentListener) {
        this.getDocument().addDocumentListener(documentListener);
        this.getDocument().addDocumentListener(this);
    }

    public void removeDocumentListener(DocumentListener documentListener) {
        this.getDocument().removeDocumentListener(documentListener);
        this.getDocument().removeDocumentListener(this);
    }

    public void limitText(int n) {
        this.m_doc.setLimit(n);
    }

    public void disallowChars(String string) {
        this.m_doc.disallowChars(string);
    }
}

