/*
 * Decompiled with CFR 0.152.
 */
package com.novell.netmessenger.admin.swingext;

import com.novell.netmessenger.admin.common.Debug;
import com.novell.netmessenger.admin.swingext.SwingExtResource;
import javax.accessibility.AccessibleContext;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class JTreeExt
extends JTree
implements TreeModelListener {
    private boolean m_bModified;

    public JTreeExt(TreeModel treeModel) {
        super(treeModel);
        this.initAccesibility(null);
    }

    protected void initAccesibility(String string) {
        AccessibleContext accessibleContext = this.getAccessibleContext();
        accessibleContext.setAccessibleName(null);
        accessibleContext.setAccessibleDescription(SwingExtResource.get("AccessibleDescriptionTree"));
    }

    public void setModified(boolean bl) {
        this.m_bModified = bl;
    }

    public boolean isModified() {
        return this.m_bModified;
    }

    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        this.setModified(true);
    }

    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        this.setModified(true);
    }

    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        this.setModified(true);
    }

    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        this.setModified(true);
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.getModel().addTreeModelListener(treeModelListener);
        this.getModel().addTreeModelListener(this);
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.getModel().removeTreeModelListener(treeModelListener);
        this.getModel().removeTreeModelListener(this);
    }

    public void removeAllElements() {
        if (this.getModel() instanceof DefaultTreeModel) {
            Debug.trace("JTreeExt.removeAllElements: called to clear list.");
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
            TreePath[] treePathArray = this.getPathBetweenRows(0, this.getRowCount() - 1);
            for (int i = 0; i < treePathArray.length; ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[i].getLastPathComponent();
                if (defaultMutableTreeNode == null) continue;
                defaultTreeModel.removeNodeFromParent(defaultMutableTreeNode);
            }
        } else {
            Debug.traceDlg("JTreeExt.removeAllElements: DefaultTreeModel not used, so doing nothing here.");
        }
    }
}

